/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import com.googlecode.icegem.serialization.AutoSerializable;
import com.googlecode.icegem.serialization.BeanVersion;
import com.googlecode.icegem.serialization.Configuration;
import com.googlecode.icegem.serialization.codegen.ClassProcessor;
import com.googlecode.icegem.serialization.codegen.CodeGenerationListener;
import com.googlecode.icegem.serialization.codegen.Introspector;
import com.googlecode.icegem.serialization.codegen.MethodFromDataProcessor;
import com.googlecode.icegem.serialization.codegen.MethodFromDataStubProcessor;
import com.googlecode.icegem.serialization.codegen.MethodGetIdProcessor;
import com.googlecode.icegem.serialization.codegen.MethodGetSupportedClassesProcessor;
import com.googlecode.icegem.serialization.codegen.MethodToDataProcessor;
import com.googlecode.icegem.serialization.codegen.MethodToDataStubProcessor;
import com.googlecode.icegem.serialization.codegen.StaticConstructorGenerator;
import com.googlecode.icegem.serialization.codegen.XClass;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSerializerGenerator {
    private static Logger logger = LoggerFactory.getLogger(DataSerializerGenerator.class);
    public static final String PARENT_CLASS = "com.gemstone.gemfire.DataSerializer";
    private static final Map<Integer, String> dataSerializerID2ClassNameMap = new HashMap<Integer, String>();
    private static CodeGenerationListener listener;

    private static ClassPool newClassPool(ClassLoader loader) {
        ClassPool result = new ClassPool(null);
        result.appendClassPath((ClassPath)new ClassClassPath(Object.class));
        result.appendClassPath((ClassPath)new LoaderClassPath(loader));
        return result;
    }

    public static synchronized List<Class<?>> generateDataSerializerClasses(ClassLoader classLoader, Class<?> ... classArray) throws CannotCompileException, InvalidClassException {
        return DataSerializerGenerator.generateDataSerializerClasses(classLoader, Arrays.asList(classArray), null);
    }

    public static synchronized List<Class<?>> generateDataSerializerClasses(ClassLoader classLoader, List<Class<?>> classList) throws CannotCompileException, InvalidClassException {
        return DataSerializerGenerator.generateDataSerializerClasses(classLoader, classList, null);
    }

    public static synchronized List<Class<?>> generateDataSerializerClasses(ClassLoader classLoader, List<Class<?>> classList, String outputDir) throws CannotCompileException, InvalidClassException {
        CtClass cc;
        DataSerializerGenerator.checkClassesValid(classList);
        ArrayList<CtClass> dataSerializerClassList = new ArrayList<CtClass>();
        ClassPool classPool = DataSerializerGenerator.newClassPool(classLoader);
        for (Class<?> clazz : classList) {
            String serializerClsName = DataSerializerGenerator.createDataSerializerClassNameForClass(clazz);
            if (DataSerializerGenerator.existsClass(serializerClsName, classLoader)) {
                logger.debug("Serializer for class {} exists. Skipping generation", (Object)clazz.getName());
                break;
            }
            cc = DataSerializerGenerator.createClass(classPool, clazz, serializerClsName);
            dataSerializerClassList.add(cc);
            DataSerializerGenerator.addStaticConstruct(clazz, cc, serializerClsName);
            DataSerializerGenerator.addMethodGetId(clazz, cc);
            DataSerializerGenerator.addMethodGetSupportedClasses(clazz, cc);
            DataSerializerGenerator.addMethodToDataStub(clazz, cc);
            DataSerializerGenerator.addMethodFromDataStub(clazz, cc);
            try {
                cc.toBytecode();
            }
            catch (IOException e) {
                throw new CannotCompileException("Error during end of compilation phase #1 (call CtClass.toBytecode() for some Javassist-magic with CtClass) for " + cc.getName(), (Throwable)e);
            }
            catch (CannotCompileException e) {
                throw new CannotCompileException("Error during end of compilation phase #1 (call CtClass.toBytecode() for some Javassist-magic with CtClass) for " + cc.getName(), (Throwable)e);
            }
        }
        ArrayList result = new ArrayList();
        for (int k = 0; k < classList.size(); ++k) {
            Class resultClass;
            Class<?> clazz;
            block11: {
                clazz = classList.get(k);
                cc = (CtClass)dataSerializerClassList.get(k);
                cc.defrost();
                DataSerializerGenerator.addMethodToData(clazz, cc);
                DataSerializerGenerator.addMethodFromData(clazz, cc);
                try {
                    resultClass = cc.toClass(classLoader, null);
                    logger.info("compiled data serializer for class: {}; id: {}; version: {}", new Object[]{clazz, clazz.getAnnotation(AutoSerializable.class).dataSerializerID(), clazz.getAnnotation(BeanVersion.class).value()});
                    if (outputDir == null || outputDir.length() <= 0) break block11;
                    try {
                        cc.writeFile(outputDir);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("couldn't save DataSerializer for class " + clazz.getName(), e);
                    }
                }
                catch (CannotCompileException e) {
                    throw new CannotCompileException("Error during end of compilation phase #2 (call CtClass.toClass()) for " + cc.getName() + ". Probably you second time try generate and load DataSerializer class " + cc.getName() + " for class " + clazz.getName(), (Throwable)e);
                }
            }
            if (listener != null) {
                listener.generated(clazz.getName(), cc.getName(), new ClassProcessor().process(new XClass(clazz), cc.getName()));
            }
            result.add(resultClass);
        }
        return result;
    }

    private static boolean existsClass(String clsName, ClassLoader clsLoader) {
        String resource = clsName.replace('.', '/');
        return clsLoader.getResource(resource) != null;
    }

    public static synchronized void registerCodeGenerationListener(CodeGenerationListener l) {
        listener = l;
    }

    private static void checkClassesValid(List<Class<?>> classList) throws InvalidClassException {
        for (Class<?> clazz : classList) {
            Introspector.checkClassIsSerialized(clazz);
        }
        DataSerializerGenerator.checkDataSerializerIDIsUnique(classList);
    }

    private static void checkDataSerializerIDIsUnique(List<Class<?>> classList) throws InvalidClassException {
        for (Class<?> clazz : classList) {
            AutoSerializable annotation = clazz.getAnnotation(AutoSerializable.class);
            int dataSerializerID = annotation.dataSerializerID();
            if (dataSerializerID2ClassNameMap.containsKey(dataSerializerID)) {
                throw new InvalidClassException("Classes " + dataSerializerID2ClassNameMap.get(dataSerializerID) + " and " + clazz.getName() + " contain duplicated value of @AutoSerializable.dataSerializerID: " + dataSerializerID);
            }
            dataSerializerID2ClassNameMap.put(dataSerializerID, clazz.getName());
        }
    }

    private static String createDataSerializerClassNameForClass(Class<?> clazz) {
        String dataSerializerPackage = Configuration.get().getDataSerializerPackage();
        return dataSerializerPackage + "." + clazz.getName() + "DataSerializer";
    }

    private static CtClass createClass(ClassPool classPool, Class<?> baseClass, String newSerializerClassName) throws CannotCompileException {
        CtClass parentClass;
        try {
            parentClass = classPool.get(PARENT_CLASS);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException("There is no com.gemstone.gemfire.DataSerializer in classpath of context ClassLoader for " + baseClass.getName(), (Throwable)e);
        }
        try {
            return classPool.makeClass(newSerializerClassName, parentClass);
        }
        catch (RuntimeException e) {
            throw new CannotCompileException("There is some internal error in our code (probably class " + newSerializerClassName + " exists and frozen) for " + baseClass.getName(), (Throwable)e);
        }
    }

    private static void addStaticConstruct(Class<?> baseClass, CtClass cc, String serializerClsName) throws CannotCompileException {
        String src = new StaticConstructorGenerator().process(new XClass(baseClass), serializerClsName);
        try {
            CtField metaInfoField = CtField.make((String)"public static final com.googlecode.icegem.serialization.codegen.VersionMap VERSION_METADATA;", (CtClass)cc);
            cc.addField(metaInfoField);
            CtConstructor staticConstructor = cc.makeClassInitializer();
            staticConstructor.insertBefore(src);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Cann't add static block for class ", src, baseClass, cc), (Throwable)e);
        }
    }

    private static void addMethodGetId(Class<?> baseClass, CtClass cc) throws CannotCompileException {
        CtMethod methodGetId;
        XClass xClass = new XClass(baseClass);
        String src = new MethodGetIdProcessor().process(xClass);
        try {
            methodGetId = CtNewMethod.make((String)src, (CtClass)cc, null, null);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't compile method '.getId()'\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.addMethod(methodGetId);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can compile but can't add compiled method '.getId()'\n", src, baseClass, cc), (Throwable)e);
        }
    }

    private static void addMethodGetSupportedClasses(Class<?> baseClass, CtClass cc) throws CannotCompileException {
        CtMethod methodGetSupportedClasses;
        XClass xClass = new XClass(baseClass);
        String src = new MethodGetSupportedClassesProcessor().process(xClass);
        try {
            methodGetSupportedClasses = CtNewMethod.make((String)src, (CtClass)cc, null, null);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't compile method '.getSupportedClasses()'\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.addMethod(methodGetSupportedClasses);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can compile but can't add compiled method '.getSupportedClasses()'\n", src, baseClass, cc), (Throwable)e);
        }
    }

    private static void addMethodToDataStub(Class<?> baseClass, CtClass cc) throws CannotCompileException {
        CtMethod methodToData;
        XClass xClass = new XClass(baseClass);
        String src = new MethodToDataStubProcessor().process(xClass);
        try {
            methodToData = CtNewMethod.make((String)src, (CtClass)cc, null, null);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't compile stub method '.toData()' (compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.addMethod(methodToData);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can compile stub but can't add compiled method '.toData()' (compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
    }

    private static void addMethodFromDataStub(Class<?> baseClass, CtClass cc) throws CannotCompileException {
        CtMethod methodFromData;
        XClass xClass = new XClass(baseClass);
        String src = new MethodFromDataStubProcessor().process(xClass);
        try {
            methodFromData = CtNewMethod.make((String)src, (CtClass)cc, null, null);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't compile stub method '.fromData(...)' (compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.addMethod(methodFromData);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can compile stub but can't add compiled method '.fromData(...)' (compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
    }

    private static void addMethodToData(Class<?> baseClass, CtClass cc) throws CannotCompileException {
        CtMethod removedStubMethod;
        CtMethod methodToData;
        XClass xClass = new XClass(baseClass);
        String src = new MethodToDataProcessor().process(xClass);
        try {
            methodToData = CtNewMethod.make((String)src, (CtClass)cc, null, null);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't compile method '.toData()' (compilation phase #2)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            removedStubMethod = cc.getDeclaredMethod("toData");
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't find stub method '.toData()' (from compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.removeMethod(removedStubMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can find but can't remove stub method '.toData()' (from compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.addMethod(methodToData);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can compile new, find old, remove old but can't add new compiled method '.toData()' (compilation phase #2)\n", src, baseClass, cc), (Throwable)e);
        }
    }

    private static void addMethodFromData(Class<?> baseClass, CtClass cc) throws CannotCompileException {
        CtMethod removedStubMethod;
        CtMethod methodFromData;
        XClass xClass = new XClass(baseClass);
        String src = new MethodFromDataProcessor().process(xClass);
        try {
            methodFromData = CtNewMethod.make((String)src, (CtClass)cc, null, null);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't compile method '.fromData(...)' (compilation phase #2)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            removedStubMethod = cc.getDeclaredMethod("fromData");
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can't find stub method '.fromData(...)' (from compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.removeMethod(removedStubMethod);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can find but can't remove stub method '.fromData(...)' (from compilation phase #1)\n", src, baseClass, cc), (Throwable)e);
        }
        try {
            cc.addMethod(methodFromData);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileException(DataSerializerGenerator.formatMsg("Can compile new, find old, remove old but can't add new compiled method '.fromData(...)' (compilation phase #2)\n", src, baseClass, cc), (Throwable)e);
        }
    }

    private static String formatMsg(String headerMsg, String methodSrc, Class<?> baseClass, CtClass cc) {
        return headerMsg + "\n" + "source:\n" + methodSrc + "\n" + "method generated for DataSerializer for class: " + baseClass + "\n" + "partially created class of DataSerializer: " + cc + "\n";
    }
}

