/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import com.googlecode.icegem.serialization.codegen.CodeGenUtils;
import com.googlecode.icegem.serialization.codegen.XClass;
import com.googlecode.icegem.serialization.codegen.XProperty;
import com.googlecode.icegem.serialization.codegen.impl.FromDataFieldProcessor;
import java.util.List;

public class MethodFromDataProcessor {
    public String process(XClass element) {
        if (Enum.class.isAssignableFrom(element.getType())) {
            if (element.getType() == Enum.class) {
                throw new RuntimeException("Never here!");
            }
            return this.processEnum(element);
        }
        return this.processNotEnum(element);
    }

    private String processNotEnum(XClass xClass) {
        StringBuilder builder = new StringBuilder();
        List<XProperty> fields = xClass.getOrderedProperties();
        String className = xClass.getType().getName();
        byte currentBeanVersion = xClass.getBeanVersion();
        builder.append("public Object fromData(java.io.DataInput in) throws java.io.IOException, ClassNotFoundException {\n");
        builder.append(CodeGenUtils.tab("// checks header version\n")).append(CodeGenUtils.tab("byte header = in.readByte();\n")).append(CodeGenUtils.tab("byte actualHeaderVersion = (header & 0xF0) >> 4;\n")).append(CodeGenUtils.tab("byte versionHistoryLength = (header & 0x0F);\n")).append(CodeGenUtils.tab("if (actualHeaderVersion !=0) {\n")).append(CodeGenUtils.tab(2, "throw new ClassCastException(\"Unknown binary header version: \" + actualHeaderVersion);\n")).append(CodeGenUtils.tab("}\n")).append("\n");
        builder.append(CodeGenUtils.tab("// checks bean version\n")).append(CodeGenUtils.tab("byte currentVersion = " + currentBeanVersion + "; \n")).append(CodeGenUtils.tab("byte actualVersion = in.readByte();\n")).append(CodeGenUtils.tab("if (currentVersion < actualVersion) {\n")).append(CodeGenUtils.tab(2, "throw new ClassCastException(\"Current bean version is less than serialized: ")).append("current is '\" + currentVersion + \"', actual is '\" + actualVersion + \"'\");\n").append(CodeGenUtils.tab("}\n")).append("\n");
        builder.append(CodeGenUtils.tab("VERSION_METADATA.readAndCheck(in, actualVersion, versionHistoryLength);\n")).append(CodeGenUtils.tab("\n"));
        builder.append(CodeGenUtils.tab("// create 'empty' bean\n")).append(CodeGenUtils.tab(className + " result = new " + className + "();\n"));
        for (XProperty field : fields) {
            if (field.getPropertyVersion() > 1) {
                builder.append(CodeGenUtils.tab("if (actualVersion == currentVersion || actualVersion >= " + field.getPropertyVersion() + ") {"));
                MethodFromDataProcessor.attachFieldReader(builder, field);
                builder.append(CodeGenUtils.tab("}"));
                continue;
            }
            MethodFromDataProcessor.attachFieldReader(builder, field);
        }
        builder.append("\n");
        builder.append(CodeGenUtils.tab("// return 'full' bean\n"));
        builder.append(CodeGenUtils.tab("return result;\n")).append("}\n");
        return builder.toString();
    }

    private static void attachFieldReader(StringBuilder builder, XProperty field) {
        builder.append("\n");
        builder.append(CodeGenUtils.tab("// byte[] -> this." + field.getName() + "\n"));
        builder.append(CodeGenUtils.tab(new FromDataFieldProcessor().process(field)));
    }

    private String processEnum(XClass element) {
        StringBuilder builder = new StringBuilder();
        String className = element.getType().getName();
        builder.append("public Object fromData(java.io.DataInput in) throws java.io.IOException, ClassNotFoundException {\n").append(CodeGenUtils.tab("// read only 'name'\n")).append(CodeGenUtils.tab("return Enum.valueOf(" + className + ".class, in.readUTF());\n")).append("}\n");
        return builder.toString();
    }
}

