/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.codegen;

import java.io.InvalidClassException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTSupport {
    private static final Set<Class<?>> JDK_ALLOWED_CLASSES = new HashSet();

    public static void checkAllowedInCompileTime(Class<?> clazz) throws InvalidClassException {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            RTSupport.checkAllowedInCompileTimeJdkType(clazz);
        } else {
            RTSupport.checkAllowedInCompileTimeCustomType(clazz);
        }
    }

    private static void checkAllowedInCompileTimeJdkType(Class<?> clazz) throws InvalidClassException {
        if (!JDK_ALLOWED_CLASSES.contains(clazz)) {
            throw new InvalidClassException(clazz.getName() + " is disallowed, only " + JDK_ALLOWED_CLASSES);
        }
    }

    private static void checkAllowedInCompileTimeCustomType(Class<?> clazz) {
    }

    public static void checkAllowedInRealTime(Object obj) throws InvalidClassException {
        try {
            RTSupport.checkAllowedInRealTime0(obj, 1);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Too deep method frame stack - 256. Perhaps cyclic references in serialized object have been found.. For object: " + obj.toString());
        }
    }

    private static void checkAllowedInRealTime0(Object obj, int depth) throws InvalidClassException {
        if (depth >= 256) {
            throw new RuntimeException();
        }
        Class<?> clazz = obj.getClass();
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            RTSupport.checkAllowedInCompileTimeJdkType(clazz);
        } else {
            RTSupport.checkAllowedInCompileTimeCustomType(clazz);
        }
        if (clazz.isArray()) {
            int length = Array.getLength(obj);
            for (int k = 0; k < length; ++k) {
                Object elem = Array.get(obj, k);
                RTSupport.checkAllowedInRealTime0(elem, depth + 1);
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            for (Object elem : (Collection)obj) {
                RTSupport.checkAllowedInRealTime0(elem, depth + 1);
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            for (Map.Entry elem : ((Map)obj).entrySet()) {
                RTSupport.checkAllowedInRealTime0(elem.getKey(), depth + 1);
                RTSupport.checkAllowedInRealTime0(elem.getValue(), depth + 1);
            }
        }
    }

    static {
        JDK_ALLOWED_CLASSES.addAll(Arrays.asList(Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        JDK_ALLOWED_CLASSES.addAll(Arrays.asList(Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class));
        JDK_ALLOWED_CLASSES.addAll(Arrays.asList(String.class, Date.class));
        JDK_ALLOWED_CLASSES.addAll(Arrays.asList(ArrayList.class, LinkedList.class, HashMap.class, TreeMap.class, IdentityHashMap.class, LinkedHashSet.class, HashSet.class, TreeSet.class));
        JDK_ALLOWED_CLASSES.addAll(Arrays.asList(Hashtable.class, Vector.class, Stack.class));
    }
}

