/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.serializers;

import com.gemstone.gemfire.DataSerializer;
import com.googlecode.icegem.SerializationID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JodaTimeDataSerializer
extends DataSerializer
implements SerializationID {
    private static final int CUSTOM_TZ_ID = 63;
    private static final String[] TIMEZONE_IDS = new String[]{"UTC", "Europe/London", "America/New_York", "America/Chicago", "America/Los_Angeles", "Europe/Moscow", "Asia/Novosibirsk", "Asia/Tokyo", "GMT", "EST"};

    public Class<?>[] getSupportedClasses() {
        return new Class[]{DateTime.class};
    }

    public boolean toData(Object o, DataOutput dataOutput) throws IOException {
        if (o instanceof DateTime) {
            DateTime dt = (DateTime)o;
            dataOutput.writeLong(dt.getMillis());
            Chronology chronology = dt.getChronology();
            boolean customChronology = false;
            if (!chronology.getClass().getName().equals(ISOChronology.class.getName())) {
                customChronology = true;
            }
            int flags = 0;
            boolean customTimeZone = true;
            String timeZoneId = chronology.getZone().getID();
            for (int i = 0; i < TIMEZONE_IDS.length; i = (int)((byte)(i + 1))) {
                if (!timeZoneId.equals(TIMEZONE_IDS[i])) continue;
                flags = i;
                customTimeZone = false;
                break;
            }
            if (customTimeZone) {
                flags = 63;
            }
            flags = (byte)(flags | (customChronology ? 128 : 0));
            dataOutput.write(flags);
            if (customChronology) {
                dataOutput.writeUTF(chronology.getClass().getName());
            }
            if (customTimeZone) {
                dataOutput.writeUTF(chronology.getZone().getID());
            }
            return true;
        }
        return false;
    }

    public Object fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
        ISOChronology chronology;
        DateTimeZone dateTimeZone;
        long time = dataInput.readLong();
        byte flags = dataInput.readByte();
        boolean customChornology = (flags & 0x80) != 0;
        byte timeZoneIndex = (byte)(flags & 0x7F);
        boolean customTimeZone = timeZoneIndex == 63;
        String chronologyClassName = null;
        if (customChornology) {
            chronologyClassName = dataInput.readUTF();
        }
        if (customTimeZone) {
            dateTimeZone = DateTimeZone.forID((String)dataInput.readUTF());
        } else {
            if (timeZoneIndex >= TIMEZONE_IDS.length) {
                throw new IOException("Serialized form contains unknown TZ index");
            }
            String tzId = TIMEZONE_IDS[timeZoneIndex];
            dateTimeZone = DateTimeZone.forID((String)tzId);
        }
        if (chronologyClassName != null) {
            Class<?> chronologyCls = Class.forName(chronologyClassName);
            try {
                Method factory = chronologyCls.getMethod("getInstance", DateTimeZone.class);
                chronology = (Chronology)factory.invoke(null, dateTimeZone);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate Joda Chronology");
            }
        } else {
            chronology = ISOChronology.getInstance((DateTimeZone)dateTimeZone);
        }
        return new DateTime(time, (Chronology)chronology);
    }

    public int getId() {
        return 16001;
    }

    static {
        DataSerializer.register(JodaTimeDataSerializer.class);
    }
}

