/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.serialization.serializers;

import com.gemstone.gemfire.DataSerializer;
import com.googlecode.icegem.SerializationID;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDDataSerializer
extends DataSerializer
implements SerializationID {
    public Class<?>[] getSupportedClasses() {
        return new Class[]{UUID.class};
    }

    public boolean toData(Object o, DataOutput dataOutput) throws IOException {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            dataOutput.writeLong(uuid.getMostSignificantBits());
            dataOutput.writeLong(uuid.getLeastSignificantBits());
            return true;
        }
        return false;
    }

    public Object fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
        long mostSignificantBits = dataInput.readLong();
        long leastSignificantBits = dataInput.readLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public int getId() {
        return 16003;
    }

    static {
        DataSerializer.register(UUIDDataSerializer.class);
    }
}

