/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProcessLauncher {
    private static final String PROCESS_STDOUT_STREAM_PREFIX = " out>";
    private static final String PROCESS_ERROR_STREAM_PREFIX = " error>";
    public static final String PROCESS_STARTUP_COMPLETED = "JavaProcessLauncher: startup complete";
    public static final long DEFAULT_PROCESS_STARTUP_SHUTDOWN_TIME = 5000L;
    private boolean redirectProcessInputStreamToParentProcessStdOut;
    private boolean redirectProcessErrorStreamToParentProcessStdOut;
    private boolean printType;

    public JavaProcessLauncher() {
        this(false, true, true);
    }

    public JavaProcessLauncher(boolean redirectProcessInputStreamToParentProcessStdOut, boolean redirectProcessErrorStreamToParentProcessStdOut) {
        this(redirectProcessInputStreamToParentProcessStdOut, redirectProcessErrorStreamToParentProcessStdOut, true);
    }

    public JavaProcessLauncher(boolean redirectProcessInputStreamToParentProcessStdOut, boolean redirectProcessErrorStreamToParentProcessStdOut, boolean printType) {
        this.redirectProcessInputStreamToParentProcessStdOut = redirectProcessInputStreamToParentProcessStdOut;
        this.redirectProcessErrorStreamToParentProcessStdOut = redirectProcessErrorStreamToParentProcessStdOut;
        this.printType = printType;
    }

    public void setRedirectProcessErrorStreamToParentProcessStdOut(boolean redirectProcessErrorStreamToParentProcessStdOut) {
        this.redirectProcessErrorStreamToParentProcessStdOut = redirectProcessErrorStreamToParentProcessStdOut;
    }

    public void setRedirectProcessInputStreamToParentProcessStdOut(boolean redirectProcessInputStreamToParentProcessStdOut) {
        this.redirectProcessInputStreamToParentProcessStdOut = redirectProcessInputStreamToParentProcessStdOut;
    }

    public int runAndWaitProcessExitCode(Class klass, String[] javaArguments, String[] processArguments) throws IOException, InterruptedException {
        Process process = this.startProcess(klass, javaArguments, processArguments, false);
        process.waitFor();
        return process.exitValue();
    }

    public Process runWithoutConfirmation(Class<?> clazz, String[] javaArguments, String[] processArguments) throws IOException, InterruptedException {
        return this.startProcess(clazz, javaArguments, processArguments, false);
    }

    public Process runWithConfirmation(Class klass, String[] javaArguments, String[] processArguments) throws IOException, InterruptedException {
        Process process = this.startProcess(klass, javaArguments, processArguments, true);
        this.waitConfirmation(klass.getSimpleName(), process);
        new StreamRedirector(process.getInputStream(), klass.getSimpleName() + PROCESS_STDOUT_STREAM_PREFIX, this.redirectProcessInputStreamToParentProcessStdOut).start();
        return process;
    }

    public Process runWithStartupDelay(Class klass, String[] javaArguments, String[] processArguments) throws IOException, InterruptedException, TimeoutException {
        return this.runWithStartupDelay(klass, javaArguments, processArguments, 5000L);
    }

    public Process runWithStartupDelay(Class klass, String[] javaArguments, String[] processArguments, long processStartupTime) throws IOException, InterruptedException, TimeoutException {
        Process process = this.runWithConfirmation(klass, javaArguments, processArguments);
        if (processStartupTime > 0L) {
            Thread.sleep(processStartupTime);
        }
        return process;
    }

    public void stopBySendingNewLineIntoProcess(Process process) throws IOException, InterruptedException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        writer.newLine();
        writer.flush();
        process.waitFor();
    }

    public void stopByDestroyingProcess(Process process) throws IOException {
        process.destroy();
    }

    private Process startProcess(Class klass, String[] javaArguments, String[] processArguments, boolean withConfirmation) throws IOException, InterruptedException {
        List<String> arguments = this.createCommandLineForProcess(klass, javaArguments, processArguments);
        Process process = new ProcessBuilder(arguments).start();
        this.redirectProcessStreams(klass, process, !withConfirmation);
        return process;
    }

    private void redirectProcessStreams(Class klass, Process process, boolean redirectProcessStdOut) {
        String errorStreamType = this.printType ? klass.getSimpleName() + PROCESS_ERROR_STREAM_PREFIX : "";
        new StreamRedirector(process.getErrorStream(), errorStreamType, this.redirectProcessErrorStreamToParentProcessStdOut, System.err).start();
        if (redirectProcessStdOut) {
            String outputStreamType = this.printType ? klass.getSimpleName() + PROCESS_STDOUT_STREAM_PREFIX : "";
            new StreamRedirector(process.getInputStream(), outputStreamType, this.redirectProcessInputStreamToParentProcessStdOut, System.out).start();
        }
    }

    private List<String> createCommandLineForProcess(Class klazz, String[] processArguments) {
        return this.createCommandLineForProcess(klazz, null, processArguments);
    }

    private List<String> createCommandLineForProcess(Class klazz, String[] javaArguments, String[] processArguments) {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> argumentsList = new ArrayList<String>();
        argumentsList.add(javaBin);
        argumentsList.add("-cp");
        argumentsList.add(classpath);
        if (javaArguments != null && javaArguments.length > 0) {
            argumentsList.addAll(Arrays.asList(javaArguments));
        }
        argumentsList.add(klazz.getCanonicalName());
        if (processArguments != null && processArguments.length > 0) {
            argumentsList.addAll(Arrays.asList(processArguments));
        }
        return argumentsList;
    }

    private void waitConfirmation(String className, Process process) throws IOException, InterruptedException {
        String line;
        System.out.println("Waiting startup complete confirmation for a process (" + className + ")...");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = bufferedReader.readLine()) != null) {
            if (line.equals(PROCESS_STARTUP_COMPLETED)) {
                System.out.println("The process (" + className + ") has been started successfully");
                return;
            }
            if (!this.redirectProcessInputStreamToParentProcessStdOut) continue;
            System.out.println(className + PROCESS_STDOUT_STREAM_PREFIX + line);
        }
        throw new InterruptedException("Process (" + className + ") " + "has been already finished without startup complete confirmation");
    }

    private class StreamRedirector
    extends Thread {
        private InputStream inputStream;
        private String type;
        private boolean redirectToParentProcessStdOut;
        private final PrintStream printStream;

        public StreamRedirector(InputStream inputStream, String type) {
            this(inputStream, type, false);
        }

        public StreamRedirector(InputStream inputStream, String type, boolean redirectToParentProcessStdOut) {
            this(inputStream, type, redirectToParentProcessStdOut, System.out);
        }

        public StreamRedirector(InputStream inputStream, String type, boolean redirectToParentProcessStdOut, PrintStream printStream) {
            this.inputStream = inputStream;
            this.type = type;
            this.redirectToParentProcessStdOut = redirectToParentProcessStdOut;
            this.printStream = printStream;
        }

        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((line = br.readLine()) != null) {
                    if (!this.redirectToParentProcessStdOut) continue;
                    this.printStream.println(this.type + line);
                }
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

