/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.expiration;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.googlecode.icegem.expiration.DestroyedEntriesCountCollector;
import com.googlecode.icegem.expiration.ExpirationFunction;
import com.googlecode.icegem.expiration.ExpirationFunctionArguments;
import com.googlecode.icegem.expiration.ExpirationPolicy;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpirationController {
    private Logger logger = LoggerFactory.getLogger(ExpirationController.class);
    private static final long DEFAULT_PACKET_SIZE = 1L;
    private static final long DEFAULT_PACKET_DELAY = 0L;
    private long packetSize = 1L;
    private long packetDelay = 0L;

    public long getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(long packetSize) {
        this.packetSize = packetSize;
    }

    public long getPacketDelay() {
        return this.packetDelay;
    }

    public void setPacketDelay(long packetDelay) {
        this.packetDelay = packetDelay;
    }

    public long process(Region<?, ?> region, ExpirationPolicy policy) {
        long destroyedEntriesNumber = 0L;
        try {
            if (region == null) {
                throw new IllegalStateException("The Region cannot be null");
            }
            if (policy == null) {
                throw new IllegalArgumentException("The ExpirationPolicy cannot be null");
            }
            this.logger.info("Running ExpirationController process with parameters region = " + region + ", policy = " + policy + ", packetSize = " + this.packetSize + ", packetDelay = " + this.packetDelay);
            DestroyedEntriesCountCollector collector = (DestroyedEntriesCountCollector)FunctionService.onRegion(region).withArgs((Serializable)new ExpirationFunctionArguments(this.packetSize, this.packetDelay)).withCollector((ResultCollector)new DestroyedEntriesCountCollector()).execute((Function)new ExpirationFunction(policy));
            Serializable result = collector.getResult();
            if (result instanceof Long) {
                destroyedEntriesNumber = (Long)result;
            }
            this.logger.info("ExpirationController process with parameters region = " + region + ", policy = " + policy + ", packetSize = " + this.packetSize + ", packetDelay = " + this.packetDelay + " has destroyed " + destroyedEntriesNumber + " entries");
        }
        catch (RuntimeException re) {
            this.logger.error("RuntimeException during processing", (Throwable)re);
            throw re;
        }
        return destroyedEntriesNumber;
    }
}

