/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.utils;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.googlecode.icegem.utils.OperationRequireRetryException;
import com.googlecode.icegem.utils.OperationRetryFailedException;
import com.googlecode.icegem.utils.RegionSizeFunction;
import com.googlecode.icegem.utils.RegionSizeResultCollector;
import com.googlecode.icegem.utils.Retryable;
import com.googlecode.icegem.utils.function.ClearRegionFunction;
import com.googlecode.icegem.utils.function.RemoveAllFunction;
import java.io.Serializable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheUtils {
    private static Logger log = LoggerFactory.getLogger(CacheUtils.class);
    private static long BACKOFF_BASE = 10L;

    public static String addQueryLimit(String queryString, int queryLimit) {
        int limitIndex = queryString.lastIndexOf("limit");
        if (limitIndex == -1) {
            limitIndex = queryString.lastIndexOf("LIMIT");
        }
        if (limitIndex == -1) {
            return queryString + " LIMIT " + (queryLimit + 1);
        }
        int limitNumber = Integer.parseInt(queryString.substring(limitIndex + 5).trim());
        return limitNumber > queryLimit ? queryString.substring(0, limitIndex) + " LIMIT " + (queryLimit + 1) : queryString;
    }

    public static String[] getFirstLocatorFromLocatorsString(String locatorsString) {
        if (locatorsString == null || locatorsString.length() == 0) {
            return new String[2];
        }
        String[] firstLocator = new String[2];
        firstLocator[0] = locatorsString.substring(0, locatorsString.indexOf(91)).trim();
        locatorsString = locatorsString.substring(locatorsString.indexOf(91) + 1);
        firstLocator[1] = locatorsString.substring(0, locatorsString.indexOf(93));
        return firstLocator;
    }

    public static void clearRegion(Region<?, ?> region) {
        ClearRegionFunction cleaner = new ClearRegionFunction();
        FunctionService.registerFunction((Function)cleaner);
        ResultCollector rc = FunctionService.onRegion(region).withArgs((Serializable)((Object)region.getName())).execute((Function)cleaner);
        rc.getResult();
    }

    public static int getRegionSize(Region<?, ?> region) {
        RegionSizeFunction function = new RegionSizeFunction();
        FunctionService.registerFunction((Function)function);
        ResultCollector rc = FunctionService.onRegion(region).withCollector((ResultCollector)new RegionSizeResultCollector()).execute((Function)function);
        return (Integer)rc.getResult();
    }

    public static <K> void removeAll(Region<K, ?> region, Set<K> keys) {
        RemoveAllFunction function = new RemoveAllFunction();
        FunctionService.registerFunction((Function)function);
        ResultCollector rc = FunctionService.onRegion(region).withFilter(keys).withArgs((Serializable)((Object)region.getName())).execute((Function)function);
        rc.getResult();
    }

    public static <T> T retryWithExponentialBackoff(Retryable<T> runnable, int maxRetries) throws InterruptedException, OperationRetryFailedException {
        for (int retry = 0; retry < maxRetries; ++retry) {
            try {
                return runnable.execute();
            }
            catch (OperationRequireRetryException e) {
                continue;
            }
            catch (InterruptedException e) {
                throw e;
            }
        }
        throw new OperationRetryFailedException("Maximum number of operation retries reached");
    }
}

