/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.icegem.utils.function;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import java.io.Serializable;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveAllFunction
extends FunctionAdapter {
    private static final String FUNCTION_ID = RemoveAllFunction.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(RemoveAllFunction.class);

    public void execute(FunctionContext ctx) {
        RegionFunctionContext rctx = (RegionFunctionContext)ctx;
        ResultSender rs = ctx.getResultSender();
        Set keys = rctx.getFilter();
        String regionName = (String)((Object)ctx.getArguments());
        Cache cache = CacheFactory.getAnyInstance();
        Region region = cache.getRegion(regionName);
        for (Object key : keys) {
            DistributedMember primaryMemberForKey = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, key);
            if (primaryMemberForKey != cache.getDistributedSystem().getDistributedMember()) continue;
            try {
                region.destroy(key);
            }
            catch (EntryNotFoundException e) {
                LOG.warn("Entry {} not found", key);
            }
        }
        rs.lastResult((Serializable)Boolean.valueOf(true));
    }

    public String getId() {
        return FUNCTION_ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public boolean isHA() {
        return true;
    }
}

