/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo;

import jaitools.CollectionFactory;
import jaitools.demo.ImageReceiver;
import jaitools.imageutils.ImageUtils;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.runtime.JiffleCompletionEvent;
import jaitools.jiffle.runtime.JiffleEventAdapter;
import jaitools.jiffle.runtime.JiffleEventListener;
import jaitools.jiffle.runtime.JiffleInterpreter;
import jaitools.jiffle.runtime.JiffleProgressEvent;
import jaitools.swing.ProgressMeter;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DemoImageProvider {
    public static final int CHESSBOARD = 0;
    public static final int INTERFERENCE = 1;
    public static final int RIPPLES = 2;
    private static final String[] scriptName = new String[]{"chessboard", "interference", "ripple"};
    private static DemoImageProvider instance;
    private JiffleInterpreter interp;
    private RenderedImage image;
    private Map<Integer, Job> jobs = CollectionFactory.orderedMap();

    private DemoImageProvider() {
        this.interp = new JiffleInterpreter();
        this.interp.addEventListener((JiffleEventListener)new JiffleEventAdapter(){

            public void onCompletionEvent(JiffleCompletionEvent ev) {
                DemoImageProvider.this.onCompletion(ev);
            }

            public void onProgressEvent(JiffleProgressEvent ev) {
                DemoImageProvider.this.showProgress(ev);
            }
        });
    }

    public static DemoImageProvider getInstance() {
        if (instance == null) {
            instance = new DemoImageProvider();
        }
        return instance;
    }

    public void requestImage(int choice, int width, int height, ImageReceiver receiver) throws Exception {
        String name = "/scripts/" + scriptName[choice] + ".jfl";
        URL url = DemoImageProvider.class.getResource(name);
        File file = new File(url.toURI());
        this.image = ImageUtils.createConstantImage((int)width, (int)height, (Number)0.0);
        Map imgParams = CollectionFactory.map();
        imgParams.put("result", this.image);
        try {
            Job job = new Job();
            job.receiver = receiver;
            job.progMeter.setTitle("Creating image");
            job.progMeter.setVisible(true);
            Jiffle jiffle = new Jiffle(file, imgParams);
            int jobID = this.interp.submit(jiffle);
            this.jobs.put(jobID, job);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onCompletion(JiffleCompletionEvent ev) {
        Job job = this.jobs.get(ev.getJobId());
        job.progMeter.setVisible(false);
        job.receiver.receiveImage(ev.getJiffle().getImage("result"));
    }

    private void showProgress(final JiffleProgressEvent ev) {
        final Job job = this.jobs.get(ev.getJobId());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                job.progMeter.setProgress(ev.getProgress());
            }
        });
    }

    private static class Job {
        ImageReceiver receiver;
        ProgressMeter progMeter = new ProgressMeter();

        private Job() {
        }
    }
}

