/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.jiffle;

import jaitools.CollectionFactory;
import jaitools.imageutils.ImageUtils;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.JiffleCompilationException;
import jaitools.jiffle.runtime.JiffleCompletionEvent;
import jaitools.jiffle.runtime.JiffleEventListener;
import jaitools.jiffle.runtime.JiffleFailureEvent;
import jaitools.jiffle.runtime.JiffleInterpreter;
import jaitools.jiffle.runtime.JiffleInterpreterException;
import jaitools.jiffle.runtime.JiffleProgressEvent;
import jaitools.swing.ImageFrame;
import jaitools.swing.ProgressMeter;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.media.jai.TiledImage;
import javax.swing.SwingUtilities;

public class InterpreterDemo {
    private JiffleInterpreter interp = new JiffleInterpreter();
    private ProgressMeter progMeter;
    final int imgWidth = 400;
    final int imgHeight = 400;

    public static void main(String[] args) throws Exception {
        InterpreterDemo demo = new InterpreterDemo();
        URL url = demo.getClass().getResource("/scripts/ripple.jfl");
        File f = new File(url.toURI());
        demo.compileAndRun(f);
    }

    public InterpreterDemo() {
        this.interp.addEventListener(new JiffleEventListener(){

            public void onCompletionEvent(JiffleCompletionEvent ev) {
                InterpreterDemo.this.onCompletion(ev);
            }

            public void onFailureEvent(JiffleFailureEvent ev) {
                InterpreterDemo.this.onFailure(ev);
            }

            public void onProgressEvent(JiffleProgressEvent ev) {
                InterpreterDemo.this.onProgress(ev);
            }
        });
        this.progMeter = new ProgressMeter("Jiffle interpreter", "Running script...");
    }

    public void compileAndRun(File scriptFile) throws Exception {
        TiledImage tImg = ImageUtils.createConstantImage((int)400, (int)400, (Number)0.0);
        Map imgParams = CollectionFactory.map();
        imgParams.put("result", tImg);
        try {
            Jiffle j = new Jiffle(scriptFile, imgParams);
            if (j.isCompiled()) {
                this.progMeter.setVisible(true);
                this.interp.submit(j);
            }
        }
        catch (JiffleCompilationException cex) {
            cex.printStackTrace();
            return;
        }
        catch (JiffleInterpreterException iex) {
            iex.printStackTrace();
        }
    }

    private void onCompletion(JiffleCompletionEvent ev) {
        this.progMeter.setVisible(false);
        RenderedImage img = ev.getJiffle().getImage("result");
        ImageFrame frame = new ImageFrame(img, "Jiffle image demo");
        frame.setVisible(true);
    }

    private void onFailure(JiffleFailureEvent ev) {
        System.err.println("Bummer: script failed to run");
        this.progMeter.setVisible(false);
    }

    private void onProgress(final JiffleProgressEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InterpreterDemo.this.progMeter.setProgress(ev.getProgress());
            }
        });
    }
}

