/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.kernelstats;

import jaitools.demo.DemoImageProvider;
import jaitools.demo.ImageReceiver;
import jaitools.imageutils.ImageUtils;
import jaitools.media.jai.kernel.KernelFactory;
import jaitools.numeric.Statistic;
import jaitools.swing.ImageFrame;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class KernelStatsDemo
implements ImageReceiver {
    public static void main(String[] args) {
        KernelStatsDemo me = new KernelStatsDemo();
        me.demo();
    }

    private KernelStatsDemo() {
    }

    private void demo() {
        try {
            DemoImageProvider.getInstance().requestImage(1, 300, 300, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void receiveImage(RenderedImage image) {
        ImageFrame frame = new ImageFrame(image, "KernelStats: source image");
        frame.setVisible(true);
        this.calculateStats(image);
    }

    private void calculateStats(RenderedImage dataImage) {
        KernelJAI kernel = KernelFactory.createCircle((int)10);
        ParameterBlockJAI pb = new ParameterBlockJAI("KernelStats");
        pb.setSource("source0", (Object)dataImage);
        pb.setParameter("kernel", (Object)kernel);
        Statistic[] stats = new Statistic[]{Statistic.MEAN, Statistic.SDEV};
        pb.setParameter("stats", (Object)stats);
        BorderExtender extender = BorderExtender.createInstance((int)2);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
        RenderedOp multibandImg = JAI.create((String)"KernelStats", (ParameterBlock)pb, (RenderingHints)hints);
        List statImages = ImageUtils.getBandsAsImages((RenderedImage)multibandImg);
        int k = 0;
        for (RenderedImage statImg : statImages) {
            ImageFrame frame = new ImageFrame(statImg, "KernelStats: " + stats[k++].toString());
            frame.setVisible(true);
        }
    }
}

