/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.regionalize;

import jaitools.demo.DemoImageProvider;
import jaitools.demo.ImageReceiver;
import jaitools.imageutils.ImageUtils;
import jaitools.media.jai.regionalize.Region;
import jaitools.swing.ImageFrame;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class RegionalizeDemo
implements ImageReceiver {
    public static void main(String[] args) {
        RegionalizeDemo me = new RegionalizeDemo();
        me.demo();
    }

    public void demo() {
        try {
            DemoImageProvider.getInstance().requestImage(0, 320, 320, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void receiveImage(RenderedImage image) {
        ImageFrame frame = new ImageFrame(image, "Regionalize demo: test image");
        frame.setVisible(true);
        this.regionalizeImage(image);
    }

    public void regionalizeImage(RenderedImage image) {
        ParameterBlockJAI pb = new ParameterBlockJAI("regionalize");
        pb.setSource("source0", (Object)image);
        pb.setParameter("diagonal", false);
        RenderedOp orthoImg = JAI.create((String)"Regionalize", (ParameterBlock)pb);
        orthoImg.getData();
        List regions = (List)orthoImg.getProperty("regiondata");
        for (Region r : regions) {
            System.out.println(r);
        }
        RenderedImage displayImg = ImageUtils.createDisplayImage((RenderedImage)orthoImg, (int)regions.size());
        ImageFrame frame = new ImageFrame(displayImg, (RenderedImage)orthoImg, "Regions with orthogonal connection");
        frame.setVisible(true);
        pb = new ParameterBlockJAI("regionalize");
        pb.setSource("source0", (Object)image);
        pb.setParameter("diagonal", true);
        RenderedOp diagImg = JAI.create((String)"regionalize", (ParameterBlock)pb);
        RenderedImage diagDisplayImg = ImageUtils.createDisplayImage((RenderedImage)diagImg, (int)2);
        frame = new ImageFrame(diagDisplayImg, (RenderedImage)diagImg, "Regions with diagonal connection");
        frame.setVisible(true);
    }
}

