/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.tiledimage;

import jaitools.swing.ImageFrame;
import jaitools.tiledimage.DiskMemImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;

public class DrawingDemo {
    public static void main(String[] args) {
        DrawingDemo me = new DrawingDemo();
        me.demo();
    }

    private void demo() {
        ColorModel cm = ColorModel.getRGBdefault();
        SampleModel sm = cm.createCompatibleSampleModel(128, 128);
        DiskMemImage img = new DiskMemImage(0, 0, 256, 256, 0, 0, sm, cm);
        Graphics2D gr = img.createGraphics();
        gr.setBackground(Color.ORANGE);
        gr.clearRect(0, 0, 256, 256);
        Rectangle shp = new Rectangle(64, 64, 128, 128);
        gr.setColor(Color.BLUE);
        gr.setStroke(new BasicStroke(3.0f));
        gr.draw(shp);
        gr.setColor(Color.RED);
        gr.fillRect(96, 96, 64, 64);
        gr.setColor(Color.BLACK);
        Font font = gr.getFont();
        gr.setFont(font.deriveFont(24.0f));
        gr.drawString("Hello World !", 48, 32);
        gr.setStroke(new BasicStroke(1.0f));
        gr.setColor(Color.GRAY);
        gr.drawLine(128, 0, 128, 255);
        gr.drawLine(0, 128, 255, 128);
        ImageFrame frame = new ImageFrame((RenderedImage)img, "Image of 4 square tiles");
        frame.setVisible(true);
    }
}

