/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.zonalstats;

import jaitools.imageutils.ImageUtils;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.runtime.JiffleRunner;
import jaitools.media.jai.zonalstats.Result;
import jaitools.media.jai.zonalstats.ZonalStats;
import jaitools.media.jai.zonalstats.ZonalStatsDescriptor;
import jaitools.numeric.Statistic;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;

public class ZonalStatsDemo {
    private RenderedImage dataImg = ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0);
    private RenderedImage zoneImg;
    Map<String, RenderedImage> imgParams;

    public static void main(String[] args) throws Exception {
        ZonalStatsDemo me = new ZonalStatsDemo();
        me.demo();
    }

    private void demo() {
        ParameterBlockJAI pb = new ParameterBlockJAI("zonalstats");
        pb.setSource("dataImage", (Object)this.dataImg);
        pb.setSource("zoneImage", (Object)this.zoneImg);
        Statistic[] statistics = new Statistic[]{Statistic.MIN, Statistic.MAX, Statistic.MEDIAN, Statistic.APPROX_MEDIAN, Statistic.SDEV};
        pb.setParameter("stats", (Object)statistics);
        RenderedOp zsImg = JAI.create((String)"zonalstats", (ParameterBlock)pb);
        ZonalStats zs = (ZonalStats)zsImg.getProperty(ZonalStatsDescriptor.ZONAL_STATS_PROPERTY);
        System.out.println("                               exact    approx");
        System.out.println(" band zone      min      max   median   median     sdev");
        System.out.println("-----------------------------------------------------------");
        boolean band = false;
        Iterator i$ = zs.getZones().iterator();
        while (i$.hasNext()) {
            int z = (Integer)i$.next();
            System.out.printf(" %4d %4d", 0, z);
            ZonalStats zoneSubset = zs.band(0).zone(z);
            for (Statistic s : statistics) {
                System.out.printf(" %8.4f", ((Result)zoneSubset.statistic(s).results().get(0)).getValue());
            }
            System.out.println();
        }
    }

    public ZonalStatsDemo() throws Exception {
        TiledImage zoneDoubleImg = ImageUtils.createConstantImage((int)500, (int)500, (Number)0.0);
        this.imgParams = new HashMap<String, RenderedImage>();
        this.imgParams.put("dataImg", this.dataImg);
        this.imgParams.put("zoneImg", (RenderedImage)zoneDoubleImg);
        Jiffle jif = new Jiffle("dataImg = rand(10); numZones = 5; rowsPerZone = height() / numZones;zoneImg = y() / rowsPerZone + 1;", this.imgParams);
        JiffleRunner runner = new JiffleRunner(jif);
        runner.run();
        ParameterBlockJAI pb = new ParameterBlockJAI("format");
        pb.setSource("source0", (Object)zoneDoubleImg);
        pb.setParameter("dataType", 3);
        this.zoneImg = JAI.create((String)"format", (ParameterBlock)pb);
    }
}

