// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/CheckAssignments.g 2011-03-08 17:37:56

package jaitools.jiffle.parser;

import java.util.Set;
import jaitools.CollectionFactory;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * Checks for valid use of image variables.
 *
 * @author Michael Bedward
 */
public class CheckAssignments extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public CheckAssignments(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public CheckAssignments(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CheckAssignments.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/CheckAssignments.g"; }



    private MessageTable msgTable;
    private SymbolScopeStack varScope;

    public CheckAssignments(TreeNodeStream input, MessageTable msgTable) {
        this(input);
        if (msgTable == null) {
            throw new IllegalArgumentException( "msgTable should not be null" );
        }
        this.msgTable = msgTable;

        varScope = new SymbolScopeStack();
    }




    // $ANTLR start "start"
    // jaitools/jiffle/parser/CheckAssignments.g:59:1: start : ( jiffleOption )* ( varDeclaration )* ( statement )+ ;
    public final void start() throws RecognitionException {

            varScope.addLevel("top");

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:62:17: ( ( jiffleOption )* ( varDeclaration )* ( statement )+ )
            // jaitools/jiffle/parser/CheckAssignments.g:62:19: ( jiffleOption )* ( varDeclaration )* ( statement )+
            {
            // jaitools/jiffle/parser/CheckAssignments.g:62:19: ( jiffleOption )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case JIFFLE_OPTION:
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // jaitools/jiffle/parser/CheckAssignments.g:62:19: jiffleOption
            	    {
            	    pushFollow(FOLLOW_jiffleOption_in_start77);
            	    jiffleOption();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            // jaitools/jiffle/parser/CheckAssignments.g:62:33: ( varDeclaration )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case IMAGE_SCOPE_VAR_DECL:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // jaitools/jiffle/parser/CheckAssignments.g:62:33: varDeclaration
            	    {
            	    pushFollow(FOLLOW_varDeclaration_in_start80);
            	    varDeclaration();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            // jaitools/jiffle/parser/CheckAssignments.g:62:49: ( statement )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case DECLARED_LIST:
                case PAR:
                case FUNC_CALL:
                case IF_CALL:
                case BLOCK:
                case IMAGE_POS:
                case PREFIX:
                case POSTFIX:
                case CONSTANT:
                case IMAGE_WRITE:
                case VAR_DEST:
                case VAR_SOURCE:
                case VAR_IMAGE_SCOPE:
                case VAR_PIXEL_SCOPE:
                case VAR_LOOP:
                case VAR_LIST:
                case EQ:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case APPEND:
                case TIMESEQ:
                case DIVEQ:
                case MODEQ:
                case PLUSEQ:
                case MINUSEQ:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case POW:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // jaitools/jiffle/parser/CheckAssignments.g:62:49: statement
            	    {
            	    pushFollow(FOLLOW_statement_in_start83);
            	    statement();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "start"


    // $ANTLR start "jiffleOption"
    // jaitools/jiffle/parser/CheckAssignments.g:66:1: jiffleOption : ^( JIFFLE_OPTION ID . ) ;
    public final void jiffleOption() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:66:17: ( ^( JIFFLE_OPTION ID . ) )
            // jaitools/jiffle/parser/CheckAssignments.g:66:19: ^( JIFFLE_OPTION ID . )
            {
            match(input,JIFFLE_OPTION,FOLLOW_JIFFLE_OPTION_in_jiffleOption114); 

            match(input, Token.DOWN, null); 
            match(input,ID,FOLLOW_ID_in_jiffleOption116); 
            matchAny(input); 

            match(input, Token.UP, null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "jiffleOption"


    // $ANTLR start "varDeclaration"
    // jaitools/jiffle/parser/CheckAssignments.g:70:1: varDeclaration : ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE . ) ;
    public final void varDeclaration() throws RecognitionException {
        CommonTree VAR_IMAGE_SCOPE1=null;

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:70:17: ( ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE . ) )
            // jaitools/jiffle/parser/CheckAssignments.g:70:19: ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE . )
            {
            match(input,IMAGE_SCOPE_VAR_DECL,FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration147); 

            match(input, Token.DOWN, null); 
            VAR_IMAGE_SCOPE1=(CommonTree)match(input,VAR_IMAGE_SCOPE,FOLLOW_VAR_IMAGE_SCOPE_in_varDeclaration149); 
            matchAny(input); 

            match(input, Token.UP, null); 
             
                                varScope.addSymbol((VAR_IMAGE_SCOPE1!=null?VAR_IMAGE_SCOPE1.getText():null), SymbolType.SCALAR, ScopeType.IMAGE);
                            

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "varDeclaration"


    // $ANTLR start "block"
    // jaitools/jiffle/parser/CheckAssignments.g:77:1: block : ^( BLOCK ( blockStatement )* ) ;
    public final void block() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:77:17: ( ^( BLOCK ( blockStatement )* ) )
            // jaitools/jiffle/parser/CheckAssignments.g:77:19: ^( BLOCK ( blockStatement )* )
            {
            match(input,BLOCK,FOLLOW_BLOCK_in_block207); 

            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/CheckAssignments.g:77:27: ( blockStatement )*
                loop4:
                do {
                    int alt4=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case BLOCK:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case CONSTANT:
                    case IMAGE_WRITE:
                    case VAR_DEST:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case EQ:
                    case BREAKIF:
                    case WHILE:
                    case UNTIL:
                    case FOREACH:
                    case APPEND:
                    case TIMESEQ:
                    case DIVEQ:
                    case MODEQ:
                    case PLUSEQ:
                    case MINUSEQ:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                        {
                        alt4=1;
                        }
                        break;

                    }

                    switch (alt4) {
                	case 1 :
                	    // jaitools/jiffle/parser/CheckAssignments.g:77:27: blockStatement
                	    {
                	    pushFollow(FOLLOW_blockStatement_in_block209);
                	    blockStatement();

                	    state._fsp--;


                	    }
                	    break;

                	default :
                	    break loop4;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "block"


    // $ANTLR start "blockStatement"
    // jaitools/jiffle/parser/CheckAssignments.g:81:1: blockStatement : ( statement | ^( BREAKIF expression ) );
    public final void blockStatement() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:81:17: ( statement | ^( BREAKIF expression ) )
            int alt5=2;
            switch ( input.LA(1) ) {
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case BLOCK:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case IMAGE_WRITE:
            case VAR_DEST:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
            case EQ:
            case WHILE:
            case UNTIL:
            case FOREACH:
            case APPEND:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt5=1;
                }
                break;
            case BREAKIF:
                {
                alt5=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;
            }

            switch (alt5) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:81:19: statement
                    {
                    pushFollow(FOLLOW_statement_in_blockStatement238);
                    statement();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:82:19: ^( BREAKIF expression )
                    {
                    match(input,BREAKIF,FOLLOW_BREAKIF_in_blockStatement259); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_blockStatement261);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "blockStatement"


    // $ANTLR start "statement"
    // jaitools/jiffle/parser/CheckAssignments.g:86:1: statement : ( block | assignmentExpression | ^( WHILE loopCondition statement ) | ^( UNTIL loopCondition statement ) | foreachLoop | expression );
    public final void statement() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:86:17: ( block | assignmentExpression | ^( WHILE loopCondition statement ) | ^( UNTIL loopCondition statement ) | foreachLoop | expression )
            int alt6=6;
            switch ( input.LA(1) ) {
            case BLOCK:
                {
                alt6=1;
                }
                break;
            case EQ:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
                {
                alt6=2;
                }
                break;
            case WHILE:
                {
                alt6=3;
                }
                break;
            case UNTIL:
                {
                alt6=4;
                }
                break;
            case FOREACH:
                {
                alt6=5;
                }
                break;
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case IMAGE_WRITE:
            case VAR_DEST:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
            case APPEND:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt6=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:86:19: block
                    {
                    pushFollow(FOLLOW_block_in_statement294);
                    block();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:87:19: assignmentExpression
                    {
                    pushFollow(FOLLOW_assignmentExpression_in_statement314);
                    assignmentExpression();

                    state._fsp--;


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/CheckAssignments.g:88:19: ^( WHILE loopCondition statement )
                    {
                    match(input,WHILE,FOLLOW_WHILE_in_statement335); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_loopCondition_in_statement337);
                    loopCondition();

                    state._fsp--;

                    pushFollow(FOLLOW_statement_in_statement339);
                    statement();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/CheckAssignments.g:89:19: ^( UNTIL loopCondition statement )
                    {
                    match(input,UNTIL,FOLLOW_UNTIL_in_statement361); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_loopCondition_in_statement363);
                    loopCondition();

                    state._fsp--;

                    pushFollow(FOLLOW_statement_in_statement365);
                    statement();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/CheckAssignments.g:90:19: foreachLoop
                    {
                    pushFollow(FOLLOW_foreachLoop_in_statement386);
                    foreachLoop();

                    state._fsp--;


                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/CheckAssignments.g:91:19: expression
                    {
                    pushFollow(FOLLOW_expression_in_statement406);
                    expression();

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "statement"


    // $ANTLR start "foreachLoop"
    // jaitools/jiffle/parser/CheckAssignments.g:94:1: foreachLoop : ^( FOREACH ID loopSet statement ) ;
    public final void foreachLoop() throws RecognitionException {
        CommonTree ID2=null;


            varScope.addLevel("foreach");

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:101:17: ( ^( FOREACH ID loopSet statement ) )
            // jaitools/jiffle/parser/CheckAssignments.g:101:19: ^( FOREACH ID loopSet statement )
            {
            match(input,FOREACH,FOLLOW_FOREACH_in_foreachLoop458); 

            match(input, Token.DOWN, null); 
            ID2=(CommonTree)match(input,ID,FOLLOW_ID_in_foreachLoop460); 
            varScope.addSymbol((ID2!=null?ID2.getText():null), SymbolType.LOOP_VAR, ScopeType.PIXEL);
            pushFollow(FOLLOW_loopSet_in_foreachLoop464);
            loopSet();

            state._fsp--;

            pushFollow(FOLLOW_statement_in_foreachLoop466);
            statement();

            state._fsp--;


            match(input, Token.UP, null); 

            }


                varScope.dropLevel();

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "foreachLoop"


    // $ANTLR start "loopCondition"
    // jaitools/jiffle/parser/CheckAssignments.g:105:1: loopCondition : expression ;
    public final void loopCondition() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:105:17: ( expression )
            // jaitools/jiffle/parser/CheckAssignments.g:105:19: expression
            {
            pushFollow(FOLLOW_expression_in_loopCondition495);
            expression();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "loopCondition"


    // $ANTLR start "loopSet"
    // jaitools/jiffle/parser/CheckAssignments.g:109:1: loopSet : ( ^( SEQUENCE expression expression ) | listLiteral | VAR_LIST );
    public final void loopSet() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:109:17: ( ^( SEQUENCE expression expression ) | listLiteral | VAR_LIST )
            int alt7=3;
            switch ( input.LA(1) ) {
            case SEQUENCE:
                {
                alt7=1;
                }
                break;
            case DECLARED_LIST:
                {
                alt7=2;
                }
                break;
            case VAR_LIST:
                {
                alt7=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:109:19: ^( SEQUENCE expression expression )
                    {
                    match(input,SEQUENCE,FOLLOW_SEQUENCE_in_loopSet530); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_loopSet532);
                    expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_loopSet534);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:110:19: listLiteral
                    {
                    pushFollow(FOLLOW_listLiteral_in_loopSet555);
                    listLiteral();

                    state._fsp--;


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/CheckAssignments.g:111:19: VAR_LIST
                    {
                    match(input,VAR_LIST,FOLLOW_VAR_LIST_in_loopSet575); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "loopSet"


    // $ANTLR start "expressionList"
    // jaitools/jiffle/parser/CheckAssignments.g:115:1: expressionList : ^( EXPR_LIST ( expression )* ) ;
    public final void expressionList() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:115:17: ( ^( EXPR_LIST ( expression )* ) )
            // jaitools/jiffle/parser/CheckAssignments.g:115:19: ^( EXPR_LIST ( expression )* )
            {
            match(input,EXPR_LIST,FOLLOW_EXPR_LIST_in_expressionList603); 

            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/CheckAssignments.g:115:31: ( expression )*
                loop8:
                do {
                    int alt8=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case CONSTANT:
                    case IMAGE_WRITE:
                    case VAR_DEST:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case APPEND:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                        {
                        alt8=1;
                        }
                        break;

                    }

                    switch (alt8) {
                	case 1 :
                	    // jaitools/jiffle/parser/CheckAssignments.g:115:31: expression
                	    {
                	    pushFollow(FOLLOW_expression_in_expressionList605);
                	    expression();

                	    state._fsp--;


                	    }
                	    break;

                	default :
                	    break loop8;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "expressionList"


    // $ANTLR start "assignmentExpression"
    // jaitools/jiffle/parser/CheckAssignments.g:119:1: assignmentExpression : ^( assignmentOp identifier expression ) ;
    public final void assignmentExpression() throws RecognitionException {
        CheckAssignments.identifier_return identifier3 = null;

        CheckAssignments.assignmentOp_return assignmentOp4 = null;


        try {
            // jaitools/jiffle/parser/CheckAssignments.g:120:17: ( ^( assignmentOp identifier expression ) )
            // jaitools/jiffle/parser/CheckAssignments.g:120:19: ^( assignmentOp identifier expression )
            {
            pushFollow(FOLLOW_assignmentOp_in_assignmentExpression650);
            assignmentOp4=assignmentOp();

            state._fsp--;


            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_identifier_in_assignmentExpression652);
            identifier3=identifier();

            state._fsp--;

            pushFollow(FOLLOW_expression_in_assignmentExpression654);
            expression();

            state._fsp--;


            match(input, Token.UP, null); 
             
                                String varName = (identifier3!=null?((CommonTree)identifier3.start):null).getText();
                                int idtype = (identifier3!=null?((CommonTree)identifier3.start):null).getType();
                                switch (idtype) {
                                    case CONSTANT:
                                        msgTable.add(varName, Message.CONSTANT_LHS);
                                        break;

                                    case VAR_SOURCE:
                                        msgTable.add(varName, Message.ASSIGNMENT_TO_SRC_IMAGE); 
                                        break;

                                    default:
                                        if ((assignmentOp4!=null?((CommonTree)assignmentOp4.start):null).getType() == EQ) {
                                            if (!varScope.isDefined(varName)) {
                                                varScope.addSymbol(varName, SymbolType.SCALAR, ScopeType.PIXEL);
                                            }

                                        } else {
                                            switch (idtype) {
                                                case VAR_DEST:
                                                    msgTable.add(varName, Message.INVALID_ASSIGNMENT_OP_WITH_DEST_IMAGE);
                                                    break;

                                                default:
                                                    if (!varScope.isDefined(varName)) {
                                                        msgTable.add(varName, Message.UNINIT_VAR);
                                                    }
                                            }
                                        }
                                }
                            

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "assignmentExpression"

    public static class assignmentOp_return extends TreeRuleReturnScope {
    };

    // $ANTLR start "assignmentOp"
    // jaitools/jiffle/parser/CheckAssignments.g:156:1: assignmentOp : ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ );
    public final CheckAssignments.assignmentOp_return assignmentOp() throws RecognitionException {
        CheckAssignments.assignmentOp_return retval = new CheckAssignments.assignmentOp_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:156:17: ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( input.LA(1)==EQ||(input.LA(1)>=TIMESEQ && input.LA(1)<=MINUSEQ) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentOp"

    public static class identifier_return extends TreeRuleReturnScope {
    };

    // $ANTLR start "identifier"
    // jaitools/jiffle/parser/CheckAssignments.g:165:1: identifier : ( imageVar | userVar | CONSTANT );
    public final CheckAssignments.identifier_return identifier() throws RecognitionException {
        CheckAssignments.identifier_return retval = new CheckAssignments.identifier_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:165:17: ( imageVar | userVar | CONSTANT )
            int alt9=3;
            switch ( input.LA(1) ) {
            case VAR_DEST:
            case VAR_SOURCE:
                {
                alt9=1;
                }
                break;
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
                {
                alt9=2;
                }
                break;
            case CONSTANT:
                {
                alt9=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }

            switch (alt9) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:165:19: imageVar
                    {
                    pushFollow(FOLLOW_imageVar_in_identifier833);
                    imageVar();

                    state._fsp--;


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:166:19: userVar
                    {
                    pushFollow(FOLLOW_userVar_in_identifier853);
                    userVar();

                    state._fsp--;


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/CheckAssignments.g:167:19: CONSTANT
                    {
                    match(input,CONSTANT,FOLLOW_CONSTANT_in_identifier873); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "identifier"


    // $ANTLR start "imageVar"
    // jaitools/jiffle/parser/CheckAssignments.g:171:1: imageVar : ( VAR_SOURCE | VAR_DEST );
    public final void imageVar() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:171:17: ( VAR_SOURCE | VAR_DEST )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( (input.LA(1)>=VAR_DEST && input.LA(1)<=VAR_SOURCE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "imageVar"

    public static class userVar_return extends TreeRuleReturnScope {
    };

    // $ANTLR start "userVar"
    // jaitools/jiffle/parser/CheckAssignments.g:175:1: userVar : ( VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE | VAR_LOOP | VAR_LIST );
    public final CheckAssignments.userVar_return userVar() throws RecognitionException {
        CheckAssignments.userVar_return retval = new CheckAssignments.userVar_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:175:17: ( VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE | VAR_LOOP | VAR_LIST )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( (input.LA(1)>=VAR_IMAGE_SCOPE && input.LA(1)<=VAR_PIXEL_SCOPE)||(input.LA(1)>=VAR_LOOP && input.LA(1)<=VAR_LIST) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "userVar"


    // $ANTLR start "expression"
    // jaitools/jiffle/parser/CheckAssignments.g:182:1: expression : ( ^( FUNC_CALL ID expressionList ) | ^( IF_CALL expressionList ) | ^( QUESTION expression expression expression ) | ^( IMAGE_WRITE . expression ) | ^( IMAGE_POS . ( bandSpecifier )? ( pixelSpecifier )? ) | ^( logicalOp expression expression ) | ^( arithmeticOp expression expression ) | ^( POW expression expression ) | ^( PREFIX prefixOp expression ) | ^( POSTFIX incdecOp expression ) | ^( PAR expression ) | listOperation | listLiteral | literal | imageVar | CONSTANT | userVar );
    public final void expression() throws RecognitionException {
        CheckAssignments.userVar_return userVar5 = null;


        try {
            // jaitools/jiffle/parser/CheckAssignments.g:182:17: ( ^( FUNC_CALL ID expressionList ) | ^( IF_CALL expressionList ) | ^( QUESTION expression expression expression ) | ^( IMAGE_WRITE . expression ) | ^( IMAGE_POS . ( bandSpecifier )? ( pixelSpecifier )? ) | ^( logicalOp expression expression ) | ^( arithmeticOp expression expression ) | ^( POW expression expression ) | ^( PREFIX prefixOp expression ) | ^( POSTFIX incdecOp expression ) | ^( PAR expression ) | listOperation | listLiteral | literal | imageVar | CONSTANT | userVar )
            int alt12=17;
            switch ( input.LA(1) ) {
            case FUNC_CALL:
                {
                alt12=1;
                }
                break;
            case IF_CALL:
                {
                alt12=2;
                }
                break;
            case QUESTION:
                {
                alt12=3;
                }
                break;
            case IMAGE_WRITE:
                {
                alt12=4;
                }
                break;
            case IMAGE_POS:
                {
                alt12=5;
                }
                break;
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
                {
                alt12=6;
                }
                break;
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
                {
                alt12=7;
                }
                break;
            case POW:
                {
                alt12=8;
                }
                break;
            case PREFIX:
                {
                alt12=9;
                }
                break;
            case POSTFIX:
                {
                alt12=10;
                }
                break;
            case PAR:
                {
                alt12=11;
                }
                break;
            case APPEND:
                {
                alt12=12;
                }
                break;
            case DECLARED_LIST:
                {
                alt12=13;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt12=14;
                }
                break;
            case VAR_DEST:
            case VAR_SOURCE:
                {
                alt12=15;
                }
                break;
            case CONSTANT:
                {
                alt12=16;
                }
                break;
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
                {
                alt12=17;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:182:19: ^( FUNC_CALL ID expressionList )
                    {
                    match(input,FUNC_CALL,FOLLOW_FUNC_CALL_in_expression1051); 

                    match(input, Token.DOWN, null); 
                    match(input,ID,FOLLOW_ID_in_expression1053); 
                    pushFollow(FOLLOW_expressionList_in_expression1055);
                    expressionList();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:183:19: ^( IF_CALL expressionList )
                    {
                    match(input,IF_CALL,FOLLOW_IF_CALL_in_expression1077); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expressionList_in_expression1079);
                    expressionList();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/CheckAssignments.g:184:19: ^( QUESTION expression expression expression )
                    {
                    match(input,QUESTION,FOLLOW_QUESTION_in_expression1101); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_expression1103);
                    expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1105);
                    expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1107);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/CheckAssignments.g:185:19: ^( IMAGE_WRITE . expression )
                    {
                    match(input,IMAGE_WRITE,FOLLOW_IMAGE_WRITE_in_expression1129); 

                    match(input, Token.DOWN, null); 
                    matchAny(input); 
                    pushFollow(FOLLOW_expression_in_expression1133);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/CheckAssignments.g:186:19: ^( IMAGE_POS . ( bandSpecifier )? ( pixelSpecifier )? )
                    {
                    match(input,IMAGE_POS,FOLLOW_IMAGE_POS_in_expression1155); 

                    match(input, Token.DOWN, null); 
                    matchAny(input); 
                    // jaitools/jiffle/parser/CheckAssignments.g:186:33: ( bandSpecifier )?
                    int alt10=2;
                    switch ( input.LA(1) ) {
                        case BAND_REF:
                            {
                            alt10=1;
                            }
                            break;
                    }

                    switch (alt10) {
                        case 1 :
                            // jaitools/jiffle/parser/CheckAssignments.g:186:33: bandSpecifier
                            {
                            pushFollow(FOLLOW_bandSpecifier_in_expression1159);
                            bandSpecifier();

                            state._fsp--;


                            }
                            break;

                    }

                    // jaitools/jiffle/parser/CheckAssignments.g:186:48: ( pixelSpecifier )?
                    int alt11=2;
                    switch ( input.LA(1) ) {
                        case PIXEL_REF:
                            {
                            alt11=1;
                            }
                            break;
                    }

                    switch (alt11) {
                        case 1 :
                            // jaitools/jiffle/parser/CheckAssignments.g:186:48: pixelSpecifier
                            {
                            pushFollow(FOLLOW_pixelSpecifier_in_expression1162);
                            pixelSpecifier();

                            state._fsp--;


                            }
                            break;

                    }


                    match(input, Token.UP, null); 

                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/CheckAssignments.g:187:19: ^( logicalOp expression expression )
                    {
                    pushFollow(FOLLOW_logicalOp_in_expression1185);
                    logicalOp();

                    state._fsp--;


                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_expression1187);
                    expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1189);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 7 :
                    // jaitools/jiffle/parser/CheckAssignments.g:188:19: ^( arithmeticOp expression expression )
                    {
                    pushFollow(FOLLOW_arithmeticOp_in_expression1211);
                    arithmeticOp();

                    state._fsp--;


                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_expression1213);
                    expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1215);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 8 :
                    // jaitools/jiffle/parser/CheckAssignments.g:189:19: ^( POW expression expression )
                    {
                    match(input,POW,FOLLOW_POW_in_expression1237); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_expression1239);
                    expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1241);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 9 :
                    // jaitools/jiffle/parser/CheckAssignments.g:190:19: ^( PREFIX prefixOp expression )
                    {
                    match(input,PREFIX,FOLLOW_PREFIX_in_expression1263); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_prefixOp_in_expression1265);
                    prefixOp();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1267);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 10 :
                    // jaitools/jiffle/parser/CheckAssignments.g:191:19: ^( POSTFIX incdecOp expression )
                    {
                    match(input,POSTFIX,FOLLOW_POSTFIX_in_expression1289); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_incdecOp_in_expression1291);
                    incdecOp();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression1293);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 11 :
                    // jaitools/jiffle/parser/CheckAssignments.g:192:19: ^( PAR expression )
                    {
                    match(input,PAR,FOLLOW_PAR_in_expression1315); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_expression1317);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 12 :
                    // jaitools/jiffle/parser/CheckAssignments.g:193:19: listOperation
                    {
                    pushFollow(FOLLOW_listOperation_in_expression1338);
                    listOperation();

                    state._fsp--;


                    }
                    break;
                case 13 :
                    // jaitools/jiffle/parser/CheckAssignments.g:194:19: listLiteral
                    {
                    pushFollow(FOLLOW_listLiteral_in_expression1358);
                    listLiteral();

                    state._fsp--;


                    }
                    break;
                case 14 :
                    // jaitools/jiffle/parser/CheckAssignments.g:195:19: literal
                    {
                    pushFollow(FOLLOW_literal_in_expression1378);
                    literal();

                    state._fsp--;


                    }
                    break;
                case 15 :
                    // jaitools/jiffle/parser/CheckAssignments.g:196:19: imageVar
                    {
                    pushFollow(FOLLOW_imageVar_in_expression1398);
                    imageVar();

                    state._fsp--;


                    }
                    break;
                case 16 :
                    // jaitools/jiffle/parser/CheckAssignments.g:197:19: CONSTANT
                    {
                    match(input,CONSTANT,FOLLOW_CONSTANT_in_expression1418); 

                    }
                    break;
                case 17 :
                    // jaitools/jiffle/parser/CheckAssignments.g:199:19: userVar
                    {
                    pushFollow(FOLLOW_userVar_in_expression1439);
                    userVar5=userVar();

                    state._fsp--;


                                        String varName = (userVar5!=null?((CommonTree)userVar5.start):null).getText();
                                        int varType = (userVar5!=null?((CommonTree)userVar5.start):null).getType();
                                        if (!varScope.isDefined(varName)) {
                                            msgTable.add(varName, Message.UNINIT_VAR);
                                        }
                                    

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "expression"


    // $ANTLR start "listOperation"
    // jaitools/jiffle/parser/CheckAssignments.g:210:1: listOperation : ^( APPEND VAR_LIST expression ) ;
    public final void listOperation() throws RecognitionException {
        CommonTree VAR_LIST6=null;

        try {
            // jaitools/jiffle/parser/CheckAssignments.g:210:17: ( ^( APPEND VAR_LIST expression ) )
            // jaitools/jiffle/parser/CheckAssignments.g:210:19: ^( APPEND VAR_LIST expression )
            {
            match(input,APPEND,FOLLOW_APPEND_in_listOperation1486); 

            match(input, Token.DOWN, null); 
            VAR_LIST6=(CommonTree)match(input,VAR_LIST,FOLLOW_VAR_LIST_in_listOperation1488); 
            pushFollow(FOLLOW_expression_in_listOperation1490);
            expression();

            state._fsp--;


            match(input, Token.UP, null); 

                                if (!varScope.isDefined((VAR_LIST6!=null?VAR_LIST6.getText():null))) {
                                    msgTable.add((VAR_LIST6!=null?VAR_LIST6.getText():null), Message.UNDECLARED_LIST_VAR);
                                }
                            

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "listOperation"


    // $ANTLR start "listLiteral"
    // jaitools/jiffle/parser/CheckAssignments.g:219:1: listLiteral : ^( DECLARED_LIST expressionList ) ;
    public final void listLiteral() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:219:17: ( ^( DECLARED_LIST expressionList ) )
            // jaitools/jiffle/parser/CheckAssignments.g:219:19: ^( DECLARED_LIST expressionList )
            {
            match(input,DECLARED_LIST,FOLLOW_DECLARED_LIST_in_listLiteral1540); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expressionList_in_listLiteral1542);
            expressionList();

            state._fsp--;


            match(input, Token.UP, null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "listLiteral"


    // $ANTLR start "logicalOp"
    // jaitools/jiffle/parser/CheckAssignments.g:223:1: logicalOp : ( OR | XOR | AND | LOGICALEQ | NE | GT | GE | LT | LE );
    public final void logicalOp() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:223:17: ( OR | XOR | AND | LOGICALEQ | NE | GT | GE | LT | LE )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( (input.LA(1)>=OR && input.LA(1)<=LT) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "logicalOp"


    // $ANTLR start "arithmeticOp"
    // jaitools/jiffle/parser/CheckAssignments.g:235:1: arithmeticOp : ( PLUS | MINUS | TIMES | DIV | MOD );
    public final void arithmeticOp() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:235:17: ( PLUS | MINUS | TIMES | DIV | MOD )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( (input.LA(1)>=PLUS && input.LA(1)<=MOD) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "arithmeticOp"


    // $ANTLR start "prefixOp"
    // jaitools/jiffle/parser/CheckAssignments.g:243:1: prefixOp : ( PLUS | MINUS | NOT | incdecOp );
    public final void prefixOp() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:243:17: ( PLUS | MINUS | NOT | incdecOp )
            int alt13=4;
            switch ( input.LA(1) ) {
            case PLUS:
                {
                alt13=1;
                }
                break;
            case MINUS:
                {
                alt13=2;
                }
                break;
            case NOT:
                {
                alt13=3;
                }
                break;
            case INCR:
            case DECR:
                {
                alt13=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:243:19: PLUS
                    {
                    match(input,PLUS,FOLLOW_PLUS_in_prefixOp1877); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:244:19: MINUS
                    {
                    match(input,MINUS,FOLLOW_MINUS_in_prefixOp1897); 

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/CheckAssignments.g:245:19: NOT
                    {
                    match(input,NOT,FOLLOW_NOT_in_prefixOp1917); 

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/CheckAssignments.g:246:19: incdecOp
                    {
                    pushFollow(FOLLOW_incdecOp_in_prefixOp1937);
                    incdecOp();

                    state._fsp--;


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "prefixOp"


    // $ANTLR start "incdecOp"
    // jaitools/jiffle/parser/CheckAssignments.g:250:1: incdecOp : ( INCR | DECR );
    public final void incdecOp() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:250:17: ( INCR | DECR )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( (input.LA(1)>=INCR && input.LA(1)<=DECR) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "incdecOp"


    // $ANTLR start "pixelSpecifier"
    // jaitools/jiffle/parser/CheckAssignments.g:255:1: pixelSpecifier : ^( PIXEL_REF pixelPos pixelPos ) ;
    public final void pixelSpecifier() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:255:17: ( ^( PIXEL_REF pixelPos pixelPos ) )
            // jaitools/jiffle/parser/CheckAssignments.g:255:19: ^( PIXEL_REF pixelPos pixelPos )
            {
            match(input,PIXEL_REF,FOLLOW_PIXEL_REF_in_pixelSpecifier2018); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2020);
            pixelPos();

            state._fsp--;

            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2022);
            pixelPos();

            state._fsp--;


            match(input, Token.UP, null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "pixelSpecifier"


    // $ANTLR start "bandSpecifier"
    // jaitools/jiffle/parser/CheckAssignments.g:259:1: bandSpecifier : ^( BAND_REF expression ) ;
    public final void bandSpecifier() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:259:17: ( ^( BAND_REF expression ) )
            // jaitools/jiffle/parser/CheckAssignments.g:259:19: ^( BAND_REF expression )
            {
            match(input,BAND_REF,FOLLOW_BAND_REF_in_bandSpecifier2052); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_bandSpecifier2054);
            expression();

            state._fsp--;


            match(input, Token.UP, null); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "bandSpecifier"


    // $ANTLR start "pixelPos"
    // jaitools/jiffle/parser/CheckAssignments.g:263:1: pixelPos : ( ^( ABS_POS expression ) | ^( REL_POS expression ) );
    public final void pixelPos() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:263:17: ( ^( ABS_POS expression ) | ^( REL_POS expression ) )
            int alt14=2;
            switch ( input.LA(1) ) {
            case ABS_POS:
                {
                alt14=1;
                }
                break;
            case REL_POS:
                {
                alt14=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;
            }

            switch (alt14) {
                case 1 :
                    // jaitools/jiffle/parser/CheckAssignments.g:263:19: ^( ABS_POS expression )
                    {
                    match(input,ABS_POS,FOLLOW_ABS_POS_in_pixelPos2089); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_pixelPos2091);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/CheckAssignments.g:264:19: ^( REL_POS expression )
                    {
                    match(input,REL_POS,FOLLOW_REL_POS_in_pixelPos2113); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_pixelPos2115);
                    expression();

                    state._fsp--;


                    match(input, Token.UP, null); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "pixelPos"


    // $ANTLR start "literal"
    // jaitools/jiffle/parser/CheckAssignments.g:268:1: literal : ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL );
    public final void literal() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckAssignments.g:268:17: ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL )
            // jaitools/jiffle/parser/CheckAssignments.g:
            {
            if ( (input.LA(1)>=INT_LITERAL && input.LA(1)<=NULL) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "literal"

    // Delegated rules


 

    public static final BitSet FOLLOW_jiffleOption_in_start77 = new BitSet(new long[]{0xFFFF87041BF61FB0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_varDeclaration_in_start80 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_start83 = new BitSet(new long[]{0xFFFF87041BF61FA2L,0x000000000000F88FL});
    public static final BitSet FOLLOW_JIFFLE_OPTION_in_jiffleOption114 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_jiffleOption116 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF0L,0x00000001FFFFFFFFL});
    public static final BitSet FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration147 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_IMAGE_SCOPE_in_varDeclaration149 = new BitSet(new long[]{0xFFFFFFFFFFFFFFF0L,0x00000001FFFFFFFFL});
    public static final BitSet FOLLOW_BLOCK_in_block207 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_blockStatement_in_block209 = new BitSet(new long[]{0xFFFF87241BF61FA8L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_blockStatement238 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BREAKIF_in_blockStatement259 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_blockStatement261 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_block_in_statement294 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_assignmentExpression_in_statement314 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WHILE_in_statement335 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_loopCondition_in_statement337 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement339 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNTIL_in_statement361 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_loopCondition_in_statement363 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement365 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_foreachLoop_in_statement386 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_statement406 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FOREACH_in_foreachLoop458 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_foreachLoop460 = new BitSet(new long[]{0x0000000010080080L});
    public static final BitSet FOLLOW_loopSet_in_foreachLoop464 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_foreachLoop466 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_expression_in_loopCondition495 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SEQUENCE_in_loopSet530 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_loopSet532 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_loopSet534 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listLiteral_in_loopSet555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VAR_LIST_in_loopSet575 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPR_LIST_in_expressionList603 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expressionList605 = new BitSet(new long[]{0xFFFF87041BF61FA8L,0x000000000000F88FL});
    public static final BitSet FOLLOW_assignmentOp_in_assignmentExpression650 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_assignmentExpression652 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_assignmentExpression654 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_assignmentOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_imageVar_in_identifier833 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_userVar_in_identifier853 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONSTANT_in_identifier873 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_imageVar0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_userVar0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNC_CALL_in_expression1051 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_expression1053 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_expressionList_in_expression1055 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IF_CALL_in_expression1077 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_expression1079 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_QUESTION_in_expression1101 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1103 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1105 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1107 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IMAGE_WRITE_in_expression1129 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1133 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IMAGE_POS_in_expression1155 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_bandSpecifier_in_expression1159 = new BitSet(new long[]{0x0000000000004008L});
    public static final BitSet FOLLOW_pixelSpecifier_in_expression1162 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_logicalOp_in_expression1185 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1187 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1189 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_arithmeticOp_in_expression1211 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1213 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1215 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POW_in_expression1237 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1239 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1241 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PREFIX_in_expression1263 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_prefixOp_in_expression1265 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1267 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POSTFIX_in_expression1289 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_incdecOp_in_expression1291 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1293 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PAR_in_expression1315 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1317 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listOperation_in_expression1338 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_expression1358 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_expression1378 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_imageVar_in_expression1398 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONSTANT_in_expression1418 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_userVar_in_expression1439 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_APPEND_in_listOperation1486 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_LIST_in_listOperation1488 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_listOperation1490 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DECLARED_LIST_in_listLiteral1540 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_listLiteral1542 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_logicalOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_arithmeticOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PLUS_in_prefixOp1877 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MINUS_in_prefixOp1897 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_prefixOp1917 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_incdecOp_in_prefixOp1937 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_incdecOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PIXEL_REF_in_pixelSpecifier2018 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2020 = new BitSet(new long[]{0x0000000000018000L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2022 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BAND_REF_in_bandSpecifier2052 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_bandSpecifier2054 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_POS_in_pixelPos2089 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos2091 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REL_POS_in_pixelPos2113 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos2115 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_literal0 = new BitSet(new long[]{0x0000000000000002L});

}