// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/CheckFunctionCalls.g 2011-03-08 17:37:57

package jaitools.jiffle.parser;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
/** 
  * Checks function calls in the primary AST.
  *
  * @author Michael Bedward
  */
public class CheckFunctionCalls extends TreeFilter {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public CheckFunctionCalls(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public CheckFunctionCalls(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return CheckFunctionCalls.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/CheckFunctionCalls.g"; }



    private MessageTable msgTable;

    public CheckFunctionCalls(TreeNodeStream input, MessageTable msgTable) {
        this(input);
        if (msgTable == null) {
            throw new IllegalArgumentException( "msgTable should not be null" );
        }
        this.msgTable = msgTable;
    }




    // $ANTLR start "topdown"
    // jaitools/jiffle/parser/CheckFunctionCalls.g:53:1: topdown : functionCall ;
    public final void topdown() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/CheckFunctionCalls.g:53:9: ( functionCall )
            // jaitools/jiffle/parser/CheckFunctionCalls.g:53:11: functionCall
            {
            pushFollow(FOLLOW_functionCall_in_topdown71);
            functionCall();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "topdown"


    // $ANTLR start "functionCall"
    // jaitools/jiffle/parser/CheckFunctionCalls.g:57:1: functionCall : ^( FUNC_CALL ID expressionList ) ;
    public final void functionCall() throws RecognitionException {
        CommonTree ID1=null;
        List<String> expressionList2 = null;


        try {
            // jaitools/jiffle/parser/CheckFunctionCalls.g:57:17: ( ^( FUNC_CALL ID expressionList ) )
            // jaitools/jiffle/parser/CheckFunctionCalls.g:57:19: ^( FUNC_CALL ID expressionList )
            {
            match(input,FUNC_CALL,FOLLOW_FUNC_CALL_in_functionCall93); if (state.failed) return ;

            match(input, Token.DOWN, null); if (state.failed) return ;
            ID1=(CommonTree)match(input,ID,FOLLOW_ID_in_functionCall95); if (state.failed) return ;
            pushFollow(FOLLOW_expressionList_in_functionCall97);
            expressionList2=expressionList();

            state._fsp--;
            if (state.failed) return ;

            match(input, Token.UP, null); if (state.failed) return ;
            if ( state.backtracking==1 ) {

                                  if (!FunctionLookup.isDefined((ID1!=null?ID1.getText():null), expressionList2)) {
                                      StringBuilder sb = new StringBuilder();
                                      sb.append((ID1!=null?ID1.getText():null));
                                      sb.append("(");
                                      int k = 0;
                                      for (String s : expressionList2) {
                                          sb.append(s);
                                          if (++k < expressionList2.size()) {
                                              sb.append(", ");
                                          }
                                      }
                                      sb.append(")");
                                      msgTable.add(sb.toString(), Message.UNDEFINED_FUNCTION);
                                  }
                              
            }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "functionCall"


    // $ANTLR start "expressionList"
    // jaitools/jiffle/parser/CheckFunctionCalls.g:77:1: expressionList returns [List<String> argTypes] : ^( EXPR_LIST (e= . )* ) ;
    public final List<String> expressionList() throws RecognitionException {
        List<String> argTypes = null;

        CommonTree e=null;

         argTypes = new ArrayList<String>(); 
        try {
            // jaitools/jiffle/parser/CheckFunctionCalls.g:79:17: ( ^( EXPR_LIST (e= . )* ) )
            // jaitools/jiffle/parser/CheckFunctionCalls.g:79:19: ^( EXPR_LIST (e= . )* )
            {
            match(input,EXPR_LIST,FOLLOW_EXPR_LIST_in_expressionList167); if (state.failed) return argTypes;

            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); if (state.failed) return argTypes;
                // jaitools/jiffle/parser/CheckFunctionCalls.g:79:31: (e= . )*
                loop1:
                do {
                    int alt1=2;
                    switch ( input.LA(1) ) {
                    case JIFFLE_OPTION:
                    case IMAGE_SCOPE_VAR_DECL:
                    case EXPR_LIST:
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case BLOCK:
                    case IMAGE_POS:
                    case BAND_REF:
                    case PIXEL_REF:
                    case ABS_POS:
                    case REL_POS:
                    case PREFIX:
                    case POSTFIX:
                    case SEQUENCE:
                    case CONSTANT:
                    case IMAGE_WRITE:
                    case VAR_DEST:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_PROVIDED:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case LIST_NEW:
                    case OPTIONS:
                    case LCURLY:
                    case RCURLY:
                    case ID:
                    case EQ:
                    case SEMI:
                    case INIT:
                    case BREAKIF:
                    case LPAR:
                    case RPAR:
                    case WHILE:
                    case UNTIL:
                    case FOREACH:
                    case IN:
                    case COMMA:
                    case COLON:
                    case IF:
                    case APPEND:
                    case TIMESEQ:
                    case DIVEQ:
                    case MODEQ:
                    case PLUSEQ:
                    case MINUSEQ:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case NOT:
                    case INCR:
                    case DECR:
                    case POW:
                    case LSQUARE:
                    case RSQUARE:
                    case ABS_POS_PREFIX:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                    case COMMENT:
                    case INT_TYPE:
                    case FLOAT_TYPE:
                    case DOUBLE_TYPE:
                    case BOOLEAN_TYPE:
                    case Letter:
                    case UNDERSCORE:
                    case Digit:
                    case Dot:
                    case NonZeroDigit:
                    case FloatExp:
                    case WS:
                    case ESC_SEQ:
                    case CHAR:
                    case HEX_DIGIT:
                    case UNICODE_ESC:
                    case OCTAL_ESC:
                        {
                        alt1=1;
                        }
                        break;

                    }

                    switch (alt1) {
                	case 1 :
                	    // jaitools/jiffle/parser/CheckFunctionCalls.g:79:32: e= .
                	    {
                	    e=(CommonTree)input.LT(1);
                	    matchAny(input); if (state.failed) return argTypes;
                	    if ( state.backtracking==1 ) {
                	       
                	                              int ttype = e.getToken().getType();
                	                              argTypes.add(ttype == VAR_LIST || ttype == DECLARED_LIST ? "List" : "D");
                	                          
                	    }

                	    }
                	    break;

                	default :
                	    break loop1;
                    }
                } while (true);


                match(input, Token.UP, null); if (state.failed) return argTypes;
            }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return argTypes;
    }
    // $ANTLR end "expressionList"

    // Delegated rules


 

    public static final BitSet FOLLOW_functionCall_in_topdown71 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNC_CALL_in_functionCall93 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_functionCall95 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_expressionList_in_functionCall97 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXPR_LIST_in_expressionList167 = new BitSet(new long[]{0x0000000000000004L});

}