// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/Jiffle.g 2011-03-08 17:37:55

package jaitools.jiffle.parser;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class JiffleLexer extends Lexer {
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators

    public JiffleLexer() {;} 
    public JiffleLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public JiffleLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/Jiffle.g"; }

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:311:5: ( '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n' | '/*' ( options {greedy=false; } : . )* '*/' )
            int alt4=2;
            switch ( input.LA(1) ) {
            case '/':
                {
                switch ( input.LA(2) ) {
                case '/':
                    {
                    alt4=1;
                    }
                    break;
                case '*':
                    {
                    alt4=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }

            switch (alt4) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:311:9: '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n'
                    {
                    match("//"); 

                    // jaitools/jiffle/parser/Jiffle.g:311:14: (~ ( '\\n' | '\\r' ) )*
                    loop1:
                    do {
                        int alt1=2;
                        int LA1_0 = input.LA(1);

                        if ( ((LA1_0>='\u0000' && LA1_0<='\t')||(LA1_0>='\u000B' && LA1_0<='\f')||(LA1_0>='\u000E' && LA1_0<='\uFFFF')) ) {
                            alt1=1;
                        }


                        switch (alt1) {
                    	case 1 :
                    	    // jaitools/jiffle/parser/Jiffle.g:311:14: ~ ( '\\n' | '\\r' )
                    	    {
                    	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\uFFFF') ) {
                    	        input.consume();

                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;}


                    	    }
                    	    break;

                    	default :
                    	    break loop1;
                        }
                    } while (true);

                    // jaitools/jiffle/parser/Jiffle.g:311:28: ( '\\r' )?
                    int alt2=2;
                    switch ( input.LA(1) ) {
                        case '\r':
                            {
                            alt2=1;
                            }
                            break;
                    }

                    switch (alt2) {
                        case 1 :
                            // jaitools/jiffle/parser/Jiffle.g:311:28: '\\r'
                            {
                            match('\r'); 

                            }
                            break;

                    }

                    match('\n'); 
                    _channel=HIDDEN;

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:312:9: '/*' ( options {greedy=false; } : . )* '*/'
                    {
                    match("/*"); 

                    // jaitools/jiffle/parser/Jiffle.g:312:14: ( options {greedy=false; } : . )*
                    loop3:
                    do {
                        int alt3=2;
                        int LA3_0 = input.LA(1);

                        if ( (LA3_0=='*') ) {
                            int LA3_1 = input.LA(2);

                            if ( (LA3_1=='/') ) {
                                alt3=2;
                            }
                            else if ( ((LA3_1>='\u0000' && LA3_1<='.')||(LA3_1>='0' && LA3_1<='\uFFFF')) ) {
                                alt3=1;
                            }


                        }
                        else if ( ((LA3_0>='\u0000' && LA3_0<=')')||(LA3_0>='+' && LA3_0<='\uFFFF')) ) {
                            alt3=1;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    // jaitools/jiffle/parser/Jiffle.g:312:42: .
                    	    {
                    	    matchAny(); 

                    	    }
                    	    break;

                    	default :
                    	    break loop3;
                        }
                    } while (true);

                    match("*/"); 

                    _channel=HIDDEN;

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "TRUE"
    public final void mTRUE() throws RecognitionException {
        try {
            int _type = TRUE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:316:9: ( 'TRUE' | 'true' )
            int alt5=2;
            switch ( input.LA(1) ) {
            case 'T':
                {
                alt5=1;
                }
                break;
            case 't':
                {
                alt5=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;
            }

            switch (alt5) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:316:11: 'TRUE'
                    {
                    match("TRUE"); 


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:316:20: 'true'
                    {
                    match("true"); 


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "TRUE"

    // $ANTLR start "FALSE"
    public final void mFALSE() throws RecognitionException {
        try {
            int _type = FALSE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:317:9: ( 'FALSE' | 'false' )
            int alt6=2;
            switch ( input.LA(1) ) {
            case 'F':
                {
                alt6=1;
                }
                break;
            case 'f':
                {
                alt6=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:317:11: 'FALSE'
                    {
                    match("FALSE"); 


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:317:21: 'false'
                    {
                    match("false"); 


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "FALSE"

    // $ANTLR start "NULL"
    public final void mNULL() throws RecognitionException {
        try {
            int _type = NULL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:318:9: ( 'NULL' | 'null' )
            int alt7=2;
            switch ( input.LA(1) ) {
            case 'N':
                {
                alt7=1;
                }
                break;
            case 'n':
                {
                alt7=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:318:11: 'NULL'
                    {
                    match("NULL"); 


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:318:20: 'null'
                    {
                    match("null"); 


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NULL"

    // $ANTLR start "INT_TYPE"
    public final void mINT_TYPE() throws RecognitionException {
        try {
            int _type = INT_TYPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:321:17: ( 'int' )
            // jaitools/jiffle/parser/Jiffle.g:321:19: 'int'
            {
            match("int"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "INT_TYPE"

    // $ANTLR start "FLOAT_TYPE"
    public final void mFLOAT_TYPE() throws RecognitionException {
        try {
            int _type = FLOAT_TYPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:322:17: ( 'float' )
            // jaitools/jiffle/parser/Jiffle.g:322:19: 'float'
            {
            match("float"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "FLOAT_TYPE"

    // $ANTLR start "DOUBLE_TYPE"
    public final void mDOUBLE_TYPE() throws RecognitionException {
        try {
            int _type = DOUBLE_TYPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:323:17: ( 'double' )
            // jaitools/jiffle/parser/Jiffle.g:323:19: 'double'
            {
            match("double"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DOUBLE_TYPE"

    // $ANTLR start "BOOLEAN_TYPE"
    public final void mBOOLEAN_TYPE() throws RecognitionException {
        try {
            int _type = BOOLEAN_TYPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:324:17: ( 'boolean' )
            // jaitools/jiffle/parser/Jiffle.g:324:19: 'boolean'
            {
            match("boolean"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "BOOLEAN_TYPE"

    // $ANTLR start "OPTIONS"
    public final void mOPTIONS() throws RecognitionException {
        try {
            int _type = OPTIONS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:326:9: ( 'options' )
            // jaitools/jiffle/parser/Jiffle.g:326:11: 'options'
            {
            match("options"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "OPTIONS"

    // $ANTLR start "INIT"
    public final void mINIT() throws RecognitionException {
        try {
            int _type = INIT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:327:9: ( 'init' )
            // jaitools/jiffle/parser/Jiffle.g:327:11: 'init'
            {
            match("init"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "INIT"

    // $ANTLR start "IF"
    public final void mIF() throws RecognitionException {
        try {
            int _type = IF;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:329:9: ( 'if' )
            // jaitools/jiffle/parser/Jiffle.g:329:11: 'if'
            {
            match("if"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "IF"

    // $ANTLR start "WHILE"
    public final void mWHILE() throws RecognitionException {
        try {
            int _type = WHILE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:330:9: ( 'while' )
            // jaitools/jiffle/parser/Jiffle.g:330:11: 'while'
            {
            match("while"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "WHILE"

    // $ANTLR start "UNTIL"
    public final void mUNTIL() throws RecognitionException {
        try {
            int _type = UNTIL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:331:9: ( 'until' )
            // jaitools/jiffle/parser/Jiffle.g:331:11: 'until'
            {
            match("until"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "UNTIL"

    // $ANTLR start "FOREACH"
    public final void mFOREACH() throws RecognitionException {
        try {
            int _type = FOREACH;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:332:9: ( 'foreach' )
            // jaitools/jiffle/parser/Jiffle.g:332:11: 'foreach'
            {
            match("foreach"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "FOREACH"

    // $ANTLR start "IN"
    public final void mIN() throws RecognitionException {
        try {
            int _type = IN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:333:9: ( 'in' )
            // jaitools/jiffle/parser/Jiffle.g:333:11: 'in'
            {
            match("in"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "IN"

    // $ANTLR start "BREAKIF"
    public final void mBREAKIF() throws RecognitionException {
        try {
            int _type = BREAKIF;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:334:9: ( 'breakif' )
            // jaitools/jiffle/parser/Jiffle.g:334:11: 'breakif'
            {
            match("breakif"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "BREAKIF"

    // $ANTLR start "ABS_POS_PREFIX"
    public final void mABS_POS_PREFIX() throws RecognitionException {
        try {
            int _type = ABS_POS_PREFIX;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:339:9: ( '$' )
            // jaitools/jiffle/parser/Jiffle.g:339:11: '$'
            {
            match('$'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ABS_POS_PREFIX"

    // $ANTLR start "APPEND"
    public final void mAPPEND() throws RecognitionException {
        try {
            int _type = APPEND;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:341:9: ( '<<' )
            // jaitools/jiffle/parser/Jiffle.g:341:11: '<<'
            {
            match("<<"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "APPEND"

    // $ANTLR start "INCR"
    public final void mINCR() throws RecognitionException {
        try {
            int _type = INCR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:343:9: ( '++' )
            // jaitools/jiffle/parser/Jiffle.g:343:11: '++'
            {
            match("++"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "INCR"

    // $ANTLR start "DECR"
    public final void mDECR() throws RecognitionException {
        try {
            int _type = DECR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:344:9: ( '--' )
            // jaitools/jiffle/parser/Jiffle.g:344:11: '--'
            {
            match("--"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DECR"

    // $ANTLR start "NOT"
    public final void mNOT() throws RecognitionException {
        try {
            int _type = NOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:346:9: ( '!' )
            // jaitools/jiffle/parser/Jiffle.g:346:11: '!'
            {
            match('!'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NOT"

    // $ANTLR start "POW"
    public final void mPOW() throws RecognitionException {
        try {
            int _type = POW;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:347:9: ( '^' )
            // jaitools/jiffle/parser/Jiffle.g:347:11: '^'
            {
            match('^'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "POW"

    // $ANTLR start "TIMES"
    public final void mTIMES() throws RecognitionException {
        try {
            int _type = TIMES;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:348:9: ( '*' )
            // jaitools/jiffle/parser/Jiffle.g:348:11: '*'
            {
            match('*'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "TIMES"

    // $ANTLR start "DIV"
    public final void mDIV() throws RecognitionException {
        try {
            int _type = DIV;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:349:9: ( '/' )
            // jaitools/jiffle/parser/Jiffle.g:349:11: '/'
            {
            match('/'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DIV"

    // $ANTLR start "MOD"
    public final void mMOD() throws RecognitionException {
        try {
            int _type = MOD;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:350:9: ( '%' )
            // jaitools/jiffle/parser/Jiffle.g:350:11: '%'
            {
            match('%'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MOD"

    // $ANTLR start "PLUS"
    public final void mPLUS() throws RecognitionException {
        try {
            int _type = PLUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:351:9: ( '+' )
            // jaitools/jiffle/parser/Jiffle.g:351:11: '+'
            {
            match('+'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "PLUS"

    // $ANTLR start "MINUS"
    public final void mMINUS() throws RecognitionException {
        try {
            int _type = MINUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:352:9: ( '-' )
            // jaitools/jiffle/parser/Jiffle.g:352:11: '-'
            {
            match('-'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MINUS"

    // $ANTLR start "GT"
    public final void mGT() throws RecognitionException {
        try {
            int _type = GT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:353:9: ( '>' )
            // jaitools/jiffle/parser/Jiffle.g:353:11: '>'
            {
            match('>'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GT"

    // $ANTLR start "GE"
    public final void mGE() throws RecognitionException {
        try {
            int _type = GE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:354:9: ( '>=' )
            // jaitools/jiffle/parser/Jiffle.g:354:11: '>='
            {
            match(">="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GE"

    // $ANTLR start "LE"
    public final void mLE() throws RecognitionException {
        try {
            int _type = LE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:355:9: ( '<=' )
            // jaitools/jiffle/parser/Jiffle.g:355:11: '<='
            {
            match("<="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LE"

    // $ANTLR start "LT"
    public final void mLT() throws RecognitionException {
        try {
            int _type = LT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:356:9: ( '<' )
            // jaitools/jiffle/parser/Jiffle.g:356:11: '<'
            {
            match('<'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LT"

    // $ANTLR start "LOGICALEQ"
    public final void mLOGICALEQ() throws RecognitionException {
        try {
            int _type = LOGICALEQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:357:11: ( '==' )
            // jaitools/jiffle/parser/Jiffle.g:357:13: '=='
            {
            match("=="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LOGICALEQ"

    // $ANTLR start "NE"
    public final void mNE() throws RecognitionException {
        try {
            int _type = NE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:358:9: ( '!=' )
            // jaitools/jiffle/parser/Jiffle.g:358:11: '!='
            {
            match("!="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NE"

    // $ANTLR start "AND"
    public final void mAND() throws RecognitionException {
        try {
            int _type = AND;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:359:9: ( '&&' )
            // jaitools/jiffle/parser/Jiffle.g:359:11: '&&'
            {
            match("&&"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "AND"

    // $ANTLR start "OR"
    public final void mOR() throws RecognitionException {
        try {
            int _type = OR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:360:9: ( '||' )
            // jaitools/jiffle/parser/Jiffle.g:360:11: '||'
            {
            match("||"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "OR"

    // $ANTLR start "XOR"
    public final void mXOR() throws RecognitionException {
        try {
            int _type = XOR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:361:9: ( '^|' )
            // jaitools/jiffle/parser/Jiffle.g:361:11: '^|'
            {
            match("^|"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "XOR"

    // $ANTLR start "QUESTION"
    public final void mQUESTION() throws RecognitionException {
        try {
            int _type = QUESTION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:362:9: ( '?' )
            // jaitools/jiffle/parser/Jiffle.g:362:11: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "QUESTION"

    // $ANTLR start "TIMESEQ"
    public final void mTIMESEQ() throws RecognitionException {
        try {
            int _type = TIMESEQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:363:9: ( '*=' )
            // jaitools/jiffle/parser/Jiffle.g:363:11: '*='
            {
            match("*="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "TIMESEQ"

    // $ANTLR start "DIVEQ"
    public final void mDIVEQ() throws RecognitionException {
        try {
            int _type = DIVEQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:364:9: ( '/=' )
            // jaitools/jiffle/parser/Jiffle.g:364:11: '/='
            {
            match("/="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DIVEQ"

    // $ANTLR start "MODEQ"
    public final void mMODEQ() throws RecognitionException {
        try {
            int _type = MODEQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:365:9: ( '%=' )
            // jaitools/jiffle/parser/Jiffle.g:365:11: '%='
            {
            match("%="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MODEQ"

    // $ANTLR start "PLUSEQ"
    public final void mPLUSEQ() throws RecognitionException {
        try {
            int _type = PLUSEQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:366:9: ( '+=' )
            // jaitools/jiffle/parser/Jiffle.g:366:11: '+='
            {
            match("+="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "PLUSEQ"

    // $ANTLR start "MINUSEQ"
    public final void mMINUSEQ() throws RecognitionException {
        try {
            int _type = MINUSEQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:367:9: ( '-=' )
            // jaitools/jiffle/parser/Jiffle.g:367:11: '-='
            {
            match("-="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MINUSEQ"

    // $ANTLR start "EQ"
    public final void mEQ() throws RecognitionException {
        try {
            int _type = EQ;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:368:9: ( '=' )
            // jaitools/jiffle/parser/Jiffle.g:368:11: '='
            {
            match('='); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "EQ"

    // $ANTLR start "COMMA"
    public final void mCOMMA() throws RecognitionException {
        try {
            int _type = COMMA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:371:9: ( ',' )
            // jaitools/jiffle/parser/Jiffle.g:371:11: ','
            {
            match(','); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COMMA"

    // $ANTLR start "SEMI"
    public final void mSEMI() throws RecognitionException {
        try {
            int _type = SEMI;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:372:9: ( ';' )
            // jaitools/jiffle/parser/Jiffle.g:372:11: ';'
            {
            match(';'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "SEMI"

    // $ANTLR start "COLON"
    public final void mCOLON() throws RecognitionException {
        try {
            int _type = COLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:373:9: ( ':' )
            // jaitools/jiffle/parser/Jiffle.g:373:11: ':'
            {
            match(':'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COLON"

    // $ANTLR start "LPAR"
    public final void mLPAR() throws RecognitionException {
        try {
            int _type = LPAR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:374:9: ( '(' )
            // jaitools/jiffle/parser/Jiffle.g:374:11: '('
            {
            match('('); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LPAR"

    // $ANTLR start "RPAR"
    public final void mRPAR() throws RecognitionException {
        try {
            int _type = RPAR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:375:9: ( ')' )
            // jaitools/jiffle/parser/Jiffle.g:375:11: ')'
            {
            match(')'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RPAR"

    // $ANTLR start "LSQUARE"
    public final void mLSQUARE() throws RecognitionException {
        try {
            int _type = LSQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:376:9: ( '[' )
            // jaitools/jiffle/parser/Jiffle.g:376:11: '['
            {
            match('['); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LSQUARE"

    // $ANTLR start "RSQUARE"
    public final void mRSQUARE() throws RecognitionException {
        try {
            int _type = RSQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:377:9: ( ']' )
            // jaitools/jiffle/parser/Jiffle.g:377:11: ']'
            {
            match(']'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RSQUARE"

    // $ANTLR start "LCURLY"
    public final void mLCURLY() throws RecognitionException {
        try {
            int _type = LCURLY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:378:9: ( '{' )
            // jaitools/jiffle/parser/Jiffle.g:378:11: '{'
            {
            match('{'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LCURLY"

    // $ANTLR start "RCURLY"
    public final void mRCURLY() throws RecognitionException {
        try {
            int _type = RCURLY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:379:9: ( '}' )
            // jaitools/jiffle/parser/Jiffle.g:379:11: '}'
            {
            match('}'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RCURLY"

    // $ANTLR start "ID"
    public final void mID() throws RecognitionException {
        try {
            int _type = ID;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:381:9: ( ( Letter ) ( Letter | UNDERSCORE | Digit | Dot )* )
            // jaitools/jiffle/parser/Jiffle.g:381:11: ( Letter ) ( Letter | UNDERSCORE | Digit | Dot )*
            {
            // jaitools/jiffle/parser/Jiffle.g:381:11: ( Letter )
            // jaitools/jiffle/parser/Jiffle.g:381:12: Letter
            {
            mLetter(); 

            }

            // jaitools/jiffle/parser/Jiffle.g:381:20: ( Letter | UNDERSCORE | Digit | Dot )*
            loop8:
            do {
                int alt8=2;
                switch ( input.LA(1) ) {
                case '.':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt8=1;
                    }
                    break;

                }

                switch (alt8) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:
            	    {
            	    if ( input.LA(1)=='.'||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop8;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ID"

    // $ANTLR start "Letter"
    public final void mLetter() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:386:9: ( 'a' .. 'z' | 'A' .. 'Z' )
            // jaitools/jiffle/parser/Jiffle.g:
            {
            if ( (input.LA(1)>='A' && input.LA(1)<='Z')||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "Letter"

    // $ANTLR start "UNDERSCORE"
    public final void mUNDERSCORE() throws RecognitionException {
        try {
            int _type = UNDERSCORE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:390:9: ( '_' )
            // jaitools/jiffle/parser/Jiffle.g:390:11: '_'
            {
            match('_'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "UNDERSCORE"

    // $ANTLR start "INT_LITERAL"
    public final void mINT_LITERAL() throws RecognitionException {
        try {
            int _type = INT_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:393:9: ( '0' | NonZeroDigit ( Digit )* )
            int alt10=2;
            switch ( input.LA(1) ) {
            case '0':
                {
                alt10=1;
                }
                break;
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                {
                alt10=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }

            switch (alt10) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:393:11: '0'
                    {
                    match('0'); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:393:17: NonZeroDigit ( Digit )*
                    {
                    mNonZeroDigit(); 
                    // jaitools/jiffle/parser/Jiffle.g:393:30: ( Digit )*
                    loop9:
                    do {
                        int alt9=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt9=1;
                            }
                            break;

                        }

                        switch (alt9) {
                    	case 1 :
                    	    // jaitools/jiffle/parser/Jiffle.g:393:30: Digit
                    	    {
                    	    mDigit(); 

                    	    }
                    	    break;

                    	default :
                    	    break loop9;
                        }
                    } while (true);


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "INT_LITERAL"

    // $ANTLR start "FLOAT_LITERAL"
    public final void mFLOAT_LITERAL() throws RecognitionException {
        try {
            int _type = FLOAT_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:397:9: ( ( '0' | NonZeroDigit ( Digit )* )? Dot ( Digit )* ( FloatExp )? )
            // jaitools/jiffle/parser/Jiffle.g:397:11: ( '0' | NonZeroDigit ( Digit )* )? Dot ( Digit )* ( FloatExp )?
            {
            // jaitools/jiffle/parser/Jiffle.g:397:11: ( '0' | NonZeroDigit ( Digit )* )?
            int alt12=3;
            switch ( input.LA(1) ) {
                case '0':
                    {
                    alt12=1;
                    }
                    break;
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt12=2;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:397:12: '0'
                    {
                    match('0'); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:397:18: NonZeroDigit ( Digit )*
                    {
                    mNonZeroDigit(); 
                    // jaitools/jiffle/parser/Jiffle.g:397:31: ( Digit )*
                    loop11:
                    do {
                        int alt11=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt11=1;
                            }
                            break;

                        }

                        switch (alt11) {
                    	case 1 :
                    	    // jaitools/jiffle/parser/Jiffle.g:397:31: Digit
                    	    {
                    	    mDigit(); 

                    	    }
                    	    break;

                    	default :
                    	    break loop11;
                        }
                    } while (true);


                    }
                    break;

            }

            mDot(); 
            // jaitools/jiffle/parser/Jiffle.g:397:44: ( Digit )*
            loop13:
            do {
                int alt13=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt13=1;
                    }
                    break;

                }

                switch (alt13) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:397:44: Digit
            	    {
            	    mDigit(); 

            	    }
            	    break;

            	default :
            	    break loop13;
                }
            } while (true);

            // jaitools/jiffle/parser/Jiffle.g:397:51: ( FloatExp )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case 'E':
                case 'e':
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:397:51: FloatExp
                    {
                    mFloatExp(); 

                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "FLOAT_LITERAL"

    // $ANTLR start "Digit"
    public final void mDigit() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:401:9: ( '0' .. '9' )
            // jaitools/jiffle/parser/Jiffle.g:401:11: '0' .. '9'
            {
            matchRange('0','9'); 

            }

        }
        finally {
        }
    }
    // $ANTLR end "Digit"

    // $ANTLR start "Dot"
    public final void mDot() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:404:9: ( '.' )
            // jaitools/jiffle/parser/Jiffle.g:404:11: '.'
            {
            match('.'); 

            }

        }
        finally {
        }
    }
    // $ANTLR end "Dot"

    // $ANTLR start "NonZeroDigit"
    public final void mNonZeroDigit() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:408:9: ( '1' .. '9' )
            // jaitools/jiffle/parser/Jiffle.g:408:11: '1' .. '9'
            {
            matchRange('1','9'); 

            }

        }
        finally {
        }
    }
    // $ANTLR end "NonZeroDigit"

    // $ANTLR start "FloatExp"
    public final void mFloatExp() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:413:9: ( ( 'e' | 'E' ( PLUS | MINUS )? ( '0' .. '9' )+ ) )
            // jaitools/jiffle/parser/Jiffle.g:413:11: ( 'e' | 'E' ( PLUS | MINUS )? ( '0' .. '9' )+ )
            {
            // jaitools/jiffle/parser/Jiffle.g:413:11: ( 'e' | 'E' ( PLUS | MINUS )? ( '0' .. '9' )+ )
            int alt17=2;
            switch ( input.LA(1) ) {
            case 'e':
                {
                alt17=1;
                }
                break;
            case 'E':
                {
                alt17=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;
            }

            switch (alt17) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:413:12: 'e'
                    {
                    match('e'); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:413:16: 'E' ( PLUS | MINUS )? ( '0' .. '9' )+
                    {
                    match('E'); 
                    // jaitools/jiffle/parser/Jiffle.g:413:20: ( PLUS | MINUS )?
                    int alt15=2;
                    switch ( input.LA(1) ) {
                        case '+':
                        case '-':
                            {
                            alt15=1;
                            }
                            break;
                    }

                    switch (alt15) {
                        case 1 :
                            // jaitools/jiffle/parser/Jiffle.g:
                            {
                            if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
                                input.consume();

                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;}


                            }
                            break;

                    }

                    // jaitools/jiffle/parser/Jiffle.g:413:34: ( '0' .. '9' )+
                    int cnt16=0;
                    loop16:
                    do {
                        int alt16=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt16=1;
                            }
                            break;

                        }

                        switch (alt16) {
                    	case 1 :
                    	    // jaitools/jiffle/parser/Jiffle.g:413:34: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); 

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt16 >= 1 ) break loop16;
                                EarlyExitException eee =
                                    new EarlyExitException(16, input);
                                throw eee;
                        }
                        cnt16++;
                    } while (true);


                    }
                    break;

            }


            }

        }
        finally {
        }
    }
    // $ANTLR end "FloatExp"

    // $ANTLR start "WS"
    public final void mWS() throws RecognitionException {
        try {
            int _type = WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:416:5: ( ( ' ' | '\\t' | '\\r' | '\\n' | '\\u000C' ) )
            // jaitools/jiffle/parser/Jiffle.g:416:9: ( ' ' | '\\t' | '\\r' | '\\n' | '\\u000C' )
            {
            if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||(input.LA(1)>='\f' && input.LA(1)<='\r')||input.LA(1)==' ' ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            _channel=HIDDEN;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "WS"

    // $ANTLR start "CHAR"
    public final void mCHAR() throws RecognitionException {
        try {
            int _type = CHAR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // jaitools/jiffle/parser/Jiffle.g:429:5: ( '\\'' ( ESC_SEQ | ~ ( '\\'' | '\\\\' ) ) '\\'' )
            // jaitools/jiffle/parser/Jiffle.g:429:8: '\\'' ( ESC_SEQ | ~ ( '\\'' | '\\\\' ) ) '\\''
            {
            match('\''); 
            // jaitools/jiffle/parser/Jiffle.g:429:13: ( ESC_SEQ | ~ ( '\\'' | '\\\\' ) )
            int alt18=2;
            int LA18_0 = input.LA(1);

            if ( (LA18_0=='\\') ) {
                alt18=1;
            }
            else if ( ((LA18_0>='\u0000' && LA18_0<='&')||(LA18_0>='(' && LA18_0<='[')||(LA18_0>=']' && LA18_0<='\uFFFF')) ) {
                alt18=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }
            switch (alt18) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:429:15: ESC_SEQ
                    {
                    mESC_SEQ(); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:429:25: ~ ( '\\'' | '\\\\' )
                    {
                    if ( (input.LA(1)>='\u0000' && input.LA(1)<='&')||(input.LA(1)>='(' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
                        input.consume();

                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;}


                    }
                    break;

            }

            match('\''); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "CHAR"

    // $ANTLR start "HEX_DIGIT"
    public final void mHEX_DIGIT() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:433:11: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )
            // jaitools/jiffle/parser/Jiffle.g:433:13: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
            {
            if ( (input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='F')||(input.LA(1)>='a' && input.LA(1)<='f') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "HEX_DIGIT"

    // $ANTLR start "ESC_SEQ"
    public final void mESC_SEQ() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:437:5: ( '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' ) | UNICODE_ESC | OCTAL_ESC )
            int alt19=3;
            switch ( input.LA(1) ) {
            case '\\':
                {
                switch ( input.LA(2) ) {
                case '\"':
                case '\'':
                case '\\':
                case 'b':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                    {
                    alt19=1;
                    }
                    break;
                case 'u':
                    {
                    alt19=2;
                    }
                    break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt19=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 19, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;
            }

            switch (alt19) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:437:9: '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' )
                    {
                    match('\\'); 
                    if ( input.LA(1)=='\"'||input.LA(1)=='\''||input.LA(1)=='\\'||input.LA(1)=='b'||input.LA(1)=='f'||input.LA(1)=='n'||input.LA(1)=='r'||input.LA(1)=='t' ) {
                        input.consume();

                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;}


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:438:9: UNICODE_ESC
                    {
                    mUNICODE_ESC(); 

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:439:9: OCTAL_ESC
                    {
                    mOCTAL_ESC(); 

                    }
                    break;

            }
        }
        finally {
        }
    }
    // $ANTLR end "ESC_SEQ"

    // $ANTLR start "OCTAL_ESC"
    public final void mOCTAL_ESC() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:444:5: ( '\\\\' ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | '\\\\' ( '0' .. '7' ) ( '0' .. '7' ) | '\\\\' ( '0' .. '7' ) )
            int alt20=3;
            switch ( input.LA(1) ) {
            case '\\':
                {
                switch ( input.LA(2) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                    {
                    switch ( input.LA(3) ) {
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                        {
                        switch ( input.LA(4) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                            {
                            alt20=1;
                            }
                            break;
                        default:
                            alt20=2;}

                        }
                        break;
                    default:
                        alt20=3;}

                    }
                    break;
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    switch ( input.LA(3) ) {
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                        {
                        alt20=2;
                        }
                        break;
                    default:
                        alt20=3;}

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 20, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;
            }

            switch (alt20) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:444:9: '\\\\' ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    match('\\'); 
                    // jaitools/jiffle/parser/Jiffle.g:444:14: ( '0' .. '3' )
                    // jaitools/jiffle/parser/Jiffle.g:444:15: '0' .. '3'
                    {
                    matchRange('0','3'); 

                    }

                    // jaitools/jiffle/parser/Jiffle.g:444:25: ( '0' .. '7' )
                    // jaitools/jiffle/parser/Jiffle.g:444:26: '0' .. '7'
                    {
                    matchRange('0','7'); 

                    }

                    // jaitools/jiffle/parser/Jiffle.g:444:36: ( '0' .. '7' )
                    // jaitools/jiffle/parser/Jiffle.g:444:37: '0' .. '7'
                    {
                    matchRange('0','7'); 

                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:445:9: '\\\\' ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    match('\\'); 
                    // jaitools/jiffle/parser/Jiffle.g:445:14: ( '0' .. '7' )
                    // jaitools/jiffle/parser/Jiffle.g:445:15: '0' .. '7'
                    {
                    matchRange('0','7'); 

                    }

                    // jaitools/jiffle/parser/Jiffle.g:445:25: ( '0' .. '7' )
                    // jaitools/jiffle/parser/Jiffle.g:445:26: '0' .. '7'
                    {
                    matchRange('0','7'); 

                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:446:9: '\\\\' ( '0' .. '7' )
                    {
                    match('\\'); 
                    // jaitools/jiffle/parser/Jiffle.g:446:14: ( '0' .. '7' )
                    // jaitools/jiffle/parser/Jiffle.g:446:15: '0' .. '7'
                    {
                    matchRange('0','7'); 

                    }


                    }
                    break;

            }
        }
        finally {
        }
    }
    // $ANTLR end "OCTAL_ESC"

    // $ANTLR start "UNICODE_ESC"
    public final void mUNICODE_ESC() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/Jiffle.g:451:5: ( '\\\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT )
            // jaitools/jiffle/parser/Jiffle.g:451:9: '\\\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
            {
            match('\\'); 
            match('u'); 
            mHEX_DIGIT(); 
            mHEX_DIGIT(); 
            mHEX_DIGIT(); 
            mHEX_DIGIT(); 

            }

        }
        finally {
        }
    }
    // $ANTLR end "UNICODE_ESC"

    public void mTokens() throws RecognitionException {
        // jaitools/jiffle/parser/Jiffle.g:1:8: ( COMMENT | TRUE | FALSE | NULL | INT_TYPE | FLOAT_TYPE | DOUBLE_TYPE | BOOLEAN_TYPE | OPTIONS | INIT | IF | WHILE | UNTIL | FOREACH | IN | BREAKIF | ABS_POS_PREFIX | APPEND | INCR | DECR | NOT | POW | TIMES | DIV | MOD | PLUS | MINUS | GT | GE | LE | LT | LOGICALEQ | NE | AND | OR | XOR | QUESTION | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ | EQ | COMMA | SEMI | COLON | LPAR | RPAR | LSQUARE | RSQUARE | LCURLY | RCURLY | ID | UNDERSCORE | INT_LITERAL | FLOAT_LITERAL | WS | CHAR )
        int alt21=58;
        alt21 = dfa21.predict(input);
        switch (alt21) {
            case 1 :
                // jaitools/jiffle/parser/Jiffle.g:1:10: COMMENT
                {
                mCOMMENT(); 

                }
                break;
            case 2 :
                // jaitools/jiffle/parser/Jiffle.g:1:18: TRUE
                {
                mTRUE(); 

                }
                break;
            case 3 :
                // jaitools/jiffle/parser/Jiffle.g:1:23: FALSE
                {
                mFALSE(); 

                }
                break;
            case 4 :
                // jaitools/jiffle/parser/Jiffle.g:1:29: NULL
                {
                mNULL(); 

                }
                break;
            case 5 :
                // jaitools/jiffle/parser/Jiffle.g:1:34: INT_TYPE
                {
                mINT_TYPE(); 

                }
                break;
            case 6 :
                // jaitools/jiffle/parser/Jiffle.g:1:43: FLOAT_TYPE
                {
                mFLOAT_TYPE(); 

                }
                break;
            case 7 :
                // jaitools/jiffle/parser/Jiffle.g:1:54: DOUBLE_TYPE
                {
                mDOUBLE_TYPE(); 

                }
                break;
            case 8 :
                // jaitools/jiffle/parser/Jiffle.g:1:66: BOOLEAN_TYPE
                {
                mBOOLEAN_TYPE(); 

                }
                break;
            case 9 :
                // jaitools/jiffle/parser/Jiffle.g:1:79: OPTIONS
                {
                mOPTIONS(); 

                }
                break;
            case 10 :
                // jaitools/jiffle/parser/Jiffle.g:1:87: INIT
                {
                mINIT(); 

                }
                break;
            case 11 :
                // jaitools/jiffle/parser/Jiffle.g:1:92: IF
                {
                mIF(); 

                }
                break;
            case 12 :
                // jaitools/jiffle/parser/Jiffle.g:1:95: WHILE
                {
                mWHILE(); 

                }
                break;
            case 13 :
                // jaitools/jiffle/parser/Jiffle.g:1:101: UNTIL
                {
                mUNTIL(); 

                }
                break;
            case 14 :
                // jaitools/jiffle/parser/Jiffle.g:1:107: FOREACH
                {
                mFOREACH(); 

                }
                break;
            case 15 :
                // jaitools/jiffle/parser/Jiffle.g:1:115: IN
                {
                mIN(); 

                }
                break;
            case 16 :
                // jaitools/jiffle/parser/Jiffle.g:1:118: BREAKIF
                {
                mBREAKIF(); 

                }
                break;
            case 17 :
                // jaitools/jiffle/parser/Jiffle.g:1:126: ABS_POS_PREFIX
                {
                mABS_POS_PREFIX(); 

                }
                break;
            case 18 :
                // jaitools/jiffle/parser/Jiffle.g:1:141: APPEND
                {
                mAPPEND(); 

                }
                break;
            case 19 :
                // jaitools/jiffle/parser/Jiffle.g:1:148: INCR
                {
                mINCR(); 

                }
                break;
            case 20 :
                // jaitools/jiffle/parser/Jiffle.g:1:153: DECR
                {
                mDECR(); 

                }
                break;
            case 21 :
                // jaitools/jiffle/parser/Jiffle.g:1:158: NOT
                {
                mNOT(); 

                }
                break;
            case 22 :
                // jaitools/jiffle/parser/Jiffle.g:1:162: POW
                {
                mPOW(); 

                }
                break;
            case 23 :
                // jaitools/jiffle/parser/Jiffle.g:1:166: TIMES
                {
                mTIMES(); 

                }
                break;
            case 24 :
                // jaitools/jiffle/parser/Jiffle.g:1:172: DIV
                {
                mDIV(); 

                }
                break;
            case 25 :
                // jaitools/jiffle/parser/Jiffle.g:1:176: MOD
                {
                mMOD(); 

                }
                break;
            case 26 :
                // jaitools/jiffle/parser/Jiffle.g:1:180: PLUS
                {
                mPLUS(); 

                }
                break;
            case 27 :
                // jaitools/jiffle/parser/Jiffle.g:1:185: MINUS
                {
                mMINUS(); 

                }
                break;
            case 28 :
                // jaitools/jiffle/parser/Jiffle.g:1:191: GT
                {
                mGT(); 

                }
                break;
            case 29 :
                // jaitools/jiffle/parser/Jiffle.g:1:194: GE
                {
                mGE(); 

                }
                break;
            case 30 :
                // jaitools/jiffle/parser/Jiffle.g:1:197: LE
                {
                mLE(); 

                }
                break;
            case 31 :
                // jaitools/jiffle/parser/Jiffle.g:1:200: LT
                {
                mLT(); 

                }
                break;
            case 32 :
                // jaitools/jiffle/parser/Jiffle.g:1:203: LOGICALEQ
                {
                mLOGICALEQ(); 

                }
                break;
            case 33 :
                // jaitools/jiffle/parser/Jiffle.g:1:213: NE
                {
                mNE(); 

                }
                break;
            case 34 :
                // jaitools/jiffle/parser/Jiffle.g:1:216: AND
                {
                mAND(); 

                }
                break;
            case 35 :
                // jaitools/jiffle/parser/Jiffle.g:1:220: OR
                {
                mOR(); 

                }
                break;
            case 36 :
                // jaitools/jiffle/parser/Jiffle.g:1:223: XOR
                {
                mXOR(); 

                }
                break;
            case 37 :
                // jaitools/jiffle/parser/Jiffle.g:1:227: QUESTION
                {
                mQUESTION(); 

                }
                break;
            case 38 :
                // jaitools/jiffle/parser/Jiffle.g:1:236: TIMESEQ
                {
                mTIMESEQ(); 

                }
                break;
            case 39 :
                // jaitools/jiffle/parser/Jiffle.g:1:244: DIVEQ
                {
                mDIVEQ(); 

                }
                break;
            case 40 :
                // jaitools/jiffle/parser/Jiffle.g:1:250: MODEQ
                {
                mMODEQ(); 

                }
                break;
            case 41 :
                // jaitools/jiffle/parser/Jiffle.g:1:256: PLUSEQ
                {
                mPLUSEQ(); 

                }
                break;
            case 42 :
                // jaitools/jiffle/parser/Jiffle.g:1:263: MINUSEQ
                {
                mMINUSEQ(); 

                }
                break;
            case 43 :
                // jaitools/jiffle/parser/Jiffle.g:1:271: EQ
                {
                mEQ(); 

                }
                break;
            case 44 :
                // jaitools/jiffle/parser/Jiffle.g:1:274: COMMA
                {
                mCOMMA(); 

                }
                break;
            case 45 :
                // jaitools/jiffle/parser/Jiffle.g:1:280: SEMI
                {
                mSEMI(); 

                }
                break;
            case 46 :
                // jaitools/jiffle/parser/Jiffle.g:1:285: COLON
                {
                mCOLON(); 

                }
                break;
            case 47 :
                // jaitools/jiffle/parser/Jiffle.g:1:291: LPAR
                {
                mLPAR(); 

                }
                break;
            case 48 :
                // jaitools/jiffle/parser/Jiffle.g:1:296: RPAR
                {
                mRPAR(); 

                }
                break;
            case 49 :
                // jaitools/jiffle/parser/Jiffle.g:1:301: LSQUARE
                {
                mLSQUARE(); 

                }
                break;
            case 50 :
                // jaitools/jiffle/parser/Jiffle.g:1:309: RSQUARE
                {
                mRSQUARE(); 

                }
                break;
            case 51 :
                // jaitools/jiffle/parser/Jiffle.g:1:317: LCURLY
                {
                mLCURLY(); 

                }
                break;
            case 52 :
                // jaitools/jiffle/parser/Jiffle.g:1:324: RCURLY
                {
                mRCURLY(); 

                }
                break;
            case 53 :
                // jaitools/jiffle/parser/Jiffle.g:1:331: ID
                {
                mID(); 

                }
                break;
            case 54 :
                // jaitools/jiffle/parser/Jiffle.g:1:334: UNDERSCORE
                {
                mUNDERSCORE(); 

                }
                break;
            case 55 :
                // jaitools/jiffle/parser/Jiffle.g:1:345: INT_LITERAL
                {
                mINT_LITERAL(); 

                }
                break;
            case 56 :
                // jaitools/jiffle/parser/Jiffle.g:1:357: FLOAT_LITERAL
                {
                mFLOAT_LITERAL(); 

                }
                break;
            case 57 :
                // jaitools/jiffle/parser/Jiffle.g:1:371: WS
                {
                mWS(); 

                }
                break;
            case 58 :
                // jaitools/jiffle/parser/Jiffle.g:1:374: CHAR
                {
                mCHAR(); 

                }
                break;

        }

    }


    protected DFA21 dfa21 = new DFA21(this);
    static final String DFA21_eotS =
        "\1\uffff\1\55\14\44\1\uffff\1\100\1\103\1\106\1\110\1\112\1\114"+
        "\1\116\1\120\1\122\16\uffff\2\123\6\uffff\10\44\1\137\1\140\6\44"+
        "\26\uffff\1\123\10\44\1\157\1\44\2\uffff\6\44\2\167\4\44\2\174\1"+
        "\uffff\1\175\6\44\1\uffff\2\u0084\1\u0085\1\44\2\uffff\4\44\1\u008b"+
        "\1\u008c\2\uffff\1\44\1\u008e\3\44\2\uffff\1\u0092\1\uffff\1\u0093"+
        "\1\u0094\1\u0095\4\uffff";
    static final String DFA21_eofS =
        "\u0096\uffff";
    static final String DFA21_minS =
        "\1\11\1\52\1\122\1\162\1\101\1\141\1\125\1\165\1\146\2\157\1\160"+
        "\1\150\1\156\1\uffff\1\74\1\53\1\55\1\75\1\174\4\75\16\uffff\2\56"+
        "\6\uffff\1\125\1\165\1\114\1\154\1\157\1\162\1\114\1\154\2\56\1"+
        "\165\1\157\1\145\1\164\1\151\1\164\26\uffff\1\56\1\105\1\145\1\123"+
        "\1\163\1\141\1\145\1\114\1\154\1\56\1\164\2\uffff\1\142\1\154\1"+
        "\141\1\151\1\154\1\151\2\56\1\105\1\145\1\164\1\141\2\56\1\uffff"+
        "\1\56\1\154\1\145\1\153\1\157\1\145\1\154\1\uffff\3\56\1\143\2\uffff"+
        "\1\145\1\141\1\151\1\156\2\56\2\uffff\1\150\1\56\1\156\1\146\1\163"+
        "\2\uffff\1\56\1\uffff\3\56\4\uffff";
    static final String DFA21_maxS =
        "\1\175\1\75\1\122\1\162\1\101\1\157\1\125\1\165\1\156\1\157\1\162"+
        "\1\160\1\150\1\156\1\uffff\4\75\1\174\4\75\16\uffff\1\56\1\71\6"+
        "\uffff\1\125\1\165\1\114\1\154\1\157\1\162\1\114\1\154\2\172\1\165"+
        "\1\157\1\145\1\164\1\151\1\164\26\uffff\1\71\1\105\1\145\1\123\1"+
        "\163\1\141\1\145\1\114\1\154\1\172\1\164\2\uffff\1\142\1\154\1\141"+
        "\1\151\1\154\1\151\2\172\1\105\1\145\1\164\1\141\2\172\1\uffff\1"+
        "\172\1\154\1\145\1\153\1\157\1\145\1\154\1\uffff\3\172\1\143\2\uffff"+
        "\1\145\1\141\1\151\1\156\2\172\2\uffff\1\150\1\172\1\156\1\146\1"+
        "\163\2\uffff\1\172\1\uffff\3\172\4\uffff";
    static final String DFA21_acceptS =
        "\16\uffff\1\21\11\uffff\1\42\1\43\1\45\1\54\1\55\1\56\1\57\1\60"+
        "\1\61\1\62\1\63\1\64\1\65\1\66\2\uffff\1\70\1\71\1\72\1\1\1\47\1"+
        "\30\20\uffff\1\22\1\36\1\37\1\23\1\51\1\32\1\24\1\52\1\33\1\41\1"+
        "\25\1\44\1\26\1\46\1\27\1\50\1\31\1\35\1\34\1\40\1\53\1\67\13\uffff"+
        "\1\17\1\13\16\uffff\1\5\7\uffff\1\2\4\uffff\1\4\1\12\6\uffff\1\3"+
        "\1\6\5\uffff\1\14\1\15\1\uffff\1\7\3\uffff\1\16\1\10\1\20\1\11";
    static final String DFA21_specialS =
        "\u0096\uffff}>";
    static final String[] DFA21_transitionS = {
            "\2\51\1\uffff\2\51\22\uffff\1\51\1\22\2\uffff\1\16\1\25\1\30"+
            "\1\52\1\36\1\37\1\24\1\20\1\33\1\21\1\50\1\1\1\46\11\47\1\35"+
            "\1\34\1\17\1\27\1\26\1\32\1\uffff\5\44\1\4\7\44\1\6\5\44\1\2"+
            "\6\44\1\40\1\uffff\1\41\1\23\1\45\1\uffff\1\44\1\12\1\44\1\11"+
            "\1\44\1\5\2\44\1\10\4\44\1\7\1\13\4\44\1\3\1\15\1\44\1\14\3"+
            "\44\1\42\1\31\1\43",
            "\1\53\4\uffff\1\53\15\uffff\1\54",
            "\1\56",
            "\1\57",
            "\1\60",
            "\1\61\12\uffff\1\62\2\uffff\1\63",
            "\1\64",
            "\1\65",
            "\1\67\7\uffff\1\66",
            "\1\70",
            "\1\71\2\uffff\1\72",
            "\1\73",
            "\1\74",
            "\1\75",
            "",
            "\1\76\1\77",
            "\1\101\21\uffff\1\102",
            "\1\104\17\uffff\1\105",
            "\1\107",
            "\1\111",
            "\1\113",
            "\1\115",
            "\1\117",
            "\1\121",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\50",
            "\1\50\1\uffff\12\124",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\125",
            "\1\126",
            "\1\127",
            "\1\130",
            "\1\131",
            "\1\132",
            "\1\133",
            "\1\134",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\10\44"+
            "\1\136\12\44\1\135\6\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\141",
            "\1\142",
            "\1\143",
            "\1\144",
            "\1\145",
            "\1\146",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\50\1\uffff\12\124",
            "\1\147",
            "\1\150",
            "\1\151",
            "\1\152",
            "\1\153",
            "\1\154",
            "\1\155",
            "\1\156",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\160",
            "",
            "",
            "\1\161",
            "\1\162",
            "\1\163",
            "\1\164",
            "\1\165",
            "\1\166",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\170",
            "\1\171",
            "\1\172",
            "\1\173",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\176",
            "\1\177",
            "\1\u0080",
            "\1\u0081",
            "\1\u0082",
            "\1\u0083",
            "",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\u0086",
            "",
            "",
            "\1\u0087",
            "\1\u0088",
            "\1\u0089",
            "\1\u008a",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "",
            "",
            "\1\u008d",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\u008f",
            "\1\u0090",
            "\1\u0091",
            "",
            "",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "\1\44\1\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff\32\44",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA21_eot = DFA.unpackEncodedString(DFA21_eotS);
    static final short[] DFA21_eof = DFA.unpackEncodedString(DFA21_eofS);
    static final char[] DFA21_min = DFA.unpackEncodedStringToUnsignedChars(DFA21_minS);
    static final char[] DFA21_max = DFA.unpackEncodedStringToUnsignedChars(DFA21_maxS);
    static final short[] DFA21_accept = DFA.unpackEncodedString(DFA21_acceptS);
    static final short[] DFA21_special = DFA.unpackEncodedString(DFA21_specialS);
    static final short[][] DFA21_transition;

    static {
        int numStates = DFA21_transitionS.length;
        DFA21_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA21_transition[i] = DFA.unpackEncodedString(DFA21_transitionS[i]);
        }
    }

    class DFA21 extends DFA {

        public DFA21(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 21;
            this.eot = DFA21_eot;
            this.eof = DFA21_eof;
            this.min = DFA21_min;
            this.max = DFA21_max;
            this.accept = DFA21_accept;
            this.special = DFA21_special;
            this.transition = DFA21_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( COMMENT | TRUE | FALSE | NULL | INT_TYPE | FLOAT_TYPE | DOUBLE_TYPE | BOOLEAN_TYPE | OPTIONS | INIT | IF | WHILE | UNTIL | FOREACH | IN | BREAKIF | ABS_POS_PREFIX | APPEND | INCR | DECR | NOT | POW | TIMES | DIV | MOD | PLUS | MINUS | GT | GE | LE | LT | LOGICALEQ | NE | AND | OR | XOR | QUESTION | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ | EQ | COMMA | SEMI | COLON | LPAR | RPAR | LSQUARE | RSQUARE | LCURLY | RCURLY | ID | UNDERSCORE | INT_LITERAL | FLOAT_LITERAL | WS | CHAR );";
        }
    }
 

}