// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/Jiffle.g 2011-03-08 17:37:54

package jaitools.jiffle.parser;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.tree.*;

/**
 * Jiffle language parser grammar. Generates the primary AST
 * from an input Jiffle script.
 *
 * @author Michael Bedward
 */
public class JiffleParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public JiffleParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public JiffleParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
            this.state.ruleMemo = new HashMap[44+1];
             
             
        }
        
    protected TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }
    public TreeAdaptor getTreeAdaptor() {
        return adaptor;
    }

    public String[] getTokenNames() { return JiffleParser.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/Jiffle.g"; }



    @Override
    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow) throws RecognitionException {
        if (ttype == Token.EOF) {
            throw new UnexpectedInputException("Invalid statement before end of file");
        }
        return super.recoverFromMismatchedToken(input, ttype, follow);
    }



    public static class prog_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prog"
    // jaitools/jiffle/parser/Jiffle.g:86:1: prog : ( optionsBlock )? ( initBlock )? ( statement )+ EOF ;
    public final JiffleParser.prog_return prog() throws RecognitionException {
        JiffleParser.prog_return retval = new JiffleParser.prog_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token EOF4=null;
        JiffleParser.optionsBlock_return optionsBlock1 = null;

        JiffleParser.initBlock_return initBlock2 = null;

        JiffleParser.statement_return statement3 = null;


        CommonTree EOF4_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:86:17: ( ( optionsBlock )? ( initBlock )? ( statement )+ EOF )
            // jaitools/jiffle/parser/Jiffle.g:86:19: ( optionsBlock )? ( initBlock )? ( statement )+ EOF
            {
            root_0 = (CommonTree)adaptor.nil();

            // jaitools/jiffle/parser/Jiffle.g:86:19: ( optionsBlock )?
            int alt1=2;
            switch ( input.LA(1) ) {
                case OPTIONS:
                    {
                    alt1=1;
                    }
                    break;
            }

            switch (alt1) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:86:19: optionsBlock
                    {
                    pushFollow(FOLLOW_optionsBlock_in_prog266);
                    optionsBlock1=optionsBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, optionsBlock1.getTree());

                    }
                    break;

            }

            // jaitools/jiffle/parser/Jiffle.g:86:33: ( initBlock )?
            int alt2=2;
            switch ( input.LA(1) ) {
                case INIT:
                    {
                    alt2=1;
                    }
                    break;
            }

            switch (alt2) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:86:33: initBlock
                    {
                    pushFollow(FOLLOW_initBlock_in_prog269);
                    initBlock2=initBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, initBlock2.getTree());

                    }
                    break;

            }

            // jaitools/jiffle/parser/Jiffle.g:86:44: ( statement )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case LCURLY:
                case ID:
                case SEMI:
                case LPAR:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case IF:
                case PLUS:
                case MINUS:
                case NOT:
                case INCR:
                case DECR:
                case LSQUARE:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:86:44: statement
            	    {
            	    pushFollow(FOLLOW_statement_in_prog272);
            	    statement3=statement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, statement3.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);

            EOF4=(Token)match(input,EOF,FOLLOW_EOF_in_prog275); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (UnexpectedInputException ex) {

                                throw new JiffleParserException(ex);
                            
        }
        catch (EarlyExitException ex) {

                                throw new JiffleParserException("Unexpected input at line " + ex.line);
                            
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prog"

    public static class optionsBlock_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "optionsBlock"
    // jaitools/jiffle/parser/Jiffle.g:96:1: optionsBlock : OPTIONS LCURLY ( option )* RCURLY -> ( option )* ;
    public final JiffleParser.optionsBlock_return optionsBlock() throws RecognitionException {
        JiffleParser.optionsBlock_return retval = new JiffleParser.optionsBlock_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token OPTIONS5=null;
        Token LCURLY6=null;
        Token RCURLY8=null;
        JiffleParser.option_return option7 = null;


        CommonTree OPTIONS5_tree=null;
        CommonTree LCURLY6_tree=null;
        CommonTree RCURLY8_tree=null;
        RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
        RewriteRuleTokenStream stream_OPTIONS=new RewriteRuleTokenStream(adaptor,"token OPTIONS");
        RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
        RewriteRuleSubtreeStream stream_option=new RewriteRuleSubtreeStream(adaptor,"rule option");
        try {
            // jaitools/jiffle/parser/Jiffle.g:96:17: ( OPTIONS LCURLY ( option )* RCURLY -> ( option )* )
            // jaitools/jiffle/parser/Jiffle.g:96:19: OPTIONS LCURLY ( option )* RCURLY
            {
            OPTIONS5=(Token)match(input,OPTIONS,FOLLOW_OPTIONS_in_optionsBlock349); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_OPTIONS.add(OPTIONS5);

            LCURLY6=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_optionsBlock351); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LCURLY.add(LCURLY6);

            // jaitools/jiffle/parser/Jiffle.g:96:34: ( option )*
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case ID:
                    {
                    alt4=1;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:96:34: option
            	    {
            	    pushFollow(FOLLOW_option_in_optionsBlock353);
            	    option7=option();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_option.add(option7.getTree());

            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

            RCURLY8=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_optionsBlock356); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RCURLY.add(RCURLY8);



            // AST REWRITE
            // elements: option
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 96:49: -> ( option )*
            {
                // jaitools/jiffle/parser/Jiffle.g:96:52: ( option )*
                while ( stream_option.hasNext() ) {
                    adaptor.addChild(root_0, stream_option.nextTree());

                }
                stream_option.reset();

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionsBlock"

    public static class option_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "option"
    // jaitools/jiffle/parser/Jiffle.g:99:1: option : ID EQ optionValue SEMI -> ^( JIFFLE_OPTION ID optionValue ) ;
    public final JiffleParser.option_return option() throws RecognitionException {
        JiffleParser.option_return retval = new JiffleParser.option_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID9=null;
        Token EQ10=null;
        Token SEMI12=null;
        JiffleParser.optionValue_return optionValue11 = null;


        CommonTree ID9_tree=null;
        CommonTree EQ10_tree=null;
        CommonTree SEMI12_tree=null;
        RewriteRuleTokenStream stream_EQ=new RewriteRuleTokenStream(adaptor,"token EQ");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
        RewriteRuleSubtreeStream stream_optionValue=new RewriteRuleSubtreeStream(adaptor,"rule optionValue");
        try {
            // jaitools/jiffle/parser/Jiffle.g:99:17: ( ID EQ optionValue SEMI -> ^( JIFFLE_OPTION ID optionValue ) )
            // jaitools/jiffle/parser/Jiffle.g:99:19: ID EQ optionValue SEMI
            {
            ID9=(Token)match(input,ID,FOLLOW_ID_in_option395); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_ID.add(ID9);

            EQ10=(Token)match(input,EQ,FOLLOW_EQ_in_option397); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_EQ.add(EQ10);

            pushFollow(FOLLOW_optionValue_in_option399);
            optionValue11=optionValue();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_optionValue.add(optionValue11.getTree());
            SEMI12=(Token)match(input,SEMI,FOLLOW_SEMI_in_option401); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_SEMI.add(SEMI12);



            // AST REWRITE
            // elements: ID, optionValue
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 99:42: -> ^( JIFFLE_OPTION ID optionValue )
            {
                // jaitools/jiffle/parser/Jiffle.g:99:45: ^( JIFFLE_OPTION ID optionValue )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(JIFFLE_OPTION, "JIFFLE_OPTION"), root_1);

                adaptor.addChild(root_1, stream_ID.nextNode());
                adaptor.addChild(root_1, stream_optionValue.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "option"

    public static class optionValue_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "optionValue"
    // jaitools/jiffle/parser/Jiffle.g:103:1: optionValue : ( ID | literal );
    public final JiffleParser.optionValue_return optionValue() throws RecognitionException {
        JiffleParser.optionValue_return retval = new JiffleParser.optionValue_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID13=null;
        JiffleParser.literal_return literal14 = null;


        CommonTree ID13_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:103:17: ( ID | literal )
            int alt5=2;
            switch ( input.LA(1) ) {
            case ID:
                {
                alt5=1;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt5=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;
            }

            switch (alt5) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:103:19: ID
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    ID13=(Token)match(input,ID,FOLLOW_ID_in_optionValue441); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ID13_tree = (CommonTree)adaptor.create(ID13);
                    adaptor.addChild(root_0, ID13_tree);
                    }

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:104:19: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_literal_in_optionValue461);
                    literal14=literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, literal14.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionValue"

    public static class initBlock_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "initBlock"
    // jaitools/jiffle/parser/Jiffle.g:108:1: initBlock : INIT LCURLY ( varDeclaration )* RCURLY -> ( varDeclaration )* ;
    public final JiffleParser.initBlock_return initBlock() throws RecognitionException {
        JiffleParser.initBlock_return retval = new JiffleParser.initBlock_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token INIT15=null;
        Token LCURLY16=null;
        Token RCURLY18=null;
        JiffleParser.varDeclaration_return varDeclaration17 = null;


        CommonTree INIT15_tree=null;
        CommonTree LCURLY16_tree=null;
        CommonTree RCURLY18_tree=null;
        RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
        RewriteRuleTokenStream stream_INIT=new RewriteRuleTokenStream(adaptor,"token INIT");
        RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
        RewriteRuleSubtreeStream stream_varDeclaration=new RewriteRuleSubtreeStream(adaptor,"rule varDeclaration");
        try {
            // jaitools/jiffle/parser/Jiffle.g:108:17: ( INIT LCURLY ( varDeclaration )* RCURLY -> ( varDeclaration )* )
            // jaitools/jiffle/parser/Jiffle.g:108:19: INIT LCURLY ( varDeclaration )* RCURLY
            {
            INIT15=(Token)match(input,INIT,FOLLOW_INIT_in_initBlock493); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_INIT.add(INIT15);

            LCURLY16=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_initBlock495); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LCURLY.add(LCURLY16);

            // jaitools/jiffle/parser/Jiffle.g:108:31: ( varDeclaration )*
            loop6:
            do {
                int alt6=2;
                switch ( input.LA(1) ) {
                case ID:
                    {
                    alt6=1;
                    }
                    break;

                }

                switch (alt6) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:108:31: varDeclaration
            	    {
            	    pushFollow(FOLLOW_varDeclaration_in_initBlock497);
            	    varDeclaration17=varDeclaration();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_varDeclaration.add(varDeclaration17.getTree());

            	    }
            	    break;

            	default :
            	    break loop6;
                }
            } while (true);

            RCURLY18=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_initBlock500); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RCURLY.add(RCURLY18);



            // AST REWRITE
            // elements: varDeclaration
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 108:54: -> ( varDeclaration )*
            {
                // jaitools/jiffle/parser/Jiffle.g:108:57: ( varDeclaration )*
                while ( stream_varDeclaration.hasNext() ) {
                    adaptor.addChild(root_0, stream_varDeclaration.nextTree());

                }
                stream_varDeclaration.reset();

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "initBlock"

    public static class varDeclaration_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varDeclaration"
    // jaitools/jiffle/parser/Jiffle.g:112:1: varDeclaration : ID EQ expression SEMI -> ^( IMAGE_SCOPE_VAR_DECL ID expression ) ;
    public final JiffleParser.varDeclaration_return varDeclaration() throws RecognitionException {
        JiffleParser.varDeclaration_return retval = new JiffleParser.varDeclaration_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID19=null;
        Token EQ20=null;
        Token SEMI22=null;
        JiffleParser.expression_return expression21 = null;


        CommonTree ID19_tree=null;
        CommonTree EQ20_tree=null;
        CommonTree SEMI22_tree=null;
        RewriteRuleTokenStream stream_EQ=new RewriteRuleTokenStream(adaptor,"token EQ");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleTokenStream stream_SEMI=new RewriteRuleTokenStream(adaptor,"token SEMI");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:112:17: ( ID EQ expression SEMI -> ^( IMAGE_SCOPE_VAR_DECL ID expression ) )
            // jaitools/jiffle/parser/Jiffle.g:112:19: ID EQ expression SEMI
            {
            ID19=(Token)match(input,ID,FOLLOW_ID_in_varDeclaration532); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_ID.add(ID19);

            EQ20=(Token)match(input,EQ,FOLLOW_EQ_in_varDeclaration534); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_EQ.add(EQ20);

            pushFollow(FOLLOW_expression_in_varDeclaration536);
            expression21=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression21.getTree());
            SEMI22=(Token)match(input,SEMI,FOLLOW_SEMI_in_varDeclaration538); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_SEMI.add(SEMI22);



            // AST REWRITE
            // elements: ID, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 112:41: -> ^( IMAGE_SCOPE_VAR_DECL ID expression )
            {
                // jaitools/jiffle/parser/Jiffle.g:112:44: ^( IMAGE_SCOPE_VAR_DECL ID expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IMAGE_SCOPE_VAR_DECL, "IMAGE_SCOPE_VAR_DECL"), root_1);

                adaptor.addChild(root_1, stream_ID.nextNode());
                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varDeclaration"

    public static class block_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "block"
    // jaitools/jiffle/parser/Jiffle.g:116:1: block : LCURLY ( blockStatement )* RCURLY -> ^( BLOCK ( blockStatement )* ) ;
    public final JiffleParser.block_return block() throws RecognitionException {
        JiffleParser.block_return retval = new JiffleParser.block_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LCURLY23=null;
        Token RCURLY25=null;
        JiffleParser.blockStatement_return blockStatement24 = null;


        CommonTree LCURLY23_tree=null;
        CommonTree RCURLY25_tree=null;
        RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
        RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
        RewriteRuleSubtreeStream stream_blockStatement=new RewriteRuleSubtreeStream(adaptor,"rule blockStatement");
        try {
            // jaitools/jiffle/parser/Jiffle.g:116:17: ( LCURLY ( blockStatement )* RCURLY -> ^( BLOCK ( blockStatement )* ) )
            // jaitools/jiffle/parser/Jiffle.g:116:19: LCURLY ( blockStatement )* RCURLY
            {
            LCURLY23=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_block584); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LCURLY.add(LCURLY23);

            // jaitools/jiffle/parser/Jiffle.g:116:26: ( blockStatement )*
            loop7:
            do {
                int alt7=2;
                switch ( input.LA(1) ) {
                case LCURLY:
                case ID:
                case SEMI:
                case BREAKIF:
                case LPAR:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case IF:
                case PLUS:
                case MINUS:
                case NOT:
                case INCR:
                case DECR:
                case LSQUARE:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                    {
                    alt7=1;
                    }
                    break;

                }

                switch (alt7) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:116:26: blockStatement
            	    {
            	    pushFollow(FOLLOW_blockStatement_in_block586);
            	    blockStatement24=blockStatement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_blockStatement.add(blockStatement24.getTree());

            	    }
            	    break;

            	default :
            	    break loop7;
                }
            } while (true);

            RCURLY25=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_block589); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RCURLY.add(RCURLY25);



            // AST REWRITE
            // elements: blockStatement
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 116:49: -> ^( BLOCK ( blockStatement )* )
            {
                // jaitools/jiffle/parser/Jiffle.g:116:52: ^( BLOCK ( blockStatement )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(BLOCK, "BLOCK"), root_1);

                // jaitools/jiffle/parser/Jiffle.g:116:60: ( blockStatement )*
                while ( stream_blockStatement.hasNext() ) {
                    adaptor.addChild(root_1, stream_blockStatement.nextTree());

                }
                stream_blockStatement.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "block"

    public static class blockStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "blockStatement"
    // jaitools/jiffle/parser/Jiffle.g:120:1: blockStatement : ( statement | BREAKIF LPAR expression RPAR -> ^( BREAKIF expression ) );
    public final JiffleParser.blockStatement_return blockStatement() throws RecognitionException {
        JiffleParser.blockStatement_return retval = new JiffleParser.blockStatement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token BREAKIF27=null;
        Token LPAR28=null;
        Token RPAR30=null;
        JiffleParser.statement_return statement26 = null;

        JiffleParser.expression_return expression29 = null;


        CommonTree BREAKIF27_tree=null;
        CommonTree LPAR28_tree=null;
        CommonTree RPAR30_tree=null;
        RewriteRuleTokenStream stream_RPAR=new RewriteRuleTokenStream(adaptor,"token RPAR");
        RewriteRuleTokenStream stream_LPAR=new RewriteRuleTokenStream(adaptor,"token LPAR");
        RewriteRuleTokenStream stream_BREAKIF=new RewriteRuleTokenStream(adaptor,"token BREAKIF");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:120:17: ( statement | BREAKIF LPAR expression RPAR -> ^( BREAKIF expression ) )
            int alt8=2;
            switch ( input.LA(1) ) {
            case LCURLY:
            case ID:
            case SEMI:
            case LPAR:
            case WHILE:
            case UNTIL:
            case FOREACH:
            case IF:
            case PLUS:
            case MINUS:
            case NOT:
            case INCR:
            case DECR:
            case LSQUARE:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt8=1;
                }
                break;
            case BREAKIF:
                {
                alt8=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:120:19: statement
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_statement_in_blockStatement625);
                    statement26=statement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, statement26.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:121:19: BREAKIF LPAR expression RPAR
                    {
                    BREAKIF27=(Token)match(input,BREAKIF,FOLLOW_BREAKIF_in_blockStatement645); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_BREAKIF.add(BREAKIF27);

                    LPAR28=(Token)match(input,LPAR,FOLLOW_LPAR_in_blockStatement647); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(LPAR28);

                    pushFollow(FOLLOW_expression_in_blockStatement649);
                    expression29=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression29.getTree());
                    RPAR30=(Token)match(input,RPAR,FOLLOW_RPAR_in_blockStatement651); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(RPAR30);



                    // AST REWRITE
                    // elements: BREAKIF, expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 121:48: -> ^( BREAKIF expression )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:121:51: ^( BREAKIF expression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_BREAKIF.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_expression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "blockStatement"

    public static class statement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "statement"
    // jaitools/jiffle/parser/Jiffle.g:125:1: statement : ( block | delimitedStatement SEMI | assignmentExpression SEMI | WHILE LPAR loopCondition RPAR statement -> ^( WHILE loopCondition statement ) | UNTIL LPAR loopCondition RPAR statement -> ^( UNTIL loopCondition statement ) | FOREACH LPAR ID IN loopSet RPAR statement -> ^( FOREACH ID loopSet statement ) | SEMI );
    public final JiffleParser.statement_return statement() throws RecognitionException {
        JiffleParser.statement_return retval = new JiffleParser.statement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token SEMI33=null;
        Token SEMI35=null;
        Token WHILE36=null;
        Token LPAR37=null;
        Token RPAR39=null;
        Token UNTIL41=null;
        Token LPAR42=null;
        Token RPAR44=null;
        Token FOREACH46=null;
        Token LPAR47=null;
        Token ID48=null;
        Token IN49=null;
        Token RPAR51=null;
        Token SEMI53=null;
        JiffleParser.block_return block31 = null;

        JiffleParser.delimitedStatement_return delimitedStatement32 = null;

        JiffleParser.assignmentExpression_return assignmentExpression34 = null;

        JiffleParser.loopCondition_return loopCondition38 = null;

        JiffleParser.statement_return statement40 = null;

        JiffleParser.loopCondition_return loopCondition43 = null;

        JiffleParser.statement_return statement45 = null;

        JiffleParser.loopSet_return loopSet50 = null;

        JiffleParser.statement_return statement52 = null;


        CommonTree SEMI33_tree=null;
        CommonTree SEMI35_tree=null;
        CommonTree WHILE36_tree=null;
        CommonTree LPAR37_tree=null;
        CommonTree RPAR39_tree=null;
        CommonTree UNTIL41_tree=null;
        CommonTree LPAR42_tree=null;
        CommonTree RPAR44_tree=null;
        CommonTree FOREACH46_tree=null;
        CommonTree LPAR47_tree=null;
        CommonTree ID48_tree=null;
        CommonTree IN49_tree=null;
        CommonTree RPAR51_tree=null;
        CommonTree SEMI53_tree=null;
        RewriteRuleTokenStream stream_RPAR=new RewriteRuleTokenStream(adaptor,"token RPAR");
        RewriteRuleTokenStream stream_FOREACH=new RewriteRuleTokenStream(adaptor,"token FOREACH");
        RewriteRuleTokenStream stream_IN=new RewriteRuleTokenStream(adaptor,"token IN");
        RewriteRuleTokenStream stream_LPAR=new RewriteRuleTokenStream(adaptor,"token LPAR");
        RewriteRuleTokenStream stream_WHILE=new RewriteRuleTokenStream(adaptor,"token WHILE");
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleTokenStream stream_UNTIL=new RewriteRuleTokenStream(adaptor,"token UNTIL");
        RewriteRuleSubtreeStream stream_statement=new RewriteRuleSubtreeStream(adaptor,"rule statement");
        RewriteRuleSubtreeStream stream_loopSet=new RewriteRuleSubtreeStream(adaptor,"rule loopSet");
        RewriteRuleSubtreeStream stream_loopCondition=new RewriteRuleSubtreeStream(adaptor,"rule loopCondition");
        try {
            // jaitools/jiffle/parser/Jiffle.g:125:17: ( block | delimitedStatement SEMI | assignmentExpression SEMI | WHILE LPAR loopCondition RPAR statement -> ^( WHILE loopCondition statement ) | UNTIL LPAR loopCondition RPAR statement -> ^( UNTIL loopCondition statement ) | FOREACH LPAR ID IN loopSet RPAR statement -> ^( FOREACH ID loopSet statement ) | SEMI )
            int alt9=7;
            switch ( input.LA(1) ) {
            case LCURLY:
                {
                alt9=1;
                }
                break;
            case LPAR:
            case IF:
            case PLUS:
            case MINUS:
            case NOT:
            case INCR:
            case DECR:
            case LSQUARE:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt9=2;
                }
                break;
            case ID:
                {
                switch ( input.LA(2) ) {
                case SEMI:
                case LPAR:
                case APPEND:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case INCR:
                case DECR:
                case POW:
                case LSQUARE:
                    {
                    alt9=2;
                    }
                    break;
                case EQ:
                case TIMESEQ:
                case DIVEQ:
                case MODEQ:
                case PLUSEQ:
                case MINUSEQ:
                    {
                    alt9=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 9, 3, input);

                    throw nvae;
                }

                }
                break;
            case WHILE:
                {
                alt9=4;
                }
                break;
            case UNTIL:
                {
                alt9=5;
                }
                break;
            case FOREACH:
                {
                alt9=6;
                }
                break;
            case SEMI:
                {
                alt9=7;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;
            }

            switch (alt9) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:125:19: block
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_block_in_statement691);
                    block31=block();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, block31.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:126:19: delimitedStatement SEMI
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_delimitedStatement_in_statement711);
                    delimitedStatement32=delimitedStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, delimitedStatement32.getTree());
                    SEMI33=(Token)match(input,SEMI,FOLLOW_SEMI_in_statement713); if (state.failed) return retval;

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:127:19: assignmentExpression SEMI
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_assignmentExpression_in_statement734);
                    assignmentExpression34=assignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, assignmentExpression34.getTree());
                    SEMI35=(Token)match(input,SEMI,FOLLOW_SEMI_in_statement736); if (state.failed) return retval;

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/Jiffle.g:128:19: WHILE LPAR loopCondition RPAR statement
                    {
                    WHILE36=(Token)match(input,WHILE,FOLLOW_WHILE_in_statement757); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_WHILE.add(WHILE36);

                    LPAR37=(Token)match(input,LPAR,FOLLOW_LPAR_in_statement759); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(LPAR37);

                    pushFollow(FOLLOW_loopCondition_in_statement761);
                    loopCondition38=loopCondition();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_loopCondition.add(loopCondition38.getTree());
                    RPAR39=(Token)match(input,RPAR,FOLLOW_RPAR_in_statement763); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(RPAR39);

                    pushFollow(FOLLOW_statement_in_statement765);
                    statement40=statement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_statement.add(statement40.getTree());


                    // AST REWRITE
                    // elements: statement, WHILE, loopCondition
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 128:59: -> ^( WHILE loopCondition statement )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:128:62: ^( WHILE loopCondition statement )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_WHILE.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_loopCondition.nextTree());
                        adaptor.addChild(root_1, stream_statement.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/Jiffle.g:129:19: UNTIL LPAR loopCondition RPAR statement
                    {
                    UNTIL41=(Token)match(input,UNTIL,FOLLOW_UNTIL_in_statement795); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_UNTIL.add(UNTIL41);

                    LPAR42=(Token)match(input,LPAR,FOLLOW_LPAR_in_statement797); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(LPAR42);

                    pushFollow(FOLLOW_loopCondition_in_statement799);
                    loopCondition43=loopCondition();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_loopCondition.add(loopCondition43.getTree());
                    RPAR44=(Token)match(input,RPAR,FOLLOW_RPAR_in_statement801); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(RPAR44);

                    pushFollow(FOLLOW_statement_in_statement803);
                    statement45=statement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_statement.add(statement45.getTree());


                    // AST REWRITE
                    // elements: statement, loopCondition, UNTIL
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 129:59: -> ^( UNTIL loopCondition statement )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:129:62: ^( UNTIL loopCondition statement )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_UNTIL.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_loopCondition.nextTree());
                        adaptor.addChild(root_1, stream_statement.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/Jiffle.g:130:19: FOREACH LPAR ID IN loopSet RPAR statement
                    {
                    FOREACH46=(Token)match(input,FOREACH,FOLLOW_FOREACH_in_statement833); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_FOREACH.add(FOREACH46);

                    LPAR47=(Token)match(input,LPAR,FOLLOW_LPAR_in_statement835); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(LPAR47);

                    ID48=(Token)match(input,ID,FOLLOW_ID_in_statement837); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_ID.add(ID48);

                    IN49=(Token)match(input,IN,FOLLOW_IN_in_statement839); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_IN.add(IN49);

                    pushFollow(FOLLOW_loopSet_in_statement841);
                    loopSet50=loopSet();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_loopSet.add(loopSet50.getTree());
                    RPAR51=(Token)match(input,RPAR,FOLLOW_RPAR_in_statement843); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(RPAR51);

                    pushFollow(FOLLOW_statement_in_statement845);
                    statement52=statement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_statement.add(statement52.getTree());


                    // AST REWRITE
                    // elements: statement, loopSet, ID, FOREACH
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 130:61: -> ^( FOREACH ID loopSet statement )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:130:64: ^( FOREACH ID loopSet statement )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_FOREACH.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_ID.nextNode());
                        adaptor.addChild(root_1, stream_loopSet.nextTree());
                        adaptor.addChild(root_1, stream_statement.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 7 :
                    // jaitools/jiffle/parser/Jiffle.g:131:19: SEMI
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    SEMI53=(Token)match(input,SEMI,FOLLOW_SEMI_in_statement877); if (state.failed) return retval;

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "statement"

    public static class delimitedStatement_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "delimitedStatement"
    // jaitools/jiffle/parser/Jiffle.g:135:1: delimitedStatement : expression ;
    public final JiffleParser.delimitedStatement_return delimitedStatement() throws RecognitionException {
        JiffleParser.delimitedStatement_return retval = new JiffleParser.delimitedStatement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        JiffleParser.expression_return expression54 = null;



        try {
            // jaitools/jiffle/parser/Jiffle.g:136:17: ( expression )
            // jaitools/jiffle/parser/Jiffle.g:136:19: expression
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_expression_in_delimitedStatement920);
            expression54=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expression54.getTree());

            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "delimitedStatement"

    public static class loopCondition_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "loopCondition"
    // jaitools/jiffle/parser/Jiffle.g:140:1: loopCondition : orExpression ;
    public final JiffleParser.loopCondition_return loopCondition() throws RecognitionException {
        JiffleParser.loopCondition_return retval = new JiffleParser.loopCondition_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        JiffleParser.orExpression_return orExpression55 = null;



        try {
            // jaitools/jiffle/parser/Jiffle.g:140:17: ( orExpression )
            // jaitools/jiffle/parser/Jiffle.g:140:19: orExpression
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_orExpression_in_loopCondition948);
            orExpression55=orExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, orExpression55.getTree());

            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loopCondition"

    public static class loopSet_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "loopSet"
    // jaitools/jiffle/parser/Jiffle.g:144:1: loopSet options {backtrack=true; } : ( listLiteral | sequence | ID );
    public final JiffleParser.loopSet_return loopSet() throws RecognitionException {
        JiffleParser.loopSet_return retval = new JiffleParser.loopSet_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID58=null;
        JiffleParser.listLiteral_return listLiteral56 = null;

        JiffleParser.sequence_return sequence57 = null;


        CommonTree ID58_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:146:17: ( listLiteral | sequence | ID )
            int alt10=3;
            alt10 = dfa10.predict(input);
            switch (alt10) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:146:19: listLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_listLiteral_in_loopSet1000);
                    listLiteral56=listLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, listLiteral56.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:147:19: sequence
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_sequence_in_loopSet1020);
                    sequence57=sequence();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, sequence57.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:148:19: ID
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    ID58=(Token)match(input,ID,FOLLOW_ID_in_loopSet1040); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ID58_tree = (CommonTree)adaptor.create(ID58);
                    adaptor.addChild(root_0, ID58_tree);
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loopSet"

    public static class expressionList_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expressionList"
    // jaitools/jiffle/parser/Jiffle.g:152:1: expressionList : ( expression ( COMMA expression )* )? -> ^( EXPR_LIST ( expression )* ) ;
    public final JiffleParser.expressionList_return expressionList() throws RecognitionException {
        JiffleParser.expressionList_return retval = new JiffleParser.expressionList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token COMMA60=null;
        JiffleParser.expression_return expression59 = null;

        JiffleParser.expression_return expression61 = null;


        CommonTree COMMA60_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:152:17: ( ( expression ( COMMA expression )* )? -> ^( EXPR_LIST ( expression )* ) )
            // jaitools/jiffle/parser/Jiffle.g:152:19: ( expression ( COMMA expression )* )?
            {
            // jaitools/jiffle/parser/Jiffle.g:152:19: ( expression ( COMMA expression )* )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case ID:
                case LPAR:
                case IF:
                case PLUS:
                case MINUS:
                case NOT:
                case INCR:
                case DECR:
                case LSQUARE:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:152:20: expression ( COMMA expression )*
                    {
                    pushFollow(FOLLOW_expression_in_expressionList1068);
                    expression59=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression59.getTree());
                    // jaitools/jiffle/parser/Jiffle.g:152:31: ( COMMA expression )*
                    loop11:
                    do {
                        int alt11=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt11=1;
                            }
                            break;

                        }

                        switch (alt11) {
                    	case 1 :
                    	    // jaitools/jiffle/parser/Jiffle.g:152:32: COMMA expression
                    	    {
                    	    COMMA60=(Token)match(input,COMMA,FOLLOW_COMMA_in_expressionList1071); if (state.failed) return retval; 
                    	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA60);

                    	    pushFollow(FOLLOW_expression_in_expressionList1073);
                    	    expression61=expression();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) stream_expression.add(expression61.getTree());

                    	    }
                    	    break;

                    	default :
                    	    break loop11;
                        }
                    } while (true);


                    }
                    break;

            }



            // AST REWRITE
            // elements: expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 152:54: -> ^( EXPR_LIST ( expression )* )
            {
                // jaitools/jiffle/parser/Jiffle.g:152:57: ^( EXPR_LIST ( expression )* )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EXPR_LIST, "EXPR_LIST"), root_1);

                // jaitools/jiffle/parser/Jiffle.g:152:69: ( expression )*
                while ( stream_expression.hasNext() ) {
                    adaptor.addChild(root_1, stream_expression.nextTree());

                }
                stream_expression.reset();

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expressionList"

    public static class sequence_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "sequence"
    // jaitools/jiffle/parser/Jiffle.g:156:1: sequence : lo= expression COLON hi= expression -> ^( SEQUENCE $lo $hi) ;
    public final JiffleParser.sequence_return sequence() throws RecognitionException {
        JiffleParser.sequence_return retval = new JiffleParser.sequence_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token COLON62=null;
        JiffleParser.expression_return lo = null;

        JiffleParser.expression_return hi = null;


        CommonTree COLON62_tree=null;
        RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:156:17: (lo= expression COLON hi= expression -> ^( SEQUENCE $lo $hi) )
            // jaitools/jiffle/parser/Jiffle.g:156:19: lo= expression COLON hi= expression
            {
            pushFollow(FOLLOW_expression_in_sequence1122);
            lo=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(lo.getTree());
            COLON62=(Token)match(input,COLON,FOLLOW_COLON_in_sequence1124); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_COLON.add(COLON62);

            pushFollow(FOLLOW_expression_in_sequence1128);
            hi=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(hi.getTree());


            // AST REWRITE
            // elements: hi, lo
            // token labels: 
            // rule labels: lo, retval, hi
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_lo=new RewriteRuleSubtreeStream(adaptor,"rule lo",lo!=null?lo.tree:null);
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
            RewriteRuleSubtreeStream stream_hi=new RewriteRuleSubtreeStream(adaptor,"rule hi",hi!=null?hi.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 156:53: -> ^( SEQUENCE $lo $hi)
            {
                // jaitools/jiffle/parser/Jiffle.g:156:56: ^( SEQUENCE $lo $hi)
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(SEQUENCE, "SEQUENCE"), root_1);

                adaptor.addChild(root_1, stream_lo.nextTree());
                adaptor.addChild(root_1, stream_hi.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "sequence"

    public static class ifCall_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "ifCall"
    // jaitools/jiffle/parser/Jiffle.g:166:1: ifCall : IF LPAR expressionList RPAR -> ^( IF_CALL expressionList ) ;
    public final JiffleParser.ifCall_return ifCall() throws RecognitionException {
        JiffleParser.ifCall_return retval = new JiffleParser.ifCall_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token IF63=null;
        Token LPAR64=null;
        Token RPAR66=null;
        JiffleParser.expressionList_return expressionList65 = null;


        CommonTree IF63_tree=null;
        CommonTree LPAR64_tree=null;
        CommonTree RPAR66_tree=null;
        RewriteRuleTokenStream stream_RPAR=new RewriteRuleTokenStream(adaptor,"token RPAR");
        RewriteRuleTokenStream stream_LPAR=new RewriteRuleTokenStream(adaptor,"token LPAR");
        RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
        RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
        try {
            // jaitools/jiffle/parser/Jiffle.g:166:17: ( IF LPAR expressionList RPAR -> ^( IF_CALL expressionList ) )
            // jaitools/jiffle/parser/Jiffle.g:166:19: IF LPAR expressionList RPAR
            {
            IF63=(Token)match(input,IF,FOLLOW_IF_in_ifCall1177); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IF.add(IF63);

            LPAR64=(Token)match(input,LPAR,FOLLOW_LPAR_in_ifCall1179); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LPAR.add(LPAR64);

            pushFollow(FOLLOW_expressionList_in_ifCall1181);
            expressionList65=expressionList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expressionList.add(expressionList65.getTree());
            RPAR66=(Token)match(input,RPAR,FOLLOW_RPAR_in_ifCall1183); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RPAR.add(RPAR66);



            // AST REWRITE
            // elements: expressionList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 166:47: -> ^( IF_CALL expressionList )
            {
                // jaitools/jiffle/parser/Jiffle.g:166:50: ^( IF_CALL expressionList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IF_CALL, "IF_CALL"), root_1);

                adaptor.addChild(root_1, stream_expressionList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "ifCall"

    public static class assignmentExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "assignmentExpression"
    // jaitools/jiffle/parser/Jiffle.g:175:1: assignmentExpression : ID assignmentOp expression ;
    public final JiffleParser.assignmentExpression_return assignmentExpression() throws RecognitionException {
        JiffleParser.assignmentExpression_return retval = new JiffleParser.assignmentExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID67=null;
        JiffleParser.assignmentOp_return assignmentOp68 = null;

        JiffleParser.expression_return expression69 = null;


        CommonTree ID67_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:176:17: ( ID assignmentOp expression )
            // jaitools/jiffle/parser/Jiffle.g:176:19: ID assignmentOp expression
            {
            root_0 = (CommonTree)adaptor.nil();

            ID67=(Token)match(input,ID,FOLLOW_ID_in_assignmentExpression1235); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            ID67_tree = (CommonTree)adaptor.create(ID67);
            adaptor.addChild(root_0, ID67_tree);
            }
            pushFollow(FOLLOW_assignmentOp_in_assignmentExpression1237);
            assignmentOp68=assignmentOp();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) root_0 = (CommonTree)adaptor.becomeRoot(assignmentOp68.getTree(), root_0);
            pushFollow(FOLLOW_expression_in_assignmentExpression1240);
            expression69=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expression69.getTree());

            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentExpression"

    public static class expression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expression"
    // jaitools/jiffle/parser/Jiffle.g:179:1: expression : ( conditionalExpression | ID APPEND expression );
    public final JiffleParser.expression_return expression() throws RecognitionException {
        JiffleParser.expression_return retval = new JiffleParser.expression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID71=null;
        Token APPEND72=null;
        JiffleParser.conditionalExpression_return conditionalExpression70 = null;

        JiffleParser.expression_return expression73 = null;


        CommonTree ID71_tree=null;
        CommonTree APPEND72_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:179:17: ( conditionalExpression | ID APPEND expression )
            int alt13=2;
            switch ( input.LA(1) ) {
            case LPAR:
            case IF:
            case PLUS:
            case MINUS:
            case NOT:
            case INCR:
            case DECR:
            case LSQUARE:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt13=1;
                }
                break;
            case ID:
                {
                switch ( input.LA(2) ) {
                case APPEND:
                    {
                    alt13=2;
                    }
                    break;
                case EOF:
                case SEMI:
                case LPAR:
                case RPAR:
                case COMMA:
                case COLON:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case INCR:
                case DECR:
                case POW:
                case LSQUARE:
                case RSQUARE:
                    {
                    alt13=1;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 13, 2, input);

                    throw nvae;
                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:179:19: conditionalExpression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_conditionalExpression_in_expression1270);
                    conditionalExpression70=conditionalExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, conditionalExpression70.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:180:19: ID APPEND expression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    ID71=(Token)match(input,ID,FOLLOW_ID_in_expression1290); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ID71_tree = (CommonTree)adaptor.create(ID71);
                    adaptor.addChild(root_0, ID71_tree);
                    }
                    APPEND72=(Token)match(input,APPEND,FOLLOW_APPEND_in_expression1292); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    APPEND72_tree = (CommonTree)adaptor.create(APPEND72);
                    root_0 = (CommonTree)adaptor.becomeRoot(APPEND72_tree, root_0);
                    }
                    pushFollow(FOLLOW_expression_in_expression1295);
                    expression73=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression73.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expression"

    public static class assignmentOp_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "assignmentOp"
    // jaitools/jiffle/parser/Jiffle.g:184:1: assignmentOp : ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ );
    public final JiffleParser.assignmentOp_return assignmentOp() throws RecognitionException {
        JiffleParser.assignmentOp_return retval = new JiffleParser.assignmentOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token set74=null;

        CommonTree set74_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:184:17: ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ )
            // jaitools/jiffle/parser/Jiffle.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            set74=(Token)input.LT(1);
            if ( input.LA(1)==EQ||(input.LA(1)>=TIMESEQ && input.LA(1)<=MINUSEQ) ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, (CommonTree)adaptor.create(set74));
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentOp"

    public static class conditionalExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "conditionalExpression"
    // jaitools/jiffle/parser/Jiffle.g:193:1: conditionalExpression : orExpression ( QUESTION expression COLON expression )? ;
    public final JiffleParser.conditionalExpression_return conditionalExpression() throws RecognitionException {
        JiffleParser.conditionalExpression_return retval = new JiffleParser.conditionalExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token QUESTION76=null;
        Token COLON78=null;
        JiffleParser.orExpression_return orExpression75 = null;

        JiffleParser.expression_return expression77 = null;

        JiffleParser.expression_return expression79 = null;


        CommonTree QUESTION76_tree=null;
        CommonTree COLON78_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:194:17: ( orExpression ( QUESTION expression COLON expression )? )
            // jaitools/jiffle/parser/Jiffle.g:194:19: orExpression ( QUESTION expression COLON expression )?
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_orExpression_in_conditionalExpression1466);
            orExpression75=orExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, orExpression75.getTree());
            // jaitools/jiffle/parser/Jiffle.g:194:32: ( QUESTION expression COLON expression )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case QUESTION:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:194:33: QUESTION expression COLON expression
                    {
                    QUESTION76=(Token)match(input,QUESTION,FOLLOW_QUESTION_in_conditionalExpression1469); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    QUESTION76_tree = (CommonTree)adaptor.create(QUESTION76);
                    root_0 = (CommonTree)adaptor.becomeRoot(QUESTION76_tree, root_0);
                    }
                    pushFollow(FOLLOW_expression_in_conditionalExpression1472);
                    expression77=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression77.getTree());
                    COLON78=(Token)match(input,COLON,FOLLOW_COLON_in_conditionalExpression1474); if (state.failed) return retval;
                    pushFollow(FOLLOW_expression_in_conditionalExpression1477);
                    expression79=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, expression79.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "conditionalExpression"

    public static class orExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "orExpression"
    // jaitools/jiffle/parser/Jiffle.g:198:1: orExpression : xorExpression ( OR xorExpression )* ;
    public final JiffleParser.orExpression_return orExpression() throws RecognitionException {
        JiffleParser.orExpression_return retval = new JiffleParser.orExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token OR81=null;
        JiffleParser.xorExpression_return xorExpression80 = null;

        JiffleParser.xorExpression_return xorExpression82 = null;


        CommonTree OR81_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:198:17: ( xorExpression ( OR xorExpression )* )
            // jaitools/jiffle/parser/Jiffle.g:198:19: xorExpression ( OR xorExpression )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_xorExpression_in_orExpression1508);
            xorExpression80=xorExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, xorExpression80.getTree());
            // jaitools/jiffle/parser/Jiffle.g:198:33: ( OR xorExpression )*
            loop15:
            do {
                int alt15=2;
                switch ( input.LA(1) ) {
                case OR:
                    {
                    alt15=1;
                    }
                    break;

                }

                switch (alt15) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:198:34: OR xorExpression
            	    {
            	    OR81=(Token)match(input,OR,FOLLOW_OR_in_orExpression1511); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    OR81_tree = (CommonTree)adaptor.create(OR81);
            	    root_0 = (CommonTree)adaptor.becomeRoot(OR81_tree, root_0);
            	    }
            	    pushFollow(FOLLOW_xorExpression_in_orExpression1514);
            	    xorExpression82=xorExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, xorExpression82.getTree());

            	    }
            	    break;

            	default :
            	    break loop15;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "orExpression"

    public static class xorExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "xorExpression"
    // jaitools/jiffle/parser/Jiffle.g:202:1: xorExpression : andExpression ( XOR andExpression )* ;
    public final JiffleParser.xorExpression_return xorExpression() throws RecognitionException {
        JiffleParser.xorExpression_return retval = new JiffleParser.xorExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token XOR84=null;
        JiffleParser.andExpression_return andExpression83 = null;

        JiffleParser.andExpression_return andExpression85 = null;


        CommonTree XOR84_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:202:17: ( andExpression ( XOR andExpression )* )
            // jaitools/jiffle/parser/Jiffle.g:202:19: andExpression ( XOR andExpression )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_andExpression_in_xorExpression1544);
            andExpression83=andExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, andExpression83.getTree());
            // jaitools/jiffle/parser/Jiffle.g:202:33: ( XOR andExpression )*
            loop16:
            do {
                int alt16=2;
                switch ( input.LA(1) ) {
                case XOR:
                    {
                    alt16=1;
                    }
                    break;

                }

                switch (alt16) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:202:34: XOR andExpression
            	    {
            	    XOR84=(Token)match(input,XOR,FOLLOW_XOR_in_xorExpression1547); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    XOR84_tree = (CommonTree)adaptor.create(XOR84);
            	    root_0 = (CommonTree)adaptor.becomeRoot(XOR84_tree, root_0);
            	    }
            	    pushFollow(FOLLOW_andExpression_in_xorExpression1550);
            	    andExpression85=andExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, andExpression85.getTree());

            	    }
            	    break;

            	default :
            	    break loop16;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "xorExpression"

    public static class andExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "andExpression"
    // jaitools/jiffle/parser/Jiffle.g:206:1: andExpression : eqExpression ( AND eqExpression )* ;
    public final JiffleParser.andExpression_return andExpression() throws RecognitionException {
        JiffleParser.andExpression_return retval = new JiffleParser.andExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token AND87=null;
        JiffleParser.eqExpression_return eqExpression86 = null;

        JiffleParser.eqExpression_return eqExpression88 = null;


        CommonTree AND87_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:206:17: ( eqExpression ( AND eqExpression )* )
            // jaitools/jiffle/parser/Jiffle.g:206:19: eqExpression ( AND eqExpression )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_eqExpression_in_andExpression1580);
            eqExpression86=eqExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, eqExpression86.getTree());
            // jaitools/jiffle/parser/Jiffle.g:206:32: ( AND eqExpression )*
            loop17:
            do {
                int alt17=2;
                switch ( input.LA(1) ) {
                case AND:
                    {
                    alt17=1;
                    }
                    break;

                }

                switch (alt17) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:206:33: AND eqExpression
            	    {
            	    AND87=(Token)match(input,AND,FOLLOW_AND_in_andExpression1583); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    AND87_tree = (CommonTree)adaptor.create(AND87);
            	    root_0 = (CommonTree)adaptor.becomeRoot(AND87_tree, root_0);
            	    }
            	    pushFollow(FOLLOW_eqExpression_in_andExpression1586);
            	    eqExpression88=eqExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, eqExpression88.getTree());

            	    }
            	    break;

            	default :
            	    break loop17;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "andExpression"

    public static class eqExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "eqExpression"
    // jaitools/jiffle/parser/Jiffle.g:210:1: eqExpression : compExpression ( ( LOGICALEQ | NE ) compExpression )? ;
    public final JiffleParser.eqExpression_return eqExpression() throws RecognitionException {
        JiffleParser.eqExpression_return retval = new JiffleParser.eqExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LOGICALEQ90=null;
        Token NE91=null;
        JiffleParser.compExpression_return compExpression89 = null;

        JiffleParser.compExpression_return compExpression92 = null;


        CommonTree LOGICALEQ90_tree=null;
        CommonTree NE91_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:210:17: ( compExpression ( ( LOGICALEQ | NE ) compExpression )? )
            // jaitools/jiffle/parser/Jiffle.g:210:19: compExpression ( ( LOGICALEQ | NE ) compExpression )?
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_compExpression_in_eqExpression1617);
            compExpression89=compExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, compExpression89.getTree());
            // jaitools/jiffle/parser/Jiffle.g:210:34: ( ( LOGICALEQ | NE ) compExpression )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case LOGICALEQ:
                case NE:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:210:35: ( LOGICALEQ | NE ) compExpression
                    {
                    // jaitools/jiffle/parser/Jiffle.g:210:35: ( LOGICALEQ | NE )
                    int alt18=2;
                    switch ( input.LA(1) ) {
                    case LOGICALEQ:
                        {
                        alt18=1;
                        }
                        break;
                    case NE:
                        {
                        alt18=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 18, 0, input);

                        throw nvae;
                    }

                    switch (alt18) {
                        case 1 :
                            // jaitools/jiffle/parser/Jiffle.g:210:36: LOGICALEQ
                            {
                            LOGICALEQ90=(Token)match(input,LOGICALEQ,FOLLOW_LOGICALEQ_in_eqExpression1621); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            LOGICALEQ90_tree = (CommonTree)adaptor.create(LOGICALEQ90);
                            root_0 = (CommonTree)adaptor.becomeRoot(LOGICALEQ90_tree, root_0);
                            }

                            }
                            break;
                        case 2 :
                            // jaitools/jiffle/parser/Jiffle.g:210:49: NE
                            {
                            NE91=(Token)match(input,NE,FOLLOW_NE_in_eqExpression1626); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            NE91_tree = (CommonTree)adaptor.create(NE91);
                            root_0 = (CommonTree)adaptor.becomeRoot(NE91_tree, root_0);
                            }

                            }
                            break;

                    }

                    pushFollow(FOLLOW_compExpression_in_eqExpression1630);
                    compExpression92=compExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, compExpression92.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "eqExpression"

    public static class compExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "compExpression"
    // jaitools/jiffle/parser/Jiffle.g:214:1: compExpression : addExpression ( ( GT | GE | LE | LT ) addExpression )? ;
    public final JiffleParser.compExpression_return compExpression() throws RecognitionException {
        JiffleParser.compExpression_return retval = new JiffleParser.compExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token GT94=null;
        Token GE95=null;
        Token LE96=null;
        Token LT97=null;
        JiffleParser.addExpression_return addExpression93 = null;

        JiffleParser.addExpression_return addExpression98 = null;


        CommonTree GT94_tree=null;
        CommonTree GE95_tree=null;
        CommonTree LE96_tree=null;
        CommonTree LT97_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:214:17: ( addExpression ( ( GT | GE | LE | LT ) addExpression )? )
            // jaitools/jiffle/parser/Jiffle.g:214:19: addExpression ( ( GT | GE | LE | LT ) addExpression )?
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_addExpression_in_compExpression1659);
            addExpression93=addExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, addExpression93.getTree());
            // jaitools/jiffle/parser/Jiffle.g:214:33: ( ( GT | GE | LE | LT ) addExpression )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case GT:
                case GE:
                case LE:
                case LT:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:214:34: ( GT | GE | LE | LT ) addExpression
                    {
                    // jaitools/jiffle/parser/Jiffle.g:214:34: ( GT | GE | LE | LT )
                    int alt20=4;
                    switch ( input.LA(1) ) {
                    case GT:
                        {
                        alt20=1;
                        }
                        break;
                    case GE:
                        {
                        alt20=2;
                        }
                        break;
                    case LE:
                        {
                        alt20=3;
                        }
                        break;
                    case LT:
                        {
                        alt20=4;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 20, 0, input);

                        throw nvae;
                    }

                    switch (alt20) {
                        case 1 :
                            // jaitools/jiffle/parser/Jiffle.g:214:35: GT
                            {
                            GT94=(Token)match(input,GT,FOLLOW_GT_in_compExpression1663); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            GT94_tree = (CommonTree)adaptor.create(GT94);
                            root_0 = (CommonTree)adaptor.becomeRoot(GT94_tree, root_0);
                            }

                            }
                            break;
                        case 2 :
                            // jaitools/jiffle/parser/Jiffle.g:214:41: GE
                            {
                            GE95=(Token)match(input,GE,FOLLOW_GE_in_compExpression1668); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            GE95_tree = (CommonTree)adaptor.create(GE95);
                            root_0 = (CommonTree)adaptor.becomeRoot(GE95_tree, root_0);
                            }

                            }
                            break;
                        case 3 :
                            // jaitools/jiffle/parser/Jiffle.g:214:47: LE
                            {
                            LE96=(Token)match(input,LE,FOLLOW_LE_in_compExpression1673); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            LE96_tree = (CommonTree)adaptor.create(LE96);
                            root_0 = (CommonTree)adaptor.becomeRoot(LE96_tree, root_0);
                            }

                            }
                            break;
                        case 4 :
                            // jaitools/jiffle/parser/Jiffle.g:214:53: LT
                            {
                            LT97=(Token)match(input,LT,FOLLOW_LT_in_compExpression1678); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                            LT97_tree = (CommonTree)adaptor.create(LT97);
                            root_0 = (CommonTree)adaptor.becomeRoot(LT97_tree, root_0);
                            }

                            }
                            break;

                    }

                    pushFollow(FOLLOW_addExpression_in_compExpression1682);
                    addExpression98=addExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, addExpression98.getTree());

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "compExpression"

    public static class addExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "addExpression"
    // jaitools/jiffle/parser/Jiffle.g:218:1: addExpression : multExpression ( ( PLUS | MINUS ) multExpression )* ;
    public final JiffleParser.addExpression_return addExpression() throws RecognitionException {
        JiffleParser.addExpression_return retval = new JiffleParser.addExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token PLUS100=null;
        Token MINUS101=null;
        JiffleParser.multExpression_return multExpression99 = null;

        JiffleParser.multExpression_return multExpression102 = null;


        CommonTree PLUS100_tree=null;
        CommonTree MINUS101_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:218:17: ( multExpression ( ( PLUS | MINUS ) multExpression )* )
            // jaitools/jiffle/parser/Jiffle.g:218:19: multExpression ( ( PLUS | MINUS ) multExpression )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_multExpression_in_addExpression1712);
            multExpression99=multExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, multExpression99.getTree());
            // jaitools/jiffle/parser/Jiffle.g:218:34: ( ( PLUS | MINUS ) multExpression )*
            loop23:
            do {
                int alt23=2;
                switch ( input.LA(1) ) {
                case PLUS:
                case MINUS:
                    {
                    alt23=1;
                    }
                    break;

                }

                switch (alt23) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:218:35: ( PLUS | MINUS ) multExpression
            	    {
            	    // jaitools/jiffle/parser/Jiffle.g:218:35: ( PLUS | MINUS )
            	    int alt22=2;
            	    switch ( input.LA(1) ) {
            	    case PLUS:
            	        {
            	        alt22=1;
            	        }
            	        break;
            	    case MINUS:
            	        {
            	        alt22=2;
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 22, 0, input);

            	        throw nvae;
            	    }

            	    switch (alt22) {
            	        case 1 :
            	            // jaitools/jiffle/parser/Jiffle.g:218:36: PLUS
            	            {
            	            PLUS100=(Token)match(input,PLUS,FOLLOW_PLUS_in_addExpression1716); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            PLUS100_tree = (CommonTree)adaptor.create(PLUS100);
            	            root_0 = (CommonTree)adaptor.becomeRoot(PLUS100_tree, root_0);
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // jaitools/jiffle/parser/Jiffle.g:218:44: MINUS
            	            {
            	            MINUS101=(Token)match(input,MINUS,FOLLOW_MINUS_in_addExpression1721); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            MINUS101_tree = (CommonTree)adaptor.create(MINUS101);
            	            root_0 = (CommonTree)adaptor.becomeRoot(MINUS101_tree, root_0);
            	            }

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_multExpression_in_addExpression1725);
            	    multExpression102=multExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, multExpression102.getTree());

            	    }
            	    break;

            	default :
            	    break loop23;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "addExpression"

    public static class multExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "multExpression"
    // jaitools/jiffle/parser/Jiffle.g:222:1: multExpression : unaryExpression ( ( TIMES | DIV | MOD ) unaryExpression )* ;
    public final JiffleParser.multExpression_return multExpression() throws RecognitionException {
        JiffleParser.multExpression_return retval = new JiffleParser.multExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token TIMES104=null;
        Token DIV105=null;
        Token MOD106=null;
        JiffleParser.unaryExpression_return unaryExpression103 = null;

        JiffleParser.unaryExpression_return unaryExpression107 = null;


        CommonTree TIMES104_tree=null;
        CommonTree DIV105_tree=null;
        CommonTree MOD106_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:222:17: ( unaryExpression ( ( TIMES | DIV | MOD ) unaryExpression )* )
            // jaitools/jiffle/parser/Jiffle.g:222:19: unaryExpression ( ( TIMES | DIV | MOD ) unaryExpression )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_unaryExpression_in_multExpression1754);
            unaryExpression103=unaryExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, unaryExpression103.getTree());
            // jaitools/jiffle/parser/Jiffle.g:222:35: ( ( TIMES | DIV | MOD ) unaryExpression )*
            loop25:
            do {
                int alt25=2;
                switch ( input.LA(1) ) {
                case TIMES:
                case DIV:
                case MOD:
                    {
                    alt25=1;
                    }
                    break;

                }

                switch (alt25) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:222:36: ( TIMES | DIV | MOD ) unaryExpression
            	    {
            	    // jaitools/jiffle/parser/Jiffle.g:222:36: ( TIMES | DIV | MOD )
            	    int alt24=3;
            	    switch ( input.LA(1) ) {
            	    case TIMES:
            	        {
            	        alt24=1;
            	        }
            	        break;
            	    case DIV:
            	        {
            	        alt24=2;
            	        }
            	        break;
            	    case MOD:
            	        {
            	        alt24=3;
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return retval;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 24, 0, input);

            	        throw nvae;
            	    }

            	    switch (alt24) {
            	        case 1 :
            	            // jaitools/jiffle/parser/Jiffle.g:222:37: TIMES
            	            {
            	            TIMES104=(Token)match(input,TIMES,FOLLOW_TIMES_in_multExpression1758); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            TIMES104_tree = (CommonTree)adaptor.create(TIMES104);
            	            root_0 = (CommonTree)adaptor.becomeRoot(TIMES104_tree, root_0);
            	            }

            	            }
            	            break;
            	        case 2 :
            	            // jaitools/jiffle/parser/Jiffle.g:222:46: DIV
            	            {
            	            DIV105=(Token)match(input,DIV,FOLLOW_DIV_in_multExpression1763); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            DIV105_tree = (CommonTree)adaptor.create(DIV105);
            	            root_0 = (CommonTree)adaptor.becomeRoot(DIV105_tree, root_0);
            	            }

            	            }
            	            break;
            	        case 3 :
            	            // jaitools/jiffle/parser/Jiffle.g:222:53: MOD
            	            {
            	            MOD106=(Token)match(input,MOD,FOLLOW_MOD_in_multExpression1768); if (state.failed) return retval;
            	            if ( state.backtracking==0 ) {
            	            MOD106_tree = (CommonTree)adaptor.create(MOD106);
            	            root_0 = (CommonTree)adaptor.becomeRoot(MOD106_tree, root_0);
            	            }

            	            }
            	            break;

            	    }

            	    pushFollow(FOLLOW_unaryExpression_in_multExpression1772);
            	    unaryExpression107=unaryExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, unaryExpression107.getTree());

            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "multExpression"

    public static class unaryExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "unaryExpression"
    // jaitools/jiffle/parser/Jiffle.g:226:1: unaryExpression : ( prefixOp unaryExpression -> ^( PREFIX prefixOp unaryExpression ) | powerExpression );
    public final JiffleParser.unaryExpression_return unaryExpression() throws RecognitionException {
        JiffleParser.unaryExpression_return retval = new JiffleParser.unaryExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        JiffleParser.prefixOp_return prefixOp108 = null;

        JiffleParser.unaryExpression_return unaryExpression109 = null;

        JiffleParser.powerExpression_return powerExpression110 = null;


        RewriteRuleSubtreeStream stream_prefixOp=new RewriteRuleSubtreeStream(adaptor,"rule prefixOp");
        RewriteRuleSubtreeStream stream_unaryExpression=new RewriteRuleSubtreeStream(adaptor,"rule unaryExpression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:226:17: ( prefixOp unaryExpression -> ^( PREFIX prefixOp unaryExpression ) | powerExpression )
            int alt26=2;
            switch ( input.LA(1) ) {
            case PLUS:
            case MINUS:
            case NOT:
            case INCR:
            case DECR:
                {
                alt26=1;
                }
                break;
            case ID:
            case LPAR:
            case IF:
            case LSQUARE:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt26=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 26, 0, input);

                throw nvae;
            }

            switch (alt26) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:226:19: prefixOp unaryExpression
                    {
                    pushFollow(FOLLOW_prefixOp_in_unaryExpression1800);
                    prefixOp108=prefixOp();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_prefixOp.add(prefixOp108.getTree());
                    pushFollow(FOLLOW_unaryExpression_in_unaryExpression1802);
                    unaryExpression109=unaryExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_unaryExpression.add(unaryExpression109.getTree());


                    // AST REWRITE
                    // elements: prefixOp, unaryExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 226:44: -> ^( PREFIX prefixOp unaryExpression )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:226:47: ^( PREFIX prefixOp unaryExpression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PREFIX, "PREFIX"), root_1);

                        adaptor.addChild(root_1, stream_prefixOp.nextTree());
                        adaptor.addChild(root_1, stream_unaryExpression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:227:19: powerExpression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_powerExpression_in_unaryExpression1832);
                    powerExpression110=powerExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, powerExpression110.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "unaryExpression"

    public static class prefixOp_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prefixOp"
    // jaitools/jiffle/parser/Jiffle.g:231:1: prefixOp : ( PLUS | MINUS | NOT | incdecOp );
    public final JiffleParser.prefixOp_return prefixOp() throws RecognitionException {
        JiffleParser.prefixOp_return retval = new JiffleParser.prefixOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token PLUS111=null;
        Token MINUS112=null;
        Token NOT113=null;
        JiffleParser.incdecOp_return incdecOp114 = null;


        CommonTree PLUS111_tree=null;
        CommonTree MINUS112_tree=null;
        CommonTree NOT113_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:231:17: ( PLUS | MINUS | NOT | incdecOp )
            int alt27=4;
            switch ( input.LA(1) ) {
            case PLUS:
                {
                alt27=1;
                }
                break;
            case MINUS:
                {
                alt27=2;
                }
                break;
            case NOT:
                {
                alt27=3;
                }
                break;
            case INCR:
            case DECR:
                {
                alt27=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;
            }

            switch (alt27) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:231:19: PLUS
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    PLUS111=(Token)match(input,PLUS,FOLLOW_PLUS_in_prefixOp1865); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    PLUS111_tree = (CommonTree)adaptor.create(PLUS111);
                    adaptor.addChild(root_0, PLUS111_tree);
                    }

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:232:19: MINUS
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    MINUS112=(Token)match(input,MINUS,FOLLOW_MINUS_in_prefixOp1885); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    MINUS112_tree = (CommonTree)adaptor.create(MINUS112);
                    adaptor.addChild(root_0, MINUS112_tree);
                    }

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:233:19: NOT
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    NOT113=(Token)match(input,NOT,FOLLOW_NOT_in_prefixOp1905); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    NOT113_tree = (CommonTree)adaptor.create(NOT113);
                    adaptor.addChild(root_0, NOT113_tree);
                    }

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/Jiffle.g:234:19: incdecOp
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_incdecOp_in_prefixOp1925);
                    incdecOp114=incdecOp();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, incdecOp114.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prefixOp"

    public static class incdecOp_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "incdecOp"
    // jaitools/jiffle/parser/Jiffle.g:238:1: incdecOp : ( INCR | DECR );
    public final JiffleParser.incdecOp_return incdecOp() throws RecognitionException {
        JiffleParser.incdecOp_return retval = new JiffleParser.incdecOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token set115=null;

        CommonTree set115_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:238:17: ( INCR | DECR )
            // jaitools/jiffle/parser/Jiffle.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            set115=(Token)input.LT(1);
            if ( (input.LA(1)>=INCR && input.LA(1)<=DECR) ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, (CommonTree)adaptor.create(set115));
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "incdecOp"

    public static class powerExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "powerExpression"
    // jaitools/jiffle/parser/Jiffle.g:243:1: powerExpression : primaryExpression ( POW primaryExpression )* ;
    public final JiffleParser.powerExpression_return powerExpression() throws RecognitionException {
        JiffleParser.powerExpression_return retval = new JiffleParser.powerExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token POW117=null;
        JiffleParser.primaryExpression_return primaryExpression116 = null;

        JiffleParser.primaryExpression_return primaryExpression118 = null;


        CommonTree POW117_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:243:17: ( primaryExpression ( POW primaryExpression )* )
            // jaitools/jiffle/parser/Jiffle.g:243:19: primaryExpression ( POW primaryExpression )*
            {
            root_0 = (CommonTree)adaptor.nil();

            pushFollow(FOLLOW_primaryExpression_in_powerExpression2004);
            primaryExpression116=primaryExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, primaryExpression116.getTree());
            // jaitools/jiffle/parser/Jiffle.g:243:37: ( POW primaryExpression )*
            loop28:
            do {
                int alt28=2;
                switch ( input.LA(1) ) {
                case POW:
                    {
                    alt28=1;
                    }
                    break;

                }

                switch (alt28) {
            	case 1 :
            	    // jaitools/jiffle/parser/Jiffle.g:243:38: POW primaryExpression
            	    {
            	    POW117=(Token)match(input,POW,FOLLOW_POW_in_powerExpression2007); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    POW117_tree = (CommonTree)adaptor.create(POW117);
            	    root_0 = (CommonTree)adaptor.becomeRoot(POW117_tree, root_0);
            	    }
            	    pushFollow(FOLLOW_primaryExpression_in_powerExpression2010);
            	    primaryExpression118=primaryExpression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, primaryExpression118.getTree());

            	    }
            	    break;

            	default :
            	    break loop28;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "powerExpression"

    public static class primaryExpression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "primaryExpression"
    // jaitools/jiffle/parser/Jiffle.g:247:1: primaryExpression : atom ( incdecOp )? -> {postfix}? ^( POSTFIX incdecOp atom ) -> atom ;
    public final JiffleParser.primaryExpression_return primaryExpression() throws RecognitionException {
        JiffleParser.primaryExpression_return retval = new JiffleParser.primaryExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        JiffleParser.atom_return atom119 = null;

        JiffleParser.incdecOp_return incdecOp120 = null;


        RewriteRuleSubtreeStream stream_atom=new RewriteRuleSubtreeStream(adaptor,"rule atom");
        RewriteRuleSubtreeStream stream_incdecOp=new RewriteRuleSubtreeStream(adaptor,"rule incdecOp");
         boolean postfix = false; 
        try {
            // jaitools/jiffle/parser/Jiffle.g:249:17: ( atom ( incdecOp )? -> {postfix}? ^( POSTFIX incdecOp atom ) -> atom )
            // jaitools/jiffle/parser/Jiffle.g:249:19: atom ( incdecOp )?
            {
            pushFollow(FOLLOW_atom_in_primaryExpression2059);
            atom119=atom();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_atom.add(atom119.getTree());
            // jaitools/jiffle/parser/Jiffle.g:249:24: ( incdecOp )?
            int alt29=2;
            switch ( input.LA(1) ) {
                case INCR:
                case DECR:
                    {
                    alt29=1;
                    }
                    break;
            }

            switch (alt29) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:249:25: incdecOp
                    {
                    pushFollow(FOLLOW_incdecOp_in_primaryExpression2062);
                    incdecOp120=incdecOp();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_incdecOp.add(incdecOp120.getTree());
                    if ( state.backtracking==0 ) {
                       postfix = true; 
                    }

                    }
                    break;

            }



            // AST REWRITE
            // elements: atom, incdecOp, atom
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 250:19: -> {postfix}? ^( POSTFIX incdecOp atom )
            if (postfix) {
                // jaitools/jiffle/parser/Jiffle.g:250:33: ^( POSTFIX incdecOp atom )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(POSTFIX, "POSTFIX"), root_1);

                adaptor.addChild(root_1, stream_incdecOp.nextTree());
                adaptor.addChild(root_1, stream_atom.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 251:19: -> atom
            {
                adaptor.addChild(root_0, stream_atom.nextTree());

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "primaryExpression"

    public static class atom_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "atom"
    // jaitools/jiffle/parser/Jiffle.g:255:1: atom : ( LPAR expression RPAR -> ^( PAR expression ) | literal | listLiteral | ifCall | identifiedAtom );
    public final JiffleParser.atom_return atom() throws RecognitionException {
        JiffleParser.atom_return retval = new JiffleParser.atom_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LPAR121=null;
        Token RPAR123=null;
        JiffleParser.expression_return expression122 = null;

        JiffleParser.literal_return literal124 = null;

        JiffleParser.listLiteral_return listLiteral125 = null;

        JiffleParser.ifCall_return ifCall126 = null;

        JiffleParser.identifiedAtom_return identifiedAtom127 = null;


        CommonTree LPAR121_tree=null;
        CommonTree RPAR123_tree=null;
        RewriteRuleTokenStream stream_RPAR=new RewriteRuleTokenStream(adaptor,"token RPAR");
        RewriteRuleTokenStream stream_LPAR=new RewriteRuleTokenStream(adaptor,"token LPAR");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:255:17: ( LPAR expression RPAR -> ^( PAR expression ) | literal | listLiteral | ifCall | identifiedAtom )
            int alt30=5;
            switch ( input.LA(1) ) {
            case LPAR:
                {
                alt30=1;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt30=2;
                }
                break;
            case LSQUARE:
                {
                alt30=3;
                }
                break;
            case IF:
                {
                alt30=4;
                }
                break;
            case ID:
                {
                alt30=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;
            }

            switch (alt30) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:255:19: LPAR expression RPAR
                    {
                    LPAR121=(Token)match(input,LPAR,FOLLOW_LPAR_in_atom2156); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_LPAR.add(LPAR121);

                    pushFollow(FOLLOW_expression_in_atom2158);
                    expression122=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression122.getTree());
                    RPAR123=(Token)match(input,RPAR,FOLLOW_RPAR_in_atom2160); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_RPAR.add(RPAR123);



                    // AST REWRITE
                    // elements: expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 255:40: -> ^( PAR expression )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:255:43: ^( PAR expression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PAR, "PAR"), root_1);

                        adaptor.addChild(root_1, stream_expression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:256:19: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_literal_in_atom2188);
                    literal124=literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, literal124.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:257:19: listLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_listLiteral_in_atom2208);
                    listLiteral125=listLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, listLiteral125.getTree());

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/Jiffle.g:258:19: ifCall
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_ifCall_in_atom2228);
                    ifCall126=ifCall();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, ifCall126.getTree());

                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/Jiffle.g:259:19: identifiedAtom
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_identifiedAtom_in_atom2248);
                    identifiedAtom127=identifiedAtom();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, identifiedAtom127.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "atom"

    public static class identifiedAtom_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "identifiedAtom"
    // jaitools/jiffle/parser/Jiffle.g:263:1: identifiedAtom : ( ID arguments -> ^( FUNC_CALL ID arguments ) | ID imagePos -> ^( IMAGE_POS ID imagePos ) | ID );
    public final JiffleParser.identifiedAtom_return identifiedAtom() throws RecognitionException {
        JiffleParser.identifiedAtom_return retval = new JiffleParser.identifiedAtom_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ID128=null;
        Token ID130=null;
        Token ID132=null;
        JiffleParser.arguments_return arguments129 = null;

        JiffleParser.imagePos_return imagePos131 = null;


        CommonTree ID128_tree=null;
        CommonTree ID130_tree=null;
        CommonTree ID132_tree=null;
        RewriteRuleTokenStream stream_ID=new RewriteRuleTokenStream(adaptor,"token ID");
        RewriteRuleSubtreeStream stream_arguments=new RewriteRuleSubtreeStream(adaptor,"rule arguments");
        RewriteRuleSubtreeStream stream_imagePos=new RewriteRuleSubtreeStream(adaptor,"rule imagePos");
        try {
            // jaitools/jiffle/parser/Jiffle.g:263:17: ( ID arguments -> ^( FUNC_CALL ID arguments ) | ID imagePos -> ^( IMAGE_POS ID imagePos ) | ID )
            int alt31=3;
            switch ( input.LA(1) ) {
            case ID:
                {
                switch ( input.LA(2) ) {
                case LPAR:
                    {
                    alt31=1;
                    }
                    break;
                case LSQUARE:
                    {
                    alt31=2;
                    }
                    break;
                case EOF:
                case SEMI:
                case RPAR:
                case COMMA:
                case COLON:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case INCR:
                case DECR:
                case POW:
                case RSQUARE:
                    {
                    alt31=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 31, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 31, 0, input);

                throw nvae;
            }

            switch (alt31) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:263:19: ID arguments
                    {
                    ID128=(Token)match(input,ID,FOLLOW_ID_in_identifiedAtom2275); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_ID.add(ID128);

                    pushFollow(FOLLOW_arguments_in_identifiedAtom2277);
                    arguments129=arguments();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_arguments.add(arguments129.getTree());


                    // AST REWRITE
                    // elements: ID, arguments
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 263:32: -> ^( FUNC_CALL ID arguments )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:263:35: ^( FUNC_CALL ID arguments )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(FUNC_CALL, "FUNC_CALL"), root_1);

                        adaptor.addChild(root_1, stream_ID.nextNode());
                        adaptor.addChild(root_1, stream_arguments.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:264:19: ID imagePos
                    {
                    ID130=(Token)match(input,ID,FOLLOW_ID_in_identifiedAtom2307); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_ID.add(ID130);

                    pushFollow(FOLLOW_imagePos_in_identifiedAtom2309);
                    imagePos131=imagePos();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_imagePos.add(imagePos131.getTree());


                    // AST REWRITE
                    // elements: imagePos, ID
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 264:31: -> ^( IMAGE_POS ID imagePos )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:264:34: ^( IMAGE_POS ID imagePos )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IMAGE_POS, "IMAGE_POS"), root_1);

                        adaptor.addChild(root_1, stream_ID.nextNode());
                        adaptor.addChild(root_1, stream_imagePos.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:265:19: ID
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    ID132=(Token)match(input,ID,FOLLOW_ID_in_identifiedAtom2339); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    ID132_tree = (CommonTree)adaptor.create(ID132);
                    adaptor.addChild(root_0, ID132_tree);
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "identifiedAtom"

    public static class arguments_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "arguments"
    // jaitools/jiffle/parser/Jiffle.g:269:1: arguments : LPAR expressionList RPAR ;
    public final JiffleParser.arguments_return arguments() throws RecognitionException {
        JiffleParser.arguments_return retval = new JiffleParser.arguments_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LPAR133=null;
        Token RPAR135=null;
        JiffleParser.expressionList_return expressionList134 = null;


        CommonTree LPAR133_tree=null;
        CommonTree RPAR135_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:269:17: ( LPAR expressionList RPAR )
            // jaitools/jiffle/parser/Jiffle.g:269:19: LPAR expressionList RPAR
            {
            root_0 = (CommonTree)adaptor.nil();

            LPAR133=(Token)match(input,LPAR,FOLLOW_LPAR_in_arguments2371); if (state.failed) return retval;
            pushFollow(FOLLOW_expressionList_in_arguments2374);
            expressionList134=expressionList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expressionList134.getTree());
            RPAR135=(Token)match(input,RPAR,FOLLOW_RPAR_in_arguments2376); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "arguments"

    public static class imagePos_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "imagePos"
    // jaitools/jiffle/parser/Jiffle.g:273:1: imagePos options {backtrack=true; memoize=true; } : ( bandSpecifier pixelSpecifier | pixelSpecifier | bandSpecifier );
    public final JiffleParser.imagePos_return imagePos() throws RecognitionException {
        JiffleParser.imagePos_return retval = new JiffleParser.imagePos_return();
        retval.start = input.LT(1);
        int imagePos_StartIndex = input.index();
        CommonTree root_0 = null;

        JiffleParser.bandSpecifier_return bandSpecifier136 = null;

        JiffleParser.pixelSpecifier_return pixelSpecifier137 = null;

        JiffleParser.pixelSpecifier_return pixelSpecifier138 = null;

        JiffleParser.bandSpecifier_return bandSpecifier139 = null;



        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 35) ) { return retval; }
            // jaitools/jiffle/parser/Jiffle.g:275:17: ( bandSpecifier pixelSpecifier | pixelSpecifier | bandSpecifier )
            int alt32=3;
            switch ( input.LA(1) ) {
            case LSQUARE:
                {
                int LA32_1 = input.LA(2);

                if ( (synpred3_Jiffle()) ) {
                    alt32=1;
                }
                else if ( (synpred4_Jiffle()) ) {
                    alt32=2;
                }
                else if ( (true) ) {
                    alt32=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 32, 1, input);

                    throw nvae;
                }
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 32, 0, input);

                throw nvae;
            }

            switch (alt32) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:275:19: bandSpecifier pixelSpecifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_bandSpecifier_in_imagePos2433);
                    bandSpecifier136=bandSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, bandSpecifier136.getTree());
                    pushFollow(FOLLOW_pixelSpecifier_in_imagePos2435);
                    pixelSpecifier137=pixelSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, pixelSpecifier137.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:276:19: pixelSpecifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_pixelSpecifier_in_imagePos2455);
                    pixelSpecifier138=pixelSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, pixelSpecifier138.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/Jiffle.g:277:19: bandSpecifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    pushFollow(FOLLOW_bandSpecifier_in_imagePos2475);
                    bandSpecifier139=bandSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, bandSpecifier139.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
            if ( state.backtracking>0 ) { memoize(input, 35, imagePos_StartIndex); }
        }
        return retval;
    }
    // $ANTLR end "imagePos"

    public static class pixelSpecifier_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pixelSpecifier"
    // jaitools/jiffle/parser/Jiffle.g:281:1: pixelSpecifier : LSQUARE pixelPos COMMA pixelPos RSQUARE -> ^( PIXEL_REF pixelPos pixelPos ) ;
    public final JiffleParser.pixelSpecifier_return pixelSpecifier() throws RecognitionException {
        JiffleParser.pixelSpecifier_return retval = new JiffleParser.pixelSpecifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LSQUARE140=null;
        Token COMMA142=null;
        Token RSQUARE144=null;
        JiffleParser.pixelPos_return pixelPos141 = null;

        JiffleParser.pixelPos_return pixelPos143 = null;


        CommonTree LSQUARE140_tree=null;
        CommonTree COMMA142_tree=null;
        CommonTree RSQUARE144_tree=null;
        RewriteRuleTokenStream stream_LSQUARE=new RewriteRuleTokenStream(adaptor,"token LSQUARE");
        RewriteRuleTokenStream stream_RSQUARE=new RewriteRuleTokenStream(adaptor,"token RSQUARE");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_pixelPos=new RewriteRuleSubtreeStream(adaptor,"rule pixelPos");
        try {
            // jaitools/jiffle/parser/Jiffle.g:281:17: ( LSQUARE pixelPos COMMA pixelPos RSQUARE -> ^( PIXEL_REF pixelPos pixelPos ) )
            // jaitools/jiffle/parser/Jiffle.g:281:19: LSQUARE pixelPos COMMA pixelPos RSQUARE
            {
            LSQUARE140=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_pixelSpecifier2502); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LSQUARE.add(LSQUARE140);

            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2504);
            pixelPos141=pixelPos();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_pixelPos.add(pixelPos141.getTree());
            COMMA142=(Token)match(input,COMMA,FOLLOW_COMMA_in_pixelSpecifier2506); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_COMMA.add(COMMA142);

            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2508);
            pixelPos143=pixelPos();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_pixelPos.add(pixelPos143.getTree());
            RSQUARE144=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_pixelSpecifier2510); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RSQUARE.add(RSQUARE144);



            // AST REWRITE
            // elements: pixelPos, pixelPos
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 281:59: -> ^( PIXEL_REF pixelPos pixelPos )
            {
                // jaitools/jiffle/parser/Jiffle.g:281:62: ^( PIXEL_REF pixelPos pixelPos )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(PIXEL_REF, "PIXEL_REF"), root_1);

                adaptor.addChild(root_1, stream_pixelPos.nextTree());
                adaptor.addChild(root_1, stream_pixelPos.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelSpecifier"

    public static class bandSpecifier_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "bandSpecifier"
    // jaitools/jiffle/parser/Jiffle.g:285:1: bandSpecifier : LSQUARE expression RSQUARE -> ^( BAND_REF expression ) ;
    public final JiffleParser.bandSpecifier_return bandSpecifier() throws RecognitionException {
        JiffleParser.bandSpecifier_return retval = new JiffleParser.bandSpecifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LSQUARE145=null;
        Token RSQUARE147=null;
        JiffleParser.expression_return expression146 = null;


        CommonTree LSQUARE145_tree=null;
        CommonTree RSQUARE147_tree=null;
        RewriteRuleTokenStream stream_LSQUARE=new RewriteRuleTokenStream(adaptor,"token LSQUARE");
        RewriteRuleTokenStream stream_RSQUARE=new RewriteRuleTokenStream(adaptor,"token RSQUARE");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:285:17: ( LSQUARE expression RSQUARE -> ^( BAND_REF expression ) )
            // jaitools/jiffle/parser/Jiffle.g:285:19: LSQUARE expression RSQUARE
            {
            LSQUARE145=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_bandSpecifier2548); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LSQUARE.add(LSQUARE145);

            pushFollow(FOLLOW_expression_in_bandSpecifier2550);
            expression146=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression146.getTree());
            RSQUARE147=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_bandSpecifier2552); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RSQUARE.add(RSQUARE147);



            // AST REWRITE
            // elements: expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 285:46: -> ^( BAND_REF expression )
            {
                // jaitools/jiffle/parser/Jiffle.g:285:49: ^( BAND_REF expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(BAND_REF, "BAND_REF"), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "bandSpecifier"

    public static class pixelPos_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pixelPos"
    // jaitools/jiffle/parser/Jiffle.g:289:1: pixelPos : ( ABS_POS_PREFIX expression -> ^( ABS_POS expression ) | expression -> ^( REL_POS expression ) );
    public final JiffleParser.pixelPos_return pixelPos() throws RecognitionException {
        JiffleParser.pixelPos_return retval = new JiffleParser.pixelPos_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token ABS_POS_PREFIX148=null;
        JiffleParser.expression_return expression149 = null;

        JiffleParser.expression_return expression150 = null;


        CommonTree ABS_POS_PREFIX148_tree=null;
        RewriteRuleTokenStream stream_ABS_POS_PREFIX=new RewriteRuleTokenStream(adaptor,"token ABS_POS_PREFIX");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/Jiffle.g:289:17: ( ABS_POS_PREFIX expression -> ^( ABS_POS expression ) | expression -> ^( REL_POS expression ) )
            int alt33=2;
            switch ( input.LA(1) ) {
            case ABS_POS_PREFIX:
                {
                alt33=1;
                }
                break;
            case ID:
            case LPAR:
            case IF:
            case PLUS:
            case MINUS:
            case NOT:
            case INCR:
            case DECR:
            case LSQUARE:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt33=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;
            }

            switch (alt33) {
                case 1 :
                    // jaitools/jiffle/parser/Jiffle.g:289:19: ABS_POS_PREFIX expression
                    {
                    ABS_POS_PREFIX148=(Token)match(input,ABS_POS_PREFIX,FOLLOW_ABS_POS_PREFIX_in_pixelPos2593); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_ABS_POS_PREFIX.add(ABS_POS_PREFIX148);

                    pushFollow(FOLLOW_expression_in_pixelPos2595);
                    expression149=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression149.getTree());


                    // AST REWRITE
                    // elements: expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 289:45: -> ^( ABS_POS expression )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:289:48: ^( ABS_POS expression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(ABS_POS, "ABS_POS"), root_1);

                        adaptor.addChild(root_1, stream_expression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/Jiffle.g:290:19: expression
                    {
                    pushFollow(FOLLOW_expression_in_pixelPos2623);
                    expression150=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression150.getTree());


                    // AST REWRITE
                    // elements: expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 290:30: -> ^( REL_POS expression )
                    {
                        // jaitools/jiffle/parser/Jiffle.g:290:33: ^( REL_POS expression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(REL_POS, "REL_POS"), root_1);

                        adaptor.addChild(root_1, stream_expression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;}
                    }
                    break;

            }
            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelPos"

    public static class literal_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "literal"
    // jaitools/jiffle/parser/Jiffle.g:294:1: literal : ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL );
    public final JiffleParser.literal_return literal() throws RecognitionException {
        JiffleParser.literal_return retval = new JiffleParser.literal_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token set151=null;

        CommonTree set151_tree=null;

        try {
            // jaitools/jiffle/parser/Jiffle.g:294:17: ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL )
            // jaitools/jiffle/parser/Jiffle.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            set151=(Token)input.LT(1);
            if ( (input.LA(1)>=INT_LITERAL && input.LA(1)<=NULL) ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, (CommonTree)adaptor.create(set151));
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "literal"

    public static class listLiteral_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "listLiteral"
    // jaitools/jiffle/parser/Jiffle.g:302:1: listLiteral : LSQUARE expressionList RSQUARE -> ^( DECLARED_LIST expressionList ) ;
    public final JiffleParser.listLiteral_return listLiteral() throws RecognitionException {
        JiffleParser.listLiteral_return retval = new JiffleParser.listLiteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        Token LSQUARE152=null;
        Token RSQUARE154=null;
        JiffleParser.expressionList_return expressionList153 = null;


        CommonTree LSQUARE152_tree=null;
        CommonTree RSQUARE154_tree=null;
        RewriteRuleTokenStream stream_LSQUARE=new RewriteRuleTokenStream(adaptor,"token LSQUARE");
        RewriteRuleTokenStream stream_RSQUARE=new RewriteRuleTokenStream(adaptor,"token RSQUARE");
        RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
        try {
            // jaitools/jiffle/parser/Jiffle.g:302:17: ( LSQUARE expressionList RSQUARE -> ^( DECLARED_LIST expressionList ) )
            // jaitools/jiffle/parser/Jiffle.g:302:19: LSQUARE expressionList RSQUARE
            {
            LSQUARE152=(Token)match(input,LSQUARE,FOLLOW_LSQUARE_in_listLiteral2775); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LSQUARE.add(LSQUARE152);

            pushFollow(FOLLOW_expressionList_in_listLiteral2777);
            expressionList153=expressionList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expressionList.add(expressionList153.getTree());
            RSQUARE154=(Token)match(input,RSQUARE,FOLLOW_RSQUARE_in_listLiteral2779); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RSQUARE.add(RSQUARE154);



            // AST REWRITE
            // elements: expressionList
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 302:50: -> ^( DECLARED_LIST expressionList )
            {
                // jaitools/jiffle/parser/Jiffle.g:302:53: ^( DECLARED_LIST expressionList )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(DECLARED_LIST, "DECLARED_LIST"), root_1);

                adaptor.addChild(root_1, stream_expressionList.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;}
            }

            retval.stop = input.LT(-1);

            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listLiteral"

    // $ANTLR start synpred1_Jiffle
    public final void synpred1_Jiffle_fragment() throws RecognitionException {   
        // jaitools/jiffle/parser/Jiffle.g:146:19: ( listLiteral )
        // jaitools/jiffle/parser/Jiffle.g:146:19: listLiteral
        {
        pushFollow(FOLLOW_listLiteral_in_synpred1_Jiffle1000);
        listLiteral();

        state._fsp--;
        if (state.failed) return ;

        }
    }
    // $ANTLR end synpred1_Jiffle

    // $ANTLR start synpred2_Jiffle
    public final void synpred2_Jiffle_fragment() throws RecognitionException {   
        // jaitools/jiffle/parser/Jiffle.g:147:19: ( sequence )
        // jaitools/jiffle/parser/Jiffle.g:147:19: sequence
        {
        pushFollow(FOLLOW_sequence_in_synpred2_Jiffle1020);
        sequence();

        state._fsp--;
        if (state.failed) return ;

        }
    }
    // $ANTLR end synpred2_Jiffle

    // $ANTLR start synpred3_Jiffle
    public final void synpred3_Jiffle_fragment() throws RecognitionException {   
        // jaitools/jiffle/parser/Jiffle.g:275:19: ( bandSpecifier pixelSpecifier )
        // jaitools/jiffle/parser/Jiffle.g:275:19: bandSpecifier pixelSpecifier
        {
        pushFollow(FOLLOW_bandSpecifier_in_synpred3_Jiffle2433);
        bandSpecifier();

        state._fsp--;
        if (state.failed) return ;
        pushFollow(FOLLOW_pixelSpecifier_in_synpred3_Jiffle2435);
        pixelSpecifier();

        state._fsp--;
        if (state.failed) return ;

        }
    }
    // $ANTLR end synpred3_Jiffle

    // $ANTLR start synpred4_Jiffle
    public final void synpred4_Jiffle_fragment() throws RecognitionException {   
        // jaitools/jiffle/parser/Jiffle.g:276:19: ( pixelSpecifier )
        // jaitools/jiffle/parser/Jiffle.g:276:19: pixelSpecifier
        {
        pushFollow(FOLLOW_pixelSpecifier_in_synpred4_Jiffle2455);
        pixelSpecifier();

        state._fsp--;
        if (state.failed) return ;

        }
    }
    // $ANTLR end synpred4_Jiffle

    // Delegated rules

    public final boolean synpred1_Jiffle() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_Jiffle_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred2_Jiffle() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred2_Jiffle_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred3_Jiffle() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred3_Jiffle_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred4_Jiffle() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred4_Jiffle_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA10 dfa10 = new DFA10(this);
    static final String DFA10_eotS =
        "\14\uffff";
    static final String DFA10_eofS =
        "\14\uffff";
    static final String DFA10_minS =
        "\1\41\1\0\7\uffff\1\0\2\uffff";
    static final String DFA10_maxS =
        "\1\117\1\0\7\uffff\1\0\2\uffff";
    static final String DFA10_acceptS =
        "\2\uffff\1\2\7\uffff\1\1\1\3";
    static final String DFA10_specialS =
        "\1\uffff\1\0\7\uffff\1\1\2\uffff}>";
    static final String[] DFA10_transitionS = {
            "\1\11\4\uffff\1\2\7\uffff\1\2\20\uffff\2\2\3\uffff\3\2\1\uffff"+
            "\1\1\2\uffff\5\2",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            ""
    };

    static final short[] DFA10_eot = DFA.unpackEncodedString(DFA10_eotS);
    static final short[] DFA10_eof = DFA.unpackEncodedString(DFA10_eofS);
    static final char[] DFA10_min = DFA.unpackEncodedStringToUnsignedChars(DFA10_minS);
    static final char[] DFA10_max = DFA.unpackEncodedStringToUnsignedChars(DFA10_maxS);
    static final short[] DFA10_accept = DFA.unpackEncodedString(DFA10_acceptS);
    static final short[] DFA10_special = DFA.unpackEncodedString(DFA10_specialS);
    static final short[][] DFA10_transition;

    static {
        int numStates = DFA10_transitionS.length;
        DFA10_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA10_transition[i] = DFA.unpackEncodedString(DFA10_transitionS[i]);
        }
    }

    class DFA10 extends DFA {

        public DFA10(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 10;
            this.eot = DFA10_eot;
            this.eof = DFA10_eof;
            this.min = DFA10_min;
            this.max = DFA10_max;
            this.accept = DFA10_accept;
            this.special = DFA10_special;
            this.transition = DFA10_transition;
        }
        public String getDescription() {
            return "144:1: loopSet options {backtrack=true; } : ( listLiteral | sequence | ID );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA10_1 = input.LA(1);

                         
                        int index10_1 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (synpred1_Jiffle()) ) {s = 10;}

                        else if ( (synpred2_Jiffle()) ) {s = 2;}

                         
                        input.seek(index10_1);
                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA10_9 = input.LA(1);

                         
                        int index10_9 = input.index();
                        input.rewind();
                        s = -1;
                        if ( (synpred2_Jiffle()) ) {s = 2;}

                        else if ( (true) ) {s = 11;}

                         
                        input.seek(index10_9);
                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 10, _s, input);
            error(nvae);
            throw nvae;
        }
    }
 

    public static final BitSet FOLLOW_optionsBlock_in_prog266 = new BitSet(new long[]{0x8000475A80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_initBlock_in_prog269 = new BitSet(new long[]{0x8000475A80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_statement_in_prog272 = new BitSet(new long[]{0x8000475A80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_EOF_in_prog275 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OPTIONS_in_optionsBlock349 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_LCURLY_in_optionsBlock351 = new BitSet(new long[]{0x0000000300000000L});
    public static final BitSet FOLLOW_option_in_optionsBlock353 = new BitSet(new long[]{0x0000000300000000L});
    public static final BitSet FOLLOW_RCURLY_in_optionsBlock356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_option395 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_EQ_in_option397 = new BitSet(new long[]{0x0000000200000000L,0x000000000000F800L});
    public static final BitSet FOLLOW_optionValue_in_option399 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_SEMI_in_option401 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_optionValue441 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_optionValue461 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INIT_in_initBlock493 = new BitSet(new long[]{0x0000000080000000L});
    public static final BitSet FOLLOW_LCURLY_in_initBlock495 = new BitSet(new long[]{0x0000000300000000L});
    public static final BitSet FOLLOW_varDeclaration_in_initBlock497 = new BitSet(new long[]{0x0000000300000000L});
    public static final BitSet FOLLOW_RCURLY_in_initBlock500 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_varDeclaration532 = new BitSet(new long[]{0x0000000400000000L});
    public static final BitSet FOLLOW_EQ_in_varDeclaration534 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_varDeclaration536 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_SEMI_in_varDeclaration538 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LCURLY_in_block584 = new BitSet(new long[]{0x8000477B80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_blockStatement_in_block586 = new BitSet(new long[]{0x8000477B80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_RCURLY_in_block589 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statement_in_blockStatement625 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BREAKIF_in_blockStatement645 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_LPAR_in_blockStatement647 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_blockStatement649 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_blockStatement651 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_block_in_statement691 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_delimitedStatement_in_statement711 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_SEMI_in_statement713 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_assignmentExpression_in_statement734 = new BitSet(new long[]{0x0000000800000000L});
    public static final BitSet FOLLOW_SEMI_in_statement736 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WHILE_in_statement757 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_LPAR_in_statement759 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_loopCondition_in_statement761 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_statement763 = new BitSet(new long[]{0x8000475A80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_statement_in_statement765 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UNTIL_in_statement795 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_LPAR_in_statement797 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_loopCondition_in_statement799 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_statement801 = new BitSet(new long[]{0x8000475A80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_statement_in_statement803 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FOREACH_in_statement833 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_LPAR_in_statement835 = new BitSet(new long[]{0x0000000200000000L});
    public static final BitSet FOLLOW_ID_in_statement837 = new BitSet(new long[]{0x0000080000000000L});
    public static final BitSet FOLLOW_IN_in_statement839 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_loopSet_in_statement841 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_statement843 = new BitSet(new long[]{0x8000475A80000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_statement_in_statement845 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SEMI_in_statement877 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_delimitedStatement920 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_orExpression_in_loopCondition948 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_loopSet1000 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sequence_in_loopSet1020 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_loopSet1040 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_expressionList1068 = new BitSet(new long[]{0x0000100000000002L});
    public static final BitSet FOLLOW_COMMA_in_expressionList1071 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_expressionList1073 = new BitSet(new long[]{0x0000100000000002L});
    public static final BitSet FOLLOW_expression_in_sequence1122 = new BitSet(new long[]{0x0000200000000000L});
    public static final BitSet FOLLOW_COLON_in_sequence1124 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_sequence1128 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IF_in_ifCall1177 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_LPAR_in_ifCall1179 = new BitSet(new long[]{0x800040C200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expressionList_in_ifCall1181 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_ifCall1183 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_assignmentExpression1235 = new BitSet(new long[]{0x001F000400000000L});
    public static final BitSet FOLLOW_assignmentOp_in_assignmentExpression1237 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_assignmentExpression1240 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_conditionalExpression_in_expression1270 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_expression1290 = new BitSet(new long[]{0x0000800000000000L});
    public static final BitSet FOLLOW_APPEND_in_expression1292 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_expression1295 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_assignmentOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_orExpression_in_conditionalExpression1466 = new BitSet(new long[]{0x0020000000000002L});
    public static final BitSet FOLLOW_QUESTION_in_conditionalExpression1469 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_conditionalExpression1472 = new BitSet(new long[]{0x0000200000000000L});
    public static final BitSet FOLLOW_COLON_in_conditionalExpression1474 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_conditionalExpression1477 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_xorExpression_in_orExpression1508 = new BitSet(new long[]{0x0040000000000002L});
    public static final BitSet FOLLOW_OR_in_orExpression1511 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_xorExpression_in_orExpression1514 = new BitSet(new long[]{0x0040000000000002L});
    public static final BitSet FOLLOW_andExpression_in_xorExpression1544 = new BitSet(new long[]{0x0080000000000002L});
    public static final BitSet FOLLOW_XOR_in_xorExpression1547 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_andExpression_in_xorExpression1550 = new BitSet(new long[]{0x0080000000000002L});
    public static final BitSet FOLLOW_eqExpression_in_andExpression1580 = new BitSet(new long[]{0x0100000000000002L});
    public static final BitSet FOLLOW_AND_in_andExpression1583 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_eqExpression_in_andExpression1586 = new BitSet(new long[]{0x0100000000000002L});
    public static final BitSet FOLLOW_compExpression_in_eqExpression1617 = new BitSet(new long[]{0x0600000000000002L});
    public static final BitSet FOLLOW_LOGICALEQ_in_eqExpression1621 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_NE_in_eqExpression1626 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_compExpression_in_eqExpression1630 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_addExpression_in_compExpression1659 = new BitSet(new long[]{0x7800000000000002L});
    public static final BitSet FOLLOW_GT_in_compExpression1663 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_GE_in_compExpression1668 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_LE_in_compExpression1673 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_LT_in_compExpression1678 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_addExpression_in_compExpression1682 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_multExpression_in_addExpression1712 = new BitSet(new long[]{0x8000000000000002L,0x0000000000000001L});
    public static final BitSet FOLLOW_PLUS_in_addExpression1716 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_MINUS_in_addExpression1721 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_multExpression_in_addExpression1725 = new BitSet(new long[]{0x8000000000000002L,0x0000000000000001L});
    public static final BitSet FOLLOW_unaryExpression_in_multExpression1754 = new BitSet(new long[]{0x0000000000000002L,0x000000000000000EL});
    public static final BitSet FOLLOW_TIMES_in_multExpression1758 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_DIV_in_multExpression1763 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_MOD_in_multExpression1768 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_unaryExpression_in_multExpression1772 = new BitSet(new long[]{0x0000000000000002L,0x000000000000000EL});
    public static final BitSet FOLLOW_prefixOp_in_unaryExpression1800 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_unaryExpression_in_unaryExpression1802 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_powerExpression_in_unaryExpression1832 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PLUS_in_prefixOp1865 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MINUS_in_prefixOp1885 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_prefixOp1905 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_incdecOp_in_prefixOp1925 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_incdecOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_primaryExpression_in_powerExpression2004 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000080L});
    public static final BitSet FOLLOW_POW_in_powerExpression2007 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_primaryExpression_in_powerExpression2010 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000080L});
    public static final BitSet FOLLOW_atom_in_primaryExpression2059 = new BitSet(new long[]{0x8000000000000002L,0x0000000000000071L});
    public static final BitSet FOLLOW_incdecOp_in_primaryExpression2062 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAR_in_atom2156 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_atom2158 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_atom2160 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_atom2188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_atom2208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ifCall_in_atom2228 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifiedAtom_in_atom2248 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_identifiedAtom2275 = new BitSet(new long[]{0x0000004000000000L});
    public static final BitSet FOLLOW_arguments_in_identifiedAtom2277 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_identifiedAtom2307 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_imagePos_in_identifiedAtom2309 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ID_in_identifiedAtom2339 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LPAR_in_arguments2371 = new BitSet(new long[]{0x800040C200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expressionList_in_arguments2374 = new BitSet(new long[]{0x0000008000000000L});
    public static final BitSet FOLLOW_RPAR_in_arguments2376 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bandSpecifier_in_imagePos2433 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_pixelSpecifier_in_imagePos2435 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pixelSpecifier_in_imagePos2455 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bandSpecifier_in_imagePos2475 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LSQUARE_in_pixelSpecifier2502 = new BitSet(new long[]{0x8000404200000000L,0x000000000000FD71L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2504 = new BitSet(new long[]{0x0000100000000000L});
    public static final BitSet FOLLOW_COMMA_in_pixelSpecifier2506 = new BitSet(new long[]{0x8000404200000000L,0x000000000000FD71L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2508 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_RSQUARE_in_pixelSpecifier2510 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LSQUARE_in_bandSpecifier2548 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_bandSpecifier2550 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_RSQUARE_in_bandSpecifier2552 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ABS_POS_PREFIX_in_pixelPos2593 = new BitSet(new long[]{0x8000404200000000L,0x000000000000F971L});
    public static final BitSet FOLLOW_expression_in_pixelPos2595 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_pixelPos2623 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LSQUARE_in_listLiteral2775 = new BitSet(new long[]{0x8000404200000000L,0x000000000000FB71L});
    public static final BitSet FOLLOW_expressionList_in_listLiteral2777 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_RSQUARE_in_listLiteral2779 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_synpred1_Jiffle1000 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sequence_in_synpred2_Jiffle1020 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bandSpecifier_in_synpred3_Jiffle2433 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_pixelSpecifier_in_synpred3_Jiffle2435 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pixelSpecifier_in_synpred4_Jiffle2455 = new BitSet(new long[]{0x0000000000000002L});

}