/*
 * Copyright 2011 Michael Bedward
 * 
 * This file is part of jai-tools.
 *
 * jai-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 *
 * jai-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with jai-tools.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package jaitools.jiffle.parser;

/**
 * An exception thrown when the Jiffle parser aborts due to errors.
 * 
 * @author Michael Bedward
 * @since 1.1
 * @version $Id: JiffleParserException.java 1389 2011-02-11 08:54:11Z michael.bedward $
 */
public class JiffleParserException extends RuntimeException {

    /**
     * Creates a new exception.
     * 
     * @param thrwbl the base exception
     */
    public JiffleParserException(Throwable thrwbl) {
        super(thrwbl);
    }

    /**
     * Creates a new exception.
     * 
     * @param msg error message
     */
    public JiffleParserException(String msg) {
        super(msg);
    }

}
