// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/OptionsBlockReader.g 2011-03-08 17:37:56

package jaitools.jiffle.parser;

import java.util.Map;
import jaitools.CollectionFactory;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
/**
  * Transforms tokens representing variables into specific token types.
  *
  * @author Michael Bedward
  */
public class OptionsBlockReader extends TreeFilter {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public OptionsBlockReader(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public OptionsBlockReader(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return OptionsBlockReader.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/OptionsBlockReader.g"; }



    private MessageTable msgTable;
    private Map<String, String> options = CollectionFactory.map();

    public OptionsBlockReader( TreeNodeStream nodes, MessageTable msgTable ) {
        this(nodes);
        if (msgTable == null) {
            throw new IllegalArgumentException( "msgTable should not be null" );
        }
        this.msgTable = msgTable;
    }

    public Map<String, String> getOptions() {
        return options;
    }

    public void addOption(String name, String value) {
        try {
            if (OptionLookup.isValidValue(name, value)) {
                options.put(name, value);
            } else {
                msgTable.add(value, Message.INVALID_OPTION_VALUE);
            }
        } catch (UndefinedOptionException ex) {
            msgTable.add(name, Message.INVALID_OPTION);
        }
    }




    // $ANTLR start "topdown"
    // jaitools/jiffle/parser/OptionsBlockReader.g:76:1: topdown : jiffleOption ;
    public final void topdown() throws RecognitionException {
        try {
            // jaitools/jiffle/parser/OptionsBlockReader.g:76:17: ( jiffleOption )
            // jaitools/jiffle/parser/OptionsBlockReader.g:76:19: jiffleOption
            {
            pushFollow(FOLLOW_jiffleOption_in_topdown82);
            jiffleOption();

            state._fsp--;
            if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "topdown"


    // $ANTLR start "jiffleOption"
    // jaitools/jiffle/parser/OptionsBlockReader.g:80:1: jiffleOption : ^( JIFFLE_OPTION ID optionValue ) ;
    public final void jiffleOption() throws RecognitionException {
        CommonTree ID1=null;
        OptionsBlockReader.optionValue_return optionValue2 = null;


        try {
            // jaitools/jiffle/parser/OptionsBlockReader.g:80:17: ( ^( JIFFLE_OPTION ID optionValue ) )
            // jaitools/jiffle/parser/OptionsBlockReader.g:80:19: ^( JIFFLE_OPTION ID optionValue )
            {
            match(input,JIFFLE_OPTION,FOLLOW_JIFFLE_OPTION_in_jiffleOption112); if (state.failed) return ;

            match(input, Token.DOWN, null); if (state.failed) return ;
            ID1=(CommonTree)match(input,ID,FOLLOW_ID_in_jiffleOption114); if (state.failed) return ;
            pushFollow(FOLLOW_optionValue_in_jiffleOption116);
            optionValue2=optionValue();

            state._fsp--;
            if (state.failed) return ;

            match(input, Token.UP, null); if (state.failed) return ;
            if ( state.backtracking==1 ) {
               addOption((ID1!=null?ID1.getText():null), (optionValue2!=null?((CommonTree)optionValue2.start):null).getText()); 
            }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "jiffleOption"

    public static class optionValue_return extends TreeRuleReturnScope {
        public String str;
    };

    // $ANTLR start "optionValue"
    // jaitools/jiffle/parser/OptionsBlockReader.g:85:1: optionValue returns [String str] : ( ID | literal );
    public final OptionsBlockReader.optionValue_return optionValue() throws RecognitionException {
        OptionsBlockReader.optionValue_return retval = new OptionsBlockReader.optionValue_return();
        retval.start = input.LT(1);

        CommonTree ID3=null;
        OptionsBlockReader.literal_return literal4 = null;


        try {
            // jaitools/jiffle/parser/OptionsBlockReader.g:86:17: ( ID | literal )
            int alt1=2;
            switch ( input.LA(1) ) {
            case ID:
                {
                alt1=1;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt1=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;
            }

            switch (alt1) {
                case 1 :
                    // jaitools/jiffle/parser/OptionsBlockReader.g:86:19: ID
                    {
                    ID3=(CommonTree)match(input,ID,FOLLOW_ID_in_optionValue181); if (state.failed) return retval;
                    if ( state.backtracking==1 ) {
                       retval.str = (ID3!=null?ID3.getText():null); 
                    }

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/OptionsBlockReader.g:87:19: literal
                    {
                    pushFollow(FOLLOW_literal_in_optionValue203);
                    literal4=literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==1 ) {
                       retval.str = (literal4!=null?((CommonTree)literal4.start):null).getText(); 
                    }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionValue"

    public static class literal_return extends TreeRuleReturnScope {
    };

    // $ANTLR start "literal"
    // jaitools/jiffle/parser/OptionsBlockReader.g:91:1: literal : ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL );
    public final OptionsBlockReader.literal_return literal() throws RecognitionException {
        OptionsBlockReader.literal_return retval = new OptionsBlockReader.literal_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/OptionsBlockReader.g:91:17: ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL )
            // jaitools/jiffle/parser/OptionsBlockReader.g:
            {
            if ( (input.LA(1)>=INT_LITERAL && input.LA(1)<=NULL) ) {
                input.consume();
                state.errorRecovery=false;state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "literal"

    // Delegated rules


 

    public static final BitSet FOLLOW_jiffleOption_in_topdown82 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_JIFFLE_OPTION_in_jiffleOption112 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_jiffleOption114 = new BitSet(new long[]{0x0000000200000000L,0x000000000000F800L});
    public static final BitSet FOLLOW_optionValue_in_jiffleOption116 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ID_in_optionValue181 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_optionValue203 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal0 = new BitSet(new long[]{0x0000000000000002L});

}