// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/RuntimeSourceGenerator.g 2011-03-08 17:37:55

package jaitools.jiffle.parser;

import jaitools.jiffle.Jiffle;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.stringtemplate.*;
import org.antlr.stringtemplate.language.*;
import java.util.HashMap;
/**
  * Generates Java sources for the runtime class from the final AST.
  *
  * @author Michael Bedward
  */
public class RuntimeSourceGenerator extends AbstractSourceGenerator {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public RuntimeSourceGenerator(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public RuntimeSourceGenerator(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        
    protected StringTemplateGroup templateLib =
      new StringTemplateGroup("RuntimeSourceGeneratorTemplates", AngleBracketTemplateLexer.class);

    public void setTemplateLib(StringTemplateGroup templateLib) {
      this.templateLib = templateLib;
    }
    public StringTemplateGroup getTemplateLib() {
      return templateLib;
    }
    /** allows convenient multi-value initialization:
     *  "new STAttrMap().put(...).put(...)"
     */
    public static class STAttrMap extends HashMap {
      public STAttrMap put(String attrName, Object value) {
        super.put(attrName, value);
        return this;
      }
      public STAttrMap put(String attrName, int value) {
        super.put(attrName, new Integer(value));
        return this;
      }
    }

    public String[] getTokenNames() { return RuntimeSourceGenerator.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/RuntimeSourceGenerator.g"; }



    private SymbolScopeStack varScope = new SymbolScopeStack();

    private String getConstantString(String name) {
        String s = String.valueOf(ConstantLookup.getValue(name));
        if ("NaN".equals(s)) {
            return "Double.NaN";
        }
        return s;
    }



    public static class generate_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "generate"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:58:1: generate : (o+= jiffleOption )* (v+= varDeclaration )* (s+= statement )+ -> runtime(pkgname=pkgNameimports=importsname=classNamebase=baseClassNameopts=$ofields=$veval=$s);
    public final RuntimeSourceGenerator.generate_return generate() throws RecognitionException {
        RuntimeSourceGenerator.generate_return retval = new RuntimeSourceGenerator.generate_return();
        retval.start = input.LT(1);

        List list_o=null;
        List list_v=null;
        List list_s=null;
        RuleReturnScope o = null;
        RuleReturnScope v = null;
        RuleReturnScope s = null;

            varScope.addLevel("top");

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:17: ( (o+= jiffleOption )* (v+= varDeclaration )* (s+= statement )+ -> runtime(pkgname=pkgNameimports=importsname=classNamebase=baseClassNameopts=$ofields=$veval=$s))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:19: (o+= jiffleOption )* (v+= varDeclaration )* (s+= statement )+
            {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:20: (o+= jiffleOption )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case JIFFLE_OPTION:
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:20: o+= jiffleOption
            	    {
            	    pushFollow(FOLLOW_jiffleOption_in_generate105);
            	    o=jiffleOption();

            	    state._fsp--;

            	    if (list_o==null) list_o=new ArrayList();
            	    list_o.add(o.getTemplate());


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:37: (v+= varDeclaration )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case IMAGE_SCOPE_VAR_DECL:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:37: v+= varDeclaration
            	    {
            	    pushFollow(FOLLOW_varDeclaration_in_generate110);
            	    v=varDeclaration();

            	    state._fsp--;

            	    if (list_v==null) list_v=new ArrayList();
            	    list_v.add(v.getTemplate());


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:56: (s+= statement )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case DECLARED_LIST:
                case PAR:
                case FUNC_CALL:
                case IF_CALL:
                case BLOCK:
                case IMAGE_POS:
                case PREFIX:
                case POSTFIX:
                case CONSTANT:
                case IMAGE_WRITE:
                case VAR_SOURCE:
                case VAR_IMAGE_SCOPE:
                case VAR_PIXEL_SCOPE:
                case VAR_PROVIDED:
                case VAR_LOOP:
                case VAR_LIST:
                case EQ:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case APPEND:
                case TIMESEQ:
                case DIVEQ:
                case MODEQ:
                case PLUSEQ:
                case MINUSEQ:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case POW:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:62:56: s+= statement
            	    {
            	    pushFollow(FOLLOW_statement_in_generate115);
            	    s=statement();

            	    state._fsp--;

            	    if (list_s==null) list_s=new ArrayList();
            	    list_s.add(s.getTemplate());


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);



            // TEMPLATE REWRITE
            // 64:17: -> runtime(pkgname=pkgNameimports=importsname=classNamebase=baseClassNameopts=$ofields=$veval=$s)
            {
                retval.st = templateLib.getInstanceOf("runtime",
              new STAttrMap().put("pkgname", pkgName).put("imports", imports).put("name", className).put("base", baseClassName).put("opts", list_o).put("fields", list_v).put("eval", list_s));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "generate"

    public static class jiffleOption_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "jiffleOption"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:70:1: jiffleOption : ^( JIFFLE_OPTION ID optionValue ) -> {%{getOptionExpr($ID.text, $optionValue.src)}};
    public final RuntimeSourceGenerator.jiffleOption_return jiffleOption() throws RecognitionException {
        RuntimeSourceGenerator.jiffleOption_return retval = new RuntimeSourceGenerator.jiffleOption_return();
        retval.start = input.LT(1);

        CommonTree ID1=null;
        RuntimeSourceGenerator.optionValue_return optionValue2 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:70:17: ( ^( JIFFLE_OPTION ID optionValue ) -> {%{getOptionExpr($ID.text, $optionValue.src)}})
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:70:19: ^( JIFFLE_OPTION ID optionValue )
            {
            match(input,JIFFLE_OPTION,FOLLOW_JIFFLE_OPTION_in_jiffleOption258); 

            match(input, Token.DOWN, null); 
            ID1=(CommonTree)match(input,ID,FOLLOW_ID_in_jiffleOption260); 
            pushFollow(FOLLOW_optionValue_in_jiffleOption262);
            optionValue2=optionValue();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 71:17: -> {%{getOptionExpr($ID.text, $optionValue.src)}}
            {
                retval.st = new StringTemplate(templateLib,getOptionExpr((ID1!=null?ID1.getText():null), (optionValue2!=null?optionValue2.src:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "jiffleOption"

    public static class optionValue_return extends TreeRuleReturnScope {
        public String src;
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "optionValue"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:75:1: optionValue returns [String src] : ( ID | literal | CONSTANT );
    public final RuntimeSourceGenerator.optionValue_return optionValue() throws RecognitionException {
        RuntimeSourceGenerator.optionValue_return retval = new RuntimeSourceGenerator.optionValue_return();
        retval.start = input.LT(1);

        CommonTree ID3=null;
        CommonTree CONSTANT5=null;
        RuntimeSourceGenerator.literal_return literal4 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:76:17: ( ID | literal | CONSTANT )
            int alt4=3;
            switch ( input.LA(1) ) {
            case ID:
                {
                alt4=1;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
                {
                alt4=2;
                }
                break;
            case CONSTANT:
                {
                alt4=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }

            switch (alt4) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:76:19: ID
                    {
                    ID3=(CommonTree)match(input,ID,FOLLOW_ID_in_optionValue329); 
                     retval.src = (ID3!=null?ID3.getText():null); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:77:19: literal
                    {
                    pushFollow(FOLLOW_literal_in_optionValue351);
                    literal4=literal();

                    state._fsp--;

                     retval.src = (literal4!=null?((CommonTree)literal4.start):null).getText(); 

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:78:19: CONSTANT
                    {
                    CONSTANT5=(CommonTree)match(input,CONSTANT,FOLLOW_CONSTANT_in_optionValue373); 
                     retval.src = getConstantString((CONSTANT5!=null?CONSTANT5.getText():null)); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionValue"

    public static class varDeclaration_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "varDeclaration"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:82:1: varDeclaration : ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE e= expression ) -> field(name=$VAR_IMAGE_SCOPE.texttype=%{\"double\"}mods=%{\"private\"}init=$e.st);
    public final RuntimeSourceGenerator.varDeclaration_return varDeclaration() throws RecognitionException {
        RuntimeSourceGenerator.varDeclaration_return retval = new RuntimeSourceGenerator.varDeclaration_return();
        retval.start = input.LT(1);

        CommonTree VAR_IMAGE_SCOPE6=null;
        RuntimeSourceGenerator.expression_return e = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:82:17: ( ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE e= expression ) -> field(name=$VAR_IMAGE_SCOPE.texttype=%{\"double\"}mods=%{\"private\"}init=$e.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:82:19: ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE e= expression )
            {
            match(input,IMAGE_SCOPE_VAR_DECL,FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration403); 

            match(input, Token.DOWN, null); 
            VAR_IMAGE_SCOPE6=(CommonTree)match(input,VAR_IMAGE_SCOPE,FOLLOW_VAR_IMAGE_SCOPE_in_varDeclaration405); 
            pushFollow(FOLLOW_expression_in_varDeclaration409);
            e=expression();

            state._fsp--;


            match(input, Token.UP, null); 

                                varScope.addSymbol((VAR_IMAGE_SCOPE6!=null?VAR_IMAGE_SCOPE6.getText():null), SymbolType.SCALAR, ScopeType.IMAGE);
                            


            // TEMPLATE REWRITE
            // 86:17: -> field(name=$VAR_IMAGE_SCOPE.texttype=%{\"double\"}mods=%{\"private\"}init=$e.st)
            {
                retval.st = templateLib.getInstanceOf("field",
              new STAttrMap().put("name", (VAR_IMAGE_SCOPE6!=null?VAR_IMAGE_SCOPE6.getText():null)).put("type", new StringTemplate(templateLib,"double")).put("mods", new StringTemplate(templateLib,"private")).put("init", (e!=null?e.st:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varDeclaration"

    public static class block_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "block"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:90:1: block : ^( BLOCK (s+= blockStatement )* ) -> block(stmts=$s);
    public final RuntimeSourceGenerator.block_return block() throws RecognitionException {
        RuntimeSourceGenerator.block_return retval = new RuntimeSourceGenerator.block_return();
        retval.start = input.LT(1);

        List list_s=null;
        RuleReturnScope s = null;

            varScope.addLevel("block");

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:97:17: ( ^( BLOCK (s+= blockStatement )* ) -> block(stmts=$s))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:97:19: ^( BLOCK (s+= blockStatement )* )
            {
            match(input,BLOCK,FOLLOW_BLOCK_in_block521); 

            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/RuntimeSourceGenerator.g:97:28: (s+= blockStatement )*
                loop5:
                do {
                    int alt5=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case BLOCK:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case CONSTANT:
                    case IMAGE_WRITE:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_PROVIDED:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case EQ:
                    case BREAKIF:
                    case WHILE:
                    case UNTIL:
                    case FOREACH:
                    case APPEND:
                    case TIMESEQ:
                    case DIVEQ:
                    case MODEQ:
                    case PLUSEQ:
                    case MINUSEQ:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                        {
                        alt5=1;
                        }
                        break;

                    }

                    switch (alt5) {
                	case 1 :
                	    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:97:28: s+= blockStatement
                	    {
                	    pushFollow(FOLLOW_blockStatement_in_block525);
                	    s=blockStatement();

                	    state._fsp--;

                	    if (list_s==null) list_s=new ArrayList();
                	    list_s.add(s.getTemplate());


                	    }
                	    break;

                	default :
                	    break loop5;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }


            // TEMPLATE REWRITE
            // 98:17: -> block(stmts=$s)
            {
                retval.st = templateLib.getInstanceOf("block",
              new STAttrMap().put("stmts", list_s));
            }


            }


                varScope.dropLevel();

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "block"

    public static class blockStatement_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "blockStatement"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:102:1: blockStatement : ( statement -> {$statement.st} | ^( BREAKIF expression ) -> breakif(cond=$expression.st));
    public final RuntimeSourceGenerator.blockStatement_return blockStatement() throws RecognitionException {
        RuntimeSourceGenerator.blockStatement_return retval = new RuntimeSourceGenerator.blockStatement_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.statement_return statement7 = null;

        RuntimeSourceGenerator.expression_return expression8 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:102:17: ( statement -> {$statement.st} | ^( BREAKIF expression ) -> breakif(cond=$expression.st))
            int alt6=2;
            switch ( input.LA(1) ) {
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case BLOCK:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case IMAGE_WRITE:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_PROVIDED:
            case VAR_LOOP:
            case VAR_LIST:
            case EQ:
            case WHILE:
            case UNTIL:
            case FOREACH:
            case APPEND:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
                {
                alt6=1;
                }
                break;
            case BREAKIF:
                {
                alt6=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:102:19: statement
                    {
                    pushFollow(FOLLOW_statement_in_blockStatement579);
                    statement7=statement();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 102:29: -> {$statement.st}
                    {
                        retval.st = (statement7!=null?statement7.st:null);
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:103:19: ^( BREAKIF expression )
                    {
                    match(input,BREAKIF,FOLLOW_BREAKIF_in_blockStatement604); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_blockStatement606);
                    expression8=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 103:41: -> breakif(cond=$expression.st)
                    {
                        retval.st = templateLib.getInstanceOf("breakif",
                      new STAttrMap().put("cond", (expression8!=null?expression8.st:null)));
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "blockStatement"

    public static class statement_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "statement"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:107:1: statement : ( simpleStatement -> delimstmt(stmt=$simpleStatement.st) | block -> {$block.st});
    public final RuntimeSourceGenerator.statement_return statement() throws RecognitionException {
        RuntimeSourceGenerator.statement_return retval = new RuntimeSourceGenerator.statement_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.simpleStatement_return simpleStatement9 = null;

        RuntimeSourceGenerator.block_return block10 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:107:17: ( simpleStatement -> delimstmt(stmt=$simpleStatement.st) | block -> {$block.st})
            int alt7=2;
            switch ( input.LA(1) ) {
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case IMAGE_WRITE:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_PROVIDED:
            case VAR_LOOP:
            case VAR_LIST:
            case EQ:
            case WHILE:
            case UNTIL:
            case FOREACH:
            case APPEND:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
                {
                alt7=1;
                }
                break;
            case BLOCK:
                {
                alt7=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:107:19: simpleStatement
                    {
                    pushFollow(FOLLOW_simpleStatement_in_statement648);
                    simpleStatement9=simpleStatement();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 107:35: -> delimstmt(stmt=$simpleStatement.st)
                    {
                        retval.st = templateLib.getInstanceOf("delimstmt",
                      new STAttrMap().put("stmt", (simpleStatement9!=null?simpleStatement9.st:null)));
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:108:19: block
                    {
                    pushFollow(FOLLOW_block_in_statement677);
                    block10=block();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 108:25: -> {$block.st}
                    {
                        retval.st = (block10!=null?block10.st:null);
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "statement"

    public static class simpleStatement_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "simpleStatement"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:112:1: simpleStatement : ( imageWrite -> {$imageWrite.st} | scalarAssignment -> {$scalarAssignment.st} | listAssignment -> {$listAssignment.st} | loop -> {$loop.st} | expression -> {$expression.st});
    public final RuntimeSourceGenerator.simpleStatement_return simpleStatement() throws RecognitionException {
        RuntimeSourceGenerator.simpleStatement_return retval = new RuntimeSourceGenerator.simpleStatement_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.imageWrite_return imageWrite11 = null;

        RuntimeSourceGenerator.scalarAssignment_return scalarAssignment12 = null;

        RuntimeSourceGenerator.listAssignment_return listAssignment13 = null;

        RuntimeSourceGenerator.loop_return loop14 = null;

        RuntimeSourceGenerator.expression_return expression15 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:112:17: ( imageWrite -> {$imageWrite.st} | scalarAssignment -> {$scalarAssignment.st} | listAssignment -> {$listAssignment.st} | loop -> {$loop.st} | expression -> {$expression.st})
            int alt8=5;
            switch ( input.LA(1) ) {
            case IMAGE_WRITE:
                {
                alt8=1;
                }
                break;
            case EQ:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case VAR_LIST:
                        {
                        alt8=3;
                        }
                        break;
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                        {
                        alt8=2;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 8, 6, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 8, 2, input);

                    throw nvae;
                }

                }
                break;
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
                {
                alt8=2;
                }
                break;
            case WHILE:
            case UNTIL:
            case FOREACH:
                {
                alt8=4;
                }
                break;
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_PROVIDED:
            case VAR_LOOP:
            case VAR_LIST:
            case APPEND:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
                {
                alt8=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:112:19: imageWrite
                    {
                    pushFollow(FOLLOW_imageWrite_in_simpleStatement707);
                    imageWrite11=imageWrite();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 112:30: -> {$imageWrite.st}
                    {
                        retval.st = (imageWrite11!=null?imageWrite11.st:null);
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:113:19: scalarAssignment
                    {
                    pushFollow(FOLLOW_scalarAssignment_in_simpleStatement731);
                    scalarAssignment12=scalarAssignment();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 113:36: -> {$scalarAssignment.st}
                    {
                        retval.st = (scalarAssignment12!=null?scalarAssignment12.st:null);
                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:114:19: listAssignment
                    {
                    pushFollow(FOLLOW_listAssignment_in_simpleStatement755);
                    listAssignment13=listAssignment();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 114:34: -> {$listAssignment.st}
                    {
                        retval.st = (listAssignment13!=null?listAssignment13.st:null);
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:115:19: loop
                    {
                    pushFollow(FOLLOW_loop_in_simpleStatement779);
                    loop14=loop();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 115:24: -> {$loop.st}
                    {
                        retval.st = (loop14!=null?loop14.st:null);
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:116:19: expression
                    {
                    pushFollow(FOLLOW_expression_in_simpleStatement803);
                    expression15=expression();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 116:30: -> {$expression.st}
                    {
                        retval.st = (expression15!=null?expression15.st:null);
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "simpleStatement"

    public static class imageWrite_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "imageWrite"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:120:1: imageWrite : ^( IMAGE_WRITE VAR_DEST expression ) -> setdestvalue(var=$VAR_DEST.textexpr=$expression.st);
    public final RuntimeSourceGenerator.imageWrite_return imageWrite() throws RecognitionException {
        RuntimeSourceGenerator.imageWrite_return retval = new RuntimeSourceGenerator.imageWrite_return();
        retval.start = input.LT(1);

        CommonTree VAR_DEST16=null;
        RuntimeSourceGenerator.expression_return expression17 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:120:17: ( ^( IMAGE_WRITE VAR_DEST expression ) -> setdestvalue(var=$VAR_DEST.textexpr=$expression.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:120:19: ^( IMAGE_WRITE VAR_DEST expression )
            {
            match(input,IMAGE_WRITE,FOLLOW_IMAGE_WRITE_in_imageWrite839); 

            match(input, Token.DOWN, null); 
            VAR_DEST16=(CommonTree)match(input,VAR_DEST,FOLLOW_VAR_DEST_in_imageWrite841); 
            pushFollow(FOLLOW_expression_in_imageWrite843);
            expression17=expression();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 121:17: -> setdestvalue(var=$VAR_DEST.textexpr=$expression.st)
            {
                retval.st = templateLib.getInstanceOf("setdestvalue",
              new STAttrMap().put("var", (VAR_DEST16!=null?VAR_DEST16.getText():null)).put("expr", (expression17!=null?expression17.st:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "imageWrite"

    public static class expressionList_return extends TreeRuleReturnScope {
        public List argTypes;
        public List templates;
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "expressionList"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:125:1: expressionList returns [List argTypes, List templates] : ^( EXPR_LIST ( expression )* ) ;
    public final RuntimeSourceGenerator.expressionList_return expressionList() throws RecognitionException {
        RuntimeSourceGenerator.expressionList_return retval = new RuntimeSourceGenerator.expressionList_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.expression_return expression18 = null;


         
            retval.argTypes = new ArrayList();
            retval.templates = new ArrayList();

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:130:17: ( ^( EXPR_LIST ( expression )* ) )
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:130:19: ^( EXPR_LIST ( expression )* )
            {
            match(input,EXPR_LIST,FOLLOW_EXPR_LIST_in_expressionList926); 

            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/RuntimeSourceGenerator.g:130:31: ( expression )*
                loop9:
                do {
                    int alt9=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case CONSTANT:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_PROVIDED:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case APPEND:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                        {
                        alt9=1;
                        }
                        break;

                    }

                    switch (alt9) {
                	case 1 :
                	    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:130:32: expression
                	    {
                	    pushFollow(FOLLOW_expression_in_expressionList929);
                	    expression18=expression();

                	    state._fsp--;

                	       
                	                            int ttype = (expression18!=null?((CommonTree)expression18.start):null).getType();
                	                            retval.argTypes.add(ttype == VAR_LIST || ttype == DECLARED_LIST ? "List" : "D");
                	                            retval.templates.add((expression18!=null?expression18.st:null));
                	                        

                	    }
                	    break;

                	default :
                	    break loop9;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expressionList"

    public static class scalarAssignment_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "scalarAssignment"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:139:1: scalarAssignment : ^(op= assignmentOp id= scalar expression ) -> binaryexpr(lhs=$id.stop=$op.strhs=$expression.st);
    public final RuntimeSourceGenerator.scalarAssignment_return scalarAssignment() throws RecognitionException {
        RuntimeSourceGenerator.scalarAssignment_return retval = new RuntimeSourceGenerator.scalarAssignment_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.assignmentOp_return op = null;

        RuntimeSourceGenerator.scalar_return id = null;

        RuntimeSourceGenerator.expression_return expression19 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:140:17: ( ^(op= assignmentOp id= scalar expression ) -> binaryexpr(lhs=$id.stop=$op.strhs=$expression.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:140:19: ^(op= assignmentOp id= scalar expression )
            {
            pushFollow(FOLLOW_assignmentOp_in_scalarAssignment1001);
            op=assignmentOp();

            state._fsp--;


            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_scalar_in_scalarAssignment1005);
            id=scalar();

            state._fsp--;

            pushFollow(FOLLOW_expression_in_scalarAssignment1007);
            expression19=expression();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 141:17: -> binaryexpr(lhs=$id.stop=$op.strhs=$expression.st)
            {
                retval.st = templateLib.getInstanceOf("binaryexpr",
              new STAttrMap().put("lhs", (id!=null?id.st:null)).put("op", (op!=null?op.st:null)).put("rhs", (expression19!=null?expression19.st:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "scalarAssignment"

    protected static class listAssignment_scope {
        boolean isNew;
    }
    protected Stack listAssignment_stack = new Stack();

    public static class listAssignment_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "listAssignment"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:145:1: listAssignment : ^( EQ VAR_LIST e= expression ) -> listassign(isnew=$listAssignment::isNewvar=$VAR_LIST.textexpr=$expression.st);
    public final RuntimeSourceGenerator.listAssignment_return listAssignment() throws RecognitionException {
        listAssignment_stack.push(new listAssignment_scope());
        RuntimeSourceGenerator.listAssignment_return retval = new RuntimeSourceGenerator.listAssignment_return();
        retval.start = input.LT(1);

        CommonTree VAR_LIST20=null;
        RuntimeSourceGenerator.expression_return e = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:147:17: ( ^( EQ VAR_LIST e= expression ) -> listassign(isnew=$listAssignment::isNewvar=$VAR_LIST.textexpr=$expression.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:147:19: ^( EQ VAR_LIST e= expression )
            {
            match(input,EQ,FOLLOW_EQ_in_listAssignment1090); 

            match(input, Token.DOWN, null); 
            VAR_LIST20=(CommonTree)match(input,VAR_LIST,FOLLOW_VAR_LIST_in_listAssignment1092); 
            pushFollow(FOLLOW_expression_in_listAssignment1096);
            e=expression();

            state._fsp--;


            match(input, Token.UP, null); 
             
                                ((listAssignment_scope)listAssignment_stack.peek()).isNew = !varScope.isDefined((VAR_LIST20!=null?VAR_LIST20.getText():null), SymbolType.LIST); 
                                if (((listAssignment_scope)listAssignment_stack.peek()).isNew) {
                                    addImport("java.util.List", "java.util.ArrayList"); 
                                    varScope.addSymbol((VAR_LIST20!=null?VAR_LIST20.getText():null), SymbolType.LIST, ScopeType.PIXEL);
                                }
                            


            // TEMPLATE REWRITE
            // 156:17: -> listassign(isnew=$listAssignment::isNewvar=$VAR_LIST.textexpr=$expression.st)
            {
                retval.st = templateLib.getInstanceOf("listassign",
              new STAttrMap().put("isnew", ((listAssignment_scope)listAssignment_stack.peek()).isNew).put("var", (VAR_LIST20!=null?VAR_LIST20.getText():null)).put("expr", (e!=null?e.st:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            listAssignment_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "listAssignment"

    public static class scalar_return extends TreeRuleReturnScope {
        public boolean newVar;
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "scalar"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:161:1: scalar returns [boolean newVar] : ( VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE );
    public final RuntimeSourceGenerator.scalar_return scalar() throws RecognitionException {
        RuntimeSourceGenerator.scalar_return retval = new RuntimeSourceGenerator.scalar_return();
        retval.start = input.LT(1);

        CommonTree VAR_PIXEL_SCOPE21=null;

         
            retval.newVar = false;

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:173:17: ( VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE )
            int alt10=2;
            switch ( input.LA(1) ) {
            case VAR_IMAGE_SCOPE:
                {
                alt10=1;
                }
                break;
            case VAR_PIXEL_SCOPE:
                {
                alt10=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }

            switch (alt10) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:173:19: VAR_IMAGE_SCOPE
                    {
                    match(input,VAR_IMAGE_SCOPE,FOLLOW_VAR_IMAGE_SCOPE_in_scalar1208); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:174:19: VAR_PIXEL_SCOPE
                    {
                    VAR_PIXEL_SCOPE21=(CommonTree)match(input,VAR_PIXEL_SCOPE,FOLLOW_VAR_PIXEL_SCOPE_in_scalar1229); 
                     
                                        if (!varScope.isDefined((VAR_PIXEL_SCOPE21!=null?VAR_PIXEL_SCOPE21.getText():null))) {
                                            varScope.addSymbol((VAR_PIXEL_SCOPE21!=null?VAR_PIXEL_SCOPE21.getText():null), SymbolType.SCALAR, ScopeType.PIXEL);
                                            retval.newVar = true;
                                        }
                                    

                    }
                    break;

            }
             
                String varName = ((CommonTree)retval.start).getText();
                if (retval.newVar) {
                    retval.st = new StringTemplate(templateLib,"double " + varName);
                } else {
                    retval.st = new StringTemplate(templateLib,varName);
                }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "scalar"

    public static class loop_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "loop"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:184:1: loop : ( conditionalLoop -> {$conditionalLoop.st} | foreachLoop -> {$foreachLoop.st});
    public final RuntimeSourceGenerator.loop_return loop() throws RecognitionException {
        RuntimeSourceGenerator.loop_return retval = new RuntimeSourceGenerator.loop_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.conditionalLoop_return conditionalLoop22 = null;

        RuntimeSourceGenerator.foreachLoop_return foreachLoop23 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:184:17: ( conditionalLoop -> {$conditionalLoop.st} | foreachLoop -> {$foreachLoop.st})
            int alt11=2;
            switch ( input.LA(1) ) {
            case WHILE:
            case UNTIL:
                {
                alt11=1;
                }
                break;
            case FOREACH:
                {
                alt11=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;
            }

            switch (alt11) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:184:19: conditionalLoop
                    {
                    pushFollow(FOLLOW_conditionalLoop_in_loop1285);
                    conditionalLoop22=conditionalLoop();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 184:35: -> {$conditionalLoop.st}
                    {
                        retval.st = (conditionalLoop22!=null?conditionalLoop22.st:null);
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:185:19: foreachLoop
                    {
                    pushFollow(FOLLOW_foreachLoop_in_loop1309);
                    foreachLoop23=foreachLoop();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 185:31: -> {$foreachLoop.st}
                    {
                        retval.st = (foreachLoop23!=null?foreachLoop23.st:null);
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loop"

    public static class conditionalLoop_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "conditionalLoop"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:189:1: conditionalLoop : ( ^( WHILE e= expression s= statement ) -> while(cond=$e.ststmt=$s.st) | ^( UNTIL e= expression s= statement ) -> until(cond=$e.ststmt=$s.st));
    public final RuntimeSourceGenerator.conditionalLoop_return conditionalLoop() throws RecognitionException {
        RuntimeSourceGenerator.conditionalLoop_return retval = new RuntimeSourceGenerator.conditionalLoop_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.expression_return e = null;

        RuntimeSourceGenerator.statement_return s = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:190:17: ( ^( WHILE e= expression s= statement ) -> while(cond=$e.ststmt=$s.st) | ^( UNTIL e= expression s= statement ) -> until(cond=$e.ststmt=$s.st))
            int alt12=2;
            switch ( input.LA(1) ) {
            case WHILE:
                {
                alt12=1;
                }
                break;
            case UNTIL:
                {
                alt12=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:190:19: ^( WHILE e= expression s= statement )
                    {
                    match(input,WHILE,FOLLOW_WHILE_in_conditionalLoop1356); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_conditionalLoop1360);
                    e=expression();

                    state._fsp--;

                    pushFollow(FOLLOW_statement_in_conditionalLoop1364);
                    s=statement();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 190:53: -> while(cond=$e.ststmt=$s.st)
                    {
                        retval.st = templateLib.getInstanceOf("while",
                      new STAttrMap().put("cond", (e!=null?e.st:null)).put("stmt", (s!=null?s.st:null)));
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:191:19: ^( UNTIL e= expression s= statement )
                    {
                    match(input,UNTIL,FOLLOW_UNTIL_in_conditionalLoop1400); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_conditionalLoop1404);
                    e=expression();

                    state._fsp--;

                    pushFollow(FOLLOW_statement_in_conditionalLoop1408);
                    s=statement();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 191:53: -> until(cond=$e.ststmt=$s.st)
                    {
                        retval.st = templateLib.getInstanceOf("until",
                      new STAttrMap().put("cond", (e!=null?e.st:null)).put("stmt", (s!=null?s.st:null)));
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "conditionalLoop"

    public static class foreachLoop_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "foreachLoop"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:194:1: foreachLoop : ( ^( FOREACH ID ^( DECLARED_LIST e= expressionList ) s= statement ) -> foreachlist(n=++varIndexvar=$ID.textlist=$e.templatesstmt=$s.st) | ^( FOREACH ID VAR_LIST s= statement ) -> foreachlistvar(n=++varIndexvar=$ID.textlistvar=%{$VAR_LIST.text}stmt=$s.st) | ^( FOREACH ID ^( SEQUENCE lo= expression hi= expression ) s= statement ) -> foreachseq(n=++varIndexvar=$ID.textlo=$lo.sthi=$hi.ststmt=$s.st));
    public final RuntimeSourceGenerator.foreachLoop_return foreachLoop() throws RecognitionException {
        RuntimeSourceGenerator.foreachLoop_return retval = new RuntimeSourceGenerator.foreachLoop_return();
        retval.start = input.LT(1);

        CommonTree ID24=null;
        CommonTree ID25=null;
        CommonTree VAR_LIST26=null;
        CommonTree ID27=null;
        RuntimeSourceGenerator.expressionList_return e = null;

        RuntimeSourceGenerator.statement_return s = null;

        RuntimeSourceGenerator.expression_return lo = null;

        RuntimeSourceGenerator.expression_return hi = null;



            varScope.addLevel("foreach");

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:201:17: ( ^( FOREACH ID ^( DECLARED_LIST e= expressionList ) s= statement ) -> foreachlist(n=++varIndexvar=$ID.textlist=$e.templatesstmt=$s.st) | ^( FOREACH ID VAR_LIST s= statement ) -> foreachlistvar(n=++varIndexvar=$ID.textlistvar=%{$VAR_LIST.text}stmt=$s.st) | ^( FOREACH ID ^( SEQUENCE lo= expression hi= expression ) s= statement ) -> foreachseq(n=++varIndexvar=$ID.textlo=$lo.sthi=$hi.ststmt=$s.st))
            int alt13=3;
            switch ( input.LA(1) ) {
            case FOREACH:
                {
                switch ( input.LA(2) ) {
                case DOWN:
                    {
                    switch ( input.LA(3) ) {
                    case ID:
                        {
                        switch ( input.LA(4) ) {
                        case DECLARED_LIST:
                            {
                            alt13=1;
                            }
                            break;
                        case VAR_LIST:
                            {
                            alt13=2;
                            }
                            break;
                        case SEQUENCE:
                            {
                            alt13=3;
                            }
                            break;
                        default:
                            NoViableAltException nvae =
                                new NoViableAltException("", 13, 3, input);

                            throw nvae;
                        }

                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 13, 2, input);

                        throw nvae;
                    }

                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 13, 1, input);

                    throw nvae;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:201:19: ^( FOREACH ID ^( DECLARED_LIST e= expressionList ) s= statement )
                    {
                    match(input,FOREACH,FOLLOW_FOREACH_in_foreachLoop1475); 

                    match(input, Token.DOWN, null); 
                    ID24=(CommonTree)match(input,ID,FOLLOW_ID_in_foreachLoop1477); 
                    varScope.addSymbol((ID24!=null?ID24.getText():null), SymbolType.LOOP_VAR, ScopeType.PIXEL);
                    match(input,DECLARED_LIST,FOLLOW_DECLARED_LIST_in_foreachLoop1523); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expressionList_in_foreachLoop1527);
                    e=expressionList();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    pushFollow(FOLLOW_statement_in_foreachLoop1532);
                    s=statement();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 205:17: -> foreachlist(n=++varIndexvar=$ID.textlist=$e.templatesstmt=$s.st)
                    {
                        retval.st = templateLib.getInstanceOf("foreachlist",
                      new STAttrMap().put("n", ++varIndex).put("var", (ID24!=null?ID24.getText():null)).put("list", (e!=null?e.templates:null)).put("stmt", (s!=null?s.st:null)));
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:207:19: ^( FOREACH ID VAR_LIST s= statement )
                    {
                    match(input,FOREACH,FOLLOW_FOREACH_in_foreachLoop1596); 

                    match(input, Token.DOWN, null); 
                    ID25=(CommonTree)match(input,ID,FOLLOW_ID_in_foreachLoop1598); 
                    varScope.addSymbol((ID25!=null?ID25.getText():null), SymbolType.LOOP_VAR, ScopeType.PIXEL);
                    VAR_LIST26=(CommonTree)match(input,VAR_LIST,FOLLOW_VAR_LIST_in_foreachLoop1643); 
                    pushFollow(FOLLOW_statement_in_foreachLoop1647);
                    s=statement();

                    state._fsp--;


                    match(input, Token.UP, null); 
                     addImport("java.util.Iterator"); 


                    // TEMPLATE REWRITE
                    // 212:17: -> foreachlistvar(n=++varIndexvar=$ID.textlistvar=%{$VAR_LIST.text}stmt=$s.st)
                    {
                        retval.st = templateLib.getInstanceOf("foreachlistvar",
                      new STAttrMap().put("n", ++varIndex).put("var", (ID25!=null?ID25.getText():null)).put("listvar", new StringTemplate(templateLib,(VAR_LIST26!=null?VAR_LIST26.getText():null))).put("stmt", (s!=null?s.st:null)));
                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:214:19: ^( FOREACH ID ^( SEQUENCE lo= expression hi= expression ) s= statement )
                    {
                    match(input,FOREACH,FOLLOW_FOREACH_in_foreachLoop1745); 

                    match(input, Token.DOWN, null); 
                    ID27=(CommonTree)match(input,ID,FOLLOW_ID_in_foreachLoop1747); 
                    varScope.addSymbol((ID27!=null?ID27.getText():null), SymbolType.LOOP_VAR, ScopeType.PIXEL);
                    match(input,SEQUENCE,FOLLOW_SEQUENCE_in_foreachLoop1793); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_foreachLoop1797);
                    lo=expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_foreachLoop1801);
                    hi=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 
                    pushFollow(FOLLOW_statement_in_foreachLoop1806);
                    s=statement();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 218:17: -> foreachseq(n=++varIndexvar=$ID.textlo=$lo.sthi=$hi.ststmt=$s.st)
                    {
                        retval.st = templateLib.getInstanceOf("foreachseq",
                      new STAttrMap().put("n", ++varIndex).put("var", (ID27!=null?ID27.getText():null)).put("lo", (lo!=null?lo.st:null)).put("hi", (hi!=null?hi.st:null)).put("stmt", (s!=null?s.st:null)));
                    }


                    }
                    break;

            }

                varScope.dropLevel();

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "foreachLoop"

    public static class expression_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "expression"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:222:1: expression : ( ^( FUNC_CALL ID el= expressionList ) -> call(name=getRuntimeExpr($ID.text, $el.argTypes)args=$el.templates) | ^( IF_CALL el= expressionList ) -> ifcall(args=$el.templates) | imagePos -> {$imagePos.st} | binaryExpression -> {$binaryExpression.st} | ^( PREFIX NOT e= expression ) -> call(name=getRuntimeExpr(\"NOT\", \"D\")args=$e.st) | ^( PREFIX prefixOp e= expression ) -> preop(op=$prefixOp.stexpr=$e.st) | ^( POSTFIX postfixOp e= expression ) -> postop(op=$postfixOp.stexpr=$e.st) | ^( PAR e= expression ) -> par(expr=$e.st) | listOperation -> {$listOperation.st} | listLiteral -> {$listLiteral.st} | var -> {$var.st} | VAR_SOURCE -> getsourcevalue(var=$VAR_SOURCE.text) | CONSTANT -> {%{getConstantString($CONSTANT.text)}} | literal -> {$literal.st});
    public final RuntimeSourceGenerator.expression_return expression() throws RecognitionException {
        RuntimeSourceGenerator.expression_return retval = new RuntimeSourceGenerator.expression_return();
        retval.start = input.LT(1);

        CommonTree ID28=null;
        CommonTree VAR_SOURCE36=null;
        CommonTree CONSTANT37=null;
        RuntimeSourceGenerator.expressionList_return el = null;

        RuntimeSourceGenerator.expression_return e = null;

        RuntimeSourceGenerator.imagePos_return imagePos29 = null;

        RuntimeSourceGenerator.binaryExpression_return binaryExpression30 = null;

        RuntimeSourceGenerator.prefixOp_return prefixOp31 = null;

        RuntimeSourceGenerator.postfixOp_return postfixOp32 = null;

        RuntimeSourceGenerator.listOperation_return listOperation33 = null;

        RuntimeSourceGenerator.listLiteral_return listLiteral34 = null;

        RuntimeSourceGenerator.var_return var35 = null;

        RuntimeSourceGenerator.literal_return literal38 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:222:17: ( ^( FUNC_CALL ID el= expressionList ) -> call(name=getRuntimeExpr($ID.text, $el.argTypes)args=$el.templates) | ^( IF_CALL el= expressionList ) -> ifcall(args=$el.templates) | imagePos -> {$imagePos.st} | binaryExpression -> {$binaryExpression.st} | ^( PREFIX NOT e= expression ) -> call(name=getRuntimeExpr(\"NOT\", \"D\")args=$e.st) | ^( PREFIX prefixOp e= expression ) -> preop(op=$prefixOp.stexpr=$e.st) | ^( POSTFIX postfixOp e= expression ) -> postop(op=$postfixOp.stexpr=$e.st) | ^( PAR e= expression ) -> par(expr=$e.st) | listOperation -> {$listOperation.st} | listLiteral -> {$listLiteral.st} | var -> {$var.st} | VAR_SOURCE -> getsourcevalue(var=$VAR_SOURCE.text) | CONSTANT -> {%{getConstantString($CONSTANT.text)}} | literal -> {$literal.st})
            int alt14=14;
            alt14 = dfa14.predict(input);
            switch (alt14) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:222:19: ^( FUNC_CALL ID el= expressionList )
                    {
                    match(input,FUNC_CALL,FOLLOW_FUNC_CALL_in_expression1885); 

                    match(input, Token.DOWN, null); 
                    ID28=(CommonTree)match(input,ID,FOLLOW_ID_in_expression1887); 
                    pushFollow(FOLLOW_expressionList_in_expression1891);
                    el=expressionList();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 223:17: -> call(name=getRuntimeExpr($ID.text, $el.argTypes)args=$el.templates)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", getRuntimeExpr((ID28!=null?ID28.getText():null), (el!=null?el.argTypes:null))).put("args", (el!=null?el.templates:null)));
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:225:19: ^( IF_CALL el= expressionList )
                    {
                    match(input,IF_CALL,FOLLOW_IF_CALL_in_expression1945); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expressionList_in_expression1949);
                    el=expressionList();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 225:48: -> ifcall(args=$el.templates)
                    {
                        retval.st = templateLib.getInstanceOf("ifcall",
                      new STAttrMap().put("args", (el!=null?el.templates:null)));
                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:227:19: imagePos
                    {
                    pushFollow(FOLLOW_imagePos_in_expression1980);
                    imagePos29=imagePos();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 227:28: -> {$imagePos.st}
                    {
                        retval.st = (imagePos29!=null?imagePos29.st:null);
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:229:19: binaryExpression
                    {
                    pushFollow(FOLLOW_binaryExpression_in_expression2005);
                    binaryExpression30=binaryExpression();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 229:36: -> {$binaryExpression.st}
                    {
                        retval.st = (binaryExpression30!=null?binaryExpression30.st:null);
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:231:19: ^( PREFIX NOT e= expression )
                    {
                    match(input,PREFIX,FOLLOW_PREFIX_in_expression2031); 

                    match(input, Token.DOWN, null); 
                    match(input,NOT,FOLLOW_NOT_in_expression2033); 
                    pushFollow(FOLLOW_expression_in_expression2037);
                    e=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 232:17: -> call(name=getRuntimeExpr(\"NOT\", \"D\")args=$e.st)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", getRuntimeExpr("NOT", "D")).put("args", (e!=null?e.st:null)));
                    }


                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:234:19: ^( PREFIX prefixOp e= expression )
                    {
                    match(input,PREFIX,FOLLOW_PREFIX_in_expression2091); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_prefixOp_in_expression2093);
                    prefixOp31=prefixOp();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression2097);
                    e=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 234:51: -> preop(op=$prefixOp.stexpr=$e.st)
                    {
                        retval.st = templateLib.getInstanceOf("preop",
                      new STAttrMap().put("op", (prefixOp31!=null?prefixOp31.st:null)).put("expr", (e!=null?e.st:null)));
                    }


                    }
                    break;
                case 7 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:236:19: ^( POSTFIX postfixOp e= expression )
                    {
                    match(input,POSTFIX,FOLLOW_POSTFIX_in_expression2134); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_postfixOp_in_expression2136);
                    postfixOp32=postfixOp();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_expression2140);
                    e=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 236:53: -> postop(op=$postfixOp.stexpr=$e.st)
                    {
                        retval.st = templateLib.getInstanceOf("postop",
                      new STAttrMap().put("op", (postfixOp32!=null?postfixOp32.st:null)).put("expr", (e!=null?e.st:null)));
                    }


                    }
                    break;
                case 8 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:238:19: ^( PAR e= expression )
                    {
                    match(input,PAR,FOLLOW_PAR_in_expression2177); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_expression2181);
                    e=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 238:39: -> par(expr=$e.st)
                    {
                        retval.st = templateLib.getInstanceOf("par",
                      new STAttrMap().put("expr", (e!=null?e.st:null)));
                    }


                    }
                    break;
                case 9 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:240:19: listOperation
                    {
                    pushFollow(FOLLOW_listOperation_in_expression2212);
                    listOperation33=listOperation();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 240:33: -> {$listOperation.st}
                    {
                        retval.st = (listOperation33!=null?listOperation33.st:null);
                    }


                    }
                    break;
                case 10 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:242:19: listLiteral
                    {
                    pushFollow(FOLLOW_listLiteral_in_expression2237);
                    listLiteral34=listLiteral();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 242:31: -> {$listLiteral.st}
                    {
                        retval.st = (listLiteral34!=null?listLiteral34.st:null);
                    }


                    }
                    break;
                case 11 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:244:19: var
                    {
                    pushFollow(FOLLOW_var_in_expression2262);
                    var35=var();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 244:23: -> {$var.st}
                    {
                        retval.st = (var35!=null?var35.st:null);
                    }


                    }
                    break;
                case 12 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:246:19: VAR_SOURCE
                    {
                    VAR_SOURCE36=(CommonTree)match(input,VAR_SOURCE,FOLLOW_VAR_SOURCE_in_expression2287); 


                    // TEMPLATE REWRITE
                    // 246:30: -> getsourcevalue(var=$VAR_SOURCE.text)
                    {
                        retval.st = templateLib.getInstanceOf("getsourcevalue",
                      new STAttrMap().put("var", (VAR_SOURCE36!=null?VAR_SOURCE36.getText():null)));
                    }


                    }
                    break;
                case 13 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:248:19: CONSTANT
                    {
                    CONSTANT37=(CommonTree)match(input,CONSTANT,FOLLOW_CONSTANT_in_expression2317); 


                    // TEMPLATE REWRITE
                    // 248:28: -> {%{getConstantString($CONSTANT.text)}}
                    {
                        retval.st = new StringTemplate(templateLib,getConstantString((CONSTANT37!=null?CONSTANT37.getText():null)));
                    }


                    }
                    break;
                case 14 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:250:19: literal
                    {
                    pushFollow(FOLLOW_literal_in_expression2342);
                    literal38=literal();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 250:27: -> {$literal.st}
                    {
                        retval.st = (literal38!=null?literal38.st:null);
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expression"

    public static class listOperation_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "listOperation"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:254:1: listOperation : ^( APPEND VAR_LIST expression ) -> listappend(var=$VAR_LIST.textexpr=$expression.st);
    public final RuntimeSourceGenerator.listOperation_return listOperation() throws RecognitionException {
        RuntimeSourceGenerator.listOperation_return retval = new RuntimeSourceGenerator.listOperation_return();
        retval.start = input.LT(1);

        CommonTree VAR_LIST39=null;
        RuntimeSourceGenerator.expression_return expression40 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:254:17: ( ^( APPEND VAR_LIST expression ) -> listappend(var=$VAR_LIST.textexpr=$expression.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:254:19: ^( APPEND VAR_LIST expression )
            {
            match(input,APPEND,FOLLOW_APPEND_in_listOperation2375); 

            match(input, Token.DOWN, null); 
            VAR_LIST39=(CommonTree)match(input,VAR_LIST,FOLLOW_VAR_LIST_in_listOperation2377); 
            pushFollow(FOLLOW_expression_in_listOperation2379);
            expression40=expression();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 255:17: -> listappend(var=$VAR_LIST.textexpr=$expression.st)
            {
                retval.st = templateLib.getInstanceOf("listappend",
              new STAttrMap().put("var", (VAR_LIST39!=null?VAR_LIST39.getText():null)).put("expr", (expression40!=null?expression40.st:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listOperation"

    public static class listLiteral_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "listLiteral"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:259:1: listLiteral : ^( DECLARED_LIST e= expressionList ) -> listliteral(empty=$e.templates.isEmpty()exprs=$e.templates);
    public final RuntimeSourceGenerator.listLiteral_return listLiteral() throws RecognitionException {
        RuntimeSourceGenerator.listLiteral_return retval = new RuntimeSourceGenerator.listLiteral_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.expressionList_return e = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:259:17: ( ^( DECLARED_LIST e= expressionList ) -> listliteral(empty=$e.templates.isEmpty()exprs=$e.templates))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:259:19: ^( DECLARED_LIST e= expressionList )
            {
            match(input,DECLARED_LIST,FOLLOW_DECLARED_LIST_in_listLiteral2442); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expressionList_in_listLiteral2446);
            e=expressionList();

            state._fsp--;


            match(input, Token.UP, null); 
             addImport("java.util.Arrays", "java.util.ArrayList"); 


            // TEMPLATE REWRITE
            // 261:17: -> listliteral(empty=$e.templates.isEmpty()exprs=$e.templates)
            {
                retval.st = templateLib.getInstanceOf("listliteral",
              new STAttrMap().put("empty", (e!=null?e.templates:null).isEmpty()).put("exprs", (e!=null?e.templates:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listLiteral"

    public static class var_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "var"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:265:1: var : ( VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE | VAR_PROVIDED | VAR_LOOP | VAR_LIST );
    public final RuntimeSourceGenerator.var_return var() throws RecognitionException {
        RuntimeSourceGenerator.var_return retval = new RuntimeSourceGenerator.var_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:267:17: ( VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE | VAR_PROVIDED | VAR_LOOP | VAR_LIST )
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:
            {
            if ( (input.LA(1)>=VAR_IMAGE_SCOPE && input.LA(1)<=VAR_LIST) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

             retval.st = ((CommonTree)retval.start).getType() == VAR_LIST ? new StringTemplate(templateLib,"(List)" + ((CommonTree)retval.start).getText()) : new StringTemplate(templateLib,((CommonTree)retval.start).getText()); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "var"

    public static class binaryExpression_return extends TreeRuleReturnScope {
        public String src;
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "binaryExpression"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:275:1: binaryExpression returns [String src] : ( ^( POW x= expression y= expression ) -> pow(x=x.sty=y.st) | ^( OR e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( XOR e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( AND e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( LOGICALEQ e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( NE e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( GT e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( GE e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( LT e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( LE e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( arithmeticOp x= expression y= expression ) -> binaryexpr(lhs=x.stop=$arithmeticOp.strhs=y.st));
    public final RuntimeSourceGenerator.binaryExpression_return binaryExpression() throws RecognitionException {
        RuntimeSourceGenerator.binaryExpression_return retval = new RuntimeSourceGenerator.binaryExpression_return();
        retval.start = input.LT(1);

        List list_e=null;
        RuntimeSourceGenerator.expression_return x = null;

        RuntimeSourceGenerator.expression_return y = null;

        RuntimeSourceGenerator.arithmeticOp_return arithmeticOp41 = null;

        RuleReturnScope e = null;
        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:276:17: ( ^( POW x= expression y= expression ) -> pow(x=x.sty=y.st) | ^( OR e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( XOR e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( AND e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( LOGICALEQ e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( NE e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( GT e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( GE e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( LT e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( LE e+= expression e+= expression ) -> call(name=$srcargs=$e) | ^( arithmeticOp x= expression y= expression ) -> binaryexpr(lhs=x.stop=$arithmeticOp.strhs=y.st))
            int alt15=11;
            switch ( input.LA(1) ) {
            case POW:
                {
                alt15=1;
                }
                break;
            case OR:
                {
                alt15=2;
                }
                break;
            case XOR:
                {
                alt15=3;
                }
                break;
            case AND:
                {
                alt15=4;
                }
                break;
            case LOGICALEQ:
                {
                alt15=5;
                }
                break;
            case NE:
                {
                alt15=6;
                }
                break;
            case GT:
                {
                alt15=7;
                }
                break;
            case GE:
                {
                alt15=8;
                }
                break;
            case LT:
                {
                alt15=9;
                }
                break;
            case LE:
                {
                alt15=10;
                }
                break;
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
                {
                alt15=11;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 15, 0, input);

                throw nvae;
            }

            switch (alt15) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:276:19: ^( POW x= expression y= expression )
                    {
                    match(input,POW,FOLLOW_POW_in_binaryExpression2670); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression2674);
                    x=expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_binaryExpression2678);
                    y=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 276:52: -> pow(x=x.sty=y.st)
                    {
                        retval.st = templateLib.getInstanceOf("pow",
                      new STAttrMap().put("x", x.st).put("y", y.st));
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:278:19: ^( OR e+= expression e+= expression )
                    {
                    match(input,OR,FOLLOW_OR_in_binaryExpression2715); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression2719);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression2723);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("OR", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 279:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:281:19: ^( XOR e+= expression e+= expression )
                    {
                    match(input,XOR,FOLLOW_XOR_in_binaryExpression2779); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression2783);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression2787);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("XOR", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 282:61: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:284:19: ^( AND e+= expression e+= expression )
                    {
                    match(input,AND,FOLLOW_AND_in_binaryExpression2843); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression2847);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression2851);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("AND", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 285:61: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:287:19: ^( LOGICALEQ e+= expression e+= expression )
                    {
                    match(input,LOGICALEQ,FOLLOW_LOGICALEQ_in_binaryExpression2907); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression2911);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression2915);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("EQ", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 288:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:290:19: ^( NE e+= expression e+= expression )
                    {
                    match(input,NE,FOLLOW_NE_in_binaryExpression2971); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression2975);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression2979);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("NE", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 291:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 7 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:293:19: ^( GT e+= expression e+= expression )
                    {
                    match(input,GT,FOLLOW_GT_in_binaryExpression3035); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression3039);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression3043);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("GT", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 294:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 8 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:296:19: ^( GE e+= expression e+= expression )
                    {
                    match(input,GE,FOLLOW_GE_in_binaryExpression3099); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression3103);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression3107);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("GE", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 297:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 9 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:299:19: ^( LT e+= expression e+= expression )
                    {
                    match(input,LT,FOLLOW_LT_in_binaryExpression3163); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression3167);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression3171);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("LT", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 300:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 10 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:302:19: ^( LE e+= expression e+= expression )
                    {
                    match(input,LE,FOLLOW_LE_in_binaryExpression3227); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression3231);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());

                    pushFollow(FOLLOW_expression_in_binaryExpression3235);
                    e=expression();

                    state._fsp--;

                    if (list_e==null) list_e=new ArrayList();
                    list_e.add(e.getTemplate());


                    match(input, Token.UP, null); 
                     retval.src = getRuntimeExpr("LE", "D", "D"); 


                    // TEMPLATE REWRITE
                    // 303:60: -> call(name=$srcargs=$e)
                    {
                        retval.st = templateLib.getInstanceOf("call",
                      new STAttrMap().put("name", retval.src).put("args", list_e));
                    }


                    }
                    break;
                case 11 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:305:19: ^( arithmeticOp x= expression y= expression )
                    {
                    pushFollow(FOLLOW_arithmeticOp_in_binaryExpression3291);
                    arithmeticOp41=arithmeticOp();

                    state._fsp--;


                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_binaryExpression3295);
                    x=expression();

                    state._fsp--;

                    pushFollow(FOLLOW_expression_in_binaryExpression3299);
                    y=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 306:17: -> binaryexpr(lhs=x.stop=$arithmeticOp.strhs=y.st)
                    {
                        retval.st = templateLib.getInstanceOf("binaryexpr",
                      new STAttrMap().put("lhs", x.st).put("op", (arithmeticOp41!=null?arithmeticOp41.st:null)).put("rhs", y.st));
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "binaryExpression"

    public static class assignmentOp_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "assignmentOp"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:310:1: assignmentOp : ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ );
    public final RuntimeSourceGenerator.assignmentOp_return assignmentOp() throws RecognitionException {
        RuntimeSourceGenerator.assignmentOp_return retval = new RuntimeSourceGenerator.assignmentOp_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:312:17: ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ )
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:
            {
            if ( input.LA(1)==EQ||(input.LA(1)>=TIMESEQ && input.LA(1)<=MINUSEQ) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

             retval.st = new StringTemplate(templateLib,((CommonTree)retval.start).getText()); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentOp"

    public static class arithmeticOp_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "arithmeticOp"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:321:1: arithmeticOp : ( TIMES | DIV | MOD | PLUS | MINUS );
    public final RuntimeSourceGenerator.arithmeticOp_return arithmeticOp() throws RecognitionException {
        RuntimeSourceGenerator.arithmeticOp_return retval = new RuntimeSourceGenerator.arithmeticOp_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:323:17: ( TIMES | DIV | MOD | PLUS | MINUS )
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:
            {
            if ( (input.LA(1)>=PLUS && input.LA(1)<=MOD) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

             retval.st = new StringTemplate(templateLib,((CommonTree)retval.start).getText()); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "arithmeticOp"

    public static class literal_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "literal"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:331:1: literal : ( INT_LITERAL -> {%{$INT_LITERAL.text + \".0\"}} | FLOAT_LITERAL -> {%{$FLOAT_LITERAL.text}});
    public final RuntimeSourceGenerator.literal_return literal() throws RecognitionException {
        RuntimeSourceGenerator.literal_return retval = new RuntimeSourceGenerator.literal_return();
        retval.start = input.LT(1);

        CommonTree INT_LITERAL42=null;
        CommonTree FLOAT_LITERAL43=null;

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:331:17: ( INT_LITERAL -> {%{$INT_LITERAL.text + \".0\"}} | FLOAT_LITERAL -> {%{$FLOAT_LITERAL.text}})
            int alt16=2;
            switch ( input.LA(1) ) {
            case INT_LITERAL:
                {
                alt16=1;
                }
                break;
            case FLOAT_LITERAL:
                {
                alt16=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;
            }

            switch (alt16) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:331:19: INT_LITERAL
                    {
                    INT_LITERAL42=(CommonTree)match(input,INT_LITERAL,FOLLOW_INT_LITERAL_in_literal3644); 


                    // TEMPLATE REWRITE
                    // 331:31: -> {%{$INT_LITERAL.text + \".0\"}}
                    {
                        retval.st = new StringTemplate(templateLib,(INT_LITERAL42!=null?INT_LITERAL42.getText():null) + ".0");
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:332:19: FLOAT_LITERAL
                    {
                    FLOAT_LITERAL43=(CommonTree)match(input,FLOAT_LITERAL,FOLLOW_FLOAT_LITERAL_in_literal3668); 


                    // TEMPLATE REWRITE
                    // 332:33: -> {%{$FLOAT_LITERAL.text}}
                    {
                        retval.st = new StringTemplate(templateLib,(FLOAT_LITERAL43!=null?FLOAT_LITERAL43.getText():null));
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "literal"

    public static class imagePos_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "imagePos"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:1: imagePos : ^( IMAGE_POS VAR_SOURCE (b= bandSpecifier )? (p= pixelSpecifier )? ) -> getsourcevalue(var=$VAR_SOURCE.textpixel=$p.stband=$b.st);
    public final RuntimeSourceGenerator.imagePos_return imagePos() throws RecognitionException {
        RuntimeSourceGenerator.imagePos_return retval = new RuntimeSourceGenerator.imagePos_return();
        retval.start = input.LT(1);

        CommonTree VAR_SOURCE44=null;
        RuntimeSourceGenerator.bandSpecifier_return b = null;

        RuntimeSourceGenerator.pixelSpecifier_return p = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:17: ( ^( IMAGE_POS VAR_SOURCE (b= bandSpecifier )? (p= pixelSpecifier )? ) -> getsourcevalue(var=$VAR_SOURCE.textpixel=$p.stband=$b.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:19: ^( IMAGE_POS VAR_SOURCE (b= bandSpecifier )? (p= pixelSpecifier )? )
            {
            match(input,IMAGE_POS,FOLLOW_IMAGE_POS_in_imagePos3706); 

            match(input, Token.DOWN, null); 
            VAR_SOURCE44=(CommonTree)match(input,VAR_SOURCE,FOLLOW_VAR_SOURCE_in_imagePos3708); 
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:43: (b= bandSpecifier )?
            int alt17=2;
            switch ( input.LA(1) ) {
                case BAND_REF:
                    {
                    alt17=1;
                    }
                    break;
            }

            switch (alt17) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:43: b= bandSpecifier
                    {
                    pushFollow(FOLLOW_bandSpecifier_in_imagePos3712);
                    b=bandSpecifier();

                    state._fsp--;


                    }
                    break;

            }

            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:60: (p= pixelSpecifier )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case PIXEL_REF:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:336:60: p= pixelSpecifier
                    {
                    pushFollow(FOLLOW_pixelSpecifier_in_imagePos3717);
                    p=pixelSpecifier();

                    state._fsp--;


                    }
                    break;

            }


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 337:17: -> getsourcevalue(var=$VAR_SOURCE.textpixel=$p.stband=$b.st)
            {
                retval.st = templateLib.getInstanceOf("getsourcevalue",
              new STAttrMap().put("var", (VAR_SOURCE44!=null?VAR_SOURCE44.getText():null)).put("pixel", (p!=null?p.st:null)).put("band", (b!=null?b.st:null)));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "imagePos"

    public static class bandSpecifier_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "bandSpecifier"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:341:1: bandSpecifier : ^( BAND_REF expression ) -> {$expression.st};
    public final RuntimeSourceGenerator.bandSpecifier_return bandSpecifier() throws RecognitionException {
        RuntimeSourceGenerator.bandSpecifier_return retval = new RuntimeSourceGenerator.bandSpecifier_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.expression_return expression45 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:341:17: ( ^( BAND_REF expression ) -> {$expression.st})
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:341:19: ^( BAND_REF expression )
            {
            match(input,BAND_REF,FOLLOW_BAND_REF_in_bandSpecifier3783); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_expression_in_bandSpecifier3785);
            expression45=expression();

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 341:42: -> {$expression.st}
            {
                retval.st = (expression45!=null?expression45.st:null);
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "bandSpecifier"

    public static class pixelSpecifier_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "pixelSpecifier"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:345:1: pixelSpecifier : ^( PIXEL_REF xpos= pixelPos[\"_x\"] ypos= pixelPos[\"_y\"] ) -> pixel(x=xpos.sty=ypos.st);
    public final RuntimeSourceGenerator.pixelSpecifier_return pixelSpecifier() throws RecognitionException {
        RuntimeSourceGenerator.pixelSpecifier_return retval = new RuntimeSourceGenerator.pixelSpecifier_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.pixelPos_return xpos = null;

        RuntimeSourceGenerator.pixelPos_return ypos = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:345:17: ( ^( PIXEL_REF xpos= pixelPos[\"_x\"] ypos= pixelPos[\"_y\"] ) -> pixel(x=xpos.sty=ypos.st))
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:345:19: ^( PIXEL_REF xpos= pixelPos[\"_x\"] ypos= pixelPos[\"_y\"] )
            {
            match(input,PIXEL_REF,FOLLOW_PIXEL_REF_in_pixelSpecifier3818); 

            match(input, Token.DOWN, null); 
            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier3822);
            xpos=pixelPos("_x");

            state._fsp--;

            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier3827);
            ypos=pixelPos("_y");

            state._fsp--;


            match(input, Token.UP, null); 


            // TEMPLATE REWRITE
            // 345:72: -> pixel(x=xpos.sty=ypos.st)
            {
                retval.st = templateLib.getInstanceOf("pixel",
              new STAttrMap().put("x", xpos.st).put("y", ypos.st));
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelSpecifier"

    public static class pixelPos_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "pixelPos"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:349:1: pixelPos[String var] : ( ^( ABS_POS expression ) -> {$expression.st} | ^( REL_POS expression ) -> binaryexpr(lhs=$varop=%{\"+\"}rhs=$expression.st));
    public final RuntimeSourceGenerator.pixelPos_return pixelPos(String var) throws RecognitionException {
        RuntimeSourceGenerator.pixelPos_return retval = new RuntimeSourceGenerator.pixelPos_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.expression_return expression46 = null;

        RuntimeSourceGenerator.expression_return expression47 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:350:17: ( ^( ABS_POS expression ) -> {$expression.st} | ^( REL_POS expression ) -> binaryexpr(lhs=$varop=%{\"+\"}rhs=$expression.st))
            int alt19=2;
            switch ( input.LA(1) ) {
            case ABS_POS:
                {
                alt19=1;
                }
                break;
            case REL_POS:
                {
                alt19=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;
            }

            switch (alt19) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:350:19: ^( ABS_POS expression )
                    {
                    match(input,ABS_POS,FOLLOW_ABS_POS_in_pixelPos3887); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_pixelPos3889);
                    expression46=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 350:41: -> {$expression.st}
                    {
                        retval.st = (expression46!=null?expression46.st:null);
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:351:19: ^( REL_POS expression )
                    {
                    match(input,REL_POS,FOLLOW_REL_POS_in_pixelPos3915); 

                    match(input, Token.DOWN, null); 
                    pushFollow(FOLLOW_expression_in_pixelPos3917);
                    expression47=expression();

                    state._fsp--;


                    match(input, Token.UP, null); 


                    // TEMPLATE REWRITE
                    // 351:41: -> binaryexpr(lhs=$varop=%{\"+\"}rhs=$expression.st)
                    {
                        retval.st = templateLib.getInstanceOf("binaryexpr",
                      new STAttrMap().put("lhs", var).put("op", new StringTemplate(templateLib,"+")).put("rhs", (expression47!=null?expression47.st:null)));
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelPos"

    public static class prefixOp_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "prefixOp"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:355:1: prefixOp : ( PLUS -> {%{\"+\"}} | MINUS -> {%{\"-\"}} | incdecOp -> {$incdecOp.st});
    public final RuntimeSourceGenerator.prefixOp_return prefixOp() throws RecognitionException {
        RuntimeSourceGenerator.prefixOp_return retval = new RuntimeSourceGenerator.prefixOp_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.incdecOp_return incdecOp48 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:355:17: ( PLUS -> {%{\"+\"}} | MINUS -> {%{\"-\"}} | incdecOp -> {$incdecOp.st})
            int alt20=3;
            switch ( input.LA(1) ) {
            case PLUS:
                {
                alt20=1;
                }
                break;
            case MINUS:
                {
                alt20=2;
                }
                break;
            case INCR:
            case DECR:
                {
                alt20=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;
            }

            switch (alt20) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:355:19: PLUS
                    {
                    match(input,PLUS,FOLLOW_PLUS_in_prefixOp3970); 


                    // TEMPLATE REWRITE
                    // 355:24: -> {%{\"+\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"+");
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:356:19: MINUS
                    {
                    match(input,MINUS,FOLLOW_MINUS_in_prefixOp3994); 


                    // TEMPLATE REWRITE
                    // 356:25: -> {%{\"-\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"-");
                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:357:19: incdecOp
                    {
                    pushFollow(FOLLOW_incdecOp_in_prefixOp4018);
                    incdecOp48=incdecOp();

                    state._fsp--;



                    // TEMPLATE REWRITE
                    // 357:29: -> {$incdecOp.st}
                    {
                        retval.st = (incdecOp48!=null?incdecOp48.st:null);
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prefixOp"

    public static class postfixOp_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "postfixOp"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:361:1: postfixOp : incdecOp -> {$incdecOp.st};
    public final RuntimeSourceGenerator.postfixOp_return postfixOp() throws RecognitionException {
        RuntimeSourceGenerator.postfixOp_return retval = new RuntimeSourceGenerator.postfixOp_return();
        retval.start = input.LT(1);

        RuntimeSourceGenerator.incdecOp_return incdecOp49 = null;


        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:361:17: ( incdecOp -> {$incdecOp.st})
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:361:19: incdecOp
            {
            pushFollow(FOLLOW_incdecOp_in_postfixOp4055);
            incdecOp49=incdecOp();

            state._fsp--;



            // TEMPLATE REWRITE
            // 361:28: -> {$incdecOp.st}
            {
                retval.st = (incdecOp49!=null?incdecOp49.st:null);
            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "postfixOp"

    public static class incdecOp_return extends TreeRuleReturnScope {
        public StringTemplate st;
        public Object getTemplate() { return st; }
        public String toString() { return st==null?null:st.toString(); }
    };

    // $ANTLR start "incdecOp"
    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:365:1: incdecOp : ( INCR -> {%{\"++\"}} | DECR -> {%{\"--\"}});
    public final RuntimeSourceGenerator.incdecOp_return incdecOp() throws RecognitionException {
        RuntimeSourceGenerator.incdecOp_return retval = new RuntimeSourceGenerator.incdecOp_return();
        retval.start = input.LT(1);

        try {
            // jaitools/jiffle/parser/RuntimeSourceGenerator.g:365:17: ( INCR -> {%{\"++\"}} | DECR -> {%{\"--\"}})
            int alt21=2;
            switch ( input.LA(1) ) {
            case INCR:
                {
                alt21=1;
                }
                break;
            case DECR:
                {
                alt21=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 21, 0, input);

                throw nvae;
            }

            switch (alt21) {
                case 1 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:365:19: INCR
                    {
                    match(input,INCR,FOLLOW_INCR_in_incdecOp4092); 


                    // TEMPLATE REWRITE
                    // 365:24: -> {%{\"++\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"++");
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/RuntimeSourceGenerator.g:366:19: DECR
                    {
                    match(input,DECR,FOLLOW_DECR_in_incdecOp4116); 


                    // TEMPLATE REWRITE
                    // 366:24: -> {%{\"--\"}}
                    {
                        retval.st = new StringTemplate(templateLib,"--");
                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "incdecOp"

    // Delegated rules


    protected DFA14 dfa14 = new DFA14(this);
    static final String DFA14_eotS =
        "\21\uffff";
    static final String DFA14_eofS =
        "\21\uffff";
    static final String DFA14_minS =
        "\1\7\4\uffff\1\2\10\uffff\1\77\2\uffff";
    static final String DFA14_maxS =
        "\1\114\4\uffff\1\2\10\uffff\1\106\2\uffff";
    static final String DFA14_acceptS =
        "\1\uffff\1\1\1\2\1\3\1\4\1\uffff\1\7\1\10\1\11\1\12\1\13\1\14\1"+
        "\15\1\16\1\uffff\1\5\1\6";
    static final String DFA14_specialS =
        "\21\uffff}>";
    static final String[] DFA14_transitionS = {
            "\1\11\1\7\1\1\1\2\1\uffff\1\3\4\uffff\1\5\1\6\1\uffff\1\14\2"+
            "\uffff\1\13\5\12\22\uffff\1\10\6\uffff\16\4\3\uffff\1\4\3\uffff"+
            "\2\15",
            "",
            "",
            "",
            "",
            "\1\16",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\2\20\3\uffff\1\17\2\20",
            "",
            ""
    };

    static final short[] DFA14_eot = DFA.unpackEncodedString(DFA14_eotS);
    static final short[] DFA14_eof = DFA.unpackEncodedString(DFA14_eofS);
    static final char[] DFA14_min = DFA.unpackEncodedStringToUnsignedChars(DFA14_minS);
    static final char[] DFA14_max = DFA.unpackEncodedStringToUnsignedChars(DFA14_maxS);
    static final short[] DFA14_accept = DFA.unpackEncodedString(DFA14_acceptS);
    static final short[] DFA14_special = DFA.unpackEncodedString(DFA14_specialS);
    static final short[][] DFA14_transition;

    static {
        int numStates = DFA14_transitionS.length;
        DFA14_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA14_transition[i] = DFA.unpackEncodedString(DFA14_transitionS[i]);
        }
    }

    class DFA14 extends DFA {

        public DFA14(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 14;
            this.eot = DFA14_eot;
            this.eof = DFA14_eof;
            this.min = DFA14_min;
            this.max = DFA14_max;
            this.accept = DFA14_accept;
            this.special = DFA14_special;
            this.transition = DFA14_transition;
        }
        public String getDescription() {
            return "222:1: expression : ( ^( FUNC_CALL ID el= expressionList ) -> call(name=getRuntimeExpr($ID.text, $el.argTypes)args=$el.templates) | ^( IF_CALL el= expressionList ) -> ifcall(args=$el.templates) | imagePos -> {$imagePos.st} | binaryExpression -> {$binaryExpression.st} | ^( PREFIX NOT e= expression ) -> call(name=getRuntimeExpr(\"NOT\", \"D\")args=$e.st) | ^( PREFIX prefixOp e= expression ) -> preop(op=$prefixOp.stexpr=$e.st) | ^( POSTFIX postfixOp e= expression ) -> postop(op=$postfixOp.stexpr=$e.st) | ^( PAR e= expression ) -> par(expr=$e.st) | listOperation -> {$listOperation.st} | listLiteral -> {$listLiteral.st} | var -> {$var.st} | VAR_SOURCE -> getsourcevalue(var=$VAR_SOURCE.text) | CONSTANT -> {%{getConstantString($CONSTANT.text)}} | literal -> {$literal.st});";
        }
    }
 

    public static final BitSet FOLLOW_jiffleOption_in_generate105 = new BitSet(new long[]{0xFFDF87041FB61FB0L,0x000000000000188FL});
    public static final BitSet FOLLOW_varDeclaration_in_generate110 = new BitSet(new long[]{0xFFDF87041FB61FA0L,0x000000000000188FL});
    public static final BitSet FOLLOW_statement_in_generate115 = new BitSet(new long[]{0xFFDF87041FB61FA2L,0x000000000000188FL});
    public static final BitSet FOLLOW_JIFFLE_OPTION_in_jiffleOption258 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_jiffleOption260 = new BitSet(new long[]{0xFFDF87061FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_optionValue_in_jiffleOption262 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ID_in_optionValue329 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_optionValue351 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONSTANT_in_optionValue373 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration403 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_IMAGE_SCOPE_in_varDeclaration405 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_varDeclaration409 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BLOCK_in_block521 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_blockStatement_in_block525 = new BitSet(new long[]{0xFFDF87241FB61FA8L,0x000000000000188FL});
    public static final BitSet FOLLOW_statement_in_blockStatement579 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BREAKIF_in_blockStatement604 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_blockStatement606 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_simpleStatement_in_statement648 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_block_in_statement677 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_imageWrite_in_simpleStatement707 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_scalarAssignment_in_simpleStatement731 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listAssignment_in_simpleStatement755 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_loop_in_simpleStatement779 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_simpleStatement803 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IMAGE_WRITE_in_imageWrite839 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_DEST_in_imageWrite841 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_imageWrite843 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXPR_LIST_in_expressionList926 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expressionList929 = new BitSet(new long[]{0xFFDF87041FB61788L,0x000000000000188FL});
    public static final BitSet FOLLOW_assignmentOp_in_scalarAssignment1001 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_scalar_in_scalarAssignment1005 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_scalarAssignment1007 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQ_in_listAssignment1090 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_LIST_in_listAssignment1092 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_listAssignment1096 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_VAR_IMAGE_SCOPE_in_scalar1208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VAR_PIXEL_SCOPE_in_scalar1229 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_conditionalLoop_in_loop1285 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_foreachLoop_in_loop1309 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WHILE_in_conditionalLoop1356 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_conditionalLoop1360 = new BitSet(new long[]{0xFFDF87041FB61FA0L,0x000000000000188FL});
    public static final BitSet FOLLOW_statement_in_conditionalLoop1364 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNTIL_in_conditionalLoop1400 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_conditionalLoop1404 = new BitSet(new long[]{0xFFDF87041FB61FA0L,0x000000000000188FL});
    public static final BitSet FOLLOW_statement_in_conditionalLoop1408 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FOREACH_in_foreachLoop1475 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_foreachLoop1477 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_DECLARED_LIST_in_foreachLoop1523 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_foreachLoop1527 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_statement_in_foreachLoop1532 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FOREACH_in_foreachLoop1596 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_foreachLoop1598 = new BitSet(new long[]{0x0000000010000000L});
    public static final BitSet FOLLOW_VAR_LIST_in_foreachLoop1643 = new BitSet(new long[]{0xFFDF87041FB61FA0L,0x000000000000188FL});
    public static final BitSet FOLLOW_statement_in_foreachLoop1647 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FOREACH_in_foreachLoop1745 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_foreachLoop1747 = new BitSet(new long[]{0x0000000000080000L});
    public static final BitSet FOLLOW_SEQUENCE_in_foreachLoop1793 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_foreachLoop1797 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_foreachLoop1801 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_statement_in_foreachLoop1806 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FUNC_CALL_in_expression1885 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_expression1887 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_expressionList_in_expression1891 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IF_CALL_in_expression1945 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_expression1949 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_imagePos_in_expression1980 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_binaryExpression_in_expression2005 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PREFIX_in_expression2031 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_NOT_in_expression2033 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_expression2037 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PREFIX_in_expression2091 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_prefixOp_in_expression2093 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_expression2097 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POSTFIX_in_expression2134 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_postfixOp_in_expression2136 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_expression2140 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PAR_in_expression2177 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression2181 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listOperation_in_expression2212 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_expression2237 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_var_in_expression2262 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VAR_SOURCE_in_expression2287 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONSTANT_in_expression2317 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_expression2342 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_APPEND_in_listOperation2375 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_LIST_in_listOperation2377 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_listOperation2379 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DECLARED_LIST_in_listLiteral2442 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_listLiteral2446 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_var0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_POW_in_binaryExpression2670 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression2674 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression2678 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OR_in_binaryExpression2715 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression2719 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression2723 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_XOR_in_binaryExpression2779 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression2783 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression2787 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AND_in_binaryExpression2843 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression2847 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression2851 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOGICALEQ_in_binaryExpression2907 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression2911 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression2915 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NE_in_binaryExpression2971 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression2975 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression2979 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GT_in_binaryExpression3035 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression3039 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression3043 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GE_in_binaryExpression3099 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression3103 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression3107 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LT_in_binaryExpression3163 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression3167 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression3171 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LE_in_binaryExpression3227 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression3231 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression3235 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_arithmeticOp_in_binaryExpression3291 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_binaryExpression3295 = new BitSet(new long[]{0xFFDF87041FB61780L,0x000000000000188FL});
    public static final BitSet FOLLOW_expression_in_binaryExpression3299 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_assignmentOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_arithmeticOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INT_LITERAL_in_literal3644 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_LITERAL_in_literal3668 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IMAGE_POS_in_imagePos3706 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_SOURCE_in_imagePos3708 = new BitSet(new long[]{0x0000000000006008L});
    public static final BitSet FOLLOW_bandSpecifier_in_imagePos3712 = new BitSet(new long[]{0x0000000000004008L});
    public static final BitSet FOLLOW_pixelSpecifier_in_imagePos3717 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BAND_REF_in_bandSpecifier3783 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_bandSpecifier3785 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PIXEL_REF_in_pixelSpecifier3818 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier3822 = new BitSet(new long[]{0x0000000000018000L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier3827 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_POS_in_pixelPos3887 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos3889 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REL_POS_in_pixelPos3915 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos3917 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PLUS_in_prefixOp3970 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MINUS_in_prefixOp3994 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_incdecOp_in_prefixOp4018 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_incdecOp_in_postfixOp4055 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INCR_in_incdecOp4092 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DECR_in_incdecOp4116 = new BitSet(new long[]{0x0000000000000002L});

}