// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/TagVars.g 2011-03-08 17:37:57

package jaitools.jiffle.parser;

import java.util.Map;
import java.util.Stack;
import jaitools.CollectionFactory;
import jaitools.jiffle.Jiffle;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


/**
  * Transforms tokens representing variables into specific token types.
  *
  * @author Michael Bedward
  */
public class TagVars extends ErrorHandlingTreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public TagVars(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public TagVars(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        
    protected TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }
    public TreeAdaptor getTreeAdaptor() {
        return adaptor;
    }

    public String[] getTokenNames() { return TagVars.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/TagVars.g"; }



    private Map<String, Jiffle.ImageRole> imageParams;
    private MessageTable msgTable;

    public TagVars( TreeNodeStream nodes, Map<String, Jiffle.ImageRole> params, MessageTable msgTable ) {
        this(nodes);

        if (params == null) {
            this.imageParams = CollectionFactory.map();
        } else {
            this.imageParams = params;
        }

        if (msgTable == null) {
            throw new IllegalArgumentException( "msgTable should not be null" );
        }
        this.msgTable = msgTable;
    }

    private boolean isSourceImage( String varName ) {
        Jiffle.ImageRole role = imageParams.get( varName );
        return role == Jiffle.ImageRole.SOURCE;
    }

    private boolean isDestImage( String varName ) {
        Jiffle.ImageRole role = imageParams.get( varName );
        return role == Jiffle.ImageRole.DEST;
    }

    private SymbolScopeStack varScope = new SymbolScopeStack();


    private String getReturnType( String funcName ) {
        try {
            return FunctionLookup.getReturnType(funcName);

        } catch (UndefinedFunctionException ex) {
            // We can't really let undefined function exceptions pass here
            throw new JiffleParserException(ex);
        }
    }



    public static class start_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "start"
    // jaitools/jiffle/parser/TagVars.g:92:1: start : ( jiffleOption )* ( varDeclaration )* ( statement )+ ;
    public final TagVars.start_return start() throws RecognitionException {
        TagVars.start_return retval = new TagVars.start_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TagVars.jiffleOption_return jiffleOption1 = null;

        TagVars.varDeclaration_return varDeclaration2 = null;

        TagVars.statement_return statement3 = null;




            varScope.addLevel("top");

        try {
            // jaitools/jiffle/parser/TagVars.g:96:17: ( ( jiffleOption )* ( varDeclaration )* ( statement )+ )
            // jaitools/jiffle/parser/TagVars.g:96:19: ( jiffleOption )* ( varDeclaration )* ( statement )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // jaitools/jiffle/parser/TagVars.g:96:19: ( jiffleOption )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case JIFFLE_OPTION:
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // jaitools/jiffle/parser/TagVars.g:96:19: jiffleOption
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_jiffleOption_in_start106);
            	    jiffleOption1=jiffleOption();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jiffleOption1.getTree());

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            // jaitools/jiffle/parser/TagVars.g:96:33: ( varDeclaration )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case IMAGE_SCOPE_VAR_DECL:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // jaitools/jiffle/parser/TagVars.g:96:33: varDeclaration
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_varDeclaration_in_start109);
            	    varDeclaration2=varDeclaration();

            	    state._fsp--;

            	    adaptor.addChild(root_0, varDeclaration2.getTree());

            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            // jaitools/jiffle/parser/TagVars.g:96:49: ( statement )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case DECLARED_LIST:
                case PAR:
                case FUNC_CALL:
                case IF_CALL:
                case BLOCK:
                case IMAGE_POS:
                case PREFIX:
                case POSTFIX:
                case ID:
                case EQ:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case APPEND:
                case TIMESEQ:
                case DIVEQ:
                case MODEQ:
                case PLUSEQ:
                case MINUSEQ:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case POW:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // jaitools/jiffle/parser/TagVars.g:96:49: statement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_statement_in_start112);
            	    statement3=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement3.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "start"

    public static class jiffleOption_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "jiffleOption"
    // jaitools/jiffle/parser/TagVars.g:100:1: jiffleOption : ^( JIFFLE_OPTION ID optionValue ) ;
    public final TagVars.jiffleOption_return jiffleOption() throws RecognitionException {
        TagVars.jiffleOption_return retval = new TagVars.jiffleOption_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree JIFFLE_OPTION4=null;
        CommonTree ID5=null;
        TagVars.optionValue_return optionValue6 = null;


        CommonTree JIFFLE_OPTION4_tree=null;
        CommonTree ID5_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:100:17: ( ^( JIFFLE_OPTION ID optionValue ) )
            // jaitools/jiffle/parser/TagVars.g:100:19: ^( JIFFLE_OPTION ID optionValue )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            JIFFLE_OPTION4=(CommonTree)match(input,JIFFLE_OPTION,FOLLOW_JIFFLE_OPTION_in_jiffleOption143); 
            JIFFLE_OPTION4_tree = (CommonTree)adaptor.dupNode(JIFFLE_OPTION4);

            root_1 = (CommonTree)adaptor.becomeRoot(JIFFLE_OPTION4_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            ID5=(CommonTree)match(input,ID,FOLLOW_ID_in_jiffleOption145); 
            ID5_tree = (CommonTree)adaptor.dupNode(ID5);

            adaptor.addChild(root_1, ID5_tree);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_optionValue_in_jiffleOption147);
            optionValue6=optionValue();

            state._fsp--;

            adaptor.addChild(root_1, optionValue6.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "jiffleOption"

    public static class optionValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "optionValue"
    // jaitools/jiffle/parser/TagVars.g:104:1: optionValue : ( identifier | literal );
    public final TagVars.optionValue_return optionValue() throws RecognitionException {
        TagVars.optionValue_return retval = new TagVars.optionValue_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TagVars.identifier_return identifier7 = null;

        TagVars.literal_return literal8 = null;



        try {
            // jaitools/jiffle/parser/TagVars.g:104:17: ( identifier | literal )
            int alt4=2;
            switch ( input.LA(1) ) {
            case ID:
                {
                alt4=1;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt4=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;
            }

            switch (alt4) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:104:19: identifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_optionValue178);
                    identifier7=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier7.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:105:19: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_optionValue198);
                    literal8=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal8.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "optionValue"

    public static class varDeclaration_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varDeclaration"
    // jaitools/jiffle/parser/TagVars.g:109:1: varDeclaration : ^( IMAGE_SCOPE_VAR_DECL ID expression ) -> ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE[varName] expression ) ;
    public final TagVars.varDeclaration_return varDeclaration() throws RecognitionException {
        TagVars.varDeclaration_return retval = new TagVars.varDeclaration_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IMAGE_SCOPE_VAR_DECL9=null;
        CommonTree ID10=null;
        TagVars.expression_return expression11 = null;


        CommonTree IMAGE_SCOPE_VAR_DECL9_tree=null;
        CommonTree ID10_tree=null;
        RewriteRuleNodeStream stream_IMAGE_SCOPE_VAR_DECL=new RewriteRuleNodeStream(adaptor,"token IMAGE_SCOPE_VAR_DECL");
        RewriteRuleNodeStream stream_ID=new RewriteRuleNodeStream(adaptor,"token ID");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // jaitools/jiffle/parser/TagVars.g:109:17: ( ^( IMAGE_SCOPE_VAR_DECL ID expression ) -> ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE[varName] expression ) )
            // jaitools/jiffle/parser/TagVars.g:109:19: ^( IMAGE_SCOPE_VAR_DECL ID expression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            IMAGE_SCOPE_VAR_DECL9=(CommonTree)match(input,IMAGE_SCOPE_VAR_DECL,FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration226);  
            stream_IMAGE_SCOPE_VAR_DECL.add(IMAGE_SCOPE_VAR_DECL9);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            ID10=(CommonTree)match(input,ID,FOLLOW_ID_in_varDeclaration228);  
            stream_ID.add(ID10);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_varDeclaration230);
            expression11=expression();

            state._fsp--;

            stream_expression.add(expression11.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


                                String varName = (ID10!=null?ID10.getText():null);

                                if (isSourceImage(varName) || isDestImage(varName)) {
                                    msgTable.add( varName, Message.IMAGE_VAR_INIT_LHS );

                                } else {
                                    varScope.addSymbol(varName, SymbolType.SCALAR, ScopeType.IMAGE);
                                }
                            


            // AST REWRITE
            // elements: IMAGE_SCOPE_VAR_DECL, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 120:19: -> ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE[varName] expression )
            {
                // jaitools/jiffle/parser/TagVars.g:120:22: ^( IMAGE_SCOPE_VAR_DECL VAR_IMAGE_SCOPE[varName] expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_IMAGE_SCOPE_VAR_DECL.nextNode(), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR_IMAGE_SCOPE, varName));
                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;
            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varDeclaration"

    public static class block_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "block"
    // jaitools/jiffle/parser/TagVars.g:124:1: block : ^( BLOCK ( blockStatement )* ) ;
    public final TagVars.block_return block() throws RecognitionException {
        TagVars.block_return retval = new TagVars.block_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BLOCK12=null;
        TagVars.blockStatement_return blockStatement13 = null;


        CommonTree BLOCK12_tree=null;


            varScope.addLevel("block");

        try {
            // jaitools/jiffle/parser/TagVars.g:131:17: ( ^( BLOCK ( blockStatement )* ) )
            // jaitools/jiffle/parser/TagVars.g:131:19: ^( BLOCK ( blockStatement )* )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            BLOCK12=(CommonTree)match(input,BLOCK,FOLLOW_BLOCK_in_block331); 
            BLOCK12_tree = (CommonTree)adaptor.dupNode(BLOCK12);

            root_1 = (CommonTree)adaptor.becomeRoot(BLOCK12_tree, root_1);



            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/TagVars.g:131:27: ( blockStatement )*
                loop5:
                do {
                    int alt5=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case BLOCK:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case ID:
                    case EQ:
                    case BREAKIF:
                    case WHILE:
                    case UNTIL:
                    case FOREACH:
                    case APPEND:
                    case TIMESEQ:
                    case DIVEQ:
                    case MODEQ:
                    case PLUSEQ:
                    case MINUSEQ:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                        {
                        alt5=1;
                        }
                        break;

                    }

                    switch (alt5) {
                	case 1 :
                	    // jaitools/jiffle/parser/TagVars.g:131:27: blockStatement
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_blockStatement_in_block333);
                	    blockStatement13=blockStatement();

                	    state._fsp--;

                	    adaptor.addChild(root_1, blockStatement13.getTree());

                	    }
                	    break;

                	default :
                	    break loop5;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);


                varScope.dropLevel();

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "block"

    public static class blockStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "blockStatement"
    // jaitools/jiffle/parser/TagVars.g:135:1: blockStatement : ( statement | ^( BREAKIF expression ) );
    public final TagVars.blockStatement_return blockStatement() throws RecognitionException {
        TagVars.blockStatement_return retval = new TagVars.blockStatement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BREAKIF15=null;
        TagVars.statement_return statement14 = null;

        TagVars.expression_return expression16 = null;


        CommonTree BREAKIF15_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:135:17: ( statement | ^( BREAKIF expression ) )
            int alt6=2;
            switch ( input.LA(1) ) {
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case BLOCK:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case ID:
            case EQ:
            case WHILE:
            case UNTIL:
            case FOREACH:
            case APPEND:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt6=1;
                }
                break;
            case BREAKIF:
                {
                alt6=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:135:19: statement
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_blockStatement362);
                    statement14=statement();

                    state._fsp--;

                    adaptor.addChild(root_0, statement14.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:136:19: ^( BREAKIF expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    BREAKIF15=(CommonTree)match(input,BREAKIF,FOLLOW_BREAKIF_in_blockStatement383); 
                    BREAKIF15_tree = (CommonTree)adaptor.dupNode(BREAKIF15);

                    root_1 = (CommonTree)adaptor.becomeRoot(BREAKIF15_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_blockStatement385);
                    expression16=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression16.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "blockStatement"

    public static class statement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "statement"
    // jaitools/jiffle/parser/TagVars.g:140:1: statement : ( block | assignmentExpression | ^( WHILE loopCondition statement ) | ^( UNTIL loopCondition statement ) | foreachLoop | expression );
    public final TagVars.statement_return statement() throws RecognitionException {
        TagVars.statement_return retval = new TagVars.statement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHILE19=null;
        CommonTree UNTIL22=null;
        TagVars.block_return block17 = null;

        TagVars.assignmentExpression_return assignmentExpression18 = null;

        TagVars.loopCondition_return loopCondition20 = null;

        TagVars.statement_return statement21 = null;

        TagVars.loopCondition_return loopCondition23 = null;

        TagVars.statement_return statement24 = null;

        TagVars.foreachLoop_return foreachLoop25 = null;

        TagVars.expression_return expression26 = null;


        CommonTree WHILE19_tree=null;
        CommonTree UNTIL22_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:140:17: ( block | assignmentExpression | ^( WHILE loopCondition statement ) | ^( UNTIL loopCondition statement ) | foreachLoop | expression )
            int alt7=6;
            switch ( input.LA(1) ) {
            case BLOCK:
                {
                alt7=1;
                }
                break;
            case EQ:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
                {
                alt7=2;
                }
                break;
            case WHILE:
                {
                alt7=3;
                }
                break;
            case UNTIL:
                {
                alt7=4;
                }
                break;
            case FOREACH:
                {
                alt7=5;
                }
                break;
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case ID:
            case APPEND:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt7=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:140:19: block
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_block_in_statement418);
                    block17=block();

                    state._fsp--;

                    adaptor.addChild(root_0, block17.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:141:19: assignmentExpression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_assignmentExpression_in_statement438);
                    assignmentExpression18=assignmentExpression();

                    state._fsp--;

                    adaptor.addChild(root_0, assignmentExpression18.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TagVars.g:142:19: ^( WHILE loopCondition statement )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    WHILE19=(CommonTree)match(input,WHILE,FOLLOW_WHILE_in_statement459); 
                    WHILE19_tree = (CommonTree)adaptor.dupNode(WHILE19);

                    root_1 = (CommonTree)adaptor.becomeRoot(WHILE19_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_loopCondition_in_statement461);
                    loopCondition20=loopCondition();

                    state._fsp--;

                    adaptor.addChild(root_1, loopCondition20.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_statement463);
                    statement21=statement();

                    state._fsp--;

                    adaptor.addChild(root_1, statement21.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TagVars.g:143:19: ^( UNTIL loopCondition statement )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    UNTIL22=(CommonTree)match(input,UNTIL,FOLLOW_UNTIL_in_statement485); 
                    UNTIL22_tree = (CommonTree)adaptor.dupNode(UNTIL22);

                    root_1 = (CommonTree)adaptor.becomeRoot(UNTIL22_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_loopCondition_in_statement487);
                    loopCondition23=loopCondition();

                    state._fsp--;

                    adaptor.addChild(root_1, loopCondition23.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_statement489);
                    statement24=statement();

                    state._fsp--;

                    adaptor.addChild(root_1, statement24.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/TagVars.g:144:19: foreachLoop
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_foreachLoop_in_statement510);
                    foreachLoop25=foreachLoop();

                    state._fsp--;

                    adaptor.addChild(root_0, foreachLoop25.getTree());

                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/TagVars.g:145:19: expression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_statement530);
                    expression26=expression();

                    state._fsp--;

                    adaptor.addChild(root_0, expression26.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "statement"

    public static class foreachLoop_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "foreachLoop"
    // jaitools/jiffle/parser/TagVars.g:149:1: foreachLoop : ^( FOREACH ID loopSet statement ) ;
    public final TagVars.foreachLoop_return foreachLoop() throws RecognitionException {
        TagVars.foreachLoop_return retval = new TagVars.foreachLoop_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FOREACH27=null;
        CommonTree ID28=null;
        TagVars.loopSet_return loopSet29 = null;

        TagVars.statement_return statement30 = null;


        CommonTree FOREACH27_tree=null;
        CommonTree ID28_tree=null;


            varScope.addLevel("foreach");

        try {
            // jaitools/jiffle/parser/TagVars.g:156:17: ( ^( FOREACH ID loopSet statement ) )
            // jaitools/jiffle/parser/TagVars.g:156:19: ^( FOREACH ID loopSet statement )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            FOREACH27=(CommonTree)match(input,FOREACH,FOLLOW_FOREACH_in_foreachLoop588); 
            FOREACH27_tree = (CommonTree)adaptor.dupNode(FOREACH27);

            root_1 = (CommonTree)adaptor.becomeRoot(FOREACH27_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            ID28=(CommonTree)match(input,ID,FOLLOW_ID_in_foreachLoop590); 
            ID28_tree = (CommonTree)adaptor.dupNode(ID28);

            adaptor.addChild(root_1, ID28_tree);

            varScope.addSymbol((ID28!=null?ID28.getText():null), SymbolType.LOOP_VAR, ScopeType.PIXEL);
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_loopSet_in_foreachLoop594);
            loopSet29=loopSet();

            state._fsp--;

            adaptor.addChild(root_1, loopSet29.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_statement_in_foreachLoop596);
            statement30=statement();

            state._fsp--;

            adaptor.addChild(root_1, statement30.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);


                varScope.dropLevel();

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "foreachLoop"

    public static class loopCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "loopCondition"
    // jaitools/jiffle/parser/TagVars.g:160:1: loopCondition : expression ;
    public final TagVars.loopCondition_return loopCondition() throws RecognitionException {
        TagVars.loopCondition_return retval = new TagVars.loopCondition_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TagVars.expression_return expression31 = null;



        try {
            // jaitools/jiffle/parser/TagVars.g:160:17: ( expression )
            // jaitools/jiffle/parser/TagVars.g:160:19: expression
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_loopCondition625);
            expression31=expression();

            state._fsp--;

            adaptor.addChild(root_0, expression31.getTree());

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loopCondition"

    public static class loopSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "loopSet"
    // jaitools/jiffle/parser/TagVars.g:164:1: loopSet : ( ^( SEQUENCE expression expression ) | listLiteral | identifier );
    public final TagVars.loopSet_return loopSet() throws RecognitionException {
        TagVars.loopSet_return retval = new TagVars.loopSet_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SEQUENCE32=null;
        TagVars.expression_return expression33 = null;

        TagVars.expression_return expression34 = null;

        TagVars.listLiteral_return listLiteral35 = null;

        TagVars.identifier_return identifier36 = null;


        CommonTree SEQUENCE32_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:164:17: ( ^( SEQUENCE expression expression ) | listLiteral | identifier )
            int alt8=3;
            switch ( input.LA(1) ) {
            case SEQUENCE:
                {
                alt8=1;
                }
                break;
            case DECLARED_LIST:
                {
                alt8=2;
                }
                break;
            case ID:
                {
                alt8=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:164:19: ^( SEQUENCE expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    SEQUENCE32=(CommonTree)match(input,SEQUENCE,FOLLOW_SEQUENCE_in_loopSet660); 
                    SEQUENCE32_tree = (CommonTree)adaptor.dupNode(SEQUENCE32);

                    root_1 = (CommonTree)adaptor.becomeRoot(SEQUENCE32_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_loopSet662);
                    expression33=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression33.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_loopSet664);
                    expression34=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression34.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:165:19: listLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_listLiteral_in_loopSet685);
                    listLiteral35=listLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, listLiteral35.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TagVars.g:166:19: identifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_loopSet705);
                    identifier36=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier36.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loopSet"

    public static class expressionList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expressionList"
    // jaitools/jiffle/parser/TagVars.g:170:1: expressionList : ^( EXPR_LIST ( expression )* ) ;
    public final TagVars.expressionList_return expressionList() throws RecognitionException {
        TagVars.expressionList_return retval = new TagVars.expressionList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EXPR_LIST37=null;
        TagVars.expression_return expression38 = null;


        CommonTree EXPR_LIST37_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:170:17: ( ^( EXPR_LIST ( expression )* ) )
            // jaitools/jiffle/parser/TagVars.g:170:19: ^( EXPR_LIST ( expression )* )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            EXPR_LIST37=(CommonTree)match(input,EXPR_LIST,FOLLOW_EXPR_LIST_in_expressionList733); 
            EXPR_LIST37_tree = (CommonTree)adaptor.dupNode(EXPR_LIST37);

            root_1 = (CommonTree)adaptor.becomeRoot(EXPR_LIST37_tree, root_1);



            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/TagVars.g:170:31: ( expression )*
                loop9:
                do {
                    int alt9=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case ID:
                    case APPEND:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                        {
                        alt9=1;
                        }
                        break;

                    }

                    switch (alt9) {
                	case 1 :
                	    // jaitools/jiffle/parser/TagVars.g:170:31: expression
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_expression_in_expressionList735);
                	    expression38=expression();

                	    state._fsp--;

                	    adaptor.addChild(root_1, expression38.getTree());

                	    }
                	    break;

                	default :
                	    break loop9;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expressionList"

    public static class assignmentExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "assignmentExpression"
    // jaitools/jiffle/parser/TagVars.g:174:1: assignmentExpression : ^( assignmentOp identifier expression ) -> {isDestImage($identifier.text)}? ^( IMAGE_WRITE identifier expression ) -> {$expression.rtnType.equals(\"List\")}? ^( EQ VAR_LIST[$identifier.start.getText()] expression ) -> ^( assignmentOp identifier expression ) ;
    public final TagVars.assignmentExpression_return assignmentExpression() throws RecognitionException {
        TagVars.assignmentExpression_return retval = new TagVars.assignmentExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TagVars.assignmentOp_return assignmentOp39 = null;

        TagVars.identifier_return identifier40 = null;

        TagVars.expression_return expression41 = null;


        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_identifier=new RewriteRuleSubtreeStream(adaptor,"rule identifier");
        RewriteRuleSubtreeStream stream_assignmentOp=new RewriteRuleSubtreeStream(adaptor,"rule assignmentOp");
        try {
            // jaitools/jiffle/parser/TagVars.g:175:17: ( ^( assignmentOp identifier expression ) -> {isDestImage($identifier.text)}? ^( IMAGE_WRITE identifier expression ) -> {$expression.rtnType.equals(\"List\")}? ^( EQ VAR_LIST[$identifier.start.getText()] expression ) -> ^( assignmentOp identifier expression ) )
            // jaitools/jiffle/parser/TagVars.g:175:19: ^( assignmentOp identifier expression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_assignmentOp_in_assignmentExpression780);
            assignmentOp39=assignmentOp();

            state._fsp--;

            stream_assignmentOp.add(assignmentOp39.getTree());


            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_identifier_in_assignmentExpression782);
            identifier40=identifier();

            state._fsp--;

            stream_identifier.add(identifier40.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_assignmentExpression784);
            expression41=expression();

            state._fsp--;

            stream_expression.add(expression41.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }

             
                                String varName = (identifier40!=null?((CommonTree)identifier40.start):null).getText();

                                SymbolType symbolType = null;
                                boolean ok = true;
                                if (!varScope.isDefined(varName)) {
                                    if ((expression41!=null?expression41.rtnType:null).equals("List")) {
                                        symbolType = SymbolType.LIST;
                                    } else {
                                        symbolType = SymbolType.SCALAR;
                                    }
                                    varScope.addSymbol(varName, symbolType, ScopeType.PIXEL);

                                } else {
                                    symbolType = varScope.findSymbol(varName).getType();
                                    if (symbolType == SymbolType.LOOP_VAR) {
                                        msgTable.add(varName, Message.ASSIGNMENT_TO_LOOP_VAR);
                                        ok = false;

                                    } else if ((expression41!=null?expression41.rtnType:null).equals("List")) {
                                        if (symbolType != SymbolType.LIST) {
                                            msgTable.add(varName, Message.ASSIGNMENT_LIST_TO_SCALAR);
                                            ok = false;
                                        } else if ((assignmentOp39!=null?((CommonTree)assignmentOp39.start):null).getType() != EQ) {
                                            msgTable.add(varName + " " + (assignmentOp39!=null?((CommonTree)assignmentOp39.start):null).getText(), 
                                                    Message.INVALID_OPERATION_FOR_LIST);
                                            ok = false;
                                        }

                                    } else {
                                        if (symbolType != SymbolType.SCALAR) {
                                            msgTable.add(varName, Message.ASSIGNMENT_SCALAR_TO_LIST);
                                            ok = false;
                                        }
                                    }
                                }

                                if (!ok) throw new JiffleParserException("Cancelling script compilation");
                            


            // AST REWRITE
            // elements: expression, assignmentOp, expression, identifier, expression, identifier
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 216:19: -> {isDestImage($identifier.text)}? ^( IMAGE_WRITE identifier expression )
            if (isDestImage((identifier40!=null?(input.getTokenStream().toString(
              input.getTreeAdaptor().getTokenStartIndex(identifier40.start),
              input.getTreeAdaptor().getTokenStopIndex(identifier40.start))):null))) {
                // jaitools/jiffle/parser/TagVars.g:216:55: ^( IMAGE_WRITE identifier expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IMAGE_WRITE, "IMAGE_WRITE"), root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());
                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 218:19: -> {$expression.rtnType.equals(\"List\")}? ^( EQ VAR_LIST[$identifier.start.getText()] expression )
            if ((expression41!=null?expression41.rtnType:null).equals("List")) {
                // jaitools/jiffle/parser/TagVars.g:219:22: ^( EQ VAR_LIST[$identifier.start.getText()] expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EQ, "EQ"), root_1);

                adaptor.addChild(root_1, (CommonTree)adaptor.create(VAR_LIST, (identifier40!=null?((CommonTree)identifier40.start):null).getText()));
                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }
            else // 221:19: -> ^( assignmentOp identifier expression )
            {
                // jaitools/jiffle/parser/TagVars.g:221:22: ^( assignmentOp identifier expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_assignmentOp.nextNode(), root_1);

                adaptor.addChild(root_1, stream_identifier.nextTree());
                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }

            retval.tree = root_0;
            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentExpression"

    public static class assignmentOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "assignmentOp"
    // jaitools/jiffle/parser/TagVars.g:225:1: assignmentOp : ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ );
    public final TagVars.assignmentOp_return assignmentOp() throws RecognitionException {
        TagVars.assignmentOp_return retval = new TagVars.assignmentOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set42=null;

        CommonTree set42_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:225:17: ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ )
            // jaitools/jiffle/parser/TagVars.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set42=(CommonTree)input.LT(1);
            if ( input.LA(1)==EQ||(input.LA(1)>=TIMESEQ && input.LA(1)<=MINUSEQ) ) {
                input.consume();

                set42_tree = (CommonTree)adaptor.dupNode(set42);

                adaptor.addChild(root_0, set42_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentOp"

    public static class expression_return extends TreeRuleReturnScope {
        public String rtnType;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expression"
    // jaitools/jiffle/parser/TagVars.g:234:1: expression returns [String rtnType] : ( ^( FUNC_CALL ID args ) | listOperation | listLiteral | scalarExpression | identifier );
    public final TagVars.expression_return expression() throws RecognitionException {
        TagVars.expression_return retval = new TagVars.expression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FUNC_CALL43=null;
        CommonTree ID44=null;
        TagVars.args_return args45 = null;

        TagVars.listOperation_return listOperation46 = null;

        TagVars.listLiteral_return listLiteral47 = null;

        TagVars.scalarExpression_return scalarExpression48 = null;

        TagVars.identifier_return identifier49 = null;


        CommonTree FUNC_CALL43_tree=null;
        CommonTree ID44_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:235:17: ( ^( FUNC_CALL ID args ) | listOperation | listLiteral | scalarExpression | identifier )
            int alt10=5;
            switch ( input.LA(1) ) {
            case FUNC_CALL:
                {
                alt10=1;
                }
                break;
            case APPEND:
                {
                alt10=2;
                }
                break;
            case DECLARED_LIST:
                {
                alt10=3;
                }
                break;
            case PAR:
            case IF_CALL:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt10=4;
                }
                break;
            case ID:
                {
                alt10=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;
            }

            switch (alt10) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:235:19: ^( FUNC_CALL ID args )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    FUNC_CALL43=(CommonTree)match(input,FUNC_CALL,FOLLOW_FUNC_CALL_in_expression1093); 
                    FUNC_CALL43_tree = (CommonTree)adaptor.dupNode(FUNC_CALL43);

                    root_1 = (CommonTree)adaptor.becomeRoot(FUNC_CALL43_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    ID44=(CommonTree)match(input,ID,FOLLOW_ID_in_expression1095); 
                    ID44_tree = (CommonTree)adaptor.dupNode(ID44);

                    adaptor.addChild(root_1, ID44_tree);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_args_in_expression1097);
                    args45=args();

                    state._fsp--;

                    adaptor.addChild(root_1, args45.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                     retval.rtnType = getReturnType((ID44!=null?ID44.getText():null)); 

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:236:19: listOperation
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_listOperation_in_expression1120);
                    listOperation46=listOperation();

                    state._fsp--;

                    adaptor.addChild(root_0, listOperation46.getTree());
                     retval.rtnType = "List"; 

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TagVars.g:237:19: listLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_listLiteral_in_expression1142);
                    listLiteral47=listLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, listLiteral47.getTree());
                     retval.rtnType = "List"; 

                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TagVars.g:238:19: scalarExpression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_scalarExpression_in_expression1164);
                    scalarExpression48=scalarExpression();

                    state._fsp--;

                    adaptor.addChild(root_0, scalarExpression48.getTree());
                     retval.rtnType = "D"; 

                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/TagVars.g:239:19: identifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_expression1186);
                    identifier49=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier49.getTree());
                     retval.rtnType = (identifier49!=null?identifier49.isList:false) ? "List" : "D"; 

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expression"

    public static class scalarExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "scalarExpression"
    // jaitools/jiffle/parser/TagVars.g:243:1: scalarExpression : ( ^( IF_CALL expressionList ) | ^( QUESTION expression expression expression ) | ^( IMAGE_POS identifier ( bandSpecifier )? ( pixelSpecifier )? ) | ^( logicalOp expression expression ) | ^( arithmeticOp expression expression ) | ^( POW expression expression ) | ^( PREFIX prefixOp expression ) | ^( POSTFIX incdecOp expression ) | ^( PAR expression ) | literal );
    public final TagVars.scalarExpression_return scalarExpression() throws RecognitionException {
        TagVars.scalarExpression_return retval = new TagVars.scalarExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IF_CALL50=null;
        CommonTree QUESTION52=null;
        CommonTree IMAGE_POS56=null;
        CommonTree POW66=null;
        CommonTree PREFIX69=null;
        CommonTree POSTFIX72=null;
        CommonTree PAR75=null;
        TagVars.expressionList_return expressionList51 = null;

        TagVars.expression_return expression53 = null;

        TagVars.expression_return expression54 = null;

        TagVars.expression_return expression55 = null;

        TagVars.identifier_return identifier57 = null;

        TagVars.bandSpecifier_return bandSpecifier58 = null;

        TagVars.pixelSpecifier_return pixelSpecifier59 = null;

        TagVars.logicalOp_return logicalOp60 = null;

        TagVars.expression_return expression61 = null;

        TagVars.expression_return expression62 = null;

        TagVars.arithmeticOp_return arithmeticOp63 = null;

        TagVars.expression_return expression64 = null;

        TagVars.expression_return expression65 = null;

        TagVars.expression_return expression67 = null;

        TagVars.expression_return expression68 = null;

        TagVars.prefixOp_return prefixOp70 = null;

        TagVars.expression_return expression71 = null;

        TagVars.incdecOp_return incdecOp73 = null;

        TagVars.expression_return expression74 = null;

        TagVars.expression_return expression76 = null;

        TagVars.literal_return literal77 = null;


        CommonTree IF_CALL50_tree=null;
        CommonTree QUESTION52_tree=null;
        CommonTree IMAGE_POS56_tree=null;
        CommonTree POW66_tree=null;
        CommonTree PREFIX69_tree=null;
        CommonTree POSTFIX72_tree=null;
        CommonTree PAR75_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:244:17: ( ^( IF_CALL expressionList ) | ^( QUESTION expression expression expression ) | ^( IMAGE_POS identifier ( bandSpecifier )? ( pixelSpecifier )? ) | ^( logicalOp expression expression ) | ^( arithmeticOp expression expression ) | ^( POW expression expression ) | ^( PREFIX prefixOp expression ) | ^( POSTFIX incdecOp expression ) | ^( PAR expression ) | literal )
            int alt13=10;
            switch ( input.LA(1) ) {
            case IF_CALL:
                {
                alt13=1;
                }
                break;
            case QUESTION:
                {
                alt13=2;
                }
                break;
            case IMAGE_POS:
                {
                alt13=3;
                }
                break;
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
                {
                alt13=4;
                }
                break;
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
                {
                alt13=5;
                }
                break;
            case POW:
                {
                alt13=6;
                }
                break;
            case PREFIX:
                {
                alt13=7;
                }
                break;
            case POSTFIX:
                {
                alt13=8;
                }
                break;
            case PAR:
                {
                alt13=9;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt13=10;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:244:19: ^( IF_CALL expressionList )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IF_CALL50=(CommonTree)match(input,IF_CALL,FOLLOW_IF_CALL_in_scalarExpression1231); 
                    IF_CALL50_tree = (CommonTree)adaptor.dupNode(IF_CALL50);

                    root_1 = (CommonTree)adaptor.becomeRoot(IF_CALL50_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expressionList_in_scalarExpression1233);
                    expressionList51=expressionList();

                    state._fsp--;

                    adaptor.addChild(root_1, expressionList51.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:245:19: ^( QUESTION expression expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    QUESTION52=(CommonTree)match(input,QUESTION,FOLLOW_QUESTION_in_scalarExpression1255); 
                    QUESTION52_tree = (CommonTree)adaptor.dupNode(QUESTION52);

                    root_1 = (CommonTree)adaptor.becomeRoot(QUESTION52_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1257);
                    expression53=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression53.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1259);
                    expression54=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression54.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1261);
                    expression55=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression55.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TagVars.g:246:19: ^( IMAGE_POS identifier ( bandSpecifier )? ( pixelSpecifier )? )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IMAGE_POS56=(CommonTree)match(input,IMAGE_POS,FOLLOW_IMAGE_POS_in_scalarExpression1283); 
                    IMAGE_POS56_tree = (CommonTree)adaptor.dupNode(IMAGE_POS56);

                    root_1 = (CommonTree)adaptor.becomeRoot(IMAGE_POS56_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_scalarExpression1285);
                    identifier57=identifier();

                    state._fsp--;

                    adaptor.addChild(root_1, identifier57.getTree());
                    // jaitools/jiffle/parser/TagVars.g:246:42: ( bandSpecifier )?
                    int alt11=2;
                    switch ( input.LA(1) ) {
                        case BAND_REF:
                            {
                            alt11=1;
                            }
                            break;
                    }

                    switch (alt11) {
                        case 1 :
                            // jaitools/jiffle/parser/TagVars.g:246:42: bandSpecifier
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_bandSpecifier_in_scalarExpression1287);
                            bandSpecifier58=bandSpecifier();

                            state._fsp--;

                            adaptor.addChild(root_1, bandSpecifier58.getTree());

                            }
                            break;

                    }

                    // jaitools/jiffle/parser/TagVars.g:246:57: ( pixelSpecifier )?
                    int alt12=2;
                    switch ( input.LA(1) ) {
                        case PIXEL_REF:
                            {
                            alt12=1;
                            }
                            break;
                    }

                    switch (alt12) {
                        case 1 :
                            // jaitools/jiffle/parser/TagVars.g:246:57: pixelSpecifier
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_pixelSpecifier_in_scalarExpression1290);
                            pixelSpecifier59=pixelSpecifier();

                            state._fsp--;

                            adaptor.addChild(root_1, pixelSpecifier59.getTree());

                            }
                            break;

                    }


                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TagVars.g:247:19: ^( logicalOp expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_logicalOp_in_scalarExpression1313);
                    logicalOp60=logicalOp();

                    state._fsp--;

                    root_1 = (CommonTree)adaptor.becomeRoot(logicalOp60.getTree(), root_1);


                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1315);
                    expression61=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression61.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1317);
                    expression62=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression62.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/TagVars.g:248:19: ^( arithmeticOp expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_arithmeticOp_in_scalarExpression1339);
                    arithmeticOp63=arithmeticOp();

                    state._fsp--;

                    root_1 = (CommonTree)adaptor.becomeRoot(arithmeticOp63.getTree(), root_1);


                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1341);
                    expression64=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression64.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1343);
                    expression65=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression65.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/TagVars.g:249:19: ^( POW expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    POW66=(CommonTree)match(input,POW,FOLLOW_POW_in_scalarExpression1365); 
                    POW66_tree = (CommonTree)adaptor.dupNode(POW66);

                    root_1 = (CommonTree)adaptor.becomeRoot(POW66_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1367);
                    expression67=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression67.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1369);
                    expression68=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression68.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 7 :
                    // jaitools/jiffle/parser/TagVars.g:250:19: ^( PREFIX prefixOp expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    PREFIX69=(CommonTree)match(input,PREFIX,FOLLOW_PREFIX_in_scalarExpression1391); 
                    PREFIX69_tree = (CommonTree)adaptor.dupNode(PREFIX69);

                    root_1 = (CommonTree)adaptor.becomeRoot(PREFIX69_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_prefixOp_in_scalarExpression1393);
                    prefixOp70=prefixOp();

                    state._fsp--;

                    adaptor.addChild(root_1, prefixOp70.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1395);
                    expression71=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression71.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 8 :
                    // jaitools/jiffle/parser/TagVars.g:251:19: ^( POSTFIX incdecOp expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    POSTFIX72=(CommonTree)match(input,POSTFIX,FOLLOW_POSTFIX_in_scalarExpression1417); 
                    POSTFIX72_tree = (CommonTree)adaptor.dupNode(POSTFIX72);

                    root_1 = (CommonTree)adaptor.becomeRoot(POSTFIX72_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_incdecOp_in_scalarExpression1419);
                    incdecOp73=incdecOp();

                    state._fsp--;

                    adaptor.addChild(root_1, incdecOp73.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1421);
                    expression74=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression74.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 9 :
                    // jaitools/jiffle/parser/TagVars.g:252:19: ^( PAR expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    PAR75=(CommonTree)match(input,PAR,FOLLOW_PAR_in_scalarExpression1443); 
                    PAR75_tree = (CommonTree)adaptor.dupNode(PAR75);

                    root_1 = (CommonTree)adaptor.becomeRoot(PAR75_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_scalarExpression1445);
                    expression76=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression76.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 10 :
                    // jaitools/jiffle/parser/TagVars.g:253:19: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_scalarExpression1466);
                    literal77=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal77.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "scalarExpression"

    public static class args_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "args"
    // jaitools/jiffle/parser/TagVars.g:257:1: args : expressionList ;
    public final TagVars.args_return args() throws RecognitionException {
        TagVars.args_return retval = new TagVars.args_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TagVars.expressionList_return expressionList78 = null;



        try {
            // jaitools/jiffle/parser/TagVars.g:257:17: ( expressionList )
            // jaitools/jiffle/parser/TagVars.g:257:19: expressionList
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expressionList_in_args1503);
            expressionList78=expressionList();

            state._fsp--;

            adaptor.addChild(root_0, expressionList78.getTree());

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "args"

    public static class listOperation_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "listOperation"
    // jaitools/jiffle/parser/TagVars.g:261:1: listOperation : ^( APPEND identifier expression ) ;
    public final TagVars.listOperation_return listOperation() throws RecognitionException {
        TagVars.listOperation_return retval = new TagVars.listOperation_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree APPEND79=null;
        TagVars.identifier_return identifier80 = null;

        TagVars.expression_return expression81 = null;


        CommonTree APPEND79_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:261:17: ( ^( APPEND identifier expression ) )
            // jaitools/jiffle/parser/TagVars.g:261:19: ^( APPEND identifier expression )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            APPEND79=(CommonTree)match(input,APPEND,FOLLOW_APPEND_in_listOperation1532); 
            APPEND79_tree = (CommonTree)adaptor.dupNode(APPEND79);

            root_1 = (CommonTree)adaptor.becomeRoot(APPEND79_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_identifier_in_listOperation1534);
            identifier80=identifier();

            state._fsp--;

            adaptor.addChild(root_1, identifier80.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_listOperation1536);
            expression81=expression();

            state._fsp--;

            adaptor.addChild(root_1, expression81.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listOperation"

    public static class listLiteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "listLiteral"
    // jaitools/jiffle/parser/TagVars.g:265:1: listLiteral : ^( DECLARED_LIST expressionList ) ;
    public final TagVars.listLiteral_return listLiteral() throws RecognitionException {
        TagVars.listLiteral_return retval = new TagVars.listLiteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DECLARED_LIST82=null;
        TagVars.expressionList_return expressionList83 = null;


        CommonTree DECLARED_LIST82_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:265:17: ( ^( DECLARED_LIST expressionList ) )
            // jaitools/jiffle/parser/TagVars.g:265:19: ^( DECLARED_LIST expressionList )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            DECLARED_LIST82=(CommonTree)match(input,DECLARED_LIST,FOLLOW_DECLARED_LIST_in_listLiteral1568); 
            DECLARED_LIST82_tree = (CommonTree)adaptor.dupNode(DECLARED_LIST82);

            root_1 = (CommonTree)adaptor.becomeRoot(DECLARED_LIST82_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expressionList_in_listLiteral1570);
            expressionList83=expressionList();

            state._fsp--;

            adaptor.addChild(root_1, expressionList83.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listLiteral"

    public static class identifier_return extends TreeRuleReturnScope {
        public boolean isList;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "identifier"
    // jaitools/jiffle/parser/TagVars.g:269:1: identifier returns [boolean isList] : ID -> {isSourceImage($ID.text)}? VAR_SOURCE[$ID.text] -> {isDestImage($ID.text)}? VAR_DEST[$ID.text] -> {ConstantLookup.isDefined($ID.text)}? CONSTANT[$ID.text] -> {varScope.isDefined($ID.text, SymbolType.LOOP_VAR)}? VAR_LOOP[$ID.text] -> {$isList}? VAR_LIST[$ID.text] -> {varScope.isDefined($ID.text, ScopeType.IMAGE)}? VAR_IMAGE_SCOPE[$ID.text] -> VAR_PIXEL_SCOPE[$ID.text] ;
    public final TagVars.identifier_return identifier() throws RecognitionException {
        TagVars.identifier_return retval = new TagVars.identifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ID84=null;

        CommonTree ID84_tree=null;
        RewriteRuleNodeStream stream_ID=new RewriteRuleNodeStream(adaptor,"token ID");

        try {
            // jaitools/jiffle/parser/TagVars.g:270:17: ( ID -> {isSourceImage($ID.text)}? VAR_SOURCE[$ID.text] -> {isDestImage($ID.text)}? VAR_DEST[$ID.text] -> {ConstantLookup.isDefined($ID.text)}? CONSTANT[$ID.text] -> {varScope.isDefined($ID.text, SymbolType.LOOP_VAR)}? VAR_LOOP[$ID.text] -> {$isList}? VAR_LIST[$ID.text] -> {varScope.isDefined($ID.text, ScopeType.IMAGE)}? VAR_IMAGE_SCOPE[$ID.text] -> VAR_PIXEL_SCOPE[$ID.text] )
            // jaitools/jiffle/parser/TagVars.g:270:19: ID
            {
            _last = (CommonTree)input.LT(1);
            ID84=(CommonTree)match(input,ID,FOLLOW_ID_in_identifier1617);  
            stream_ID.add(ID84);

             retval.isList = varScope.isDefined((ID84!=null?ID84.getText():null), SymbolType.LIST); 


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 272:19: -> {isSourceImage($ID.text)}? VAR_SOURCE[$ID.text]
            if (isSourceImage((ID84!=null?ID84.getText():null))) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_SOURCE, (ID84!=null?ID84.getText():null)));

            }
            else // 273:19: -> {isDestImage($ID.text)}? VAR_DEST[$ID.text]
            if (isDestImage((ID84!=null?ID84.getText():null))) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_DEST, (ID84!=null?ID84.getText():null)));

            }
            else // 274:19: -> {ConstantLookup.isDefined($ID.text)}? CONSTANT[$ID.text]
            if (ConstantLookup.isDefined((ID84!=null?ID84.getText():null))) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(CONSTANT, (ID84!=null?ID84.getText():null)));

            }
            else // 275:19: -> {varScope.isDefined($ID.text, SymbolType.LOOP_VAR)}? VAR_LOOP[$ID.text]
            if (varScope.isDefined((ID84!=null?ID84.getText():null), SymbolType.LOOP_VAR)) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_LOOP, (ID84!=null?ID84.getText():null)));

            }
            else // 276:19: -> {$isList}? VAR_LIST[$ID.text]
            if (retval.isList) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_LIST, (ID84!=null?ID84.getText():null)));

            }
            else // 277:19: -> {varScope.isDefined($ID.text, ScopeType.IMAGE)}? VAR_IMAGE_SCOPE[$ID.text]
            if (varScope.isDefined((ID84!=null?ID84.getText():null), ScopeType.IMAGE)) {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_IMAGE_SCOPE, (ID84!=null?ID84.getText():null)));

            }
            else // 278:19: -> VAR_PIXEL_SCOPE[$ID.text]
            {
                adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_PIXEL_SCOPE, (ID84!=null?ID84.getText():null)));

            }

            retval.tree = root_0;
            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "identifier"

    public static class logicalOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "logicalOp"
    // jaitools/jiffle/parser/TagVars.g:282:1: logicalOp : ( OR | XOR | AND | LOGICALEQ | NE | GT | GE | LT | LE );
    public final TagVars.logicalOp_return logicalOp() throws RecognitionException {
        TagVars.logicalOp_return retval = new TagVars.logicalOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set85=null;

        CommonTree set85_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:282:17: ( OR | XOR | AND | LOGICALEQ | NE | GT | GE | LT | LE )
            // jaitools/jiffle/parser/TagVars.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set85=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=OR && input.LA(1)<=LT) ) {
                input.consume();

                set85_tree = (CommonTree)adaptor.dupNode(set85);

                adaptor.addChild(root_0, set85_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "logicalOp"

    public static class arithmeticOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "arithmeticOp"
    // jaitools/jiffle/parser/TagVars.g:294:1: arithmeticOp : ( PLUS | MINUS | TIMES | DIV | MOD );
    public final TagVars.arithmeticOp_return arithmeticOp() throws RecognitionException {
        TagVars.arithmeticOp_return retval = new TagVars.arithmeticOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set86=null;

        CommonTree set86_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:294:17: ( PLUS | MINUS | TIMES | DIV | MOD )
            // jaitools/jiffle/parser/TagVars.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set86=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=PLUS && input.LA(1)<=MOD) ) {
                input.consume();

                set86_tree = (CommonTree)adaptor.dupNode(set86);

                adaptor.addChild(root_0, set86_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "arithmeticOp"

    public static class prefixOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prefixOp"
    // jaitools/jiffle/parser/TagVars.g:302:1: prefixOp : ( PLUS | MINUS | NOT | incdecOp );
    public final TagVars.prefixOp_return prefixOp() throws RecognitionException {
        TagVars.prefixOp_return retval = new TagVars.prefixOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PLUS87=null;
        CommonTree MINUS88=null;
        CommonTree NOT89=null;
        TagVars.incdecOp_return incdecOp90 = null;


        CommonTree PLUS87_tree=null;
        CommonTree MINUS88_tree=null;
        CommonTree NOT89_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:302:17: ( PLUS | MINUS | NOT | incdecOp )
            int alt14=4;
            switch ( input.LA(1) ) {
            case PLUS:
                {
                alt14=1;
                }
                break;
            case MINUS:
                {
                alt14=2;
                }
                break;
            case NOT:
                {
                alt14=3;
                }
                break;
            case INCR:
            case DECR:
                {
                alt14=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;
            }

            switch (alt14) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:302:19: PLUS
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    PLUS87=(CommonTree)match(input,PLUS,FOLLOW_PLUS_in_prefixOp2143); 
                    PLUS87_tree = (CommonTree)adaptor.dupNode(PLUS87);

                    adaptor.addChild(root_0, PLUS87_tree);


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:303:19: MINUS
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    MINUS88=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_prefixOp2163); 
                    MINUS88_tree = (CommonTree)adaptor.dupNode(MINUS88);

                    adaptor.addChild(root_0, MINUS88_tree);


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TagVars.g:304:19: NOT
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    NOT89=(CommonTree)match(input,NOT,FOLLOW_NOT_in_prefixOp2183); 
                    NOT89_tree = (CommonTree)adaptor.dupNode(NOT89);

                    adaptor.addChild(root_0, NOT89_tree);


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TagVars.g:305:19: incdecOp
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_incdecOp_in_prefixOp2203);
                    incdecOp90=incdecOp();

                    state._fsp--;

                    adaptor.addChild(root_0, incdecOp90.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prefixOp"

    public static class incdecOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "incdecOp"
    // jaitools/jiffle/parser/TagVars.g:309:1: incdecOp : ( INCR | DECR );
    public final TagVars.incdecOp_return incdecOp() throws RecognitionException {
        TagVars.incdecOp_return retval = new TagVars.incdecOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set91=null;

        CommonTree set91_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:309:17: ( INCR | DECR )
            // jaitools/jiffle/parser/TagVars.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set91=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=INCR && input.LA(1)<=DECR) ) {
                input.consume();

                set91_tree = (CommonTree)adaptor.dupNode(set91);

                adaptor.addChild(root_0, set91_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "incdecOp"

    public static class pixelSpecifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pixelSpecifier"
    // jaitools/jiffle/parser/TagVars.g:314:1: pixelSpecifier : ^( PIXEL_REF pixelPos pixelPos ) ;
    public final TagVars.pixelSpecifier_return pixelSpecifier() throws RecognitionException {
        TagVars.pixelSpecifier_return retval = new TagVars.pixelSpecifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PIXEL_REF92=null;
        TagVars.pixelPos_return pixelPos93 = null;

        TagVars.pixelPos_return pixelPos94 = null;


        CommonTree PIXEL_REF92_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:314:17: ( ^( PIXEL_REF pixelPos pixelPos ) )
            // jaitools/jiffle/parser/TagVars.g:314:19: ^( PIXEL_REF pixelPos pixelPos )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            PIXEL_REF92=(CommonTree)match(input,PIXEL_REF,FOLLOW_PIXEL_REF_in_pixelSpecifier2284); 
            PIXEL_REF92_tree = (CommonTree)adaptor.dupNode(PIXEL_REF92);

            root_1 = (CommonTree)adaptor.becomeRoot(PIXEL_REF92_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2286);
            pixelPos93=pixelPos();

            state._fsp--;

            adaptor.addChild(root_1, pixelPos93.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2288);
            pixelPos94=pixelPos();

            state._fsp--;

            adaptor.addChild(root_1, pixelPos94.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelSpecifier"

    public static class bandSpecifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "bandSpecifier"
    // jaitools/jiffle/parser/TagVars.g:318:1: bandSpecifier : ^( BAND_REF expression ) ;
    public final TagVars.bandSpecifier_return bandSpecifier() throws RecognitionException {
        TagVars.bandSpecifier_return retval = new TagVars.bandSpecifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BAND_REF95=null;
        TagVars.expression_return expression96 = null;


        CommonTree BAND_REF95_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:318:17: ( ^( BAND_REF expression ) )
            // jaitools/jiffle/parser/TagVars.g:318:19: ^( BAND_REF expression )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            BAND_REF95=(CommonTree)match(input,BAND_REF,FOLLOW_BAND_REF_in_bandSpecifier2318); 
            BAND_REF95_tree = (CommonTree)adaptor.dupNode(BAND_REF95);

            root_1 = (CommonTree)adaptor.becomeRoot(BAND_REF95_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_bandSpecifier2320);
            expression96=expression();

            state._fsp--;

            adaptor.addChild(root_1, expression96.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "bandSpecifier"

    public static class pixelPos_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pixelPos"
    // jaitools/jiffle/parser/TagVars.g:322:1: pixelPos : ( ^( ABS_POS expression ) | ^( REL_POS expression ) );
    public final TagVars.pixelPos_return pixelPos() throws RecognitionException {
        TagVars.pixelPos_return retval = new TagVars.pixelPos_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ABS_POS97=null;
        CommonTree REL_POS99=null;
        TagVars.expression_return expression98 = null;

        TagVars.expression_return expression100 = null;


        CommonTree ABS_POS97_tree=null;
        CommonTree REL_POS99_tree=null;

        try {
            // jaitools/jiffle/parser/TagVars.g:322:17: ( ^( ABS_POS expression ) | ^( REL_POS expression ) )
            int alt15=2;
            switch ( input.LA(1) ) {
            case ABS_POS:
                {
                alt15=1;
                }
                break;
            case REL_POS:
                {
                alt15=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 15, 0, input);

                throw nvae;
            }

            switch (alt15) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:322:19: ^( ABS_POS expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    ABS_POS97=(CommonTree)match(input,ABS_POS,FOLLOW_ABS_POS_in_pixelPos2355); 
                    ABS_POS97_tree = (CommonTree)adaptor.dupNode(ABS_POS97);

                    root_1 = (CommonTree)adaptor.becomeRoot(ABS_POS97_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_pixelPos2357);
                    expression98=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression98.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:323:19: ^( REL_POS expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    REL_POS99=(CommonTree)match(input,REL_POS,FOLLOW_REL_POS_in_pixelPos2379); 
                    REL_POS99_tree = (CommonTree)adaptor.dupNode(REL_POS99);

                    root_1 = (CommonTree)adaptor.becomeRoot(REL_POS99_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_pixelPos2381);
                    expression100=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression100.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelPos"

    public static class literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "literal"
    // jaitools/jiffle/parser/TagVars.g:327:1: literal : ( INT_LITERAL | FLOAT_LITERAL | TRUE -> FLOAT_LITERAL[\"1.0\"] | FALSE -> FLOAT_LITERAL[\"0.0\"] | NULL -> CONSTANT[\"NaN\"] );
    public final TagVars.literal_return literal() throws RecognitionException {
        TagVars.literal_return retval = new TagVars.literal_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INT_LITERAL101=null;
        CommonTree FLOAT_LITERAL102=null;
        CommonTree TRUE103=null;
        CommonTree FALSE104=null;
        CommonTree NULL105=null;

        CommonTree INT_LITERAL101_tree=null;
        CommonTree FLOAT_LITERAL102_tree=null;
        CommonTree TRUE103_tree=null;
        CommonTree FALSE104_tree=null;
        CommonTree NULL105_tree=null;
        RewriteRuleNodeStream stream_FALSE=new RewriteRuleNodeStream(adaptor,"token FALSE");
        RewriteRuleNodeStream stream_TRUE=new RewriteRuleNodeStream(adaptor,"token TRUE");
        RewriteRuleNodeStream stream_NULL=new RewriteRuleNodeStream(adaptor,"token NULL");

        try {
            // jaitools/jiffle/parser/TagVars.g:327:17: ( INT_LITERAL | FLOAT_LITERAL | TRUE -> FLOAT_LITERAL[\"1.0\"] | FALSE -> FLOAT_LITERAL[\"0.0\"] | NULL -> CONSTANT[\"NaN\"] )
            int alt16=5;
            switch ( input.LA(1) ) {
            case INT_LITERAL:
                {
                alt16=1;
                }
                break;
            case FLOAT_LITERAL:
                {
                alt16=2;
                }
                break;
            case TRUE:
                {
                alt16=3;
                }
                break;
            case FALSE:
                {
                alt16=4;
                }
                break;
            case NULL:
                {
                alt16=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;
            }

            switch (alt16) {
                case 1 :
                    // jaitools/jiffle/parser/TagVars.g:327:19: INT_LITERAL
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    INT_LITERAL101=(CommonTree)match(input,INT_LITERAL,FOLLOW_INT_LITERAL_in_literal2416); 
                    INT_LITERAL101_tree = (CommonTree)adaptor.dupNode(INT_LITERAL101);

                    adaptor.addChild(root_0, INT_LITERAL101_tree);


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TagVars.g:328:19: FLOAT_LITERAL
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    FLOAT_LITERAL102=(CommonTree)match(input,FLOAT_LITERAL,FOLLOW_FLOAT_LITERAL_in_literal2436); 
                    FLOAT_LITERAL102_tree = (CommonTree)adaptor.dupNode(FLOAT_LITERAL102);

                    adaptor.addChild(root_0, FLOAT_LITERAL102_tree);


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TagVars.g:329:19: TRUE
                    {
                    _last = (CommonTree)input.LT(1);
                    TRUE103=(CommonTree)match(input,TRUE,FOLLOW_TRUE_in_literal2456);  
                    stream_TRUE.add(TRUE103);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 329:24: -> FLOAT_LITERAL[\"1.0\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(FLOAT_LITERAL, "1.0"));

                    }

                    retval.tree = root_0;
                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TagVars.g:330:19: FALSE
                    {
                    _last = (CommonTree)input.LT(1);
                    FALSE104=(CommonTree)match(input,FALSE,FOLLOW_FALSE_in_literal2481);  
                    stream_FALSE.add(FALSE104);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 330:25: -> FLOAT_LITERAL[\"0.0\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(FLOAT_LITERAL, "0.0"));

                    }

                    retval.tree = root_0;
                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/TagVars.g:331:19: NULL
                    {
                    _last = (CommonTree)input.LT(1);
                    NULL105=(CommonTree)match(input,NULL,FOLLOW_NULL_in_literal2506);  
                    stream_NULL.add(NULL105);



                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 331:24: -> CONSTANT[\"NaN\"]
                    {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(CONSTANT, "NaN"));

                    }

                    retval.tree = root_0;
                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "literal"

    // Delegated rules


 

    public static final BitSet FOLLOW_jiffleOption_in_start106 = new BitSet(new long[]{0xFFFF870600061FB0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_varDeclaration_in_start109 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_start112 = new BitSet(new long[]{0xFFFF870600061FA2L,0x000000000000F88FL});
    public static final BitSet FOLLOW_JIFFLE_OPTION_in_jiffleOption143 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_jiffleOption145 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_optionValue_in_jiffleOption147 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_identifier_in_optionValue178 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_optionValue198 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration226 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_varDeclaration228 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_varDeclaration230 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BLOCK_in_block331 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_blockStatement_in_block333 = new BitSet(new long[]{0xFFFF872600061FA8L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_blockStatement362 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BREAKIF_in_blockStatement383 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_blockStatement385 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_block_in_statement418 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_assignmentExpression_in_statement438 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WHILE_in_statement459 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_loopCondition_in_statement461 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement463 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNTIL_in_statement485 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_loopCondition_in_statement487 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement489 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_foreachLoop_in_statement510 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_statement530 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FOREACH_in_foreachLoop588 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_foreachLoop590 = new BitSet(new long[]{0xFFFF8706000E1FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_loopSet_in_foreachLoop594 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_foreachLoop596 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_expression_in_loopCondition625 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SEQUENCE_in_loopSet660 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_loopSet662 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_loopSet664 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listLiteral_in_loopSet685 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifier_in_loopSet705 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPR_LIST_in_expressionList733 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expressionList735 = new BitSet(new long[]{0xFFFF870600061FA8L,0x000000000000F88FL});
    public static final BitSet FOLLOW_assignmentOp_in_assignmentExpression780 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_assignmentExpression782 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_assignmentExpression784 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_assignmentOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNC_CALL_in_expression1093 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_expression1095 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_args_in_expression1097 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listOperation_in_expression1120 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_expression1142 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_scalarExpression_in_expression1164 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifier_in_expression1186 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IF_CALL_in_scalarExpression1231 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_scalarExpression1233 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_QUESTION_in_scalarExpression1255 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_scalarExpression1257 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1259 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1261 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IMAGE_POS_in_scalarExpression1283 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_scalarExpression1285 = new BitSet(new long[]{0x0000000000006008L});
    public static final BitSet FOLLOW_bandSpecifier_in_scalarExpression1287 = new BitSet(new long[]{0x0000000000004008L});
    public static final BitSet FOLLOW_pixelSpecifier_in_scalarExpression1290 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_logicalOp_in_scalarExpression1313 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_scalarExpression1315 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1317 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_arithmeticOp_in_scalarExpression1339 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_scalarExpression1341 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1343 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POW_in_scalarExpression1365 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_scalarExpression1367 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1369 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PREFIX_in_scalarExpression1391 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_prefixOp_in_scalarExpression1393 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1395 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POSTFIX_in_scalarExpression1417 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_incdecOp_in_scalarExpression1419 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_scalarExpression1421 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PAR_in_scalarExpression1443 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_scalarExpression1445 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_literal_in_scalarExpression1466 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expressionList_in_args1503 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_APPEND_in_listOperation1532 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_listOperation1534 = new BitSet(new long[]{0xFFFF870600061FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_listOperation1536 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DECLARED_LIST_in_listLiteral1568 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_listLiteral1570 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ID_in_identifier1617 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_logicalOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_arithmeticOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PLUS_in_prefixOp2143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MINUS_in_prefixOp2163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_prefixOp2183 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_incdecOp_in_prefixOp2203 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_incdecOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PIXEL_REF_in_pixelSpecifier2284 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2286 = new BitSet(new long[]{0x0000000000018000L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2288 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BAND_REF_in_bandSpecifier2318 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_bandSpecifier2320 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_POS_in_pixelPos2355 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos2357 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REL_POS_in_pixelPos2379 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos2381 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INT_LITERAL_in_literal2416 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOAT_LITERAL_in_literal2436 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_literal2456 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_literal2481 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal2506 = new BitSet(new long[]{0x0000000000000002L});

}