// $ANTLR 3.3 Nov 30, 2010 12:46:29 jaitools/jiffle/parser/TransformExpressions.g 2011-03-08 17:37:58

package jaitools.jiffle.parser;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


/**
  * Converts calls to proxy functions into the associated variables and
  * converts ternary conditional expressions to if calls.
  *
  * @author Michael Bedward
  */
public class TransformExpressions extends ErrorHandlingTreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "JIFFLE_OPTION", "IMAGE_SCOPE_VAR_DECL", "EXPR_LIST", "DECLARED_LIST", "PAR", "FUNC_CALL", "IF_CALL", "BLOCK", "IMAGE_POS", "BAND_REF", "PIXEL_REF", "ABS_POS", "REL_POS", "PREFIX", "POSTFIX", "SEQUENCE", "CONSTANT", "IMAGE_WRITE", "VAR_DEST", "VAR_SOURCE", "VAR_IMAGE_SCOPE", "VAR_PIXEL_SCOPE", "VAR_PROVIDED", "VAR_LOOP", "VAR_LIST", "LIST_NEW", "OPTIONS", "LCURLY", "RCURLY", "ID", "EQ", "SEMI", "INIT", "BREAKIF", "LPAR", "RPAR", "WHILE", "UNTIL", "FOREACH", "IN", "COMMA", "COLON", "IF", "APPEND", "TIMESEQ", "DIVEQ", "MODEQ", "PLUSEQ", "MINUSEQ", "QUESTION", "OR", "XOR", "AND", "LOGICALEQ", "NE", "GT", "GE", "LE", "LT", "PLUS", "MINUS", "TIMES", "DIV", "MOD", "NOT", "INCR", "DECR", "POW", "LSQUARE", "RSQUARE", "ABS_POS_PREFIX", "INT_LITERAL", "FLOAT_LITERAL", "TRUE", "FALSE", "NULL", "COMMENT", "INT_TYPE", "FLOAT_TYPE", "DOUBLE_TYPE", "BOOLEAN_TYPE", "Letter", "UNDERSCORE", "Digit", "Dot", "NonZeroDigit", "FloatExp", "WS", "ESC_SEQ", "CHAR", "HEX_DIGIT", "UNICODE_ESC", "OCTAL_ESC"
    };
    public static final int EOF=-1;
    public static final int JIFFLE_OPTION=4;
    public static final int IMAGE_SCOPE_VAR_DECL=5;
    public static final int EXPR_LIST=6;
    public static final int DECLARED_LIST=7;
    public static final int PAR=8;
    public static final int FUNC_CALL=9;
    public static final int IF_CALL=10;
    public static final int BLOCK=11;
    public static final int IMAGE_POS=12;
    public static final int BAND_REF=13;
    public static final int PIXEL_REF=14;
    public static final int ABS_POS=15;
    public static final int REL_POS=16;
    public static final int PREFIX=17;
    public static final int POSTFIX=18;
    public static final int SEQUENCE=19;
    public static final int CONSTANT=20;
    public static final int IMAGE_WRITE=21;
    public static final int VAR_DEST=22;
    public static final int VAR_SOURCE=23;
    public static final int VAR_IMAGE_SCOPE=24;
    public static final int VAR_PIXEL_SCOPE=25;
    public static final int VAR_PROVIDED=26;
    public static final int VAR_LOOP=27;
    public static final int VAR_LIST=28;
    public static final int LIST_NEW=29;
    public static final int OPTIONS=30;
    public static final int LCURLY=31;
    public static final int RCURLY=32;
    public static final int ID=33;
    public static final int EQ=34;
    public static final int SEMI=35;
    public static final int INIT=36;
    public static final int BREAKIF=37;
    public static final int LPAR=38;
    public static final int RPAR=39;
    public static final int WHILE=40;
    public static final int UNTIL=41;
    public static final int FOREACH=42;
    public static final int IN=43;
    public static final int COMMA=44;
    public static final int COLON=45;
    public static final int IF=46;
    public static final int APPEND=47;
    public static final int TIMESEQ=48;
    public static final int DIVEQ=49;
    public static final int MODEQ=50;
    public static final int PLUSEQ=51;
    public static final int MINUSEQ=52;
    public static final int QUESTION=53;
    public static final int OR=54;
    public static final int XOR=55;
    public static final int AND=56;
    public static final int LOGICALEQ=57;
    public static final int NE=58;
    public static final int GT=59;
    public static final int GE=60;
    public static final int LE=61;
    public static final int LT=62;
    public static final int PLUS=63;
    public static final int MINUS=64;
    public static final int TIMES=65;
    public static final int DIV=66;
    public static final int MOD=67;
    public static final int NOT=68;
    public static final int INCR=69;
    public static final int DECR=70;
    public static final int POW=71;
    public static final int LSQUARE=72;
    public static final int RSQUARE=73;
    public static final int ABS_POS_PREFIX=74;
    public static final int INT_LITERAL=75;
    public static final int FLOAT_LITERAL=76;
    public static final int TRUE=77;
    public static final int FALSE=78;
    public static final int NULL=79;
    public static final int COMMENT=80;
    public static final int INT_TYPE=81;
    public static final int FLOAT_TYPE=82;
    public static final int DOUBLE_TYPE=83;
    public static final int BOOLEAN_TYPE=84;
    public static final int Letter=85;
    public static final int UNDERSCORE=86;
    public static final int Digit=87;
    public static final int Dot=88;
    public static final int NonZeroDigit=89;
    public static final int FloatExp=90;
    public static final int WS=91;
    public static final int ESC_SEQ=92;
    public static final int CHAR=93;
    public static final int HEX_DIGIT=94;
    public static final int UNICODE_ESC=95;
    public static final int OCTAL_ESC=96;

    // delegates
    // delegators


        public TransformExpressions(TreeNodeStream input) {
            this(input, new RecognizerSharedState());
        }
        public TransformExpressions(TreeNodeStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        
    protected TreeAdaptor adaptor = new CommonTreeAdaptor();

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }
    public TreeAdaptor getTreeAdaptor() {
        return adaptor;
    }

    public String[] getTokenNames() { return TransformExpressions.tokenNames; }
    public String getGrammarFileName() { return "jaitools/jiffle/parser/TransformExpressions.g"; }



    private boolean isProxy(String name) {
        try {
            return FunctionLookup.getInfo(name, null).isProxy(); 

        } catch (UndefinedFunctionException ex) {
            // If the function is not defined we let it pass here. It
            // will be picked up later by the function checking parser.
            return false;
        }
    }

    private String getRuntimeExpr(String name) {
        try {
            return FunctionLookup.getInfo(name, null).getRuntimeExpr();

        } catch (UndefinedFunctionException ex) {
            // getting here means a mistake in the grammar action code
            throw new RuntimeException(ex);
        }
    }



    public static class start_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "start"
    // jaitools/jiffle/parser/TransformExpressions.g:68:1: start : ( jiffleOption )* ( varDeclaration )* ( statement )+ ;
    public final TransformExpressions.start_return start() throws RecognitionException {
        TransformExpressions.start_return retval = new TransformExpressions.start_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TransformExpressions.jiffleOption_return jiffleOption1 = null;

        TransformExpressions.varDeclaration_return varDeclaration2 = null;

        TransformExpressions.statement_return statement3 = null;



        try {
            // jaitools/jiffle/parser/TransformExpressions.g:68:17: ( ( jiffleOption )* ( varDeclaration )* ( statement )+ )
            // jaitools/jiffle/parser/TransformExpressions.g:68:19: ( jiffleOption )* ( varDeclaration )* ( statement )+
            {
            root_0 = (CommonTree)adaptor.nil();

            // jaitools/jiffle/parser/TransformExpressions.g:68:19: ( jiffleOption )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case JIFFLE_OPTION:
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // jaitools/jiffle/parser/TransformExpressions.g:68:19: jiffleOption
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_jiffleOption_in_start94);
            	    jiffleOption1=jiffleOption();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jiffleOption1.getTree());

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);

            // jaitools/jiffle/parser/TransformExpressions.g:68:33: ( varDeclaration )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case IMAGE_SCOPE_VAR_DECL:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // jaitools/jiffle/parser/TransformExpressions.g:68:33: varDeclaration
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_varDeclaration_in_start97);
            	    varDeclaration2=varDeclaration();

            	    state._fsp--;

            	    adaptor.addChild(root_0, varDeclaration2.getTree());

            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            // jaitools/jiffle/parser/TransformExpressions.g:68:49: ( statement )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case DECLARED_LIST:
                case PAR:
                case FUNC_CALL:
                case IF_CALL:
                case BLOCK:
                case IMAGE_POS:
                case PREFIX:
                case POSTFIX:
                case CONSTANT:
                case IMAGE_WRITE:
                case VAR_DEST:
                case VAR_SOURCE:
                case VAR_IMAGE_SCOPE:
                case VAR_PIXEL_SCOPE:
                case VAR_LOOP:
                case VAR_LIST:
                case EQ:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case APPEND:
                case TIMESEQ:
                case DIVEQ:
                case MODEQ:
                case PLUSEQ:
                case MINUSEQ:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case POW:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // jaitools/jiffle/parser/TransformExpressions.g:68:49: statement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_statement_in_start100);
            	    statement3=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement3.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "start"

    public static class jiffleOption_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "jiffleOption"
    // jaitools/jiffle/parser/TransformExpressions.g:72:1: jiffleOption : ^( JIFFLE_OPTION ( . )+ ) ;
    public final TransformExpressions.jiffleOption_return jiffleOption() throws RecognitionException {
        TransformExpressions.jiffleOption_return retval = new TransformExpressions.jiffleOption_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree JIFFLE_OPTION4=null;
        CommonTree wildcard5=null;

        CommonTree JIFFLE_OPTION4_tree=null;
        CommonTree wildcard5_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:72:17: ( ^( JIFFLE_OPTION ( . )+ ) )
            // jaitools/jiffle/parser/TransformExpressions.g:72:19: ^( JIFFLE_OPTION ( . )+ )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            JIFFLE_OPTION4=(CommonTree)match(input,JIFFLE_OPTION,FOLLOW_JIFFLE_OPTION_in_jiffleOption131); 
            JIFFLE_OPTION4_tree = (CommonTree)adaptor.dupNode(JIFFLE_OPTION4);

            root_1 = (CommonTree)adaptor.becomeRoot(JIFFLE_OPTION4_tree, root_1);



            match(input, Token.DOWN, null); 
            // jaitools/jiffle/parser/TransformExpressions.g:72:35: ( . )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case JIFFLE_OPTION:
                case IMAGE_SCOPE_VAR_DECL:
                case EXPR_LIST:
                case DECLARED_LIST:
                case PAR:
                case FUNC_CALL:
                case IF_CALL:
                case BLOCK:
                case IMAGE_POS:
                case BAND_REF:
                case PIXEL_REF:
                case ABS_POS:
                case REL_POS:
                case PREFIX:
                case POSTFIX:
                case SEQUENCE:
                case CONSTANT:
                case IMAGE_WRITE:
                case VAR_DEST:
                case VAR_SOURCE:
                case VAR_IMAGE_SCOPE:
                case VAR_PIXEL_SCOPE:
                case VAR_PROVIDED:
                case VAR_LOOP:
                case VAR_LIST:
                case LIST_NEW:
                case OPTIONS:
                case LCURLY:
                case RCURLY:
                case ID:
                case EQ:
                case SEMI:
                case INIT:
                case BREAKIF:
                case LPAR:
                case RPAR:
                case WHILE:
                case UNTIL:
                case FOREACH:
                case IN:
                case COMMA:
                case COLON:
                case IF:
                case APPEND:
                case TIMESEQ:
                case DIVEQ:
                case MODEQ:
                case PLUSEQ:
                case MINUSEQ:
                case QUESTION:
                case OR:
                case XOR:
                case AND:
                case LOGICALEQ:
                case NE:
                case GT:
                case GE:
                case LE:
                case LT:
                case PLUS:
                case MINUS:
                case TIMES:
                case DIV:
                case MOD:
                case NOT:
                case INCR:
                case DECR:
                case POW:
                case LSQUARE:
                case RSQUARE:
                case ABS_POS_PREFIX:
                case INT_LITERAL:
                case FLOAT_LITERAL:
                case TRUE:
                case FALSE:
                case NULL:
                case COMMENT:
                case INT_TYPE:
                case FLOAT_TYPE:
                case DOUBLE_TYPE:
                case BOOLEAN_TYPE:
                case Letter:
                case UNDERSCORE:
                case Digit:
                case Dot:
                case NonZeroDigit:
                case FloatExp:
                case WS:
                case ESC_SEQ:
                case CHAR:
                case HEX_DIGIT:
                case UNICODE_ESC:
                case OCTAL_ESC:
                    {
                    alt4=1;
                    }
                    break;
                case UP:
                    {
                    alt4=2;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // jaitools/jiffle/parser/TransformExpressions.g:72:35: .
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    wildcard5=(CommonTree)input.LT(1);
            	    matchAny(input); 
            	    wildcard5_tree = (CommonTree)adaptor.dupTree(wildcard5);
            	    adaptor.addChild(root_1, wildcard5_tree);


            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "jiffleOption"

    public static class varDeclaration_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "varDeclaration"
    // jaitools/jiffle/parser/TransformExpressions.g:76:1: varDeclaration : ^( IMAGE_SCOPE_VAR_DECL id= . expression ) ;
    public final TransformExpressions.varDeclaration_return varDeclaration() throws RecognitionException {
        TransformExpressions.varDeclaration_return retval = new TransformExpressions.varDeclaration_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IMAGE_SCOPE_VAR_DECL6=null;
        CommonTree id=null;
        TransformExpressions.expression_return expression7 = null;


        CommonTree IMAGE_SCOPE_VAR_DECL6_tree=null;
        CommonTree id_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:76:17: ( ^( IMAGE_SCOPE_VAR_DECL id= . expression ) )
            // jaitools/jiffle/parser/TransformExpressions.g:76:19: ^( IMAGE_SCOPE_VAR_DECL id= . expression )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            IMAGE_SCOPE_VAR_DECL6=(CommonTree)match(input,IMAGE_SCOPE_VAR_DECL,FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration163); 
            IMAGE_SCOPE_VAR_DECL6_tree = (CommonTree)adaptor.dupNode(IMAGE_SCOPE_VAR_DECL6);

            root_1 = (CommonTree)adaptor.becomeRoot(IMAGE_SCOPE_VAR_DECL6_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            id=(CommonTree)input.LT(1);
            matchAny(input); 
            id_tree = (CommonTree)adaptor.dupTree(id);
            adaptor.addChild(root_1, id_tree);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_varDeclaration169);
            expression7=expression();

            state._fsp--;

            adaptor.addChild(root_1, expression7.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "varDeclaration"

    public static class block_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "block"
    // jaitools/jiffle/parser/TransformExpressions.g:80:1: block : ^( BLOCK ( blockStatement )* ) ;
    public final TransformExpressions.block_return block() throws RecognitionException {
        TransformExpressions.block_return retval = new TransformExpressions.block_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BLOCK8=null;
        TransformExpressions.blockStatement_return blockStatement9 = null;


        CommonTree BLOCK8_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:80:17: ( ^( BLOCK ( blockStatement )* ) )
            // jaitools/jiffle/parser/TransformExpressions.g:80:19: ^( BLOCK ( blockStatement )* )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            BLOCK8=(CommonTree)match(input,BLOCK,FOLLOW_BLOCK_in_block207); 
            BLOCK8_tree = (CommonTree)adaptor.dupNode(BLOCK8);

            root_1 = (CommonTree)adaptor.becomeRoot(BLOCK8_tree, root_1);



            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/TransformExpressions.g:80:27: ( blockStatement )*
                loop5:
                do {
                    int alt5=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case BLOCK:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case CONSTANT:
                    case IMAGE_WRITE:
                    case VAR_DEST:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case EQ:
                    case BREAKIF:
                    case WHILE:
                    case UNTIL:
                    case FOREACH:
                    case APPEND:
                    case TIMESEQ:
                    case DIVEQ:
                    case MODEQ:
                    case PLUSEQ:
                    case MINUSEQ:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                        {
                        alt5=1;
                        }
                        break;

                    }

                    switch (alt5) {
                	case 1 :
                	    // jaitools/jiffle/parser/TransformExpressions.g:80:27: blockStatement
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_blockStatement_in_block209);
                	    blockStatement9=blockStatement();

                	    state._fsp--;

                	    adaptor.addChild(root_1, blockStatement9.getTree());

                	    }
                	    break;

                	default :
                	    break loop5;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "block"

    public static class blockStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "blockStatement"
    // jaitools/jiffle/parser/TransformExpressions.g:84:1: blockStatement : ( statement | ^( BREAKIF expression ) );
    public final TransformExpressions.blockStatement_return blockStatement() throws RecognitionException {
        TransformExpressions.blockStatement_return retval = new TransformExpressions.blockStatement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BREAKIF11=null;
        TransformExpressions.statement_return statement10 = null;

        TransformExpressions.expression_return expression12 = null;


        CommonTree BREAKIF11_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:84:17: ( statement | ^( BREAKIF expression ) )
            int alt6=2;
            switch ( input.LA(1) ) {
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case BLOCK:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case IMAGE_WRITE:
            case VAR_DEST:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
            case EQ:
            case WHILE:
            case UNTIL:
            case FOREACH:
            case APPEND:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt6=1;
                }
                break;
            case BREAKIF:
                {
                alt6=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // jaitools/jiffle/parser/TransformExpressions.g:84:19: statement
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_blockStatement238);
                    statement10=statement();

                    state._fsp--;

                    adaptor.addChild(root_0, statement10.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TransformExpressions.g:85:19: ^( BREAKIF expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    BREAKIF11=(CommonTree)match(input,BREAKIF,FOLLOW_BREAKIF_in_blockStatement259); 
                    BREAKIF11_tree = (CommonTree)adaptor.dupNode(BREAKIF11);

                    root_1 = (CommonTree)adaptor.becomeRoot(BREAKIF11_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_blockStatement261);
                    expression12=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression12.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "blockStatement"

    public static class statement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "statement"
    // jaitools/jiffle/parser/TransformExpressions.g:89:1: statement : ( block | assignmentExpression | ^( WHILE loopCondition statement ) | ^( UNTIL loopCondition statement ) | ^( FOREACH ID loopSet statement ) | expression );
    public final TransformExpressions.statement_return statement() throws RecognitionException {
        TransformExpressions.statement_return retval = new TransformExpressions.statement_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHILE15=null;
        CommonTree UNTIL18=null;
        CommonTree FOREACH21=null;
        CommonTree ID22=null;
        TransformExpressions.block_return block13 = null;

        TransformExpressions.assignmentExpression_return assignmentExpression14 = null;

        TransformExpressions.loopCondition_return loopCondition16 = null;

        TransformExpressions.statement_return statement17 = null;

        TransformExpressions.loopCondition_return loopCondition19 = null;

        TransformExpressions.statement_return statement20 = null;

        TransformExpressions.loopSet_return loopSet23 = null;

        TransformExpressions.statement_return statement24 = null;

        TransformExpressions.expression_return expression25 = null;


        CommonTree WHILE15_tree=null;
        CommonTree UNTIL18_tree=null;
        CommonTree FOREACH21_tree=null;
        CommonTree ID22_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:89:17: ( block | assignmentExpression | ^( WHILE loopCondition statement ) | ^( UNTIL loopCondition statement ) | ^( FOREACH ID loopSet statement ) | expression )
            int alt7=6;
            switch ( input.LA(1) ) {
            case BLOCK:
                {
                alt7=1;
                }
                break;
            case EQ:
            case TIMESEQ:
            case DIVEQ:
            case MODEQ:
            case PLUSEQ:
            case MINUSEQ:
                {
                alt7=2;
                }
                break;
            case WHILE:
                {
                alt7=3;
                }
                break;
            case UNTIL:
                {
                alt7=4;
                }
                break;
            case FOREACH:
                {
                alt7=5;
                }
                break;
            case DECLARED_LIST:
            case PAR:
            case FUNC_CALL:
            case IF_CALL:
            case IMAGE_POS:
            case PREFIX:
            case POSTFIX:
            case CONSTANT:
            case IMAGE_WRITE:
            case VAR_DEST:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
            case APPEND:
            case QUESTION:
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
            case POW:
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt7=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 7, 0, input);

                throw nvae;
            }

            switch (alt7) {
                case 1 :
                    // jaitools/jiffle/parser/TransformExpressions.g:89:19: block
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_block_in_statement294);
                    block13=block();

                    state._fsp--;

                    adaptor.addChild(root_0, block13.getTree());

                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TransformExpressions.g:90:19: assignmentExpression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_assignmentExpression_in_statement314);
                    assignmentExpression14=assignmentExpression();

                    state._fsp--;

                    adaptor.addChild(root_0, assignmentExpression14.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TransformExpressions.g:91:19: ^( WHILE loopCondition statement )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    WHILE15=(CommonTree)match(input,WHILE,FOLLOW_WHILE_in_statement335); 
                    WHILE15_tree = (CommonTree)adaptor.dupNode(WHILE15);

                    root_1 = (CommonTree)adaptor.becomeRoot(WHILE15_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_loopCondition_in_statement337);
                    loopCondition16=loopCondition();

                    state._fsp--;

                    adaptor.addChild(root_1, loopCondition16.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_statement339);
                    statement17=statement();

                    state._fsp--;

                    adaptor.addChild(root_1, statement17.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TransformExpressions.g:92:19: ^( UNTIL loopCondition statement )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    UNTIL18=(CommonTree)match(input,UNTIL,FOLLOW_UNTIL_in_statement361); 
                    UNTIL18_tree = (CommonTree)adaptor.dupNode(UNTIL18);

                    root_1 = (CommonTree)adaptor.becomeRoot(UNTIL18_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_loopCondition_in_statement363);
                    loopCondition19=loopCondition();

                    state._fsp--;

                    adaptor.addChild(root_1, loopCondition19.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_statement365);
                    statement20=statement();

                    state._fsp--;

                    adaptor.addChild(root_1, statement20.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/TransformExpressions.g:93:19: ^( FOREACH ID loopSet statement )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    FOREACH21=(CommonTree)match(input,FOREACH,FOLLOW_FOREACH_in_statement387); 
                    FOREACH21_tree = (CommonTree)adaptor.dupNode(FOREACH21);

                    root_1 = (CommonTree)adaptor.becomeRoot(FOREACH21_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    ID22=(CommonTree)match(input,ID,FOLLOW_ID_in_statement389); 
                    ID22_tree = (CommonTree)adaptor.dupNode(ID22);

                    adaptor.addChild(root_1, ID22_tree);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_loopSet_in_statement391);
                    loopSet23=loopSet();

                    state._fsp--;

                    adaptor.addChild(root_1, loopSet23.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_statement_in_statement393);
                    statement24=statement();

                    state._fsp--;

                    adaptor.addChild(root_1, statement24.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/TransformExpressions.g:94:19: expression
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_statement414);
                    expression25=expression();

                    state._fsp--;

                    adaptor.addChild(root_0, expression25.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "statement"

    public static class loopCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "loopCondition"
    // jaitools/jiffle/parser/TransformExpressions.g:98:1: loopCondition : expression ;
    public final TransformExpressions.loopCondition_return loopCondition() throws RecognitionException {
        TransformExpressions.loopCondition_return retval = new TransformExpressions.loopCondition_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TransformExpressions.expression_return expression26 = null;



        try {
            // jaitools/jiffle/parser/TransformExpressions.g:98:17: ( expression )
            // jaitools/jiffle/parser/TransformExpressions.g:98:19: expression
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_loopCondition442);
            expression26=expression();

            state._fsp--;

            adaptor.addChild(root_0, expression26.getTree());

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loopCondition"

    public static class loopSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "loopSet"
    // jaitools/jiffle/parser/TransformExpressions.g:102:1: loopSet : ( ^( SEQUENCE expression expression ) | listLiteral | VAR_LIST );
    public final TransformExpressions.loopSet_return loopSet() throws RecognitionException {
        TransformExpressions.loopSet_return retval = new TransformExpressions.loopSet_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SEQUENCE27=null;
        CommonTree VAR_LIST31=null;
        TransformExpressions.expression_return expression28 = null;

        TransformExpressions.expression_return expression29 = null;

        TransformExpressions.listLiteral_return listLiteral30 = null;


        CommonTree SEQUENCE27_tree=null;
        CommonTree VAR_LIST31_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:102:17: ( ^( SEQUENCE expression expression ) | listLiteral | VAR_LIST )
            int alt8=3;
            switch ( input.LA(1) ) {
            case SEQUENCE:
                {
                alt8=1;
                }
                break;
            case DECLARED_LIST:
                {
                alt8=2;
                }
                break;
            case VAR_LIST:
                {
                alt8=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;
            }

            switch (alt8) {
                case 1 :
                    // jaitools/jiffle/parser/TransformExpressions.g:102:19: ^( SEQUENCE expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    SEQUENCE27=(CommonTree)match(input,SEQUENCE,FOLLOW_SEQUENCE_in_loopSet477); 
                    SEQUENCE27_tree = (CommonTree)adaptor.dupNode(SEQUENCE27);

                    root_1 = (CommonTree)adaptor.becomeRoot(SEQUENCE27_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_loopSet479);
                    expression28=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression28.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_loopSet481);
                    expression29=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression29.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TransformExpressions.g:103:19: listLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_listLiteral_in_loopSet502);
                    listLiteral30=listLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, listLiteral30.getTree());

                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TransformExpressions.g:104:19: VAR_LIST
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    VAR_LIST31=(CommonTree)match(input,VAR_LIST,FOLLOW_VAR_LIST_in_loopSet522); 
                    VAR_LIST31_tree = (CommonTree)adaptor.dupNode(VAR_LIST31);

                    adaptor.addChild(root_0, VAR_LIST31_tree);


                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "loopSet"

    public static class expressionList_return extends TreeRuleReturnScope {
        public List<String> argTypes;
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expressionList"
    // jaitools/jiffle/parser/TransformExpressions.g:108:1: expressionList returns [List<String> argTypes] : ^( EXPR_LIST (e= expression )* ) ;
    public final TransformExpressions.expressionList_return expressionList() throws RecognitionException {
        TransformExpressions.expressionList_return retval = new TransformExpressions.expressionList_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EXPR_LIST32=null;
        TransformExpressions.expression_return e = null;


        CommonTree EXPR_LIST32_tree=null;

         retval.argTypes = new ArrayList<String>(); 
        try {
            // jaitools/jiffle/parser/TransformExpressions.g:110:17: ( ^( EXPR_LIST (e= expression )* ) )
            // jaitools/jiffle/parser/TransformExpressions.g:110:19: ^( EXPR_LIST (e= expression )* )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            EXPR_LIST32=(CommonTree)match(input,EXPR_LIST,FOLLOW_EXPR_LIST_in_expressionList573); 
            EXPR_LIST32_tree = (CommonTree)adaptor.dupNode(EXPR_LIST32);

            root_1 = (CommonTree)adaptor.becomeRoot(EXPR_LIST32_tree, root_1);



            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // jaitools/jiffle/parser/TransformExpressions.g:110:31: (e= expression )*
                loop9:
                do {
                    int alt9=2;
                    switch ( input.LA(1) ) {
                    case DECLARED_LIST:
                    case PAR:
                    case FUNC_CALL:
                    case IF_CALL:
                    case IMAGE_POS:
                    case PREFIX:
                    case POSTFIX:
                    case CONSTANT:
                    case IMAGE_WRITE:
                    case VAR_DEST:
                    case VAR_SOURCE:
                    case VAR_IMAGE_SCOPE:
                    case VAR_PIXEL_SCOPE:
                    case VAR_LOOP:
                    case VAR_LIST:
                    case APPEND:
                    case QUESTION:
                    case OR:
                    case XOR:
                    case AND:
                    case LOGICALEQ:
                    case NE:
                    case GT:
                    case GE:
                    case LE:
                    case LT:
                    case PLUS:
                    case MINUS:
                    case TIMES:
                    case DIV:
                    case MOD:
                    case POW:
                    case INT_LITERAL:
                    case FLOAT_LITERAL:
                    case TRUE:
                    case FALSE:
                    case NULL:
                        {
                        alt9=1;
                        }
                        break;

                    }

                    switch (alt9) {
                	case 1 :
                	    // jaitools/jiffle/parser/TransformExpressions.g:110:32: e= expression
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_expression_in_expressionList578);
                	    e=expression();

                	    state._fsp--;

                	    adaptor.addChild(root_1, e.getTree());
                	     
                	                            retval.argTypes.add((e!=null?((CommonTree)e.start):null).getType() == VAR_LIST ? "List" : "D");
                	                        

                	    }
                	    break;

                	default :
                	    break loop9;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expressionList"

    public static class assignmentExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "assignmentExpression"
    // jaitools/jiffle/parser/TransformExpressions.g:117:1: assignmentExpression : ^( assignmentOp identifier expression ) ;
    public final TransformExpressions.assignmentExpression_return assignmentExpression() throws RecognitionException {
        TransformExpressions.assignmentExpression_return retval = new TransformExpressions.assignmentExpression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        TransformExpressions.assignmentOp_return assignmentOp33 = null;

        TransformExpressions.identifier_return identifier34 = null;

        TransformExpressions.expression_return expression35 = null;



        try {
            // jaitools/jiffle/parser/TransformExpressions.g:118:17: ( ^( assignmentOp identifier expression ) )
            // jaitools/jiffle/parser/TransformExpressions.g:118:19: ^( assignmentOp identifier expression )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_assignmentOp_in_assignmentExpression648);
            assignmentOp33=assignmentOp();

            state._fsp--;

            root_1 = (CommonTree)adaptor.becomeRoot(assignmentOp33.getTree(), root_1);


            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_identifier_in_assignmentExpression650);
            identifier34=identifier();

            state._fsp--;

            adaptor.addChild(root_1, identifier34.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_assignmentExpression652);
            expression35=expression();

            state._fsp--;

            adaptor.addChild(root_1, expression35.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentExpression"

    public static class assignmentOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "assignmentOp"
    // jaitools/jiffle/parser/TransformExpressions.g:122:1: assignmentOp : ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ );
    public final TransformExpressions.assignmentOp_return assignmentOp() throws RecognitionException {
        TransformExpressions.assignmentOp_return retval = new TransformExpressions.assignmentOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set36=null;

        CommonTree set36_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:122:17: ( EQ | TIMESEQ | DIVEQ | MODEQ | PLUSEQ | MINUSEQ )
            // jaitools/jiffle/parser/TransformExpressions.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set36=(CommonTree)input.LT(1);
            if ( input.LA(1)==EQ||(input.LA(1)>=TIMESEQ && input.LA(1)<=MINUSEQ) ) {
                input.consume();

                set36_tree = (CommonTree)adaptor.dupNode(set36);

                adaptor.addChild(root_0, set36_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "assignmentOp"

    public static class expression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "expression"
    // jaitools/jiffle/parser/TransformExpressions.g:131:1: expression : ( ^( FUNC_CALL ID expressionList ) -> {isProxy($ID.text)}? VAR_PROVIDED[ getRuntimeExpr($ID.text) ] -> ^( FUNC_CALL ID expressionList ) | ^( QUESTION e1= expression e2= expression e3= expression ) -> ^( IF_CALL ^( EXPR_LIST $e1 $e2 $e3) ) | ^( IF_CALL expressionList ) | ^( IMAGE_WRITE identifier expression ) | ^( IMAGE_POS identifier ( bandSpecifier )? ( pixelSpecifier )? ) | ^( logicalOp expression expression ) | ^( arithmeticOp expression expression ) | ^( POW expression expression ) | ^( PREFIX prefixOp expression ) | ^( POSTFIX incdecOp expression ) | ^( PAR expression ) | listOperation | listLiteral | literal | identifier );
    public final TransformExpressions.expression_return expression() throws RecognitionException {
        TransformExpressions.expression_return retval = new TransformExpressions.expression_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FUNC_CALL37=null;
        CommonTree ID38=null;
        CommonTree QUESTION40=null;
        CommonTree IF_CALL41=null;
        CommonTree IMAGE_WRITE43=null;
        CommonTree IMAGE_POS46=null;
        CommonTree POW56=null;
        CommonTree PREFIX59=null;
        CommonTree POSTFIX62=null;
        CommonTree PAR65=null;
        TransformExpressions.expression_return e1 = null;

        TransformExpressions.expression_return e2 = null;

        TransformExpressions.expression_return e3 = null;

        TransformExpressions.expressionList_return expressionList39 = null;

        TransformExpressions.expressionList_return expressionList42 = null;

        TransformExpressions.identifier_return identifier44 = null;

        TransformExpressions.expression_return expression45 = null;

        TransformExpressions.identifier_return identifier47 = null;

        TransformExpressions.bandSpecifier_return bandSpecifier48 = null;

        TransformExpressions.pixelSpecifier_return pixelSpecifier49 = null;

        TransformExpressions.logicalOp_return logicalOp50 = null;

        TransformExpressions.expression_return expression51 = null;

        TransformExpressions.expression_return expression52 = null;

        TransformExpressions.arithmeticOp_return arithmeticOp53 = null;

        TransformExpressions.expression_return expression54 = null;

        TransformExpressions.expression_return expression55 = null;

        TransformExpressions.expression_return expression57 = null;

        TransformExpressions.expression_return expression58 = null;

        TransformExpressions.prefixOp_return prefixOp60 = null;

        TransformExpressions.expression_return expression61 = null;

        TransformExpressions.incdecOp_return incdecOp63 = null;

        TransformExpressions.expression_return expression64 = null;

        TransformExpressions.expression_return expression66 = null;

        TransformExpressions.listOperation_return listOperation67 = null;

        TransformExpressions.listLiteral_return listLiteral68 = null;

        TransformExpressions.literal_return literal69 = null;

        TransformExpressions.identifier_return identifier70 = null;


        CommonTree FUNC_CALL37_tree=null;
        CommonTree ID38_tree=null;
        CommonTree QUESTION40_tree=null;
        CommonTree IF_CALL41_tree=null;
        CommonTree IMAGE_WRITE43_tree=null;
        CommonTree IMAGE_POS46_tree=null;
        CommonTree POW56_tree=null;
        CommonTree PREFIX59_tree=null;
        CommonTree POSTFIX62_tree=null;
        CommonTree PAR65_tree=null;
        RewriteRuleNodeStream stream_QUESTION=new RewriteRuleNodeStream(adaptor,"token QUESTION");
        RewriteRuleNodeStream stream_ID=new RewriteRuleNodeStream(adaptor,"token ID");
        RewriteRuleNodeStream stream_FUNC_CALL=new RewriteRuleNodeStream(adaptor,"token FUNC_CALL");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_expressionList=new RewriteRuleSubtreeStream(adaptor,"rule expressionList");
        try {
            // jaitools/jiffle/parser/TransformExpressions.g:132:17: ( ^( FUNC_CALL ID expressionList ) -> {isProxy($ID.text)}? VAR_PROVIDED[ getRuntimeExpr($ID.text) ] -> ^( FUNC_CALL ID expressionList ) | ^( QUESTION e1= expression e2= expression e3= expression ) -> ^( IF_CALL ^( EXPR_LIST $e1 $e2 $e3) ) | ^( IF_CALL expressionList ) | ^( IMAGE_WRITE identifier expression ) | ^( IMAGE_POS identifier ( bandSpecifier )? ( pixelSpecifier )? ) | ^( logicalOp expression expression ) | ^( arithmeticOp expression expression ) | ^( POW expression expression ) | ^( PREFIX prefixOp expression ) | ^( POSTFIX incdecOp expression ) | ^( PAR expression ) | listOperation | listLiteral | literal | identifier )
            int alt12=15;
            switch ( input.LA(1) ) {
            case FUNC_CALL:
                {
                alt12=1;
                }
                break;
            case QUESTION:
                {
                alt12=2;
                }
                break;
            case IF_CALL:
                {
                alt12=3;
                }
                break;
            case IMAGE_WRITE:
                {
                alt12=4;
                }
                break;
            case IMAGE_POS:
                {
                alt12=5;
                }
                break;
            case OR:
            case XOR:
            case AND:
            case LOGICALEQ:
            case NE:
            case GT:
            case GE:
            case LE:
            case LT:
                {
                alt12=6;
                }
                break;
            case PLUS:
            case MINUS:
            case TIMES:
            case DIV:
            case MOD:
                {
                alt12=7;
                }
                break;
            case POW:
                {
                alt12=8;
                }
                break;
            case PREFIX:
                {
                alt12=9;
                }
                break;
            case POSTFIX:
                {
                alt12=10;
                }
                break;
            case PAR:
                {
                alt12=11;
                }
                break;
            case APPEND:
                {
                alt12=12;
                }
                break;
            case DECLARED_LIST:
                {
                alt12=13;
                }
                break;
            case INT_LITERAL:
            case FLOAT_LITERAL:
            case TRUE:
            case FALSE:
            case NULL:
                {
                alt12=14;
                }
                break;
            case CONSTANT:
            case VAR_DEST:
            case VAR_SOURCE:
            case VAR_IMAGE_SCOPE:
            case VAR_PIXEL_SCOPE:
            case VAR_LOOP:
            case VAR_LIST:
                {
                alt12=15;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // jaitools/jiffle/parser/TransformExpressions.g:132:19: ^( FUNC_CALL ID expressionList )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    FUNC_CALL37=(CommonTree)match(input,FUNC_CALL,FOLLOW_FUNC_CALL_in_expression825);  
                    stream_FUNC_CALL.add(FUNC_CALL37);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    ID38=(CommonTree)match(input,ID,FOLLOW_ID_in_expression827);  
                    stream_ID.add(ID38);

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expressionList_in_expression829);
                    expressionList39=expressionList();

                    state._fsp--;

                    stream_expressionList.add(expressionList39.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }

                     
                                    


                    // AST REWRITE
                    // elements: ID, FUNC_CALL, expressionList
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 135:19: -> {isProxy($ID.text)}? VAR_PROVIDED[ getRuntimeExpr($ID.text) ]
                    if (isProxy((ID38!=null?ID38.getText():null))) {
                        adaptor.addChild(root_0, (CommonTree)adaptor.create(VAR_PROVIDED, getRuntimeExpr((ID38!=null?ID38.getText():null))));

                    }
                    else // 136:19: -> ^( FUNC_CALL ID expressionList )
                    {
                        // jaitools/jiffle/parser/TransformExpressions.g:136:22: ^( FUNC_CALL ID expressionList )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_FUNC_CALL.nextNode(), root_1);

                        adaptor.addChild(root_1, stream_ID.nextNode());
                        adaptor.addChild(root_1, stream_expressionList.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;
                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TransformExpressions.g:139:19: ^( QUESTION e1= expression e2= expression e3= expression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    QUESTION40=(CommonTree)match(input,QUESTION,FOLLOW_QUESTION_in_expression944);  
                    stream_QUESTION.add(QUESTION40);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression948);
                    e1=expression();

                    state._fsp--;

                    stream_expression.add(e1.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression952);
                    e2=expression();

                    state._fsp--;

                    stream_expression.add(e2.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression956);
                    e3=expression();

                    state._fsp--;

                    stream_expression.add(e3.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }



                    // AST REWRITE
                    // elements: e3, e1, e2
                    // token labels: 
                    // rule labels: e3, retval, e1, e2
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_e3=new RewriteRuleSubtreeStream(adaptor,"rule e3",e3!=null?e3.tree:null);
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_e1=new RewriteRuleSubtreeStream(adaptor,"rule e1",e1!=null?e1.tree:null);
                    RewriteRuleSubtreeStream stream_e2=new RewriteRuleSubtreeStream(adaptor,"rule e2",e2!=null?e2.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 140:19: -> ^( IF_CALL ^( EXPR_LIST $e1 $e2 $e3) )
                    {
                        // jaitools/jiffle/parser/TransformExpressions.g:140:22: ^( IF_CALL ^( EXPR_LIST $e1 $e2 $e3) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(IF_CALL, "IF_CALL"), root_1);

                        // jaitools/jiffle/parser/TransformExpressions.g:140:32: ^( EXPR_LIST $e1 $e2 $e3)
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot((CommonTree)adaptor.create(EXPR_LIST, "EXPR_LIST"), root_2);

                        adaptor.addChild(root_2, stream_e1.nextTree());
                        adaptor.addChild(root_2, stream_e2.nextTree());
                        adaptor.addChild(root_2, stream_e3.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    retval.tree = root_0;
                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TransformExpressions.g:143:19: ^( IF_CALL expressionList )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IF_CALL41=(CommonTree)match(input,IF_CALL,FOLLOW_IF_CALL_in_expression1018); 
                    IF_CALL41_tree = (CommonTree)adaptor.dupNode(IF_CALL41);

                    root_1 = (CommonTree)adaptor.becomeRoot(IF_CALL41_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expressionList_in_expression1020);
                    expressionList42=expressionList();

                    state._fsp--;

                    adaptor.addChild(root_1, expressionList42.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TransformExpressions.g:144:19: ^( IMAGE_WRITE identifier expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IMAGE_WRITE43=(CommonTree)match(input,IMAGE_WRITE,FOLLOW_IMAGE_WRITE_in_expression1042); 
                    IMAGE_WRITE43_tree = (CommonTree)adaptor.dupNode(IMAGE_WRITE43);

                    root_1 = (CommonTree)adaptor.becomeRoot(IMAGE_WRITE43_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_expression1044);
                    identifier44=identifier();

                    state._fsp--;

                    adaptor.addChild(root_1, identifier44.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1046);
                    expression45=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression45.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 5 :
                    // jaitools/jiffle/parser/TransformExpressions.g:145:19: ^( IMAGE_POS identifier ( bandSpecifier )? ( pixelSpecifier )? )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    IMAGE_POS46=(CommonTree)match(input,IMAGE_POS,FOLLOW_IMAGE_POS_in_expression1068); 
                    IMAGE_POS46_tree = (CommonTree)adaptor.dupNode(IMAGE_POS46);

                    root_1 = (CommonTree)adaptor.becomeRoot(IMAGE_POS46_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_expression1070);
                    identifier47=identifier();

                    state._fsp--;

                    adaptor.addChild(root_1, identifier47.getTree());
                    // jaitools/jiffle/parser/TransformExpressions.g:145:42: ( bandSpecifier )?
                    int alt10=2;
                    switch ( input.LA(1) ) {
                        case BAND_REF:
                            {
                            alt10=1;
                            }
                            break;
                    }

                    switch (alt10) {
                        case 1 :
                            // jaitools/jiffle/parser/TransformExpressions.g:145:42: bandSpecifier
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_bandSpecifier_in_expression1072);
                            bandSpecifier48=bandSpecifier();

                            state._fsp--;

                            adaptor.addChild(root_1, bandSpecifier48.getTree());

                            }
                            break;

                    }

                    // jaitools/jiffle/parser/TransformExpressions.g:145:57: ( pixelSpecifier )?
                    int alt11=2;
                    switch ( input.LA(1) ) {
                        case PIXEL_REF:
                            {
                            alt11=1;
                            }
                            break;
                    }

                    switch (alt11) {
                        case 1 :
                            // jaitools/jiffle/parser/TransformExpressions.g:145:57: pixelSpecifier
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_pixelSpecifier_in_expression1075);
                            pixelSpecifier49=pixelSpecifier();

                            state._fsp--;

                            adaptor.addChild(root_1, pixelSpecifier49.getTree());

                            }
                            break;

                    }


                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 6 :
                    // jaitools/jiffle/parser/TransformExpressions.g:146:19: ^( logicalOp expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_logicalOp_in_expression1098);
                    logicalOp50=logicalOp();

                    state._fsp--;

                    root_1 = (CommonTree)adaptor.becomeRoot(logicalOp50.getTree(), root_1);


                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1100);
                    expression51=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression51.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1102);
                    expression52=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression52.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 7 :
                    // jaitools/jiffle/parser/TransformExpressions.g:147:19: ^( arithmeticOp expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_arithmeticOp_in_expression1124);
                    arithmeticOp53=arithmeticOp();

                    state._fsp--;

                    root_1 = (CommonTree)adaptor.becomeRoot(arithmeticOp53.getTree(), root_1);


                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1126);
                    expression54=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression54.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1128);
                    expression55=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression55.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 8 :
                    // jaitools/jiffle/parser/TransformExpressions.g:148:19: ^( POW expression expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    POW56=(CommonTree)match(input,POW,FOLLOW_POW_in_expression1150); 
                    POW56_tree = (CommonTree)adaptor.dupNode(POW56);

                    root_1 = (CommonTree)adaptor.becomeRoot(POW56_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1152);
                    expression57=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression57.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1154);
                    expression58=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression58.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 9 :
                    // jaitools/jiffle/parser/TransformExpressions.g:149:19: ^( PREFIX prefixOp expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    PREFIX59=(CommonTree)match(input,PREFIX,FOLLOW_PREFIX_in_expression1176); 
                    PREFIX59_tree = (CommonTree)adaptor.dupNode(PREFIX59);

                    root_1 = (CommonTree)adaptor.becomeRoot(PREFIX59_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_prefixOp_in_expression1178);
                    prefixOp60=prefixOp();

                    state._fsp--;

                    adaptor.addChild(root_1, prefixOp60.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1180);
                    expression61=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression61.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 10 :
                    // jaitools/jiffle/parser/TransformExpressions.g:150:19: ^( POSTFIX incdecOp expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    POSTFIX62=(CommonTree)match(input,POSTFIX,FOLLOW_POSTFIX_in_expression1202); 
                    POSTFIX62_tree = (CommonTree)adaptor.dupNode(POSTFIX62);

                    root_1 = (CommonTree)adaptor.becomeRoot(POSTFIX62_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_incdecOp_in_expression1204);
                    incdecOp63=incdecOp();

                    state._fsp--;

                    adaptor.addChild(root_1, incdecOp63.getTree());
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1206);
                    expression64=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression64.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 11 :
                    // jaitools/jiffle/parser/TransformExpressions.g:151:19: ^( PAR expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    PAR65=(CommonTree)match(input,PAR,FOLLOW_PAR_in_expression1228); 
                    PAR65_tree = (CommonTree)adaptor.dupNode(PAR65);

                    root_1 = (CommonTree)adaptor.becomeRoot(PAR65_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_expression1230);
                    expression66=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression66.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 12 :
                    // jaitools/jiffle/parser/TransformExpressions.g:152:19: listOperation
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_listOperation_in_expression1251);
                    listOperation67=listOperation();

                    state._fsp--;

                    adaptor.addChild(root_0, listOperation67.getTree());

                    }
                    break;
                case 13 :
                    // jaitools/jiffle/parser/TransformExpressions.g:153:19: listLiteral
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_listLiteral_in_expression1271);
                    listLiteral68=listLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, listLiteral68.getTree());

                    }
                    break;
                case 14 :
                    // jaitools/jiffle/parser/TransformExpressions.g:154:19: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_expression1291);
                    literal69=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal69.getTree());

                    }
                    break;
                case 15 :
                    // jaitools/jiffle/parser/TransformExpressions.g:155:19: identifier
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_identifier_in_expression1311);
                    identifier70=identifier();

                    state._fsp--;

                    adaptor.addChild(root_0, identifier70.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "expression"

    public static class listOperation_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "listOperation"
    // jaitools/jiffle/parser/TransformExpressions.g:159:1: listOperation : ^( APPEND VAR_LIST expression ) ;
    public final TransformExpressions.listOperation_return listOperation() throws RecognitionException {
        TransformExpressions.listOperation_return retval = new TransformExpressions.listOperation_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree APPEND71=null;
        CommonTree VAR_LIST72=null;
        TransformExpressions.expression_return expression73 = null;


        CommonTree APPEND71_tree=null;
        CommonTree VAR_LIST72_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:159:17: ( ^( APPEND VAR_LIST expression ) )
            // jaitools/jiffle/parser/TransformExpressions.g:159:19: ^( APPEND VAR_LIST expression )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            APPEND71=(CommonTree)match(input,APPEND,FOLLOW_APPEND_in_listOperation1340); 
            APPEND71_tree = (CommonTree)adaptor.dupNode(APPEND71);

            root_1 = (CommonTree)adaptor.becomeRoot(APPEND71_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            VAR_LIST72=(CommonTree)match(input,VAR_LIST,FOLLOW_VAR_LIST_in_listOperation1342); 
            VAR_LIST72_tree = (CommonTree)adaptor.dupNode(VAR_LIST72);

            adaptor.addChild(root_1, VAR_LIST72_tree);

            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_listOperation1344);
            expression73=expression();

            state._fsp--;

            adaptor.addChild(root_1, expression73.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listOperation"

    public static class listLiteral_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "listLiteral"
    // jaitools/jiffle/parser/TransformExpressions.g:163:1: listLiteral : ^( DECLARED_LIST expressionList ) ;
    public final TransformExpressions.listLiteral_return listLiteral() throws RecognitionException {
        TransformExpressions.listLiteral_return retval = new TransformExpressions.listLiteral_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DECLARED_LIST74=null;
        TransformExpressions.expressionList_return expressionList75 = null;


        CommonTree DECLARED_LIST74_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:163:17: ( ^( DECLARED_LIST expressionList ) )
            // jaitools/jiffle/parser/TransformExpressions.g:163:19: ^( DECLARED_LIST expressionList )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            DECLARED_LIST74=(CommonTree)match(input,DECLARED_LIST,FOLLOW_DECLARED_LIST_in_listLiteral1376); 
            DECLARED_LIST74_tree = (CommonTree)adaptor.dupNode(DECLARED_LIST74);

            root_1 = (CommonTree)adaptor.becomeRoot(DECLARED_LIST74_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expressionList_in_listLiteral1378);
            expressionList75=expressionList();

            state._fsp--;

            adaptor.addChild(root_1, expressionList75.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "listLiteral"

    public static class identifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "identifier"
    // jaitools/jiffle/parser/TransformExpressions.g:167:1: identifier : ( VAR_SOURCE | VAR_DEST | VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE | VAR_LOOP | VAR_LIST | CONSTANT );
    public final TransformExpressions.identifier_return identifier() throws RecognitionException {
        TransformExpressions.identifier_return retval = new TransformExpressions.identifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set76=null;

        CommonTree set76_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:167:17: ( VAR_SOURCE | VAR_DEST | VAR_IMAGE_SCOPE | VAR_PIXEL_SCOPE | VAR_LOOP | VAR_LIST | CONSTANT )
            // jaitools/jiffle/parser/TransformExpressions.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set76=(CommonTree)input.LT(1);
            if ( input.LA(1)==CONSTANT||(input.LA(1)>=VAR_DEST && input.LA(1)<=VAR_PIXEL_SCOPE)||(input.LA(1)>=VAR_LOOP && input.LA(1)<=VAR_LIST) ) {
                input.consume();

                set76_tree = (CommonTree)adaptor.dupNode(set76);

                adaptor.addChild(root_0, set76_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "identifier"

    public static class logicalOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "logicalOp"
    // jaitools/jiffle/parser/TransformExpressions.g:177:1: logicalOp : ( OR | XOR | AND | LOGICALEQ | NE | GT | GE | LT | LE );
    public final TransformExpressions.logicalOp_return logicalOp() throws RecognitionException {
        TransformExpressions.logicalOp_return retval = new TransformExpressions.logicalOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set77=null;

        CommonTree set77_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:177:17: ( OR | XOR | AND | LOGICALEQ | NE | GT | GE | LT | LE )
            // jaitools/jiffle/parser/TransformExpressions.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set77=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=OR && input.LA(1)<=LT) ) {
                input.consume();

                set77_tree = (CommonTree)adaptor.dupNode(set77);

                adaptor.addChild(root_0, set77_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "logicalOp"

    public static class arithmeticOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "arithmeticOp"
    // jaitools/jiffle/parser/TransformExpressions.g:189:1: arithmeticOp : ( PLUS | MINUS | TIMES | DIV | MOD );
    public final TransformExpressions.arithmeticOp_return arithmeticOp() throws RecognitionException {
        TransformExpressions.arithmeticOp_return retval = new TransformExpressions.arithmeticOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set78=null;

        CommonTree set78_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:189:17: ( PLUS | MINUS | TIMES | DIV | MOD )
            // jaitools/jiffle/parser/TransformExpressions.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set78=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=PLUS && input.LA(1)<=MOD) ) {
                input.consume();

                set78_tree = (CommonTree)adaptor.dupNode(set78);

                adaptor.addChild(root_0, set78_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "arithmeticOp"

    public static class prefixOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "prefixOp"
    // jaitools/jiffle/parser/TransformExpressions.g:197:1: prefixOp : ( PLUS | MINUS | NOT | incdecOp );
    public final TransformExpressions.prefixOp_return prefixOp() throws RecognitionException {
        TransformExpressions.prefixOp_return retval = new TransformExpressions.prefixOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PLUS79=null;
        CommonTree MINUS80=null;
        CommonTree NOT81=null;
        TransformExpressions.incdecOp_return incdecOp82 = null;


        CommonTree PLUS79_tree=null;
        CommonTree MINUS80_tree=null;
        CommonTree NOT81_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:197:17: ( PLUS | MINUS | NOT | incdecOp )
            int alt13=4;
            switch ( input.LA(1) ) {
            case PLUS:
                {
                alt13=1;
                }
                break;
            case MINUS:
                {
                alt13=2;
                }
                break;
            case NOT:
                {
                alt13=3;
                }
                break;
            case INCR:
            case DECR:
                {
                alt13=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 0, input);

                throw nvae;
            }

            switch (alt13) {
                case 1 :
                    // jaitools/jiffle/parser/TransformExpressions.g:197:19: PLUS
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    PLUS79=(CommonTree)match(input,PLUS,FOLLOW_PLUS_in_prefixOp1864); 
                    PLUS79_tree = (CommonTree)adaptor.dupNode(PLUS79);

                    adaptor.addChild(root_0, PLUS79_tree);


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TransformExpressions.g:198:19: MINUS
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    MINUS80=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_prefixOp1884); 
                    MINUS80_tree = (CommonTree)adaptor.dupNode(MINUS80);

                    adaptor.addChild(root_0, MINUS80_tree);


                    }
                    break;
                case 3 :
                    // jaitools/jiffle/parser/TransformExpressions.g:199:19: NOT
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    NOT81=(CommonTree)match(input,NOT,FOLLOW_NOT_in_prefixOp1904); 
                    NOT81_tree = (CommonTree)adaptor.dupNode(NOT81);

                    adaptor.addChild(root_0, NOT81_tree);


                    }
                    break;
                case 4 :
                    // jaitools/jiffle/parser/TransformExpressions.g:200:19: incdecOp
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_incdecOp_in_prefixOp1924);
                    incdecOp82=incdecOp();

                    state._fsp--;

                    adaptor.addChild(root_0, incdecOp82.getTree());

                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "prefixOp"

    public static class incdecOp_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "incdecOp"
    // jaitools/jiffle/parser/TransformExpressions.g:204:1: incdecOp : ( INCR | DECR );
    public final TransformExpressions.incdecOp_return incdecOp() throws RecognitionException {
        TransformExpressions.incdecOp_return retval = new TransformExpressions.incdecOp_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set83=null;

        CommonTree set83_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:204:17: ( INCR | DECR )
            // jaitools/jiffle/parser/TransformExpressions.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set83=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=INCR && input.LA(1)<=DECR) ) {
                input.consume();

                set83_tree = (CommonTree)adaptor.dupNode(set83);

                adaptor.addChild(root_0, set83_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "incdecOp"

    public static class pixelSpecifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pixelSpecifier"
    // jaitools/jiffle/parser/TransformExpressions.g:209:1: pixelSpecifier : ^( PIXEL_REF pixelPos pixelPos ) ;
    public final TransformExpressions.pixelSpecifier_return pixelSpecifier() throws RecognitionException {
        TransformExpressions.pixelSpecifier_return retval = new TransformExpressions.pixelSpecifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PIXEL_REF84=null;
        TransformExpressions.pixelPos_return pixelPos85 = null;

        TransformExpressions.pixelPos_return pixelPos86 = null;


        CommonTree PIXEL_REF84_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:209:17: ( ^( PIXEL_REF pixelPos pixelPos ) )
            // jaitools/jiffle/parser/TransformExpressions.g:209:19: ^( PIXEL_REF pixelPos pixelPos )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            PIXEL_REF84=(CommonTree)match(input,PIXEL_REF,FOLLOW_PIXEL_REF_in_pixelSpecifier2005); 
            PIXEL_REF84_tree = (CommonTree)adaptor.dupNode(PIXEL_REF84);

            root_1 = (CommonTree)adaptor.becomeRoot(PIXEL_REF84_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2007);
            pixelPos85=pixelPos();

            state._fsp--;

            adaptor.addChild(root_1, pixelPos85.getTree());
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pixelPos_in_pixelSpecifier2009);
            pixelPos86=pixelPos();

            state._fsp--;

            adaptor.addChild(root_1, pixelPos86.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelSpecifier"

    public static class bandSpecifier_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "bandSpecifier"
    // jaitools/jiffle/parser/TransformExpressions.g:213:1: bandSpecifier : ^( BAND_REF expression ) ;
    public final TransformExpressions.bandSpecifier_return bandSpecifier() throws RecognitionException {
        TransformExpressions.bandSpecifier_return retval = new TransformExpressions.bandSpecifier_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BAND_REF87=null;
        TransformExpressions.expression_return expression88 = null;


        CommonTree BAND_REF87_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:213:17: ( ^( BAND_REF expression ) )
            // jaitools/jiffle/parser/TransformExpressions.g:213:19: ^( BAND_REF expression )
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
            BAND_REF87=(CommonTree)match(input,BAND_REF,FOLLOW_BAND_REF_in_bandSpecifier2039); 
            BAND_REF87_tree = (CommonTree)adaptor.dupNode(BAND_REF87);

            root_1 = (CommonTree)adaptor.becomeRoot(BAND_REF87_tree, root_1);



            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_expression_in_bandSpecifier2041);
            expression88=expression();

            state._fsp--;

            adaptor.addChild(root_1, expression88.getTree());

            match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
            }


            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "bandSpecifier"

    public static class pixelPos_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "pixelPos"
    // jaitools/jiffle/parser/TransformExpressions.g:217:1: pixelPos : ( ^( ABS_POS expression ) | ^( REL_POS expression ) );
    public final TransformExpressions.pixelPos_return pixelPos() throws RecognitionException {
        TransformExpressions.pixelPos_return retval = new TransformExpressions.pixelPos_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ABS_POS89=null;
        CommonTree REL_POS91=null;
        TransformExpressions.expression_return expression90 = null;

        TransformExpressions.expression_return expression92 = null;


        CommonTree ABS_POS89_tree=null;
        CommonTree REL_POS91_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:217:17: ( ^( ABS_POS expression ) | ^( REL_POS expression ) )
            int alt14=2;
            switch ( input.LA(1) ) {
            case ABS_POS:
                {
                alt14=1;
                }
                break;
            case REL_POS:
                {
                alt14=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 14, 0, input);

                throw nvae;
            }

            switch (alt14) {
                case 1 :
                    // jaitools/jiffle/parser/TransformExpressions.g:217:19: ^( ABS_POS expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    ABS_POS89=(CommonTree)match(input,ABS_POS,FOLLOW_ABS_POS_in_pixelPos2076); 
                    ABS_POS89_tree = (CommonTree)adaptor.dupNode(ABS_POS89);

                    root_1 = (CommonTree)adaptor.becomeRoot(ABS_POS89_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_pixelPos2078);
                    expression90=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression90.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;
                case 2 :
                    // jaitools/jiffle/parser/TransformExpressions.g:218:19: ^( REL_POS expression )
                    {
                    root_0 = (CommonTree)adaptor.nil();

                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    CommonTree root_1 = (CommonTree)adaptor.nil();_last = (CommonTree)input.LT(1);
                    REL_POS91=(CommonTree)match(input,REL_POS,FOLLOW_REL_POS_in_pixelPos2100); 
                    REL_POS91_tree = (CommonTree)adaptor.dupNode(REL_POS91);

                    root_1 = (CommonTree)adaptor.becomeRoot(REL_POS91_tree, root_1);



                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_expression_in_pixelPos2102);
                    expression92=expression();

                    state._fsp--;

                    adaptor.addChild(root_1, expression92.getTree());

                    match(input, Token.UP, null); adaptor.addChild(root_0, root_1);_last = _save_last_1;
                    }


                    }
                    break;

            }
            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "pixelPos"

    public static class literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };

    // $ANTLR start "literal"
    // jaitools/jiffle/parser/TransformExpressions.g:222:1: literal : ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL );
    public final TransformExpressions.literal_return literal() throws RecognitionException {
        TransformExpressions.literal_return retval = new TransformExpressions.literal_return();
        retval.start = input.LT(1);

        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set93=null;

        CommonTree set93_tree=null;

        try {
            // jaitools/jiffle/parser/TransformExpressions.g:222:17: ( INT_LITERAL | FLOAT_LITERAL | TRUE | FALSE | NULL )
            // jaitools/jiffle/parser/TransformExpressions.g:
            {
            root_0 = (CommonTree)adaptor.nil();

            _last = (CommonTree)input.LT(1);
            set93=(CommonTree)input.LT(1);
            if ( (input.LA(1)>=INT_LITERAL && input.LA(1)<=NULL) ) {
                input.consume();

                set93_tree = (CommonTree)adaptor.dupNode(set93);

                adaptor.addChild(root_0, set93_tree);

                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

             

            }

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return retval;
    }
    // $ANTLR end "literal"

    // Delegated rules


 

    public static final BitSet FOLLOW_jiffleOption_in_start94 = new BitSet(new long[]{0xFFFF87041BF61FB0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_varDeclaration_in_start97 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_start100 = new BitSet(new long[]{0xFFFF87041BF61FA2L,0x000000000000F88FL});
    public static final BitSet FOLLOW_JIFFLE_OPTION_in_jiffleOption131 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_IMAGE_SCOPE_VAR_DECL_in_varDeclaration163 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_varDeclaration169 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BLOCK_in_block207 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_blockStatement_in_block209 = new BitSet(new long[]{0xFFFF87241BF61FA8L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_blockStatement238 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BREAKIF_in_blockStatement259 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_blockStatement261 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_block_in_statement294 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_assignmentExpression_in_statement314 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WHILE_in_statement335 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_loopCondition_in_statement337 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement339 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNTIL_in_statement361 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_loopCondition_in_statement363 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement365 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FOREACH_in_statement387 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_statement389 = new BitSet(new long[]{0x0000000010080080L});
    public static final BitSet FOLLOW_loopSet_in_statement391 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_statement_in_statement393 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_expression_in_statement414 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_loopCondition442 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SEQUENCE_in_loopSet477 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_loopSet479 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_loopSet481 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listLiteral_in_loopSet502 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VAR_LIST_in_loopSet522 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPR_LIST_in_expressionList573 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expressionList578 = new BitSet(new long[]{0xFFFF87041BF61FA8L,0x000000000000F88FL});
    public static final BitSet FOLLOW_assignmentOp_in_assignmentExpression648 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_assignmentExpression650 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_assignmentExpression652 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_assignmentOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNC_CALL_in_expression825 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ID_in_expression827 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_expressionList_in_expression829 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_QUESTION_in_expression944 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression948 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression952 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression956 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IF_CALL_in_expression1018 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_expression1020 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IMAGE_WRITE_in_expression1042 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_expression1044 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1046 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IMAGE_POS_in_expression1068 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_identifier_in_expression1070 = new BitSet(new long[]{0x0000000000006008L});
    public static final BitSet FOLLOW_bandSpecifier_in_expression1072 = new BitSet(new long[]{0x0000000000004008L});
    public static final BitSet FOLLOW_pixelSpecifier_in_expression1075 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_logicalOp_in_expression1098 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1100 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1102 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_arithmeticOp_in_expression1124 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1126 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1128 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POW_in_expression1150 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1152 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1154 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PREFIX_in_expression1176 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_prefixOp_in_expression1178 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1180 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_POSTFIX_in_expression1202 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_incdecOp_in_expression1204 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_expression1206 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PAR_in_expression1228 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_expression1230 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_listOperation_in_expression1251 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_listLiteral_in_expression1271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_expression1291 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identifier_in_expression1311 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_APPEND_in_listOperation1340 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VAR_LIST_in_listOperation1342 = new BitSet(new long[]{0xFFFF87041BF61FA0L,0x000000000000F88FL});
    public static final BitSet FOLLOW_expression_in_listOperation1344 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DECLARED_LIST_in_listLiteral1376 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expressionList_in_listLiteral1378 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_identifier0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_logicalOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_arithmeticOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PLUS_in_prefixOp1864 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_MINUS_in_prefixOp1884 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_prefixOp1904 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_incdecOp_in_prefixOp1924 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_incdecOp0 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PIXEL_REF_in_pixelSpecifier2005 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2007 = new BitSet(new long[]{0x0000000000018000L});
    public static final BitSet FOLLOW_pixelPos_in_pixelSpecifier2009 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BAND_REF_in_bandSpecifier2039 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_bandSpecifier2041 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_POS_in_pixelPos2076 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos2078 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_REL_POS_in_pixelPos2100 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_expression_in_pixelPos2102 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_literal0 = new BitSet(new long[]{0x0000000000000002L});

}