/*
 * Decompiled with CFR 0.152.
 */
package jaitools.imageutils;

import jaitools.imageutils.FillResult;
import jaitools.numeric.DoubleComparison;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;

public class FloodFiller {
    private RandomIter srcIter;
    private WritableRenderedImage destImage;
    private Rectangle destBounds;
    private int fillValue;
    private double tolerance;
    private boolean diagonal;
    private double refValue;
    private int srcBand;
    private int destBand;
    private double fillRadius;
    private boolean usingRadius;
    private ROI roi;
    private Queue<ScanSegment> segmentsPending;
    private List<ScanSegment> segmentsFilled;
    private ScanSegment lastSegmentChecked;

    public FloodFiller(RenderedImage sourceImage, int sourceBand, WritableRenderedImage destImage, int destBand, double tolerance, boolean diagonal) {
        this.srcBand = sourceBand;
        this.destImage = destImage;
        this.destBand = destBand;
        this.tolerance = tolerance;
        this.diagonal = diagonal;
        if (destImage instanceof PlanarImage) {
            this.destBounds = ((PlanarImage)destImage).getBounds();
        } else if (destImage instanceof BufferedImage) {
            BufferedImage bImg = (BufferedImage)destImage;
            this.destBounds = new Rectangle(bImg.getMinX(), bImg.getMinY(), bImg.getWidth(), bImg.getHeight());
        } else {
            throw new IllegalArgumentException("regionImage arg must be a PlanarImage or a BufferedImage");
        }
        this.srcIter = RandomIterFactory.create((RenderedImage)sourceImage, null);
    }

    public FillResult fill(int x, int y, int fillValue) {
        return this.fill(x, y, fillValue, this.srcIter.getSampleDouble(x, y, this.srcBand));
    }

    public FillResult fillRadius(int x, int y, int fillValue, double radius) {
        return this.fillRadius(x, y, fillValue, this.srcIter.getSampleDouble(x, y, this.srcBand), radius);
    }

    public FillResult fill(int x, int y, int fillValue, double refValue) {
        return this.fillRadius(x, y, fillValue, refValue, Double.NaN);
    }

    public FillResult fillRadius(int x, int y, int fillValue, double refValue, double radius) {
        ScanSegment segment;
        this.fillValue = fillValue;
        this.refValue = refValue;
        this.fillRadius = radius;
        if (!Double.isNaN(radius)) {
            Ellipse2D.Double shp = new Ellipse2D.Double((double)x - radius, (double)y - radius, 2.0 * radius, 2.0 * radius);
            this.roi = new ROIShape((Shape)shp);
            this.roi = this.roi.intersect((ROI)new ROIShape((Shape)this.destBounds));
        } else {
            this.roi = new ROIShape((Shape)this.destBounds);
        }
        WritableRandomIter destIter = RandomIterFactory.createWritable((WritableRenderedImage)this.destImage, null);
        this.segmentsPending = new LinkedList<ScanSegment>();
        this.segmentsFilled = new ArrayList<ScanSegment>();
        this.fillSegment(x, y, destIter);
        while ((segment = this.segmentsPending.poll()) != null) {
            ScanSegment newSegment;
            int xi;
            int endX;
            int startX;
            if (this.diagonal) {
                startX = segment.startX - 1;
                endX = segment.endX + 1;
            } else {
                startX = segment.startX;
                endX = segment.endX;
            }
            if (segment.y > this.destBounds.y) {
                xi = startX;
                while (xi <= endX) {
                    newSegment = this.fillSegment(xi, segment.y - 1, destIter);
                    xi = newSegment != null ? newSegment.endX + 1 : xi + 1;
                }
            }
            if (segment.y >= this.destBounds.y + this.destBounds.height - 1) continue;
            xi = startX;
            while (xi <= endX) {
                newSegment = this.fillSegment(xi, segment.y + 1, destIter);
                xi = newSegment != null ? newSegment.endX + 1 : xi + 1;
            }
        }
        destIter.done();
        return new FillResult(fillValue, refValue, this.segmentsFilled);
    }

    private ScanSegment fillSegment(int x, int y, WritableRandomIter destIter) {
        if (!this.roi.contains(x, y)) {
            return null;
        }
        boolean fill = false;
        ScanSegment segment = null;
        int left = x;
        int right = x;
        int xi = x;
        while (this.roi.contains(xi, y) && this.checkPixel(xi, y)) {
            destIter.setSample(xi, y, this.destBand, this.fillValue);
            fill = true;
            left = xi--;
        }
        if (!fill) {
            return null;
        }
        xi = x + 1;
        while (this.roi.contains(xi, y) && this.checkPixel(xi, y)) {
            destIter.setSample(xi, y, this.destBand, this.fillValue);
            right = xi++;
        }
        segment = new ScanSegment(left, right, y);
        this.segmentsFilled.add(segment);
        this.segmentsPending.offer(segment);
        return segment;
    }

    private boolean checkPixel(int x, int y) {
        if (this.lastSegmentChecked != null && this.lastSegmentChecked.contains(x, y)) {
            return false;
        }
        for (ScanSegment segment : this.segmentsFilled) {
            if (!segment.contains(x, y)) continue;
            this.lastSegmentChecked = segment;
            return false;
        }
        this.lastSegmentChecked = null;
        double val = this.srcIter.getSampleDouble(x, y, this.srcBand);
        return DoubleComparison.dcomp(Math.abs(val - this.refValue), this.tolerance) <= 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScanSegment
    implements Comparable<ScanSegment> {
        int startX;
        int endX;
        int y;

        public ScanSegment(int startX, int endX, int y) {
            this.startX = startX;
            this.endX = endX;
            this.y = y;
        }

        public boolean contains(int x, int y) {
            return this.y == y && this.startX <= x && this.endX >= x;
        }

        @Override
        public int compareTo(ScanSegment other) {
            if (this.y < other.y) {
                return -1;
            }
            if (this.y > other.y) {
                return 1;
            }
            if (this.startX < other.startX) {
                return -1;
            }
            if (this.startX > other.startX) {
                return 1;
            }
            if (this.endX < other.endX) {
                return -1;
            }
            if (this.endX > other.endX) {
                return 1;
            }
            return 0;
        }
    }
}

