/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle;

import jaitools.CollectionFactory;
import jaitools.jiffle.JiffleException;
import jaitools.jiffle.JiffleProperties;
import jaitools.jiffle.parser.CheckAssignments;
import jaitools.jiffle.parser.CheckFunctionCalls;
import jaitools.jiffle.parser.JiffleLexer;
import jaitools.jiffle.parser.JiffleParser;
import jaitools.jiffle.parser.JiffleParserException;
import jaitools.jiffle.parser.Message;
import jaitools.jiffle.parser.MessageTable;
import jaitools.jiffle.parser.OptionsBlockReader;
import jaitools.jiffle.parser.ParsingErrorReporter;
import jaitools.jiffle.parser.RuntimeSourceGenerator;
import jaitools.jiffle.parser.TagVars;
import jaitools.jiffle.parser.TransformExpressions;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import jaitools.jiffle.runtime.JiffleIndirectRuntime;
import jaitools.jiffle.runtime.JiffleRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.codehaus.janino.SimpleCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jiffle {
    private static int refCount = 0;
    private String name;
    private String theScript;
    private CommonTree primaryAST;
    private Map<String, String> scriptOptions;
    private CommonTree finalAST;
    private CommonTokenStream tokens;
    private ParsingErrorReporter errorReporter;
    private Map<String, ImageRole> imageParams;
    private MessageTable msgTable;

    public Jiffle() {
        this.init();
    }

    public Jiffle(String script, Map<String, ImageRole> params) throws JiffleException {
        this.init();
        this.setScript(script);
        this.setImageParams(params);
        this.compile();
    }

    public Jiffle(File scriptFile, Map<String, ImageRole> params) throws JiffleException {
        this.init();
        this.setScript(scriptFile);
        this.setImageParams(params);
        this.compile();
    }

    public final void setScript(String script) throws JiffleException {
        if (script == null || script.trim().length() == 0) {
            throw new JiffleException("script is empty !");
        }
        if (this.theScript != null) {
            this.clearCompiledObjects();
        }
        this.theScript = script + "\n";
    }

    public final void setScript(File scriptFile) throws JiffleException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(scriptFile));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                sb.append(line);
                sb.append('\n');
            }
            this.setScript(sb.toString());
        }
        catch (IOException ex) {
            throw new JiffleException("Could not read the script file", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public String getScript() {
        return this.theScript == null ? "" : this.theScript;
    }

    public final void setImageParams(Map<String, ImageRole> params) {
        this.imageParams.clear();
        this.imageParams.putAll(params);
    }

    public Map<String, ImageRole> getImageParams() {
        return Collections.unmodifiableMap(this.imageParams);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void compile() throws JiffleException {
        if (this.theScript == null) {
            throw new JiffleException("No script has been set");
        }
        if (this.imageParams.isEmpty()) {
            throw new JiffleException("No image parameters set");
        }
        this.clearCompiledObjects();
        this.buildPrimaryAST();
        this.checkOptions();
        this.reportMessages();
        if (!this.transformAndCheckVars()) {
            throw new JiffleException(this.messagesToString());
        }
    }

    public boolean isCompiled() {
        return this.finalAST != null;
    }

    public JiffleDirectRuntime getRuntimeInstance() throws JiffleException {
        return (JiffleDirectRuntime)this.createRuntimeInstance(RuntimeModel.DIRECT, JiffleProperties.DEFAULT_DIRECT_BASE_CLASS);
    }

    public JiffleRuntime getRuntimeInstance(RuntimeModel model) throws JiffleException {
        switch (model) {
            case DIRECT: {
                return this.createRuntimeInstance(model, JiffleProperties.DEFAULT_DIRECT_BASE_CLASS);
            }
            case INDIRECT: {
                return this.createRuntimeInstance(model, JiffleProperties.DEFAULT_INDIRECT_BASE_CLASS);
            }
        }
        throw new IllegalArgumentException("Invalid runtime class type: " + (Object)((Object)model));
    }

    public <T extends JiffleRuntime> T getRuntimeInstance(Class<T> baseClass) throws JiffleException {
        RuntimeModel model = RuntimeModel.get(baseClass);
        if (model == null) {
            throw new JiffleException(baseClass.getName() + " does not implement a required Jiffle runtime interface");
        }
        return (T)this.createRuntimeInstance(model, baseClass);
    }

    public String getRuntimeSource(RuntimeModel model, boolean scriptInDocs) throws JiffleException {
        Class<? extends JiffleRuntime> baseClass = null;
        switch (model) {
            case DIRECT: {
                baseClass = JiffleProperties.DEFAULT_DIRECT_BASE_CLASS;
                break;
            }
            case INDIRECT: {
                baseClass = JiffleProperties.DEFAULT_INDIRECT_BASE_CLASS;
            }
        }
        return this.createRuntimeSource(model, baseClass.getName(), scriptInDocs);
    }

    private void init() {
        this.name = JiffleProperties.get("root.name") + ++refCount;
        this.imageParams = CollectionFactory.map();
    }

    private void clearCompiledObjects() {
        this.primaryAST = null;
        this.finalAST = null;
        this.tokens = null;
        this.errorReporter = null;
        this.msgTable = new MessageTable();
    }

    private void reportMessages() throws JiffleException {
        if (this.msgTable.hasErrors()) {
            throw new JiffleException(this.messagesToString());
        }
        if (this.msgTable.hasWarnings()) {
            Map<String, List<Message>> messages = this.msgTable.getMessages();
            System.err.println(this.messagesToString());
        }
    }

    private String messagesToString() {
        StringBuilder sb = new StringBuilder();
        if (this.msgTable != null) {
            Map<String, List<Message>> messages = this.msgTable.getMessages();
            for (String key : messages.keySet()) {
                for (Message msg : messages.get(key)) {
                    sb.append(msg.toString());
                    sb.append(": ");
                    sb.append(key);
                    sb.append("\n");
                }
            }
        }
        return sb.toString();
    }

    private void buildPrimaryAST() throws JiffleException {
        try {
            ANTLRStringStream input = new ANTLRStringStream(this.theScript);
            JiffleLexer lexer = new JiffleLexer((CharStream)input);
            this.tokens = new CommonTokenStream((TokenSource)lexer);
            JiffleParser parser = new JiffleParser((TokenStream)this.tokens);
            this.primaryAST = (CommonTree)parser.prog().getTree();
        }
        catch (RecognitionException ex) {
            throw new JiffleException("error in script at or around line:" + ex.line + " col:" + ex.charPositionInLine);
        }
    }

    private void checkOptions() {
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)this.primaryAST);
        nodes.setTokenStream((TokenStream)this.tokens);
        OptionsBlockReader reader = new OptionsBlockReader((TreeNodeStream)nodes, this.msgTable);
        reader.downup(this.primaryAST);
    }

    private boolean transformAndCheckVars() throws JiffleException {
        try {
            CommonTree tree = this.primaryAST;
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)this.tokens);
            TagVars tag = new TagVars((TreeNodeStream)nodes, this.imageParams, this.msgTable);
            tree = (CommonTree)tag.start().getTree();
            if (this.msgTable.hasErrors()) {
                return false;
            }
            nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)this.tokens);
            CheckAssignments assignments = new CheckAssignments((TreeNodeStream)nodes, this.msgTable);
            assignments.start();
            if (this.msgTable.hasErrors()) {
                return false;
            }
            nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)this.tokens);
            TransformExpressions trexpr = new TransformExpressions((TreeNodeStream)nodes);
            tree = (CommonTree)trexpr.start().getTree();
            nodes = new CommonTreeNodeStream((Object)tree);
            nodes.setTokenStream((TokenStream)this.tokens);
            CheckFunctionCalls calls = new CheckFunctionCalls((TreeNodeStream)nodes, this.msgTable);
            calls.downup(tree);
            if (this.msgTable.hasErrors()) {
                return false;
            }
            this.finalAST = tree;
            return true;
        }
        catch (RecognitionException ex) {
            throw new JiffleException("error in script at or around line:" + ex.line + " col:" + ex.charPositionInLine);
        }
        catch (JiffleParserException ex) {
            throw new JiffleException(ex);
        }
    }

    private JiffleRuntime createRuntimeInstance(RuntimeModel model, Class<? extends JiffleRuntime> baseClass) throws JiffleException {
        if (!this.isCompiled()) {
            throw new JiffleException("The script has not been compiled");
        }
        String runtimeSource = this.createRuntimeSource(model, baseClass.getName(), false);
        try {
            SimpleCompiler compiler = new SimpleCompiler();
            compiler.cook(runtimeSource);
            StringBuilder sb = new StringBuilder();
            sb.append(JiffleProperties.get("runtime.package")).append(".");
            switch (model) {
                case DIRECT: {
                    sb.append(JiffleProperties.get("direct.class"));
                    break;
                }
                case INDIRECT: {
                    sb.append(JiffleProperties.get("indirect.class"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Internal compiler error");
                }
            }
            Class<?> clazz = compiler.getClassLoader().loadClass(sb.toString());
            return (JiffleRuntime)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new JiffleException("Runtime source error", ex);
        }
    }

    private String createRuntimeSource(RuntimeModel model, String baseClassName, boolean scriptInDocs) throws JiffleException {
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)this.finalAST);
        nodes.setTokenStream((TokenStream)this.tokens);
        RuntimeSourceGenerator generator = new RuntimeSourceGenerator((TreeNodeStream)nodes);
        generator.setBaseClassName(baseClassName);
        generator.setRuntimeModel(model);
        return generator.getSource();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageRole {
        SOURCE,
        DEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RuntimeModel {
        DIRECT(JiffleDirectRuntime.class),
        INDIRECT(JiffleIndirectRuntime.class);

        private Class<? extends JiffleRuntime> runtimeClass;

        private RuntimeModel(Class<? extends JiffleRuntime> clazz) {
            this.runtimeClass = clazz;
        }

        public Class<? extends JiffleRuntime> getRuntimeClass() {
            return this.runtimeClass;
        }

        public static RuntimeModel get(Class<? extends JiffleRuntime> clazz) {
            for (RuntimeModel t : RuntimeModel.values()) {
                if (!t.runtimeClass.isAssignableFrom(clazz)) continue;
                return t;
            }
            return null;
        }
    }
}

