/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle;

import jaitools.CollectionFactory;
import jaitools.imageutils.ImageUtils;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.JiffleException;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.media.jai.TiledImage;

public class JiffleBuilder {
    private String script;
    private final Map<String, Jiffle.ImageRole> imageParams = CollectionFactory.orderedMap();
    private final Map<String, ImageRef> images = CollectionFactory.orderedMap();

    public void clear() {
        this.script = null;
        this.imageParams.clear();
        this.images.clear();
    }

    public JiffleBuilder script(String script) {
        this.script = script;
        return this;
    }

    public JiffleBuilder script(File scriptFile) throws JiffleException {
        this.script = this.readScriptFile(scriptFile);
        return this;
    }

    public JiffleBuilder source(String varName, RenderedImage sourceImage) {
        this.imageParams.put(varName, Jiffle.ImageRole.SOURCE);
        this.images.put(varName, new ImageRef(sourceImage, true));
        return this;
    }

    public JiffleBuilder dest(String varName, Rectangle destBounds) {
        if (destBounds == null || destBounds.isEmpty()) {
            throw new IllegalArgumentException("destBounds argument cannot be null or empty");
        }
        return this.dest(varName, destBounds.x, destBounds.y, destBounds.width, destBounds.height);
    }

    public JiffleBuilder dest(String varName, int width, int height) {
        return this.dest(varName, 0, 0, width, height);
    }

    public JiffleBuilder dest(String varName, int minx, int miny, int width, int height) {
        TiledImage image = ImageUtils.createConstantImage(minx, miny, width, height, 0.0);
        this.imageParams.put(varName, Jiffle.ImageRole.DEST);
        this.images.put(varName, new ImageRef((RenderedImage)image, false));
        return this;
    }

    public JiffleBuilder dest(String varName, WritableRenderedImage destImage) {
        this.imageParams.put(varName, Jiffle.ImageRole.DEST);
        this.images.put(varName, new ImageRef(destImage, true));
        return this;
    }

    public JiffleBuilder run() throws JiffleException {
        this.getRuntime().evaluateAll(null);
        return this;
    }

    public JiffleDirectRuntime getRuntime() throws JiffleException {
        if (this.script == null) {
            throw new IllegalStateException("Jiffle script has not been set yet");
        }
        Jiffle jiffle = new Jiffle(this.script, this.imageParams);
        JiffleDirectRuntime runtime = jiffle.getRuntimeInstance();
        for (String var : this.images.keySet()) {
            RenderedImage img = this.images.get(var).get();
            if (img == null) {
                throw new JiffleException("Image for variable " + var + " has been garbage collected");
            }
            switch (this.imageParams.get(var)) {
                case SOURCE: {
                    runtime.setSourceImage(var, img);
                    break;
                }
                case DEST: {
                    runtime.setDestinationImage(var, (WritableRenderedImage)img);
                }
            }
        }
        return runtime;
    }

    public RenderedImage getImage(String varName) {
        ImageRef ref = this.images.get(varName);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public RenderedImage removeImage(String varName) {
        ImageRef ref = this.images.remove(varName);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    private String readScriptFile(File scriptFile) throws JiffleException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(scriptFile));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                sb.append(line);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            throw new JiffleException("Could not read the script file", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static class ImageRef {
        Object ref;
        boolean weak;

        ImageRef(RenderedImage image, boolean weak) {
            this.ref = weak ? new WeakReference<RenderedImage>(image) : image;
            this.weak = weak;
        }

        RenderedImage get() {
            if (this.weak) {
                RenderedImage image = (RenderedImage)((WeakReference)this.ref).get();
                return image;
            }
            return (RenderedImage)this.ref;
        }
    }
}

