/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.parser;

import jaitools.CollectionFactory;
import jaitools.jiffle.Jiffle;
import jaitools.jiffle.JiffleException;
import jaitools.jiffle.JiffleProperties;
import jaitools.jiffle.parser.DeferredErrorReporter;
import jaitools.jiffle.parser.ErrorHandlingTreeParser;
import jaitools.jiffle.parser.FunctionLookup;
import jaitools.jiffle.parser.OptionLookup;
import jaitools.jiffle.parser.SourceGenerator;
import jaitools.jiffle.parser.UndefinedFunctionException;
import jaitools.jiffle.parser.UndefinedOptionException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplateGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceGenerator
extends ErrorHandlingTreeParser
implements SourceGenerator {
    protected Jiffle.RuntimeModel model;
    protected String pkgName = JiffleProperties.get("runtime.package");
    protected List<String> imports = CollectionFactory.list();
    protected String className;
    protected String baseClassName;
    protected int varIndex = 0;

    public AbstractSourceGenerator(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }

    protected AbstractSourceGenerator(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
        String value = JiffleProperties.get("runtime.imports");
        if (value != null && value.trim().length() != 0) {
            this.imports.addAll(Arrays.asList(value.split(";")));
        }
    }

    @Override
    public void setRuntimeModel(Jiffle.RuntimeModel model) {
        this.model = model;
        switch (model) {
            case DIRECT: {
                this.className = JiffleProperties.get("direct.class");
                break;
            }
            case INDIRECT: {
                this.className = JiffleProperties.get("indirect.class");
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal compiler error");
            }
        }
    }

    @Override
    public void setBaseClassName(String baseClassName) {
        this.baseClassName = baseClassName;
    }

    @Override
    public String getSource() throws JiffleException {
        if (this.model == null) {
            throw new RuntimeException("Runtime model has not been set");
        }
        if (this.baseClassName == null || this.baseClassName.trim().length() == 0) {
            throw new RuntimeException("Base class name has not been set");
        }
        String commonTemplateFile = JiffleProperties.get("common.source.templates");
        String modelTemplateFile = null;
        switch (this.model) {
            case DIRECT: {
                modelTemplateFile = JiffleProperties.get("direct.source.templates");
                break;
            }
            case INDIRECT: {
                modelTemplateFile = JiffleProperties.get("indirect.source.templates");
            }
        }
        try {
            InputStream strm = AbstractSourceGenerator.class.getResourceAsStream(commonTemplateFile);
            InputStreamReader reader = new InputStreamReader(strm);
            StringTemplateGroup commonSTG = new StringTemplateGroup(reader);
            reader.close();
            strm = AbstractSourceGenerator.class.getResourceAsStream(modelTemplateFile);
            reader = new InputStreamReader(strm);
            StringTemplateGroup modelSTG = new StringTemplateGroup(reader);
            this.setTemplateLib(modelSTG);
            reader.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.setErrorReporter(new DeferredErrorReporter());
            return this.generate().getTemplate().toString();
        }
        catch (RecognitionException ex) {
            if (this.errorReporter != null && this.errorReporter.getNumErrors() > 0) {
                throw new JiffleException(this.errorReporter.getErrors());
            }
            throw new JiffleException("Error creating runtime source. No details available.");
        }
    }

    protected abstract RuleReturnScope generate() throws RecognitionException;

    public abstract void setTemplateLib(StringTemplateGroup var1);

    protected String getRuntimeExpr(String name, List<String> argTypes) {
        try {
            return FunctionLookup.getRuntimeExpr(name, argTypes);
        }
        catch (UndefinedFunctionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected String getRuntimeExpr(String name, String ... argTypes) {
        return this.getRuntimeExpr(name, Arrays.asList(argTypes));
    }

    protected String getOptionExpr(String name, String value) {
        try {
            return OptionLookup.getActiveRuntimExpr(name, value);
        }
        catch (UndefinedOptionException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    protected void addImport(String ... importNames) {
        for (String name : importNames) {
            boolean found = false;
            for (String imp : this.imports) {
                if (!imp.equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.imports.add(name);
        }
    }
}

