/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.parser;

import jaitools.CollectionFactory;
import java.util.Map;

public class ConstantLookup {
    private static final Map<String, Double> constants = CollectionFactory.map();

    public static boolean isDefined(String name) {
        return constants.containsKey(name);
    }

    public static double getValue(String name) {
        Double value = constants.get(name);
        if (value == null) {
            throw new IllegalArgumentException("Unknown constant: " + name);
        }
        return value;
    }

    static {
        constants.put("M_E", Math.E);
        constants.put("M_PI", Math.PI);
        constants.put("M_PI_2", 1.5707963267948966);
        constants.put("M_PI_4", 0.7853981633974483);
        constants.put("M_SQRT2", Math.sqrt(2.0));
        constants.put("M_NaN", Double.NaN);
        constants.put("M_NAN", Double.NaN);
        constants.put("NaN", Double.NaN);
        constants.put("NAN", Double.NaN);
    }
}

