/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.parser;

import jaitools.CollectionFactory;
import jaitools.jiffle.parser.FunctionInfo;
import jaitools.jiffle.parser.UndefinedFunctionException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionLookup {
    private static final String PROPERTIES_FILE = "META-INF/jiffle/FunctionLookup.properties";
    private static final List<FunctionInfo> lookup = CollectionFactory.list();
    private static final int JIFFLE_NAME = 0;
    private static final int RUNTIME_NAME = 1;
    private static final int PROVIDER = 2;
    private static final int VOLATILE = 3;
    private static final int RETURN = 4;
    private static final int FIRST_ARG = 5;
    private static final int MIN_ATTRIBUTES = 6;

    public static boolean isDefined(String jiffleName, List<String> argTypes) {
        try {
            FunctionLookup.getInfo(jiffleName, argTypes);
        }
        catch (UndefinedFunctionException ex) {
            return false;
        }
        return true;
    }

    public static FunctionInfo getInfo(String jiffleName, List<String> argTypes) throws UndefinedFunctionException {
        for (FunctionInfo info : lookup) {
            if (!info.matches(jiffleName, argTypes)) continue;
            return info;
        }
        throw new UndefinedFunctionException("Unrecognized function: " + jiffleName);
    }

    public static String getRuntimeExpr(String jiffleName, List<String> argTypes) throws UndefinedFunctionException {
        return FunctionLookup.getInfo(jiffleName, argTypes).getRuntimeExpr();
    }

    public static String getReturnType(String jiffleName) throws UndefinedFunctionException {
        for (FunctionInfo info : lookup) {
            if (!info.getJiffleName().equals(jiffleName)) continue;
            return info.getReturnType();
        }
        throw new UndefinedFunctionException(jiffleName);
    }

    static {
        InputStream in = null;
        try {
            in = FunctionLookup.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);
            Properties properties = new Properties();
            properties.load(in);
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = properties.getProperty(name);
                String[] attr = value.split("[,\\s]+");
                if (attr.length < 6) {
                    throw new IllegalArgumentException("Error reading META-INF/jiffle/FunctionLookup.properties record: " + name + "=" + value);
                }
                FunctionInfo.Provider provider = FunctionInfo.Provider.get(attr[2]);
                if (provider == null) {
                    throw new IllegalArgumentException("Unrecognized Jiffle function provider (" + attr[2] + ") in " + PROPERTIES_FILE);
                }
                boolean isVolatile = Boolean.parseBoolean(attr[3]);
                int numArgs = "0".equals(attr[5]) ? 0 : attr.length - 5;
                String[] argTypes = new String[numArgs];
                int i = 0;
                int k = 5;
                while (i < numArgs) {
                    argTypes[i] = attr[k];
                    ++i;
                    ++k;
                }
                lookup.add(new FunctionInfo(attr[0], attr[1], provider, isVolatile, attr[4], argTypes));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Internal compiler error", ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

