/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.parser;

import jaitools.jiffle.parser.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Message {
    ASSIGNMENT_TO_SRC_IMAGE(Level.ERROR, "Cannot assign a value to a non-destination image"),
    ASSIGNMENT_TO_LOOP_VAR(Level.ERROR, "Cannot assign a new value to a loop variable"),
    ASSIGNMENT_LIST_TO_SCALAR(Level.ERROR, "Cannot assign a list to a scalar variable"),
    ASSIGNMENT_SCALAR_TO_LIST(Level.ERROR, "Cannot assign a scalar to a list variable"),
    CONSTANT_LHS(Level.ERROR, "Constant on the left hand side of an expression"),
    IMAGE_NOT_USED(Level.WARNING, "Image variable is defined but not used"),
    IMAGE_VAR_INIT_LHS(Level.ERROR, "A value cannot be assigned to an image var in the init block"),
    INVALID_ASSIGNMENT_OP_WITH_DEST_IMAGE(Level.ERROR, "Invalid assignment op with destination image"),
    INVALID_OPERATION_FOR_LIST(Level.ERROR, "Invalid operation for list variable"),
    INVALID_OPTION(Level.WARNING, "Unrecognized option"),
    INVALID_OPTION_VALUE(Level.WARNING, "Invalid option value ignored"),
    IMAGE_POS_ON_DEST(Level.ERROR, "Image position cannot be specified for a destination image"),
    IMAGE_POS_ON_NON_IMAGE(Level.ERROR, "Image position specifier(s) used with a non-image variable"),
    NON_LIST_FUNCTION(Level.ERROR, "List argument cannot be used with this function"),
    READING_FROM_DEST_IMAGE(Level.ERROR, "Cannot read a value from a destination image"),
    SRC_IMAGE_IN_INIT_BLOCK(Level.ERROR, "Source images cannot be referenced in an init block"),
    UNDECLARED_LIST_VAR(Level.ERROR, "List variable has not been declared"),
    UNDEFINED_FUNCTION(Level.ERROR, "Call to undefined function"),
    UNINIT_VAR(Level.ERROR, "Variable used before being assigned a value");

    private Level level;
    private String desc;

    private Message(Level level, String desc) {
        this.level = level;
        this.desc = desc;
    }

    public boolean isError() {
        return this.level == Level.ERROR;
    }

    public boolean isWarning() {
        return this.level == Level.WARNING;
    }

    public String toString() {
        if (this.isError()) {
            return "Error: " + this.desc;
        }
        return "Warning: " + this.desc;
    }
}

