/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.BufferedTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public final class MultiChannelTokenStream
extends BufferedTokenStream {
    protected final List<Integer> activeChannels = new ArrayList<Integer>();

    public MultiChannelTokenStream(TokenSource tokenSource) {
        super(tokenSource);
        this.addActiveChannel(0);
    }

    public MultiChannelTokenStream(TokenSource tokenSource, int[] channels) {
        super(tokenSource);
        for (int i = 0; i < channels.length; ++i) {
            this.addActiveChannel(channels[i]);
        }
    }

    public void consume() {
        if (this.p == -1) {
            this.setup();
        }
        ++this.p;
        this.sync(this.p);
        while (!this.isActiveChannel(((Token)this.tokens.get(this.p)).getChannel())) {
            ++this.p;
            this.sync(this.p);
        }
    }

    protected Token LB(int k) {
        if (k == 0 || this.p - k < 0) {
            return null;
        }
        int i = this.p;
        for (int n = 1; n <= k; ++n) {
            i = this.skipOffTokenChannelsReverse(i - 1);
        }
        if (i < 0) {
            return null;
        }
        return (Token)this.tokens.get(i);
    }

    public Token LT(int k) {
        if (this.p == -1) {
            this.setup();
        }
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.LB(-k);
        }
        int i = this.p;
        for (int n = 1; n < k; ++n) {
            i = this.skipOffTokenChannels(i + 1);
        }
        if (i > this.range) {
            this.range = i;
        }
        return (Token)this.tokens.get(i);
    }

    protected int skipOffTokenChannels(int pos) {
        this.sync(pos);
        while (!this.isActiveChannel(((Token)this.tokens.get(pos)).getChannel())) {
            this.sync(++pos);
        }
        return pos;
    }

    protected int skipOffTokenChannelsReverse(int pos) {
        while (pos >= 0 && !this.isActiveChannel(((Token)this.tokens.get(pos)).getChannel())) {
            --pos;
        }
        return pos;
    }

    protected void setup() {
        this.p = 0;
        this.sync(0);
        int i = 0;
        while (!this.isActiveChannel(((Token)this.tokens.get(i)).getChannel())) {
            this.sync(++i);
        }
        this.p = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTokenSource(TokenSource tokenSource) {
        List<Integer> list = this.activeChannels;
        synchronized (list) {
            super.setTokenSource(tokenSource);
            this.removeAllActiveChannels();
            this.addActiveChannel(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveChannel(int channelNum) {
        List<Integer> list = this.activeChannels;
        synchronized (list) {
            if (!this.isActiveChannel(channelNum)) {
                this.activeChannels.add(channelNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveChannel(int channelNum) {
        List<Integer> list = this.activeChannels;
        synchronized (list) {
            Iterator<Integer> iter = this.activeChannels.iterator();
            while (iter.hasNext()) {
                if (iter.next() != channelNum) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveChannel(int channelNum) {
        List<Integer> list = this.activeChannels;
        synchronized (list) {
            return this.activeChannels.contains(channelNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllActiveChannels() {
        List<Integer> list = this.activeChannels;
        synchronized (list) {
            this.activeChannels.clear();
        }
    }
}

