/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.parser;

import jaitools.CollectionFactory;
import jaitools.jiffle.parser.ScopeType;
import jaitools.jiffle.parser.Symbol;
import jaitools.jiffle.parser.SymbolScope;
import jaitools.jiffle.parser.SymbolType;
import java.util.List;

public class SymbolScopeStack {
    private final List<SymbolScope> scopes = CollectionFactory.list();

    public void addLevel() {
        this.addLevel("scope level " + this.scopes.size());
    }

    public void addLevel(String label) {
        this.scopes.add(new SymbolScope(label));
    }

    public SymbolScope dropLevel() {
        if (!this.scopes.isEmpty()) {
            return this.scopes.remove(this.scopes.size() - 1);
        }
        return null;
    }

    public void addSymbol(String name, SymbolType type, ScopeType scopeType) {
        if (this.scopes.isEmpty()) {
            throw new IllegalStateException("Called addSymbol before adding any scope levels");
        }
        this.getTop().add(new Symbol(name, type, scopeType));
    }

    public boolean isEmpty() {
        return this.scopes.isEmpty();
    }

    public int size() {
        return this.scopes.size();
    }

    public boolean isDefined(String name) {
        return this.findSymbol(name) != null;
    }

    public boolean isDefined(String name, SymbolType type) {
        Symbol symbol = this.findSymbol(name);
        if (symbol == null) {
            return false;
        }
        return symbol.getType() == type;
    }

    public boolean isDefined(String name, ScopeType scopeType) {
        Symbol symbol = this.findSymbol(name);
        if (symbol == null) {
            return false;
        }
        return symbol.getScopeType() == scopeType;
    }

    public Symbol findSymbol(String name) {
        if (this.scopes.isEmpty()) {
            return null;
        }
        for (int i = this.scopes.size() - 1; i >= 0; --i) {
            Symbol s = this.scopes.get(i).findSymbolNamed(name);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private SymbolScope getTop() {
        if (!this.scopes.isEmpty()) {
            return this.scopes.get(this.scopes.size() - 1);
        }
        return null;
    }
}

