/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.runtime;

import jaitools.jiffle.runtime.AbstractJiffleRuntime;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import jaitools.jiffle.runtime.JiffleProgressListener;
import jaitools.jiffle.runtime.JiffleRuntimeException;
import jaitools.jiffle.runtime.NullProgressListener;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;

public abstract class AbstractDirectRuntime
extends AbstractJiffleRuntime
implements JiffleDirectRuntime {
    protected Map images = new HashMap();
    protected Map readers = new HashMap();
    protected Map writers = new HashMap();
    protected int _minx;
    protected int _miny;
    protected int _maxx;
    protected int _maxy;
    protected int _width;
    protected int _height;

    public AbstractDirectRuntime() {
        this.initOptionVars();
    }

    public void setDestinationImage(String imageName, WritableRenderedImage image) {
        this.images.put(imageName, image);
        if (this.writers.isEmpty()) {
            this.setBounds(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        }
        this.writers.put(imageName, RandomIterFactory.createWritable((WritableRenderedImage)image, null));
    }

    public void setBounds(int minx, int miny, int width, int height) {
        this._minx = minx;
        this._miny = miny;
        this._width = width;
        this._height = height;
        this._maxx = this._minx + this._width - 1;
        this._maxy = this._miny + this._height - 1;
        this.initImageScopeVars();
    }

    public void setSourceImage(String imageName, RenderedImage image) {
        this.images.put(imageName, image);
        this.readers.put(imageName, RandomIterFactory.create((RenderedImage)image, null));
    }

    public void evaluateAll(JiffleProgressListener pl) {
        JiffleProgressListener listener = pl == null ? new NullProgressListener() : pl;
        long numPixels = (long)this._width * (long)this._height;
        listener.setTaskSize(numPixels);
        long count = 0L;
        long sinceLastUpdate = 0L;
        long updateInterval = listener.getUpdateInterval();
        listener.start();
        int y = this._miny;
        for (int iy = 0; iy < this._height; ++iy) {
            int x = this._minx;
            for (int ix = 0; ix < this._width; ++ix) {
                this.evaluate(x, y);
                ++count;
                if (++sinceLastUpdate >= updateInterval) {
                    listener.update(count);
                    sinceLastUpdate = 0L;
                }
                ++x;
            }
            ++y;
        }
        listener.finish();
    }

    public double readFromImage(String imageName, int x, int y, int band) {
        boolean inside = true;
        RenderedImage img = (RenderedImage)this.images.get(imageName);
        int xx = x - img.getMinX();
        if (xx < 0 || xx >= img.getWidth()) {
            inside = false;
        } else {
            int yy = y - img.getMinY();
            if (yy < 0 || yy >= img.getHeight()) {
                inside = false;
            }
        }
        if (!inside) {
            if (this._outsideValueSet) {
                return this._outsideValue;
            }
            throw new JiffleRuntimeException(String.format("Position %d %d is outside bounds of image: %s", x, y, imageName));
        }
        RandomIter iter = (RandomIter)this.readers.get(imageName);
        return iter.getSampleDouble(x, y, band);
    }

    public void writeToImage(String imageName, int x, int y, int band, double value) {
        WritableRandomIter iter = (WritableRandomIter)this.writers.get(imageName);
        iter.setSample(x, y, band, value);
    }
}

