/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.runtime;

public class IntegerStack {
    public static final int CHUNK_SIZE = 1000;
    public static final int CLEAR_SIZE = 10000;
    private Integer[] data = new Integer[1000];
    private int index = -1;

    public synchronized Integer push(Integer x) {
        if (++this.index == this.data.length) {
            this.grow();
        }
        this.data[this.index] = x;
        return x;
    }

    public synchronized Integer pop() {
        if (this.index >= 0) {
            Integer val = this.data[this.index];
            --this.index;
            return val;
        }
        throw new RuntimeException("Stack is empty");
    }

    public synchronized Integer peek() {
        if (this.index >= 0) {
            return this.data[this.index];
        }
        throw new RuntimeException("Stack is empty");
    }

    public synchronized void clear() {
        if (this.data.length > 10000) {
            this.data = new Integer[1000];
        }
        this.index = -1;
    }

    public int size() {
        return this.index + 1;
    }

    private void grow() {
        Integer[] temp = new Integer[this.data.length + 1000];
        System.arraycopy(this.data, 0, temp, 0, this.data.length);
        this.data = temp;
    }
}

