/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.runtime;

import jaitools.jiffle.Jiffle;
import jaitools.jiffle.JiffleException;
import jaitools.jiffle.runtime.JiffleDirectRuntime;
import jaitools.jiffle.runtime.JiffleExecutor;
import jaitools.jiffle.runtime.JiffleExecutorResult;
import jaitools.jiffle.runtime.JiffleProgressListener;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiffleExecutorTask
implements Callable<JiffleExecutorResult> {
    private final JiffleExecutor executor;
    private final int id;
    private final Jiffle jiffle;
    private final Map<String, RenderedImage> images;
    private final JiffleProgressListener progressListener;
    private boolean completed;

    public JiffleExecutorTask(JiffleExecutor executor, int id, Jiffle jiffle, Map<String, RenderedImage> images, JiffleProgressListener progressListener) {
        this.executor = executor;
        this.id = id;
        this.jiffle = jiffle;
        this.images = images;
        this.progressListener = progressListener;
        this.completed = false;
    }

    @Override
    public JiffleExecutorResult call() throws JiffleException {
        JiffleDirectRuntime runtime = this.jiffle.getRuntimeInstance();
        Map<String, Jiffle.ImageRole> imageParams = this.jiffle.getImageParams();
        for (String imageName : this.images.keySet()) {
            switch (imageParams.get(imageName)) {
                case DEST: {
                    WritableRenderedImage destImg = (WritableRenderedImage)this.images.get(imageName);
                    runtime.setDestinationImage(imageName, destImg);
                    break;
                }
                case SOURCE: {
                    RenderedImage srcImg = this.images.get(imageName);
                    runtime.setSourceImage(imageName, srcImg);
                }
            }
        }
        boolean gotEx = false;
        try {
            runtime.evaluateAll(this.progressListener);
        }
        catch (Exception ex) {
            gotEx = true;
        }
        this.completed = !gotEx;
        return new JiffleExecutorResult(this.id, this.jiffle, this.images, this.completed);
    }
}

