/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jiffle.runtime;

import jaitools.numeric.DoubleComparison;
import jaitools.numeric.SampleStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class JiffleFunctions {
    private Random rr = new Random();

    public double degToRad(double x) {
        return Math.PI * x / 180.0;
    }

    public Integer sign(double x) {
        if (!Double.isNaN(x)) {
            return DoubleComparison.dcomp(x, 0.0);
        }
        return null;
    }

    public double isinf(double x) {
        return Double.isNaN(x) ? Double.NaN : (Double.isInfinite(x) ? 1.0 : 0.0);
    }

    public double isnan(double x) {
        return Double.isNaN(x) ? 1.0 : 0.0;
    }

    public double isnull(double x) {
        return Double.isNaN(x) ? 1.0 : 0.0;
    }

    public double log2Arg(double x, double b) {
        return Math.log(x) / Math.log(b);
    }

    public double max(List values) {
        return SampleStats.max(this.listToArray(values), true);
    }

    public double mean(List values) {
        return SampleStats.mean(this.listToArray(values), true);
    }

    public double median(List values) {
        return SampleStats.median(this.listToArray(values), true);
    }

    public double min(List values) {
        return SampleStats.min(this.listToArray(values), true);
    }

    public double mode(List values) {
        return SampleStats.mode(this.listToArray(values), true);
    }

    public double radToDeg(double x) {
        return x / Math.PI * 180.0;
    }

    public double rand(double x) {
        return this.rr.nextDouble() * x;
    }

    public double randInt(double x) {
        return this.rr.nextInt((int)x);
    }

    public double range(List values) {
        return SampleStats.range(this.listToArray(values), true);
    }

    public double round2Arg(double x, double prec) {
        int ifac = (int)(prec + 0.5);
        return Math.round(x / (double)ifac) * (long)ifac;
    }

    public double sdev(List values) {
        return SampleStats.range(this.listToArray(values), true);
    }

    public double sum(List values) {
        return SampleStats.sum(this.listToArray(values), true);
    }

    public double variance(List values) {
        return SampleStats.variance(this.listToArray(values), true);
    }

    public double OR(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return !DoubleComparison.dzero(x) || !DoubleComparison.dzero(y) ? 1.0 : 0.0;
    }

    public double AND(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return !DoubleComparison.dzero(x) && !DoubleComparison.dzero(y) ? 1.0 : 0.0;
    }

    public double XOR(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return !DoubleComparison.dzero(x) ^ !DoubleComparison.dzero(y) ? 1.0 : 0.0;
    }

    public double GT(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return DoubleComparison.dcomp(x, y) > 0 ? 1.0 : 0.0;
    }

    public double GE(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return DoubleComparison.dcomp(x, y) >= 0 ? 1.0 : 0.0;
    }

    public double LT(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return DoubleComparison.dcomp(x, y) < 0 ? 1.0 : 0.0;
    }

    public double LE(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return DoubleComparison.dcomp(x, y) <= 0 ? 1.0 : 0.0;
    }

    public double EQ(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return DoubleComparison.dcomp(x, y) == 0 ? 1.0 : 0.0;
    }

    public double NE(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return Double.NaN;
        }
        return DoubleComparison.dcomp(x, y) != 0 ? 1.0 : 0.0;
    }

    public double NOT(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        return DoubleComparison.dzero(x) ? 1.0 : 0.0;
    }

    public List concatDL(double x, List list) {
        ArrayList<Double> copy = new ArrayList<Double>(list);
        copy.add(x);
        return copy;
    }

    public List concatLD(List list, double x) {
        ArrayList<Double> copy = new ArrayList<Double>(list);
        copy.add(x);
        return copy;
    }

    public List concatLL(List list1, List list2) {
        ArrayList copy = new ArrayList(list1);
        copy.addAll(list2);
        return copy;
    }

    private Double[] listToArray(List values) {
        int N = values.size();
        Double[] dvalues = new Double[values.size()];
        for (int i = 0; i < N; ++i) {
            dvalues[i] = ((Number)values.get(i)).doubleValue();
        }
        return dvalues;
    }
}

