/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.kernel;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import jaitools.CollectionFactory;
import jaitools.media.jai.kernel.KernelFactoryHelper;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import javax.media.jai.KernelJAI;

public class KernelFactory {
    public static KernelJAI createCircle(int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Invalid radius (" + radius + "); must be > 0");
        }
        KernelFactoryHelper kh = new KernelFactoryHelper();
        float[] weights = kh.makeCircle(radius);
        int w = 2 * radius + 1;
        kh.rowFill(weights, w, w);
        return new KernelJAI(w, w, weights);
    }

    public static KernelJAI createCircle(int radius, ValueType type, float centreValue) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Invalid radius (" + radius + "); must be > 0");
        }
        KernelFactoryHelper kh = new KernelFactoryHelper();
        int width = 2 * radius + 1;
        float[] weights = new float[width * width];
        float r2 = radius * radius;
        int k0 = 0;
        int k1 = weights.length - 1;
        for (int y = radius; y > 0; --y) {
            int y2 = y * y;
            int x = -radius;
            while (x <= radius) {
                float dist2 = x * x + y2;
                float value = 0.0f;
                if (kh.fcomp(r2, dist2) >= 0) {
                    value = type == ValueType.DISTANCE ? (float)Math.sqrt(dist2) : (type == ValueType.INVERSE_DISTANCE ? 1.0f / (float)Math.sqrt(dist2) : 1.0f);
                    weights[k0] = weights[k1] = value;
                }
                ++x;
                ++k0;
                --k1;
            }
        }
        int x = -radius;
        while (x <= radius) {
            float value = x == 0 ? centreValue : (type == ValueType.DISTANCE ? (float)Math.sqrt(x * x) : (type == ValueType.INVERSE_DISTANCE ? 1.0f / (float)Math.sqrt(x * x) : 1.0f));
            weights[k0] = value;
            ++x;
            ++k0;
        }
        return new KernelJAI(width, width, weights);
    }

    public static KernelJAI createAnnulus(int outerRadius, int innerRadius, ValueType type, float centreValue) {
        if (innerRadius < 0) {
            throw new IllegalArgumentException("Invalid innerRadius (" + innerRadius + "); must be >= 0");
        }
        if (outerRadius <= innerRadius) {
            throw new IllegalArgumentException("outerRadius must be greater than innerRadius");
        }
        if (innerRadius == 0) {
            return KernelFactory.createCircle(outerRadius, type, centreValue);
        }
        KernelFactoryHelper kh = new KernelFactoryHelper();
        int width = 2 * outerRadius + 1;
        float[] weights = new float[width * width];
        int outer2 = outerRadius * outerRadius;
        float inner2 = innerRadius * innerRadius;
        int k0 = 0;
        int k1 = weights.length - 1;
        for (int y = outerRadius; y > 0; --y) {
            int y2 = y * y;
            int x = -outerRadius;
            while (x <= outerRadius) {
                float dist2 = x * x + y2;
                float value = 0.0f;
                if (kh.fcomp(dist2, outer2) <= 0 && kh.fcomp(dist2, inner2) > 0) {
                    value = type == ValueType.DISTANCE ? (float)Math.sqrt(dist2) : (type == ValueType.INVERSE_DISTANCE ? 1.0f / (float)Math.sqrt(dist2) : 1.0f);
                    weights[k0] = weights[k1] = value;
                }
                ++x;
                ++k0;
                --k1;
            }
        }
        int x = -outerRadius;
        while (x <= outerRadius) {
            float value = 0.0f;
            if (x == 0) {
                value = centreValue;
            } else if (x < -innerRadius || x > innerRadius) {
                value = type == ValueType.DISTANCE ? (float)Math.sqrt(x * x) : (type == ValueType.INVERSE_DISTANCE ? 1.0f / (float)Math.sqrt(x * x) : 1.0f);
            }
            weights[k0] = value;
            ++x;
            ++k0;
        }
        return new KernelJAI(width, width, weights);
    }

    public static KernelJAI createRectangle(int width, int height) {
        float[] weights = new KernelFactoryHelper().makeRect(width, height);
        return new KernelJAI(width, height, weights);
    }

    public static KernelJAI createRectangle(int width, int height, ValueType type, int keyX, int keyY, float keyValue) {
        if (width < 1) {
            throw new IllegalArgumentException("width must be >= 1");
        }
        if (height < 1) {
            throw new IllegalArgumentException("height must be >= 1");
        }
        if (keyX < 0 || keyX >= width || keyY < 0 || keyY >= height) {
            throw new IllegalArgumentException("key element position " + keyX + "," + keyY + " is outside rectangle bounds");
        }
        KernelFactoryHelper kh = new KernelFactoryHelper();
        if (type == ValueType.BINARY) {
            float[] weights = kh.makeRect(width, height);
            weights[keyX + keyY * width] = keyValue;
            return new KernelJAI(width, height, keyX, keyY, weights);
        }
        float[] weights = new float[width * height];
        int k = 0;
        Point p = new Point(keyX, keyY);
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                float dist = (float)p.distance(x, y);
                weights[k] = type == ValueType.DISTANCE ? dist : 1.0f / dist;
                ++x;
                ++k;
            }
        }
        weights[keyX + keyY * width] = keyValue;
        return new KernelJAI(width, height, keyX, keyY, weights);
    }

    public static KernelJAI createFromShape(Shape shape, AffineTransform transform, ValueType type, int keyX, int keyY, float keyValue) {
        PathIterator iter = shape.getPathIterator(transform, 0.05);
        float[] buf = new float[6];
        List<Coordinate> coords = CollectionFactory.list();
        while (!iter.isDone()) {
            iter.currentSegment(buf);
            coords.add(new Coordinate((double)buf[0], (double)buf[1]));
            iter.next();
        }
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coordsAr = coords.toArray(new Coordinate[coords.size()]);
        Polygon poly = gf.createPolygon(gf.createLinearRing(coordsAr), null);
        Envelope env = poly.getEnvelopeInternal();
        int left = (int)Math.floor(env.getMinX());
        int right = (int)Math.ceil(env.getMaxX());
        int top = (int)Math.ceil(env.getMaxY());
        int bottom = (int)Math.floor(env.getMinY());
        int width = right - left + 1;
        int height = top - bottom + 1;
        float[] weights = new float[width * height];
        int[] offset = new int[height];
        int i = 0;
        int o = 0;
        while (i < offset.length) {
            offset[i] = o;
            ++i;
            o += width;
        }
        coords.clear();
        double y = top;
        for (int iy = 0; iy < height; ++iy) {
            double x = left;
            for (int ix = 0; ix < width; ++ix) {
                coords.add(new Coordinate(x, y));
                x += 1.0;
            }
            y -= 1.0;
        }
        MultiPoint mp = gf.createMultiPoint(coords.toArray(new Coordinate[coords.size()]));
        Geometry inside = mp.intersection(poly.buffer(0.05, Math.max(width / 2, 10)));
        int n = inside.getNumGeometries();
        for (int i2 = 0; i2 < n; ++i2) {
            Geometry g = inside.getGeometryN(i2);
            Coordinate c = g.getCoordinate();
            int index = (int)c.x - left + offset[(int)c.y - bottom];
            if (type == ValueType.BINARY) {
                weights[index] = 1.0f;
                continue;
            }
            if (type == ValueType.DISTANCE) {
                weights[index] = (float)Point2D.distance(keyX, keyY, (int)c.x, (int)c.y);
                continue;
            }
            if (type != ValueType.INVERSE_DISTANCE) continue;
            weights[index] = 1.0f / (float)Point2D.distance(keyX, keyY, (int)c.x, (int)c.y);
        }
        weights[keyX + offset[keyY]] = keyValue;
        return new KernelJAI(width, height, keyX, keyY, weights);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueType {
        BINARY,
        DISTANCE,
        INVERSE_DISTANCE;

    }
}

