/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.kernel;

import javax.media.jai.KernelJAI;

public class KernelUtil {
    private static final float TOL = 1.0E-8f;

    public static KernelJAI standardize(KernelJAI kernel) {
        float[] data = kernel.getKernelData();
        float sum = 0.0f;
        for (float f : data) {
            sum += f;
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return new KernelJAI(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), data);
    }

    public static String kernelToString(KernelJAI kernel, boolean multiLine) {
        float[] data = kernel.getKernelData();
        int w = kernel.getWidth();
        int h = kernel.getHeight();
        StringBuilder sb = new StringBuilder();
        boolean binaryData = true;
        for (int i = 0; i < data.length && binaryData; ++i) {
            if (KernelUtil.feq(data[i], 0.0f) || KernelUtil.feq(data[i], 1.0f)) continue;
            binaryData = false;
        }
        int k = 0;
        sb.append("[");
        for (int i = 0; i < w; ++i) {
            sb.append("[");
            int j = 0;
            while (j < h) {
                if (binaryData) {
                    sb.append((int)data[k]);
                } else {
                    sb.append(String.format("%.4f", Float.valueOf(data[k])));
                    if (j < w - 1) {
                        sb.append(" ");
                    }
                }
                ++j;
                ++k;
            }
            sb.append("]");
            if (i >= w - 1) continue;
            if (multiLine) {
                sb.append("\n ");
                continue;
            }
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static boolean feq(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-8f;
    }
}

