/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.rangelookup;

import jaitools.media.jai.rangelookup.RangeLookupTable;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class RangeLookupOpImage
extends PointOpImage {
    private RangeLookupTable table;
    private int[] srcBandOffsets;
    private int srcPixelStride;
    private int srcScanlineStride;
    private int destWidth;
    private int destHeight;
    private int destBands;
    private int[] dstBandOffsets;
    private int dstPixelStride;
    private int dstScanlineStride;

    public RangeLookupOpImage(RenderedImage source, Map config, ImageLayout layout, RangeLookupTable table) {
        super(source, layout, config, true);
        this.table = table;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAcc = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAcc = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        this.doLookup(srcAcc, destAcc);
    }

    private void doLookup(RasterAccessor srcAcc, RasterAccessor destAcc) {
        this.destWidth = destAcc.getWidth();
        this.destHeight = destAcc.getHeight();
        this.destBands = destAcc.getNumBands();
        this.dstBandOffsets = destAcc.getBandOffsets();
        this.dstPixelStride = destAcc.getPixelStride();
        this.dstScanlineStride = destAcc.getScanlineStride();
        this.srcBandOffsets = srcAcc.getBandOffsets();
        this.srcPixelStride = srcAcc.getPixelStride();
        this.srcScanlineStride = srcAcc.getScanlineStride();
        switch (destAcc.getDataType()) {
            case 0: {
                this.lookupAsByteData(srcAcc, destAcc);
                break;
            }
            case 3: {
                this.lookupAsIntData(srcAcc, destAcc);
                break;
            }
            case 2: {
                this.lookupAsShortData(srcAcc, destAcc);
                break;
            }
            case 1: {
                this.lookupAsUShortData(srcAcc, destAcc);
                break;
            }
            case 4: {
                this.lookupAsFloatData(srcAcc, destAcc);
                break;
            }
            case 5: {
                this.lookupAsDoubleData(srcAcc, destAcc);
            }
        }
        if (destAcc.isDataCopy()) {
            destAcc.clampDataArrays();
            destAcc.copyDataToRaster();
        }
    }

    private void lookupAsByteData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        byte[][] srcData = srcAcc.getByteDataArrays();
        byte[][] destData = destAcc.getByteDataArrays();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            byte[] destBandData = destData[k];
            byte[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    byte val = (byte)(srcBandData[srcPixelOffset] & 0xFF);
                    destBandData[dstPixelOffset] = ((Number)this.table.getDestValue(val)).byteValue();
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] srcData = srcAcc.getShortDataArrays();
        short[][] destData = destAcc.getShortDataArrays();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            short[] destBandData = destData[k];
            short[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    short val = srcBandData[srcPixelOffset];
                    destBandData[dstPixelOffset] = ((Number)this.table.getDestValue(val)).shortValue();
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsUShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] srcData = srcAcc.getShortDataArrays();
        short[][] destData = destAcc.getShortDataArrays();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            short[] destBandData = destData[k];
            short[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = srcBandData[srcPixelOffset] & 0xFFFF;
                    destBandData[dstPixelOffset] = ((Number)this.table.getDestValue(val)).shortValue();
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsIntData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int[][] srcData = srcAcc.getIntDataArrays();
        int[][] destData = destAcc.getIntDataArrays();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            int[] destBandData = destData[k];
            int[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = srcBandData[srcPixelOffset];
                    destBandData[dstPixelOffset] = ((Number)this.table.getDestValue(val)).intValue();
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsFloatData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        float[][] srcData = srcAcc.getFloatDataArrays();
        float[][] destData = destAcc.getFloatDataArrays();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            float[] destBandData = destData[k];
            float[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    float val = srcBandData[srcPixelOffset];
                    destBandData[dstPixelOffset] = ((Number)this.table.getDestValue(Float.valueOf(val))).floatValue();
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void lookupAsDoubleData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        double[][] srcData = srcAcc.getDoubleDataArrays();
        double[][] destData = destAcc.getDoubleDataArrays();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            double[] destBandData = destData[k];
            double[] srcBandData = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    double val = srcBandData[srcPixelOffset];
                    destBandData[dstPixelOffset] = ((Number)this.table.getDestValue(val)).doubleValue();
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }
}

