/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.zonalstats;

import jaitools.numeric.Range;
import jaitools.numeric.Statistic;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result {
    private List<Range> ranges;
    private int imageBand;
    private int zone;
    private Statistic stat;
    private Double value;
    private long numOffered;
    private long numAccepted;
    private long numNaN;
    private long numNoData;

    public Result(int imageBand, int zone, Statistic stat, List<Range> ranges, Double value, long numOffered, long numAccepted, long numNaN, long numNoData) {
        this.imageBand = imageBand;
        this.zone = zone;
        this.stat = stat;
        this.value = value;
        this.numOffered = numOffered;
        this.numAccepted = numAccepted;
        this.numNaN = numNaN;
        this.numNoData = numNoData;
        this.ranges = ranges;
    }

    public Collection<Range> getRanges() {
        return Collections.unmodifiableCollection(this.ranges);
    }

    public int getImageBand() {
        return this.imageBand;
    }

    public int getZone() {
        return this.zone;
    }

    public Statistic getStatistic() {
        return this.stat;
    }

    public Double getValue() {
        return this.value;
    }

    public long getNumAccepted() {
        return this.numAccepted;
    }

    public long getNumOffered() {
        return this.numOffered;
    }

    public long getNumNaN() {
        return this.numNaN;
    }

    public long getNumNoData() {
        return this.numNoData;
    }

    public String toString() {
        String rangess = this.ranges != null && !this.ranges.isEmpty() ? this.ranges.toString() : "";
        return String.format("band %d zone %d %s: %.4f N=%d (%d - ND:%d - NaN:%d) %s", new Object[]{this.imageBand, this.zone, this.stat, this.value, this.numAccepted, this.numOffered, this.numNoData, this.numNaN, rangess});
    }
}

