/*
 * Decompiled with CFR 0.152.
 */
package jaitools.swing;

import com.sun.media.jai.widget.DisplayJAI;
import jaitools.swing.FrameWithStatusBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.RenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

class ImagePane
extends DisplayJAI {
    private FrameWithStatusBar frame;
    private RenderedImage displayImage;
    private Rectangle imageDisplayBounds;
    private Point imageOrigin;
    private RenderedImage dataImage;
    private RandomIter dataImageIter;
    private int[] intData;
    private double[] doubleData;
    private ImageDataType imageDataType;

    public ImagePane(FrameWithStatusBar frame, RenderedImage displayImg, RenderedImage dataImg) {
        super(displayImg);
        this.frame = frame;
        this.displayImage = displayImg;
        this.imageDisplayBounds = new Rectangle(0, 0, this.displayImage.getWidth(), this.displayImage.getHeight());
        this.imageOrigin = new Point(this.displayImage.getMinX(), this.displayImage.getMinY());
        this.dataImage = dataImg == null ? displayImg : dataImg;
        this.dataImageIter = RandomIterFactory.create((RenderedImage)this.dataImage, (Rectangle)this.imageDisplayBounds);
        switch (this.dataImage.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.imageDataType = ImageDataType.INTEGRAL;
                this.intData = new int[this.dataImage.getSampleModel().getNumBands()];
                break;
            }
            case 4: 
            case 5: {
                this.imageDataType = ImageDataType.FLOAT;
                this.doubleData = new double[this.dataImage.getSampleModel().getNumBands()];
            }
        }
        this.addMouseListener((MouseListener)((Object)this));
        this.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void mouseMoved(MouseEvent ev) {
        Point pos;
        if (this.dataImage != null && this.imageDisplayBounds.contains(pos = ev.getPoint())) {
            StringBuilder sb = new StringBuilder();
            sb.append("x:");
            sb.append(pos.x);
            sb.append(" y:");
            sb.append(pos.y);
            sb.append(" band data:");
            if (this.imageDataType == ImageDataType.INTEGRAL) {
                this.dataImageIter.getPixel(pos.x, pos.y, this.intData);
                for (int i = 0; i < this.intData.length; ++i) {
                    sb.append(" ");
                    sb.append(this.intData[i]);
                }
            } else {
                this.dataImageIter.getPixel(pos.x, pos.y, this.doubleData);
                for (int i = 0; i < this.doubleData.length; ++i) {
                    sb.append(String.format(" %.4f", this.doubleData[i]));
                }
            }
            this.frame.setStatusText(sb.toString());
        }
    }

    public void mouseExited(MouseEvent ev) {
        this.frame.setStatusText("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ImageDataType {
        INTEGRAL,
        FLOAT;

    }
}

