/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.maskedconvolve;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class MaskedConvolveOpImage
extends AreaOpImage {
    private int[] srcBandOffsets;
    private int srcPixelStride;
    private int srcScanlineStride;
    private int destWidth;
    private int destHeight;
    private int destBands;
    private int[] dstBandOffsets;
    private int dstPixelStride;
    private int dstScanlineStride;
    private float[] kernelData;
    private int kernelW;
    private int kernelH;
    private int kernelKeyX;
    private int kernelKeyY;
    private boolean[] kernelActive;
    public static final float KERNEL_TOL = 1.0E-6f;
    private ROI roi;
    private boolean maskSrc;
    private boolean maskDest;
    Number nilValueNumber;
    private int minKernelCells;

    public MaskedConvolveOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, KernelJAI kernel, ROI roi, Boolean maskSrc, Boolean maskDest, Number nilValue, int minCells) {
        super(source, layout, config, true, extender, kernel.getLeftPadding(), kernel.getRightPadding(), kernel.getTopPadding(), kernel.getBottomPadding());
        Rectangle sourceBounds = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
        if (!roi.getBounds().contains(sourceBounds)) {
            throw new IllegalArgumentException("The bounds of the ROI must contain the source image");
        }
        this.roi = roi;
        this.maskSrc = maskSrc;
        this.maskDest = maskDest;
        try {
            Constructor<?> ctor = nilValue.getClass().getConstructor(String.class);
            this.nilValueNumber = (Number)ctor.newInstance(nilValue.toString());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Problem copying nilValue arg", ex);
        }
        this.kernelData = kernel.getKernelData();
        this.kernelActive = new boolean[this.kernelData.length];
        for (int i = 0; i < this.kernelData.length; ++i) {
            this.kernelActive[i] = Math.abs(this.kernelData[i]) > 1.0E-6f;
        }
        this.kernelW = kernel.getWidth();
        this.kernelH = kernel.getHeight();
        this.kernelKeyX = kernel.getXOrigin();
        this.kernelKeyY = kernel.getYOrigin();
        this.minKernelCells = minCells;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAcc = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor destAcc = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        this.convolve(srcAcc, destAcc);
    }

    private void convolve(RasterAccessor srcAcc, RasterAccessor destAcc) {
        this.destWidth = destAcc.getWidth();
        this.destHeight = destAcc.getHeight();
        this.destBands = destAcc.getNumBands();
        this.dstBandOffsets = destAcc.getBandOffsets();
        this.dstPixelStride = destAcc.getPixelStride();
        this.dstScanlineStride = destAcc.getScanlineStride();
        this.srcBandOffsets = srcAcc.getBandOffsets();
        this.srcPixelStride = srcAcc.getPixelStride();
        this.srcScanlineStride = srcAcc.getScanlineStride();
        switch (destAcc.getDataType()) {
            case 0: {
                this.convolveAsByteData(srcAcc, destAcc);
                break;
            }
            case 3: {
                this.convolveAsIntData(srcAcc, destAcc);
                break;
            }
            case 2: {
                this.convolveAsShortData(srcAcc, destAcc);
                break;
            }
            case 1: {
                this.convolveAsUShortData(srcAcc, destAcc);
                break;
            }
            case 4: {
                this.convolveAsFloatData(srcAcc, destAcc);
                break;
            }
            case 5: {
                this.convolveAsDoubleData(srcAcc, destAcc);
            }
        }
        if (destAcc.isDataCopy()) {
            destAcc.clampDataArrays();
            destAcc.copyDataToRaster();
        }
    }

    private void convolveAsByteData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        byte[][] srcData = srcAcc.getByteDataArrays();
        byte[][] destData = destAcc.getByteDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int destY = destAcc.getY();
            byte[] destBandData = destData[k];
            byte[] srcBandDat = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int destX = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = 0;
                    int count = 0;
                    if (!this.maskDest || this.roi.contains(destX, destY)) {
                        int srcY = destY - this.kernelKeyY;
                        float fval = 0.5f;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (u < this.kernelH) {
                            int srcX = destX - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    fval += (float)(srcBandDat[imageOffset] & 0xFF) * this.kernelData[kernelOffset + v];
                                    ++count;
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                        val = count >= this.minKernelCells ? (int)fval : nilValue;
                        if (val < 0) {
                            val = 0;
                        } else if (val > 255) {
                            val = 255;
                        }
                    }
                    destBandData[dstPixelOffset] = (byte)val;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++destX;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++destY;
            }
        }
    }

    private void convolveAsShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] destData = destAcc.getShortDataArrays();
        short[][] srcData = srcAcc.getShortDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            short[] destBand = destData[k];
            short[] srcBand = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = 0;
                    int count = 0;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        float fval = 0.5f;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    fval += (float)srcBand[imageOffset] * this.kernelData[kernelOffset + v];
                                    ++count;
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                        val = count >= this.minKernelCells ? (int)fval : nilValue;
                        if (val < Short.MIN_VALUE) {
                            val = Short.MIN_VALUE;
                        } else if (val > Short.MAX_VALUE) {
                            val = Short.MAX_VALUE;
                        }
                    }
                    destBand[dstPixelOffset] = (short)val;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsUShortData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        short[][] destData = destAcc.getShortDataArrays();
        short[][] srcData = srcAcc.getShortDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            short[] destBand = destData[k];
            short[] srcBand = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    int val = 0;
                    int count = 0;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        float fval = 0.5f;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    fval += (float)(srcBand[imageOffset] & 0xFFFF) * this.kernelData[kernelOffset + v];
                                    ++count;
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                        val = count >= this.minKernelCells ? (int)fval : nilValue;
                        if (val < 0) {
                            val = 0;
                        } else if (val > 65535) {
                            val = 65535;
                        }
                    }
                    destBand[dstPixelOffset] = (short)val;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsIntData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        int[][] destData = destAcc.getIntDataArrays();
        int[][] srcData = srcAcc.getIntDataArrays();
        int nilValue = this.nilValueNumber.intValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            int[] destBand = destData[k];
            int[] srcBand = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    float fval = 0.5f;
                    int count = 0;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    fval += (float)srcBand[imageOffset] * this.kernelData[kernelOffset + v];
                                    ++count;
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    }
                    destBand[dstPixelOffset] = count >= this.minKernelCells ? (int)fval : nilValue;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsFloatData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        float[][] destData = destAcc.getFloatDataArrays();
        float[][] srcData = srcAcc.getFloatDataArrays();
        float nilValue = this.nilValueNumber.floatValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            float[] destBand = destData[k];
            float[] srcBand = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    float fval = 0.0f;
                    int count = 0;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    fval += srcBand[imageOffset] * this.kernelData[kernelOffset + v];
                                    ++count;
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    }
                    destBand[dstPixelOffset] = count >= this.minKernelCells ? fval : nilValue;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                srcScanlineOffset += this.srcScanlineStride;
                dstScanlineOffset += this.dstScanlineStride;
                ++j;
                ++y;
            }
        }
    }

    private void convolveAsDoubleData(RasterAccessor srcAcc, RasterAccessor destAcc) {
        double[][] destData = destAcc.getDoubleDataArrays();
        double[][] srcData = srcAcc.getDoubleDataArrays();
        double nilValue = this.nilValueNumber.doubleValue();
        for (int k = 0; k < this.destBands; ++k) {
            int y = destAcc.getY();
            double[] destBand = destData[k];
            double[] srcBand = srcData[k];
            int srcScanlineOffset = this.srcBandOffsets[k];
            int dstScanlineOffset = this.dstBandOffsets[k];
            int j = 0;
            while (j < this.destHeight) {
                int x = destAcc.getX();
                int srcPixelOffset = srcScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                int i = 0;
                while (i < this.destWidth) {
                    double dval = 0.0;
                    int count = 0;
                    if (!this.maskDest || this.roi.contains(x, y)) {
                        int srcY = y - this.kernelKeyY;
                        int kernelOffset = 0;
                        int imageVerticalOffset = srcPixelOffset;
                        int u = 0;
                        while (u < this.kernelH) {
                            int srcX = x - this.kernelKeyX;
                            int imageOffset = imageVerticalOffset;
                            int v = 0;
                            while (v < this.kernelW) {
                                if (this.kernelActive[kernelOffset + v] && (!this.maskSrc || this.roi.contains(srcX, srcY))) {
                                    dval += srcBand[imageOffset] * (double)this.kernelData[kernelOffset + v];
                                    ++count;
                                }
                                imageOffset += this.srcPixelStride;
                                ++v;
                                ++srcX;
                            }
                            kernelOffset += this.kernelW;
                            imageVerticalOffset += this.srcScanlineStride;
                            ++u;
                            ++srcY;
                        }
                    }
                    destBand[dstPixelOffset] = count >= this.minKernelCells ? dval : nilValue;
                    srcPixelOffset += this.srcPixelStride;
                    dstPixelOffset += this.dstPixelStride;
                    ++i;
                    ++x;
                }
                dstScanlineOffset += this.dstScanlineStride;
                srcScanlineOffset += this.srcScanlineStride;
                ++j;
                ++y;
            }
        }
    }
}

