/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.rangelookup;

import jaitools.CollectionFactory;
import jaitools.media.jai.rangelookup.LookupItem;
import jaitools.numeric.Range;
import jaitools.numeric.RangeUtils;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeLookupTable<T extends Number, U extends Number> {
    private U defaultValue = null;
    private boolean overlapAllowed;
    private List<LookupItem<T, U>> items = CollectionFactory.list();
    private LookupItem<T, U> lastItem = null;

    public RangeLookupTable() {
        this(null);
    }

    public RangeLookupTable(U defaultValue) {
        this(defaultValue, true);
    }

    public RangeLookupTable(U defaultValue, boolean overlap) {
        this.defaultValue = defaultValue;
        this.overlapAllowed = overlap;
    }

    public void setOverlapAllowed(boolean b) {
        this.overlapAllowed = b;
    }

    public boolean getOverlapAllowed() {
        return this.overlapAllowed;
    }

    public U getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(U value) {
        this.defaultValue = value;
    }

    public void add(Range<T> range, U destValue) {
        if (range == null || destValue == null) {
            throw new IllegalArgumentException("arguments must not be null");
        }
        for (LookupItem<T, U> item : this.items) {
            if (!range.intersects(item.range)) continue;
            if (!this.overlapAllowed) {
                throw new IllegalArgumentException("New range " + range + " overlaps existing lookup " + item);
            }
            List diffs = RangeUtils.subtract(item.range, range);
            for (Range diff : diffs) {
                this.add(diff, destValue);
            }
            return;
        }
        this.items.add(new LookupItem<T, U>(range, destValue));
    }

    public U getDestValue(T srcValue) {
        if (this.lastItem != null && this.lastItem.range.contains(srcValue)) {
            return this.lastItem.value;
        }
        int k = 0;
        for (LookupItem<T, U> item : this.items) {
            if (item.range.contains(srcValue)) {
                this.lastItem = item;
                return item.value;
            }
            ++k;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        throw new IllegalArgumentException("Value cannot be matched: " + srcValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LookupItem<T, U> item : this.items) {
            sb.append(item).append("; ");
        }
        return sb.toString();
    }

    List<LookupItem<T, U>> getItems() {
        return Collections.unmodifiableList(this.items);
    }
}

