/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.vectorbinarize;

import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import jaitools.imageutils.PixelCoordType;
import jaitools.jts.CoordinateSequence2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import javax.media.jai.SourcelessOpImage;

public class VectorBinarizeOpImage
extends SourcelessOpImage {
    private final PreparedGeometry geom;
    private final Shape shape;
    private final PixelCoordType coordType;
    private final CoordinateSequence2D testPointCS;
    private final Point testPoint;
    private final CoordinateSequence2D testRectCS;
    private final Polygon testRect;
    private Raster solidTile;
    private Raster blankTile;
    static boolean DEFAULT_ANTIALIASING = false;
    private boolean antiAliasing = DEFAULT_ANTIALIASING;

    public VectorBinarizeOpImage(SampleModel sm, Map configuration, int minX, int minY, int width, int height, PreparedGeometry geom, PixelCoordType coordType) {
        this(sm, configuration, minX, minY, width, height, geom, coordType, DEFAULT_ANTIALIASING);
    }

    public VectorBinarizeOpImage(SampleModel sm, Map configuration, int minX, int minY, int width, int height, PreparedGeometry geom, PixelCoordType coordType, boolean antiAliasing) {
        super(VectorBinarizeOpImage.buildLayout(minX, minY, width, height, sm), configuration, sm, minX, minY, width, height);
        this.geom = geom;
        this.shape = new ShapeWriter().toShape(geom.getGeometry());
        this.coordType = coordType;
        this.antiAliasing = antiAliasing;
        GeometryFactory gf = new GeometryFactory();
        this.testPointCS = new CoordinateSequence2D(1);
        this.testPoint = gf.createPoint((CoordinateSequence)this.testPointCS);
        this.testRectCS = new CoordinateSequence2D(5);
        this.testRect = gf.createPolygon(gf.createLinearRing((CoordinateSequence)this.testRectCS), null);
    }

    static ImageLayout buildLayout(int minX, int minY, int width, int height, SampleModel sm) {
        ImageLayout il = new ImageLayout();
        il.setMinX(minX);
        il.setMinY(minY);
        il.setWidth(width);
        il.setHeight(height);
        il.setSampleModel(sm);
        if (!il.isValid(16)) {
            il.setTileGridXOffset(il.getMinX(null));
        }
        if (!il.isValid(32)) {
            il.setTileGridYOffset(il.getMinY(null));
        }
        return il;
    }

    public Raster computeTile(int tileX, int tileY) {
        int x = this.tileXToX(tileX);
        int y = this.tileYToY(tileY);
        Raster tile = this.getTileRaster(x, y);
        Raster result = tile.createChild(0, 0, this.tileWidth, this.tileHeight, x, y, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Raster getTileRaster(int minX, int minY) {
        this.updateTestRect(minX, minY);
        if (this.geom.contains((Geometry)this.testRect)) {
            return this.getSolidTile();
        }
        if (this.geom.disjoint((Geometry)this.testRect)) {
            return this.getBlankTile();
        }
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (java.awt.Point)new java.awt.Point(0, 0));
        BufferedImage bi = new BufferedImage(this.colorModel, raster, false, null);
        Graphics2D graphics = null;
        try {
            graphics = bi.createGraphics();
            graphics.setTransform(AffineTransform.getTranslateInstance(-minX, -minY));
            if (this.antiAliasing) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics.setColor(Color.WHITE);
            graphics.fill(this.shape);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return raster;
    }

    private Raster getSolidTile() {
        if (this.solidTile == null) {
            this.solidTile = this.constantTile(1);
        }
        return this.solidTile;
    }

    private Raster getBlankTile() {
        if (this.blankTile == null) {
            this.blankTile = this.constantTile(0);
        }
        return this.blankTile;
    }

    private Raster constantTile(int value) {
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (java.awt.Point)new java.awt.Point(0, 0));
        int dataType = this.sampleModel.getTransferType();
        int numBands = this.sampleModel.getNumBands();
        if (dataType != 0) {
            throw new IllegalArgumentException("The code works only if the sample model data type is BYTE");
        }
        if (numBands != 1) {
            throw new IllegalArgumentException("The code works only for single band rasters!");
        }
        int w = this.sampleModel.getWidth();
        int h = this.sampleModel.getHeight();
        int[] data = new int[w * h];
        Arrays.fill(data, value);
        raster.setSamples(0, 0, w, h, 0, data);
        return raster;
    }

    private void updateTestRect(int x, int y) {
        double delta = this.coordType == PixelCoordType.CENTER ? 0.5 : 0.0;
        this.testRectCS.setXY(0, (double)x + delta, (double)y + delta);
        this.testRectCS.setXY(1, (double)x + delta, (double)(y + this.tileHeight) - delta);
        this.testRectCS.setXY(2, (double)(x + this.tileWidth) - delta, (double)(y + this.tileHeight) - delta);
        this.testRectCS.setXY(3, (double)(x + this.tileWidth) - delta, (double)y + delta);
        this.testRectCS.setXY(4, (double)x + delta, (double)y + delta);
        this.testRect.geometryChanged();
    }
}

