/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.zonalstats;

import jaitools.numeric.Range;
import jaitools.numeric.RangeComparator;
import jaitools.numeric.RangeUtils;
import jaitools.numeric.Statistic;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZonalStatsDescriptor
extends OperationDescriptorImpl {
    private static final long serialVersionUID = -526208282980300507L;
    public static String ZONAL_STATS_PROPERTY = "ZonalStatsProperty";
    static final int DATA_IMAGE = 0;
    static final int ZONE_IMAGE = 1;
    private static final String[] srcImageNames = new String[]{"dataImage", "zoneImage"};
    private static final Class<?>[][] srcImageClasses = new Class[][]{{RenderedImage.class, RenderedImage.class}};
    static final int STATS_ARG = 0;
    static final int BAND_ARG = 1;
    static final int ROI_ARG = 2;
    static final int ZONE_TRANSFORM_ARG = 3;
    static final int RANGES_ARG = 4;
    static final int RANGES_TYPE_ARG = 5;
    static final int RANGE_LOCAL_STATS_ARG = 6;
    static final int NODATA_RANGES_ARG = 7;
    private static final String[] paramNames = new String[]{"stats", "bands", "roi", "zoneTransform", "ranges", "rangesType", "rangeLocalStats", "noDataRanges"};
    private static final Class<?>[] paramClasses = new Class[]{Statistic[].class, Integer[].class, ROI.class, AffineTransform.class, List.class, Range.Type.class, Boolean.class, List.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, new Integer[]{0}, null, null, null, Range.Type.UNDEFINED, Boolean.FALSE, null};

    public ZonalStatsDescriptor() {
        super((String[][])new String[][]{{"GlobalName", "ZonalStats"}, {"LocalName", "ZonalStats"}, {"Vendor", "jaitools.media.jai"}, {"Description", "Calculate neighbourhood statistics"}, {"DocURL", "http://code.google.com/p/jai-tools/"}, {"Version", "1.0.0"}, {"arg0Desc", String.format("%s - an array of Statistic constants specifying the statistics required", paramNames[0])}, {"arg1Desc", String.format("%s (default %s) - the bands of the data image to process", paramNames[1], paramDefaults[1])}, {"arg2Desc", String.format("%s (default ) - an optional ROI for masking the data image", paramNames[2], paramDefaults[2])}, {"arg3Desc", String.format("%s (default %s) - an optional AffineTransform to map dataImage pixel coords to zoneImage pixel coords", paramNames[3], paramDefaults[3])}, {"arg4Desc", String.format("%s (default %s) - an optional List of Ranges that define dataImage values to exclude from calculations", paramNames[4], paramDefaults[4])}, {"arg5Desc", String.format("%s (default %s) - in case of Ranges, specify if they are included or excluded in calculations", paramNames[5], paramDefaults[5])}, {"arg6Desc", String.format("%s (default %s) - an optional range argument type that define whether to calculate global statistics or splitted by ranges", paramNames[6], paramDefaults[6])}, {"arg7Desc", String.format("%s (default %s) - an optional List of Ranges that define dataImage values to be considered as noData and then be excluded from calculations", paramNames[7], paramDefaults[7])}}, new String[]{"rendered"}, srcImageNames, (Class[][])srcImageClasses, paramNames, (Class[])paramClasses, paramDefaults, null);
    }

    public static RenderedImage create(RenderedImage dataImage, RenderedImage zoneImage, Statistic[] stats, Integer[] bands, ROI roi, AffineTransform zoneTransform, List<Range<Double>> ranges, RenderingHints hints) {
        return ZonalStatsDescriptor.create(dataImage, zoneImage, stats, bands, roi, zoneTransform, ranges, Range.Type.EXCLUDE, false, null, hints);
    }

    public static RenderedImage create(RenderedImage dataImage, RenderedImage zoneImage, Statistic[] stats, Integer[] bands, ROI roi, AffineTransform zoneTransform, List<Range<Double>> ranges, Range.Type rangesType, boolean rangeLocalStats, List<Range<Double>> noDataRanges, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("ZonalStats", "rendered");
        pb.setSource(srcImageNames[0], (Object)dataImage);
        pb.setSource(srcImageNames[1], (Object)zoneImage);
        pb.setParameter(paramNames[0], (Object)stats);
        pb.setParameter(paramNames[1], (Object)bands);
        pb.setParameter(paramNames[2], (Object)roi);
        pb.setParameter(paramNames[3], (Object)zoneTransform);
        pb.setParameter(paramNames[4], ranges);
        pb.setParameter(paramNames[5], (Object)rangesType);
        pb.setParameter(paramNames[6], rangeLocalStats);
        pb.setParameter(paramNames[7], noDataRanges);
        return JAI.create((String)"ZonalStats", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public boolean arePropertiesSupported() {
        return true;
    }

    public boolean validateArguments(String modeName, ParameterBlock pb, StringBuffer msg) {
        Object rangesType;
        Object noDataRangeObject;
        if (pb.getNumSources() == 0 || pb.getNumSources() > 2) {
            msg.append("ZonalStats operator takes 1 or 2 source images");
            return false;
        }
        Object rangeObject = pb.getObjectParameter(4);
        if (rangeObject != null) {
            boolean ok = true;
            if (rangeObject instanceof List) {
                Object range = ((List)rangeObject).get(0);
                if (!(range instanceof Range)) {
                    msg.append(paramNames[4] + " arg has to be of type List<Range<Double>>");
                    ok = false;
                } else {
                    List ranges = (List)rangeObject;
                    List sortedRanges = RangeUtils.sort(ranges);
                    int elements = sortedRanges.size();
                    if (elements > 1) {
                        RangeComparator rc = new RangeComparator();
                        List rr = sortedRanges;
                        for (int i = 0; i < elements - 1; ++i) {
                            Range r2;
                            Range r1 = rr.get(i);
                            RangeComparator.Result result = rc.compare(r1, r2 = rr.get(i + 1));
                            if (!RangeComparator.isIntersection(result)) continue;
                            ok = false;
                            msg.append(paramNames[4] + " arg can't contain intersecting ranges");
                            break;
                        }
                    }
                }
            } else if (rangeObject != null) {
                ok = false;
                msg.append(paramNames[4] + " arg has to be of type List<Range<Double>>");
            }
            if (!ok) {
                return false;
            }
        }
        if ((noDataRangeObject = pb.getObjectParameter(7)) != null) {
            boolean ok = true;
            if (noDataRangeObject instanceof List) {
                Object range = ((List)noDataRangeObject).get(0);
                if (!(range instanceof Range)) {
                    msg.append(paramNames[7] + " arg has to be of type List<Range<Double>>");
                    ok = false;
                }
            } else if (noDataRangeObject != null) {
                ok = false;
                msg.append(paramNames[7] + " arg has to be of type List<Range<Double>>");
            }
            if (!ok) {
                return false;
            }
        }
        if ((rangesType = pb.getObjectParameter(5)) != null && rangesType instanceof Range.Type) {
            Range.Type rt = (Range.Type)((Object)rangesType);
            if (rangeObject != null && rt == Range.Type.UNDEFINED) {
                msg.append(paramNames[5] + " arg has to be of Type.EXCLUDED or Type.INCLUDED when specifying a Ranges List");
                return false;
            }
        }
        Object bandsObject = pb.getObjectParameter(1);
        Integer[] bands = null;
        if (!(bandsObject instanceof Integer[])) {
            msg.append(paramNames[1] + " arg has to be of type Integer[]");
            return false;
        }
        bands = (Integer[])bandsObject;
        RenderedImage dataImg = pb.getRenderedSource(0);
        for (Integer band : bands) {
            if (band >= 0 && band < dataImg.getSampleModel().getNumBands()) continue;
            msg.append("band index out of bounds for source image: " + band);
            return false;
        }
        Rectangle dataBounds = new Rectangle(dataImg.getMinX(), dataImg.getMinY(), dataImg.getWidth(), dataImg.getHeight());
        Object roiObject = pb.getObjectParameter(2);
        if (roiObject != null) {
            if (!(roiObject instanceof ROI)) {
                msg.append("The supplied ROI is not a supported class");
                return false;
            }
            if (!((ROI)roiObject).intersects(dataBounds)) {
                msg.append("The supplied ROI does not intersect the source image");
                return false;
            }
        }
        if (pb.getNumSources() == 2) {
            RenderedImage zoneImg = pb.getRenderedSource(1);
            int dataType = zoneImg.getSampleModel().getDataType();
            boolean integralType = false;
            if (dataType == 0 || dataType == 3 || dataType == 2 || dataType == 1) {
                integralType = true;
            }
            if (!integralType) {
                msg.append("The zone image must be an integral data type");
                return false;
            }
            AffineTransform tr = null;
            Object trObject = pb.getObjectParameter(3);
            if (trObject != null && !(trObject instanceof AffineTransform)) {
                msg.append("The supplied transform should be an instance of AffineTransform");
                return false;
            }
            tr = (AffineTransform)trObject;
            Rectangle zoneBounds = new Rectangle(zoneImg.getMinX(), zoneImg.getMinY(), zoneImg.getWidth(), zoneImg.getHeight());
            if (tr != null && !tr.isIdentity()) {
                Shape zoneBoundsTransformed = tr.createTransformedShape(zoneBounds);
                if (!zoneBoundsTransformed.intersects(dataBounds)) {
                    msg.append("Zone image bounds are outside the data image bounds");
                    return false;
                }
            } else if (!dataBounds.intersects(zoneBounds)) {
                msg.append("Zone image bounds are outside the data image bounds");
                return false;
            }
        }
        return true;
    }
}

