/*
 * Decompiled with CFR 0.152.
 */
package jaitools.media.jai.zonalstats;

import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.util.ImageUtil;
import jaitools.media.jai.zonalstats.ZonalStatsOpImage;
import jaitools.numeric.Range;
import jaitools.numeric.Statistic;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.List;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;
import javax.media.jai.RasterFactory;

public class ZonalStatsRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout;
        RenderedImage dataImage = paramBlock.getRenderedSource(0);
        RenderedImage zoneImage = null;
        if (paramBlock.getNumSources() == 2) {
            zoneImage = paramBlock.getRenderedSource(1);
        }
        if ((layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints)) == null) {
            layout = new ImageLayout();
        }
        Statistic[] stats = (Statistic[])paramBlock.getObjectParameter(0);
        Integer[] bands = (Integer[])paramBlock.getObjectParameter(1);
        Object localStats = paramBlock.getObjectParameter(6);
        Boolean rangeLocalStats = localStats != null ? (Boolean)localStats : Boolean.FALSE;
        Object rng = paramBlock.getObjectParameter(4);
        List ranges = rng != null ? (List)rng : null;
        Object noDataRng = paramBlock.getObjectParameter(7);
        List noDataRanges = noDataRng != null ? (List)noDataRng : null;
        Object rngType = paramBlock.getObjectParameter(5);
        Range.Type rangesType = rngType != null ? (Range.Type)((Object)rngType) : (rng != null ? Range.Type.EXCLUDE : Range.Type.UNDEFINED);
        SampleModel sm = layout.getSampleModel(null);
        if (sm == null || sm.getNumBands() != stats.length) {
            int dataType = dataImage.getSampleModel().getDataType();
            if (dataType != 4 && dataType != 5) {
                for (Statistic stat : stats) {
                    if (stat.supportsIntegralResult()) continue;
                    dataType = 5;
                    break;
                }
            }
            sm = RasterFactory.createComponentSampleModel((SampleModel)dataImage.getSampleModel(), (int)dataType, (int)dataImage.getWidth(), (int)dataImage.getHeight(), (int)stats.length);
            layout.setSampleModel(sm);
            if (layout.getColorModel(null) != null) {
                ColorModel cm = ImageUtil.getCompatibleColorModel((SampleModel)sm, (Map)renderHints);
                layout.setColorModel(cm);
            }
        }
        ROI roi = (ROI)paramBlock.getObjectParameter(2);
        AffineTransform zoneTransform = (AffineTransform)paramBlock.getObjectParameter(3);
        return new ZonalStatsOpImage(dataImage, zoneImage, renderHints, layout, stats, bands, roi, zoneTransform, ranges, rangesType, rangeLocalStats, noDataRanges);
    }
}

