/*
 * Decompiled with CFR 0.152.
 */
package jaitools.numeric;

import jaitools.numeric.Range;
import jaitools.numeric.RangeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeUtils {
    public static <T extends Number> List<Range<T>> createComplement(Range<T> range) {
        return RangeUtils.subtract(range, new Range<Object>(null, false, null, false));
    }

    public static <T extends Number> List<Range<T>> createComplement(Collection<Range<T>> ranges) {
        List<Range<T>> inputs = RangeUtils.simplify(ranges);
        ArrayList<Range<T>> complements = new ArrayList<Range<T>>();
        complements.add(new Range<Object>(null, true, null, true));
        for (int i = 0; i < inputs.size(); ++i) {
            boolean changed = false;
            Range<T> rin = inputs.get(i);
            block6: for (int j = 0; j < complements.size() && !changed; ++j) {
                Range rc = (Range)complements.get(j);
                List<Range<T>> diff = RangeUtils.subtract(rin, rc);
                int ndiff = diff.size();
                switch (ndiff) {
                    case 0: {
                        complements.remove(j);
                        changed = true;
                        continue block6;
                    }
                    case 1: {
                        if (diff.get(0).equals(rc)) continue block6;
                        complements.remove(j);
                        complements.add(diff.get(0));
                        changed = true;
                        continue block6;
                    }
                    case 2: {
                        complements.remove(j);
                        complements.addAll(diff);
                        changed = true;
                    }
                }
            }
        }
        return complements;
    }

    public static <T extends Number> List<Range<T>> sort(Collection<Range<T>> ranges) {
        ArrayList<Range<T>> inputs = new ArrayList<Range<T>>(ranges);
        Collections.sort(inputs, new RangeSortComparator(new RangeComparator()));
        return inputs;
    }

    public static <T extends Number> List<Range<T>> simplify(Collection<Range<T>> ranges) {
        Range r2;
        int j;
        Range r1;
        int i;
        boolean changed;
        ArrayList<Range<T>> inputs = new ArrayList<Range<T>>(ranges);
        RangeComparator comparator = new RangeComparator();
        do {
            changed = false;
            for (i = 0; i < inputs.size() - 1 && !changed; ++i) {
                r1 = (Range)inputs.get(i);
                for (j = i + 1; j < inputs.size() && !changed; ++j) {
                    r2 = (Range)inputs.get(j);
                    RangeComparator.Result result = comparator.compare(r1, r2);
                    if (!RangeComparator.isIntersection(result)) continue;
                    switch (result) {
                        case EEEE: 
                        case EEGG: 
                        case LEEG: 
                        case LEGG: 
                        case LLEE: 
                        case LLEG: 
                        case LLGG: {
                            inputs.remove(j);
                            break;
                        }
                        case EGEG: 
                        case LELE: 
                        case LELG: 
                        case LGEG: 
                        case LGLG: {
                            inputs.remove(i);
                            break;
                        }
                        case EGGG: 
                        case LGGG: {
                            inputs.remove(j);
                            inputs.remove(i);
                            inputs.add(0, new Range(r2.getMin(), r2.isMinIncluded(), r1.getMax(), r1.isMaxIncluded()));
                            break;
                        }
                        case LLLE: 
                        case LLLG: {
                            inputs.remove(j);
                            inputs.remove(i);
                            inputs.add(0, new Range(r1.getMin(), r1.isMinIncluded(), r2.getMax(), r2.isMaxIncluded()));
                        }
                    }
                    changed = true;
                }
            }
        } while (changed);
        Collections.sort(inputs, new RangeSortComparator(comparator));
        do {
            changed = false;
            for (i = 0; i < inputs.size() - 1 && !changed; ++i) {
                r1 = (Range)inputs.get(i);
                if (!r1.isMaxClosed()) continue;
                for (j = i + 1; j < inputs.size() && !changed; ++j) {
                    r2 = (Range)inputs.get(j);
                    if (!r2.isMinClosed() || ((Comparable)r1.getMax()).compareTo(r2.getMin()) != 0) continue;
                    inputs.remove(j);
                    inputs.remove(i);
                    inputs.add(i, new Range(r1.getMin(), r1.isMinIncluded(), r2.getMax(), r2.isMaxIncluded()));
                    changed = true;
                }
            }
        } while (changed);
        return inputs;
    }

    public static <T extends Number> Range<T> intersection(Range<T> r1, Range<T> r2) {
        if (r1.isPoint()) {
            if (r2.isPoint()) {
                if (r1.equals(r2)) {
                    return new Range<T>(r1);
                }
                return null;
            }
            if (r1.isMinInf() && r2.isMaxOpen() || r1.isMinNegInf() && r2.isMinOpen() || r2.contains(r1.getMin())) {
                return new Range<T>(r1);
            }
            return null;
        }
        if (r2.isPoint()) {
            if (r2.isMinInf() && r1.isMaxOpen() || r2.isMinNegInf() && r1.isMinOpen() || r1.contains(r2.getMin())) {
                return new Range<T>(r2);
            }
            return null;
        }
        RangeComparator<T> rc = new RangeComparator<T>();
        RangeComparator.Result result = rc.compare(r1, r2);
        if (RangeComparator.isIntersection(result)) {
            boolean maxIncluded;
            T max;
            boolean minIncluded;
            T min;
            switch (result.getAt(1)) {
                case -1: {
                    min = r2.getMin();
                    minIncluded = r2.isMinIncluded();
                    break;
                }
                case 1: {
                    min = r1.getMin();
                    minIncluded = r1.isMinIncluded();
                    break;
                }
                default: {
                    min = r1.getMin();
                    minIncluded = r1.isMinIncluded() || r2.isMinIncluded();
                }
            }
            switch (result.getAt(2)) {
                case -1: {
                    max = r1.getMax();
                    maxIncluded = r1.isMaxIncluded();
                    break;
                }
                case 1: {
                    max = r2.getMax();
                    maxIncluded = r2.isMaxIncluded();
                    break;
                }
                default: {
                    max = r1.getMax();
                    maxIncluded = r1.isMaxIncluded() || r2.isMaxIncluded();
                }
            }
            return new Range<T>(min, minIncluded, max, maxIncluded);
        }
        return null;
    }

    public static <T extends Number> List<Range<T>> subtract(Range<T> r1, Range<T> r2) {
        ArrayList<Range<T>> difference = new ArrayList<Range<T>>();
        if (r1.equals(r2)) {
            return difference;
        }
        Range<T> common = RangeUtils.intersection(r1, r2);
        if (common == null) {
            difference.add(new Range<T>(r2));
            return difference;
        }
        if (common.equals(r2)) {
            return difference;
        }
        RangeComparator<T> rc = new RangeComparator<T>();
        RangeComparator.Result result = rc.compare(common, r2);
        int minComp = result.getAt(1);
        int maxComp = result.getAt(2);
        if (minComp == 0) {
            difference.add(new Range<T>(common.getMax(), !common.isMaxIncluded(), r2.getMax(), r2.isMaxIncluded()));
        } else if (maxComp == 0) {
            difference.add(new Range<T>(r2.getMin(), r2.isMinIncluded(), common.getMin(), !common.isMinIncluded()));
        } else {
            difference.add(new Range<T>(r2.getMin(), r2.isMinIncluded(), common.getMin(), !common.isMinIncluded()));
            difference.add(new Range<T>(common.getMax(), !common.isMaxIncluded(), r2.getMax(), r2.isMaxIncluded()));
        }
        return difference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RangeSortComparator<T extends Number>
    implements Comparator<Range<T>> {
        private RangeComparator<T> rc;

        public RangeSortComparator(RangeComparator<T> rc) {
            this.rc = rc;
        }

        @Override
        public int compare(Range<T> r1, Range<T> r2) {
            RangeComparator.Result result = this.rc.compare(r1, r2);
            switch (result.getAt(1)) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
            }
            switch (result.getAt(2)) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
            }
            return 0;
        }
    }
}

