/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.swing.JPanel;

public class SimpleImagePane
extends JPanel {
    RenderedImage image;
    AffineTransform transform;
    private final Object lock = new Object();

    public SimpleImagePane() {
        this.transform = new AffineTransform();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                SimpleImagePane.this.setTransform();
            }
        });
    }

    public void setImage(RenderedImage image) {
        this.image = image;
        this.setTransform();
        this.repaint();
    }

    public void clear() {
        this.image = null;
        this.repaint();
    }

    public void resetTransform() {
        this.setTransform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Object object = this.lock;
        synchronized (object) {
            if (this.image != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.drawRenderedImage(this.image, this.transform);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransform() {
        Object object = this.lock;
        synchronized (object) {
            if (this.image != null) {
                Rectangle r = this.getVisibleRect();
                double xscale = r.getWidth() / (double)this.image.getWidth();
                double yscale = r.getHeight() / (double)this.image.getHeight();
                double scale = Math.min(xscale, yscale);
                this.transform.setToScale(scale, scale);
            }
        }
    }
}

