/*
 * Decompiled with CFR 0.152.
 */
package jaitools.demo.contour;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import jaitools.demo.DemoImages;
import jaitools.demo.ImageChoice;
import jaitools.swing.ImageFrame;
import jaitools.swing.JTSFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Collection;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class ContourDemo {
    public static void main(String[] args) throws Exception {
        JAI.setDefaultTileSize((Dimension)new Dimension(512, 512));
        ContourDemo me = new ContourDemo();
        me.doDemo();
    }

    private void doDemo() throws Exception {
        RenderedImage image = DemoImages.get(ImageChoice.SQUIRCLE, 400, 400);
        ArrayList<Double> contourIntervals = new ArrayList<Double>();
        for (double level = 0.2; level < 1.41; level += 0.2) {
            contourIntervals.add(level);
        }
        ParameterBlockJAI pb = new ParameterBlockJAI("Contour");
        pb.setSource("source0", (Object)image);
        pb.setParameter("levels", contourIntervals);
        RenderedOp dest = JAI.create((String)"Contour", (ParameterBlock)pb);
        Collection contours = (Collection)dest.getProperty("contours");
        JTSFrame jtsFrame = new JTSFrame("Contours from source image");
        for (LineString contour : contours) {
            jtsFrame.addGeometry((Geometry)contour, Color.BLUE);
        }
        ImageFrame imgFrame = new ImageFrame(image, "Source image");
        imgFrame.setLocation(100, 100);
        imgFrame.setVisible(true);
        Dimension size = imgFrame.getSize();
        jtsFrame.setSize(size);
        jtsFrame.setLocation(100 + size.width + 5, 100);
        jtsFrame.setVisible(true);
    }
}

